/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.dp.binary;

import com.mapinfo.mapmarker.AUS.AUSLanguageSoundex;
import com.mapinfo.mapmarker.AUS.AUS_Handler;
import com.mapinfo.mapmarker.AUS.dp.AUS_DataConstructionParser;
import com.mapinfo.mapmarker.AUS.dp.AUS_Geo2SacDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.AUS.dp.AUS_GeoInfoDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.AUS.dp.AUS_StreetDataSourceRecordConvertor;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_AbstractAuxillaryDataWriter;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_DataFileMasksProvider;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_GenericStreetBuilder;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_MMJSegmentComparer;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_MMJStreetRecordComparator;
import com.mapinfo.mapmarker.AUS.dp.binary.gnaf.AUS_GNAFMMJStreetRecordComparator;
import com.mapinfo.mapmarker.AUS.dp.binary.gnaf.AUS_GNAFRangeRecordComparator;
import com.mapinfo.mapmarker.AUS.dp.binary.gnaf.AUS_GNAFStreetBuilder;
import com.mapinfo.mapmarker.AUS.dp.binary.index.AUS_GeoInfoSoundexIndexer;
import com.mapinfo.mapmarker.AUS.dp.gnaf.AUS_GNAFStreetDataSourceRecordConvertor;
import com.mapinfo.mapmarker.AUS.dp.intermediate.gnaf.AUS_GNAFIntermediateStreetDataFileFormatHandler;
import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.dp.IDataHandler;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordConvertor;
import com.mapinfo.mapmarker.common.dp.Post2SacDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.common.dp.PostInfoDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.common.dp.binary.AbstractDataProvider;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataFileMasks;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecordComparator;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentComparer;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecordComparator;
import com.mapinfo.mapmarker.common.dp.binary.index.GeoInfoSoundexIndexer;
import com.mapinfo.mapmarker.common.dp.intermediate.IIntermediateDataHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.ITempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.InMemoryTempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateStreetDataFileFormatHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.NonIntermediateDataHandler;
import com.mapinfo.mapmarker.core.ICoreParseHandler;
import com.mapinfo.mapmarker.core.parser.IParser;
import com.mapinfo.mapmarker.utils.MiVersion;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.RandomAccessFile;
import java.util.Locale;
import java.util.Properties;

public abstract class AUS_AbstractDataProvider
extends AbstractDataProvider {
    private static MiVersion m_version = new MiVersion(4, 3, 0);
    private static IHandler handler = null;
    private boolean m_bGNAFStreetData;
    private MMJComplexDataFileMetadata m_streetMetadata;
    private MMJComplexDataFileMetadata m_postInfoMetadata;
    private MMJComplexDataFileMetadata m_geoInfoMetadata;

    public void initialize(Properties processingProperties) throws DataCreationException {
        super.initialize(processingProperties);
        this.m_bGNAFStreetData = processingProperties.getProperty("GNAF_PROCESSING", "").equals("YES");
        Constraints constraints = new Constraints();
        constraints.setHandler(handler);
        this.m_post2sacDataHandler = this.buildPost2SacDataHandler((IDataSourceRecordConvertor)new Post2SacDataSourceRecordConvertorImpl(processingProperties), (IIntermediateDataHandler)new NonIntermediateDataHandler(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler());
        this.m_geo2sacDataHandler = this.buildGeo2SacDataHandler((IDataSourceRecordConvertor)new AUS_Geo2SacDataSourceRecordConvertorImpl(processingProperties, new AUSLanguageSoundex()), (IIntermediateDataHandler)new NonIntermediateDataHandler(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler());
        this.m_postInfoDataHandler = this.buildPostInfoDataHandler((IDataSourceRecordConvertor)new PostInfoDataSourceRecordConvertorImpl(processingProperties), (IIntermediateDataHandler)new NonIntermediateDataHandler(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler());
        this.m_geoInfoDataHandler = this.buildGeoInfoDataHandler((IDataSourceRecordConvertor)new AUS_GeoInfoDataSourceRecordConvertorImpl(processingProperties), (IIntermediateDataHandler)new NonIntermediateDataHandler(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler());
        String processStreetsString = (String)processingProperties.get("street_create");
        if ("yes".equalsIgnoreCase(processStreetsString)) {
            if (this.m_bGNAFStreetData) {
                this.m_dataBuilder = new AUS_GNAFStreetBuilder();
                this.m_streetDataHandler = this.buildGNAFStreetDataHandler((IDataSourceRecordConvertor)new AUS_GNAFStreetDataSourceRecordConvertor(new AUSLanguageSoundex(), processingProperties, new CollationKeyGenerator(new Locale("AU", "AUS")), ((ICoreParseHandler)handler).getParser(), constraints), (IIntermediateDataHandler)new AUS_GNAFIntermediateStreetDataFileFormatHandler(StringUtilities.appendToPath((String)processingProperties.getProperty("street_outputFilePath"), (String)"streets.tmp")), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler(), new AUS_GNAFMMJStreetRecordComparator(new AUS_GNAFRangeRecordComparator()), new AUS_MMJSegmentComparer());
            } else {
                this.m_dataBuilder = new AUS_GenericStreetBuilder();
                this.m_streetDataHandler = this.buildStreetDataHandler((IDataSourceRecordConvertor)new AUS_StreetDataSourceRecordConvertor(new AUSLanguageSoundex(), processingProperties, new CollationKeyGenerator(new Locale("AU", "AUS")), ((ICoreParseHandler)handler).getParser(), constraints), (IIntermediateDataHandler)new IntermediateStreetDataFileFormatHandler(StringUtilities.appendToPath((String)processingProperties.getProperty("street_outputFilePath"), (String)"streets.tmp")), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler(), new AUS_MMJStreetRecordComparator(new MMJRangeRecordComparator()), new MMJSegmentComparer());
            }
            ((AUS_GenericStreetBuilder)this.m_dataBuilder).setGeoInfoPath(processingProperties.getProperty("street_geoInfoPath"));
        } else {
            this.m_dataBuilder = new AUS_GenericStreetBuilder();
        }
    }

    protected abstract IDataHandler buildPost2SacDataHandler(IDataSourceRecordConvertor var1, IIntermediateDataHandler var2, ITempDataRecordHandler var3);

    protected abstract IDataHandler buildGeo2SacDataHandler(IDataSourceRecordConvertor var1, IIntermediateDataHandler var2, ITempDataRecordHandler var3);

    protected abstract IDataHandler buildPostInfoDataHandler(IDataSourceRecordConvertor var1, IIntermediateDataHandler var2, ITempDataRecordHandler var3);

    protected abstract IDataHandler buildGeoInfoDataHandler(IDataSourceRecordConvertor var1, IIntermediateDataHandler var2, ITempDataRecordHandler var3);

    protected abstract IDataHandler buildStreetDataHandler(IDataSourceRecordConvertor var1, IIntermediateDataHandler var2, ITempDataRecordHandler var3, MMJStreetRecordComparator var4, MMJSegmentComparer var5) throws DataCreationException;

    protected abstract IDataHandler buildGNAFStreetDataHandler(IDataSourceRecordConvertor var1, IIntermediateDataHandler var2, ITempDataRecordHandler var3, MMJStreetRecordComparator var4, MMJSegmentComparer var5) throws DataCreationException;

    public String getAlternateSearchTypeTempIndexExtension(byte type) {
        String superExtension = super.getAlternateSearchTypeTempIndexExtension(type);
        if (superExtension != null) {
            return superExtension;
        }
        if (type == 1) {
            return ".tix";
        }
        return null;
    }

    public byte[] getAlternateStreetSearchSupportedTypes() {
        return new byte[]{0, 1};
    }

    public RandomAccessFile getAlternateSearchIndexFile(byte alternateSearchIndexType) throws DataCreationException {
        if (alternateSearchIndexType == 1) {
            return this.getAlternateIndexFileForName(StringUtilities.appendToPath((String)this.getStreetFilePath(), (String)this.m_processProperties.getProperty("street_outputFile"), (String)this.getAlternateSearchTypeTempIndexExtension(alternateSearchIndexType)));
        }
        return super.getAlternateSearchIndexFile(alternateSearchIndexType);
    }

    public MMJComplexDataFileMetadata getStreetMetadata() {
        if (this.m_streetMetadata == null) {
            this.m_streetMetadata = new MMJComplexDataFileMetadata();
            this.m_streetMetadata.setVersion(m_version);
            this.m_streetMetadata.setVendorCode(this.getVandorAndDataType());
            if (this.m_bGNAFStreetData) {
                this.m_streetMetadata.setXPow10((byte)6);
                this.m_streetMetadata.setYPow10((byte)6);
            } else {
                this.m_streetMetadata.setXPow10((byte)5);
                this.m_streetMetadata.setYPow10((byte)5);
            }
            this.m_streetMetadata.setCountry("AUS");
            if (this.m_bGNAFStreetData) {
                this.m_streetMetadata.setDataFileMasks(this.getGNAFStreetDataFileMasks());
            } else {
                this.m_streetMetadata.setDataFileMasks(this.getStreetDataFileMasks());
            }
        }
        return this.m_streetMetadata;
    }

    public MMJComplexDataFileMetadata getPostInfoMetadata() {
        if (this.m_postInfoMetadata == null) {
            this.m_postInfoMetadata = new MMJComplexDataFileMetadata();
            this.m_postInfoMetadata.setCountry("AUS");
            this.m_postInfoMetadata.setXPow10((byte)5);
            this.m_postInfoMetadata.setYPow10((byte)5);
            this.m_postInfoMetadata.setVersion(m_version);
            this.m_postInfoMetadata.setDataFileMasks(this.getPostInfoDataFileMasks());
            this.m_postInfoMetadata.setVendorCode(this.getVandorAndDataType());
        }
        return this.m_postInfoMetadata;
    }

    public MMJComplexDataFileMetadata getGeoInfoMetadata() {
        if (this.m_geoInfoMetadata == null) {
            this.m_geoInfoMetadata = new MMJComplexDataFileMetadata();
            this.m_geoInfoMetadata.setCountry("AUS");
            this.m_geoInfoMetadata.setXPow10((byte)5);
            this.m_geoInfoMetadata.setYPow10((byte)5);
            this.m_geoInfoMetadata.setVersion(m_version);
            this.m_geoInfoMetadata.setDataFileMasks(this.getGeoInfoDataFileMasks());
            this.m_geoInfoMetadata.setVendorCode(this.getVandorAndDataType());
        }
        return this.m_geoInfoMetadata;
    }

    public DataFileMasks getGNAFStreetDataFileMasks() {
        return AUS_DataFileMasksProvider.buildGNAFStreetDataFileMasks();
    }

    public DataFileMasks getStreetDataFileMasks() {
        return AUS_DataFileMasksProvider.buildStreetDataFileMasks();
    }

    public DataFileMasks getPostInfoDataFileMasks() {
        return AUS_DataFileMasksProvider.buildPostInfoDataFileMasks();
    }

    public DataFileMasks getGeoInfoDataFileMasks() {
        return AUS_DataFileMasksProvider.buildGeoInfoDataFileMasks();
    }

    public String getGeoInfoForStreetsFileBaseName() {
        return (String)this.m_processProperties.get("geoInfo_outputFile");
    }

    public GeoInfoSoundexIndexer getGeoInfoSoundexIndexer() {
        return new AUS_GeoInfoSoundexIndexer();
    }

    public boolean supportsReverseGeocode() {
        return true;
    }

    public void processPostOfficeData() throws DataCreationException {
        AUS_AbstractAuxillaryDataWriter writer = this.getAuxillaryWriter();
        writer.writePostOfficeFiles();
    }

    protected abstract AUS_AbstractAuxillaryDataWriter getAuxillaryWriter();

    static {
        AddressImpl addr = new AddressImpl();
        addr.setCountry("AUS");
        handler = AUS_Handler.buildDataConstructionHandler((Address)addr);
        ((ICoreParseHandler)handler).setParser((IParser)new AUS_DataConstructionParser());
    }
}

