/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.dp.binary;

import com.mapinfo.mapmarker.AUS.dp.binary.AUS_AbstractDataProvider;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.DataCreator;
import java.util.Properties;

public class AUS_DataCreator
extends DataCreator {
    private static final String CREATE_POSTOFFICE_PROP_NAME = "postOffice_create";

    private AUS_DataCreator() {
        super(true);
    }

    protected void createDataFiles(Properties processingProperties) throws DataCreationException {
        super.createDataFiles(processingProperties);
        if (this.processPostOfficeFile(processingProperties)) {
            this.createPostOfficeFile(processingProperties);
        }
    }

    private boolean processPostOfficeFile(Properties processingProperties) {
        String processPostOfficeString = (String)processingProperties.get(CREATE_POSTOFFICE_PROP_NAME);
        return this.propIsYes(processPostOfficeString);
    }

    private void createPostOfficeFile(Properties processingProperties) throws DataCreationException {
        DataCreationLogger.getLogger().logStatus("Creating post office data...");
        AUS_AbstractDataProvider AUSProvider = (AUS_AbstractDataProvider)this.m_dataProvider;
        AUSProvider.processPostOfficeData();
        DataCreationLogger.getLogger().logStatus("Post office data created.");
    }

    public static void main(String[] args) {
        System.out.println("AUS_DataCreator");
        if (args.length != 1) {
            System.err.println("Usage: AUS_DataCreator <processing properties>");
            System.exit(1);
        }
        Properties processingProperties = DataCreator.loadPropertiesFile((String)args[0]);
        AUS_DataCreator creator = new AUS_DataCreator();
        try {
            creator.runProcess(processingProperties);
        }
        catch (DataCreationException DCEx) {
            DataCreationLogger.getLogger().logStackTrace((Throwable)DCEx);
            System.err.println("Unable to create data.");
            System.err.println("ERROR: " + DCEx.getMessage());
            DCEx.printStackTrace(System.err);
            System.exit(1);
        }
        catch (Throwable t) {
            DataCreationLogger.getLogger().logStackTrace(t);
            System.err.println("Unable to create data.");
            System.err.println("ERROR: " + t.getMessage());
            t.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

