/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.dp.binary;

import com.mapinfo.mapmarker.AUS.AUSLanguageSoundex;
import com.mapinfo.mapmarker.AUS.AUS_Constraints;
import com.mapinfo.mapmarker.AUS.AUS_DictionaryGeographyInfo;
import com.mapinfo.mapmarker.AUS.dp.binary.AUSGeo2SacRecord;
import com.mapinfo.mapmarker.AUS.dp.binary.AUSGeoBase;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_AddressFetcher;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_GeoInfoFetcherImpl;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_MMJSac2FnData;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_PostOfficeDataFetcher;
import com.mapinfo.mapmarker.AUS.dp.binary.IAUS_PostOfficeDataFetcher;
import com.mapinfo.mapmarker.AUS.dp.binary.index.AUS_GNAFPIDIndexFile;
import com.mapinfo.mapmarker.AUS.dp.binary.index.AUS_StreetIndexFile;
import com.mapinfo.mapmarker.AUS.utils.AUS_StringUtilities;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.IDictionaryGeographyInfo;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.binary.AbstractDataDictionary;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.IAddressFetcher;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.IGeoInfoFetcher;
import com.mapinfo.mapmarker.common.dp.binary.IPostInfoFetcher;
import com.mapinfo.mapmarker.common.dp.binary.IPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSac2FnData;
import com.mapinfo.mapmarker.common.dp.binary.MiSoundexGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.StandardPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerReadOnlyIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerBrowseMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerStreetMultiLevelIndexKey;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public class AUS_DataDictionary
extends AbstractDataDictionary {
    private static final Soundex soundex = new AUSLanguageSoundex();
    private static final String NO_SAC2FN_FILE = "exception.no.sac2fn";
    private static final String SAC2FN_FILE_OPEN = "exception.open.sac2fn";
    public static final String KEY_SEARCH_ONLY_BY_PLACENAME = "search.placename.only";
    private static final CollationKeyGenerator m_collationKeyGenerator = new CollationKeyGenerator(new Locale("AU", "AUS"));
    private boolean m_isGNAFDictionary;
    private IMapMarkerReadOnlyIndexFile m_PIDIndex;
    private IAUS_PostOfficeDataFetcher m_postOfficeFetcher;

    AUS_DataDictionary(int dictionaryNumber, Properties dataManagerSettings) throws DataDictionaryIntializationException {
        super(dictionaryNumber, dataManagerSettings);
        if (this.m_isGNAFDictionary) {
            this.initPIDIndex();
        }
        if (!this.isGNAFDictionary() && !this.isUserDictionary()) {
            try {
                this.m_postOfficeFetcher = new AUS_PostOfficeDataFetcher(this.getDictionaryPath());
            }
            catch (DataDictionaryIntializationException dataDictionaryIntializationException) {
                // empty catch block
            }
        }
    }

    private void initPIDIndex() throws DataDictionaryIntializationException {
        this.m_PIDIndex = new AUS_GNAFPIDIndexFile();
        try {
            this.m_PIDIndex.open(StringUtilities.appendToPath((String)this.getDictionaryPath(), (String)"aus.pix"));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException IOEx) {
            throw new DataDictionaryIntializationException((Throwable)IOEx);
        }
    }

    IMapMarkerIndex getPIDIndex() {
        return this.m_PIDIndex;
    }

    IAUS_PostOfficeDataFetcher getPostOfficeDataFetcher() {
        return this.m_postOfficeFetcher;
    }

    protected MMJSac2FnData initSac2FnData() throws DataDictionaryIntializationException {
        try {
            AUS_MMJSac2FnData data = new AUS_MMJSac2FnData(super.getDictionaryPath());
            this.m_isGNAFDictionary = data.isGNAFDictionary();
            this.setIsUserDictionary(data.forUserDictionary());
            return data;
        }
        catch (FileNotFoundException FNFEx) {
            throw new DataDictionaryIntializationException(NO_SAC2FN_FILE, (Throwable)FNFEx);
        }
        catch (IOException IOEx) {
            throw new DataDictionaryIntializationException(SAC2FN_FILE_OPEN, (Throwable)IOEx);
        }
    }

    protected IPostalBase[] getPostalBases(Address addr, IConstraints constraints) {
        String postcode1 = addr.getPostCode1();
        if (postcode1 == null || postcode1.trim().length() == 0) {
            return null;
        }
        IPostalBase[] retvals = new IPostalBase[]{new StandardPostalBase(postcode1)};
        return retvals;
    }

    public IGeoBase[] getGeoBases(Address addr, IConstraints preferences) {
        if (((AUS_Constraints)preferences).isStrictFirstPass()) {
            return null;
        }
        HashSet<AUSGeoBase> geoBaseSet = new HashSet<AUSGeoBase>();
        String an3 = addr.getAreaName3();
        if (an3 == null || an3.trim().length() == 0) {
            return null;
        }
        ISoundexKey sndxKey = soundex.getSoundex(an3);
        geoBaseSet.add(new AUSGeoBase((MiSoundexKey)sndxKey));
        if (addr.getPostCode1() == null) {
            if ("CITY".equalsIgnoreCase(an3)) {
                sndxKey = soundex.getSoundex("BRISBANE CITY");
                geoBaseSet.add(new AUSGeoBase((MiSoundexKey)sndxKey));
                sndxKey = soundex.getSoundex("BRISBANE");
                geoBaseSet.add(new AUSGeoBase((MiSoundexKey)sndxKey));
            } else if (an3.endsWith(" CITY")) {
                int pos = an3.indexOf(" CITY");
                String newstr = an3.substring(0, pos);
                sndxKey = soundex.getSoundex(newstr);
                geoBaseSet.add(new AUSGeoBase((MiSoundexKey)sndxKey));
            } else if (!an3.startsWith("CITY ") && !an3.contains(" CITY ")) {
                StringBuffer buf = new StringBuffer(an3);
                buf.append(' ');
                buf.append(" CITY");
                sndxKey = soundex.getSoundex(buf.toString());
                geoBaseSet.add(new AUSGeoBase((MiSoundexKey)sndxKey));
            }
        }
        return geoBaseSet.toArray(new IGeoBase[geoBaseSet.size()]);
    }

    protected IGeoBase[] getAlternateGeoBases(int dictNum, Address pa, IConstraints preferences, int i) {
        if (((AUS_Constraints)preferences).isStrictFirstPass()) {
            return null;
        }
        String areaName3 = pa.getAreaName3();
        if (areaName3 == null || areaName3.length() == 0) {
            return null;
        }
        MiSoundexKey key = (MiSoundexKey)soundex.getSoundex(areaName3);
        if (key == null) {
            return null;
        }
        List alternatesList = new ArrayList<MiSoundexKey>();
        alternatesList.add(key);
        switch (i) {
            case 0: {
                alternatesList = soundex.calculateAlternateSoundexKeys(areaName3, (ISoundexKey)key, 32, alternatesList);
                break;
            }
            case 1: {
                alternatesList = soundex.calculateAlternateSoundexKeys(areaName3, (ISoundexKey)key, 1, alternatesList);
                break;
            }
            case 2: {
                alternatesList = soundex.calculateAlternateSoundexKeys(areaName3, (ISoundexKey)key, 16, alternatesList);
                break;
            }
            case 3: {
                alternatesList = soundex.calculateAlternateSoundexKeys(areaName3, (ISoundexKey)key, 8, alternatesList);
                break;
            }
            case 4: {
                alternatesList = soundex.calculateAlternateSoundexKeys(areaName3, (ISoundexKey)key, 2, alternatesList);
                break;
            }
            case 5: {
                alternatesList = soundex.calculateAlternateSoundexKeys(areaName3, (ISoundexKey)key, 4, alternatesList);
                break;
            }
            default: {
                return null;
            }
        }
        if (alternatesList == null) {
            return null;
        }
        int size = alternatesList.size();
        Object[] objs = alternatesList.toArray();
        MiSoundexGeoBase[] retvals = new MiSoundexGeoBase[size];
        for (int j = 0; j < size; ++j) {
            retvals[j] = new MiSoundexGeoBase((MiSoundexKey)objs[j]);
        }
        return retvals;
    }

    protected IMapMarkerReadOnlyIndexFile getStreetIndexFileType() {
        return new AUS_StreetIndexFile();
    }

    public ISoundexKey[] makeStreetBases(Address addr, IConstraints constraints) {
        if (constraints.containsCustomObjectKey((Object)KEY_SEARCH_ONLY_BY_PLACENAME)) {
            return null;
        }
        String origStr = addr.getMainAddress();
        ISoundexKey origKey = soundex.getSoundex(origStr);
        if (origKey == null) {
            return null;
        }
        Integer tmp = (Integer)constraints.getCustomObject((Object)"KEY_AUS_ALTERNATE_SOUNDEX_CODES");
        int altTypes = 0;
        if (tmp == null) {
            ISoundexKey[] retvals = new ISoundexKey[]{origKey};
            return retvals;
        }
        altTypes = tmp;
        if (altTypes <= 0) {
            ISoundexKey[] retvals = new ISoundexKey[]{origKey};
            return retvals;
        }
        List alternates = new ArrayList<ISoundexKey>();
        alternates.add(origKey);
        alternates = soundex.calculateAlternateSoundexKeys(origStr, origKey, altTypes, alternates);
        int size = alternates.size();
        Object[] objs = alternates.toArray();
        ISoundexKey[] retvals = new ISoundexKey[size];
        for (int i = 0; i < size; ++i) {
            retvals[i] = (ISoundexKey)objs[i];
        }
        return retvals;
    }

    public MapMarkerIndexKey[] makeBrowseBases(Address addr, IConstraints constraints) {
        String mainAddress = addr.getMainAddress();
        if (mainAddress == null || mainAddress.length() == 0) {
            return null;
        }
        char c = Character.toUpperCase(mainAddress.charAt(0));
        int[] collationKey = m_collationKeyGenerator.getCollationKey(mainAddress);
        MapMarkerBrowseMultiLevelIndexKey key = new MapMarkerBrowseMultiLevelIndexKey(-1, c, collationKey);
        MapMarkerBrowseMultiLevelIndexKey[] keys = new MapMarkerBrowseMultiLevelIndexKey[]{key};
        return keys;
    }

    protected MapMarkerIndexKey[] getAlternateSearchBases(byte alternateType, Address addr, IConstraints constraints) {
        MiSoundexKey sndxKey;
        if (constraints.containsCustomObjectKey((Object)KEY_SEARCH_ONLY_BY_PLACENAME) && addr != null && !AUS_StringUtilities.isEmpty(addr.getPlaceName()) && (sndxKey = (MiSoundexKey)soundex.getSoundex(addr.getPlaceName())) != null) {
            return new MapMarkerIndexKey[]{new MapMarkerStreetMultiLevelIndexKey(-1, sndxKey)};
        }
        return null;
    }

    protected MapMarkerIndexKey[] getAlternateBrowseBases(byte alternateType, Address addr, IConstraints constraints) {
        if (addr != null && !AUS_StringUtilities.isEmpty(addr.getPlaceName())) {
            String keyString = addr.getPlaceName().toUpperCase();
            int[] collationKey = m_collationKeyGenerator.getCollationKey(keyString);
            char c = keyString.charAt(0);
            return new MapMarkerIndexKey[]{new MapMarkerBrowseMultiLevelIndexKey(-1, c, collationKey)};
        }
        return null;
    }

    protected String getAlternateStreetBrowseIndexExtension(byte alternateBrowseType) {
        switch (alternateBrowseType) {
            case 0: {
                return ".pbx";
            }
        }
        return null;
    }

    protected String getAlternateStreetSearchIndexExtension(byte alternateSearchType) {
        switch (alternateSearchType) {
            case 0: {
                return ".pdx";
            }
        }
        return null;
    }

    public IDictionaryGeographyInfo getDictionaryGeographyInfo() {
        AUS_DictionaryGeographyInfo info = new AUS_DictionaryGeographyInfo();
        info.setDictionaryPath(this.getDictionaryPath());
        info.setDictionaryNumber(this.getDictionaryNumber() + 1);
        String[] streetDataFileNames = this.getStreetDataFileNames();
        if (streetDataFileNames != null && streetDataFileNames.length > 0) {
            info.setHasStreets(true);
            info.setHasCentroids(true);
        }
        if (this.isUserDictionary()) {
            info.setIsUserDictionary(true);
        } else {
            info.setIsUserDictionary(false);
        }
        if (this.m_isGNAFDictionary) {
            info.setIsGNAFDict(true);
        } else {
            info.setIsGNAFDict(false);
        }
        return info;
    }

    protected MMJGeo2SacRecord getGeo2SacRecordType() {
        return new AUSGeo2SacRecord();
    }

    protected IGeoInfoFetcher initGeoInfoFetcher() throws DataDictionaryIntializationException {
        if (this.isUserDictionary()) {
            return null;
        }
        return new AUS_GeoInfoFetcherImpl(this.getDictionaryPath(), this.getDataManagerSettings(), null);
    }

    protected IAddressFetcher initAddressFetcher() {
        return new AUS_AddressFetcher(this.getDataManagerSettings(), null, this.m_isGNAFDictionary);
    }

    protected IPostInfoFetcher initPostInfoFetcher() throws DataDictionaryIntializationException {
        if (this.isUserDictionary()) {
            return null;
        }
        return super.initPostInfoFetcher();
    }

    public boolean isGNAFDictionary() {
        return this.m_isGNAFDictionary;
    }

    public void close() throws DataAccessException {
        super.close();
        if (this.m_PIDIndex != null) {
            try {
                this.m_PIDIndex.close();
            }
            catch (IOException IOEx) {
                throw new DataAccessException(2102, (Throwable)IOEx);
            }
            this.m_PIDIndex = null;
        }
    }

    public int[] getSacList(Address addr, IConstraints constraints, boolean bDoIntersectionOnly) {
        int[] sacList = super.getSacList(addr, constraints, bDoIntersectionOnly);
        if (sacList != null && sacList.length > 0) {
            ((AUS_Constraints)constraints).setFoundSacs(true);
        }
        return sacList;
    }
}

