/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.dp.binary;

import com.mapinfo.mapmarker.AUS.AUS_IConstraints;
import com.mapinfo.mapmarker.AUS.AUS_InternalCandidateAddress;
import com.mapinfo.mapmarker.AUS.AUS_PIDInternalCandidate;
import com.mapinfo.mapmarker.AUS.AUS_StreetCandidateAddressFilter;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_DataDictionary;
import com.mapinfo.mapmarker.AUS.dp.binary.IAUS_PostOfficeDataFetcher;
import com.mapinfo.mapmarker.AUS.dp.binary.index.AUS_GNAFPIDIndexKey;
import com.mapinfo.mapmarker.AUS.dp.binary.index.AUS_GNAFPIDIndexValue;
import com.mapinfo.mapmarker.AUS.dp.binary.index.AUS_StreetIndexFile;
import com.mapinfo.mapmarker.AUS.licensing.AUSLicenseFilter;
import com.mapinfo.mapmarker.EngineThreadingModel;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.CountryGeographyInfoImpl;
import com.mapinfo.mapmarker.common.ICountryGeographyInfo;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.DataManagerSettingsProvider;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessException;
import com.mapinfo.mapmarker.common.dp.binary.AbstractDataManager;
import com.mapinfo.mapmarker.common.dp.binary.AlternateSearchTypeKey;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.IDataDictionary;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataManagerInitializationException;
import com.mapinfo.mapmarker.common.dp.binary.SacFileData;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexMultiValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.StreetDataIndexValue;
import com.mapinfo.mapmarker.core.IRetrievedCandidates;
import com.mapinfo.mapmarker.licensing.LicenseFilter;
import com.mapinfo.mapmarker.utils.FileProviderFactory;
import com.mapinfo.mapmarker.utils.MMJLog;
import com.mapinfo.mapmarker.utils.SeekableDataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public final class AUS_DataManager
extends AbstractDataManager {
    public static final String KEY_AUS_ALTERNATE_SOUNDEX_CODES = "KEY_AUS_ALTERNATE_SOUNDEX_CODES";
    private static Throwable m_SetupException;
    private static Properties m_DataResources;
    private static AUS_DataDictionary[] m_dataDicts;
    private static int m_numDicts;
    private static LicenseFilter m_licenseFilter;
    private int m_lastIndexDictNumber = -1;
    private String m_lastIndexFileName = null;
    private SeekableDataInput m_lastIndexFile = null;

    private static void start() {
        m_SetupException = null;
        try {
            m_DataResources = DataManagerSettingsProvider.getInstance().getSettingsForCountry("AUS");
        }
        catch (IOException e) {
            MMJLog.getLog().error(e.getMessage(), (Throwable)e);
            m_SetupException = e;
        }
        try {
            m_numDicts = Integer.parseInt(m_DataResources.getProperty("DICTIONARY_COUNT"));
            if (m_numDicts < 1) {
                m_numDicts = 1;
            }
        }
        catch (Exception e) {
            m_numDicts = 1;
        }
        m_dataDicts = new AUS_DataDictionary[m_numDicts];
        try {
            for (int i = 0; i < m_numDicts; ++i) {
                try {
                    AUS_DataManager.m_dataDicts[i] = new AUS_DataDictionary(i, m_DataResources);
                    continue;
                }
                catch (DataDictionaryIntializationException DDIEx) {
                    MMJLog.getLog().error(DDIEx.getMessage(), (Throwable)DDIEx);
                    m_SetupException = DDIEx;
                }
            }
        }
        catch (Exception e) {
            MMJLog.getLog().error(e.getMessage(), (Throwable)e);
            m_SetupException = e;
        }
        try {
            m_licenseFilter = new AUSLicenseFilter();
        }
        catch (MapMarkerInternalException e) {
            MMJLog.getLog().error(e.getMessage(), (Throwable)e);
            m_SetupException = e;
        }
    }

    public AUS_DataManager() throws MMJEDataManagerInitializationException {
        if (m_SetupException != null) {
            throw new MMJEDataManagerInitializationException(m_SetupException.getMessage(), m_SetupException);
        }
        this.setStreetFilter(new AUS_StreetCandidateAddressFilter(null));
    }

    public int getDictionaryCount() {
        return m_numDicts;
    }

    public IDataDictionary getDictionary(int idx) {
        return m_dataDicts[idx];
    }

    public boolean hasGnafDictionary() {
        for (int index = 0; index < m_dataDicts.length; ++index) {
            if (!m_dataDicts[index].isGNAFDictionary()) continue;
            return true;
        }
        return false;
    }

    public static void reset() throws MMJEDataManagerInitializationException {
        if (!EngineThreadingModel.isThreadsafe()) {
            try {
                AUS_DataManager.shutdown();
            }
            catch (DataAccessException DAEx) {
                throw new MMJEDataManagerInitializationException(DAEx.getMessage(), (Throwable)DAEx);
            }
            AUS_DataManager.start();
            if (m_SetupException != null) {
                throw new MMJEDataManagerInitializationException(m_SetupException.getMessage(), m_SetupException);
            }
        }
    }

    private static void shutdown() throws DataAccessException {
        for (int i = 0; i < m_numDicts; ++i) {
            AUS_DataDictionary dict = m_dataDicts[i];
            if (dict != null) {
                dict.close();
            }
            AUS_DataManager.m_dataDicts[i] = null;
        }
        m_dataDicts = null;
    }

    protected LicenseFilter getLicenseFilter() {
        return m_licenseFilter;
    }

    protected ICountryGeographyInfo getCountryGeographyInfoObject() {
        return new CountryGeographyInfoImpl("AUS");
    }

    protected List getAlternateBrowseAddresses(AlternateSearchTypeKey[] alternateBases, int[] sacList, IConstraints preferences, IDataDictionary dict, int debugLevel) throws DataAccessException, FatalDataAccessException {
        ArrayList filteredSacList = this.filterSacsWithNoFn(sacList, dict);
        int[] filteredSacArray = this.copySacListToSacArray(filteredSacList);
        return super.getAlternateBrowseAddresses(alternateBases, filteredSacArray, preferences, dict, debugLevel);
    }

    private int[] copySacListToSacArray(ArrayList filteredSacList) {
        int[] filteredSacArray = new int[filteredSacList.size()];
        for (int i = 0; i < filteredSacList.size(); ++i) {
            Integer element = (Integer)filteredSacList.get(i);
            filteredSacArray[i] = element;
        }
        return filteredSacArray;
    }

    private ArrayList filterSacsWithNoFn(int[] sacList, IDataDictionary dict) {
        ArrayList<Integer> filteredSacList = new ArrayList<Integer>();
        for (int i = 0; i < sacList.length; ++i) {
            SacFileData sac2FnEntry = dict.getSearchAreaFiles(sacList[i]);
            if (sac2FnEntry == null) continue;
            filteredSacList.add(new Integer(sacList[i]));
        }
        return filteredSacList;
    }

    protected long getStreetDataLocation(IDataDictionary dict, int sac, ISoundexKey base, String streetFileName, String path) throws IOException {
        StreetDataIndexValue indexValue;
        AUS_StreetIndexFile indexFile = (AUS_StreetIndexFile)dict.getStreetIndexFile(streetFileName);
        MapMarkerIndexKey key = dict.makeStreetIndexKey(base, sac);
        if (dict.getDictionaryNumber() != this.m_lastIndexDictNumber || !streetFileName.equals(this.m_lastIndexFileName)) {
            this.m_lastIndexDictNumber = dict.getDictionaryNumber();
            this.m_lastIndexFileName = streetFileName;
            if (this.m_lastIndexFile != null) {
                FileProviderFactory.getFileProvider().release(this.m_lastIndexFile);
            }
            this.m_lastIndexFile = FileProviderFactory.getFileProvider().get(indexFile.getIndexFileName());
        }
        if ((indexValue = (StreetDataIndexValue)indexFile.search(key, this.m_lastIndexFile)) != null) {
            return indexValue.getStreetOffset();
        }
        return -1L;
    }

    public IRetrievedCandidates retrievePIDCandidates(Address addr, IConstraints constraints) throws FatalDataAccessException, DataAccessException {
        AUS_GNAFPIDIndexKey key;
        IRetrievedCandidates retrieved = this.buildRetrievedCandidates(null);
        HashMap additionalFields = addr.getAdditionalFields();
        if (additionalFields == null) {
            return retrieved;
        }
        String PID = (String)additionalFields.get("GNAF_PID");
        if (PID == null) {
            return retrieved;
        }
        try {
            key = new AUS_GNAFPIDIndexKey(PID);
        }
        catch (IllegalArgumentException IAEx) {
            return retrieved;
        }
        AbstractDataManager.DictionaryIterator dictionaryIterator = this.getDictionariesIterator(constraints);
        while (dictionaryIterator.hasNext()) {
            SeekableDataInput dataFile;
            AUS_GNAFPIDIndexValue value;
            AbstractDataManager.Dictionary dict = dictionaryIterator.next();
            AUS_DataDictionary dictionary = (AUS_DataDictionary)dict.getDictionary();
            IMapMarkerIndex PIDIndex = dictionary.getPIDIndex();
            if (PIDIndex == null) continue;
            try {
                value = (AUS_GNAFPIDIndexValue)PIDIndex.search((MapMarkerIndexKey)key);
            }
            catch (IOException IOEx) {
                throw new FatalDataAccessException(2102, (Throwable)IOEx);
            }
            if (value == null) continue;
            MMJDataFileMetadata metadata = dictionary.getStreetMetadataObject();
            try {
                dataFile = dictionary.getStreetDataFile(value.getFileName(), metadata);
            }
            catch (IOException IOEx) {
                throw new FatalDataAccessException(2102, (Throwable)IOEx);
            }
            MapMarkerIndexMultiValue tempIndexValue = new MapMarkerIndexMultiValue();
            tempIndexValue.addOffset((long)value.getOffset());
            ArrayList<AUS_PIDInternalCandidate> candList = null;
            try {
                List altStreetResults = this.getAlternateStreetData((IDataDictionary)dictionary, dataFile, (MapMarkerIndexValue)tempIndexValue, metadata);
                if (altStreetResults == null || altStreetResults.isEmpty()) continue;
                candList = new ArrayList<AUS_PIDInternalCandidate>();
                for (AbstractDataManager.AlternateStreetResult altResult : altStreetResults) {
                    StreetCandidateAddress street = altResult.getStreet();
                    street.setConstraints(constraints);
                    street.setFromUserDictionary(dictionary.isUserDictionary());
                    List altCandidates = dictionary.getAddressFetcher().makeAlternateStreetCandidates(street, dataFile, altResult.getAlternateRecord(), metadata, (IDataDictionary)dictionary, constraints);
                    if (altCandidates == null || altCandidates.isEmpty()) continue;
                    Iterator altsIterator = altCandidates.iterator();
                    while (altsIterator.hasNext()) {
                        candList.add(new AUS_PIDInternalCandidate((AUS_InternalCandidateAddress)((Object)altsIterator.next()), altResult.getAlternateRecord().getUnitNumber() >= 0));
                    }
                }
            }
            catch (LocalizationException LEx) {
                throw new FatalDataAccessException(2101, (Throwable)LEx);
            }
            catch (MMJEDataCorruptedException MMJEDCEx) {
                throw new FatalDataAccessException(2101, (Throwable)MMJEDCEx);
            }
            catch (IOException IOEx) {
                throw new FatalDataAccessException(2102, (Throwable)IOEx);
            }
            finally {
                try {
                    FileProviderFactory.getFileProvider().release(dataFile);
                    continue;
                }
                catch (IOException iOException) {}
            }
            retrieved = this.buildRetrievedCandidates(candList);
            LicenseFilter filter = this.getLicenseFilter();
            if (filter == null || (retrieved = filter.filterCandidates(retrieved, 0)).getCandidates().size() != 0) break;
            retrieved.setDataLicensed(false);
            break;
        }
        return retrieved;
    }

    public IRetrievedCandidates retrieveCandidates(Address pa, ScoringAddress scoringAddress, IConstraints preferences) throws DataAccessException, FatalDataAccessException {
        ((AUS_IConstraints)preferences).setFoundSacs(false);
        return super.retrieveCandidates(pa, scoringAddress, preferences);
    }

    public List getPostOfficeCandidates(Address addr, IConstraints constraints) throws DataAccessException {
        ArrayList results = new ArrayList();
        AbstractDataManager.DictionaryIterator dictionaryIterator = this.getDictionariesIterator(constraints);
        while (dictionaryIterator.hasNext()) {
            Collection candidates;
            AbstractDataManager.Dictionary dict = dictionaryIterator.next();
            AUS_DataDictionary dictionary = (AUS_DataDictionary)dict.getDictionary();
            IAUS_PostOfficeDataFetcher fetcher = dictionary.getPostOfficeDataFetcher();
            if (fetcher == null || (candidates = fetcher.getPostOfficeCandidates(addr)) == null || candidates.isEmpty()) continue;
            results.addAll(candidates);
        }
        return results;
    }

    public void finalize() throws Throwable {
        super.finalize();
        if (this.m_lastIndexFile != null) {
            FileProviderFactory.getFileProvider().release(this.m_lastIndexFile);
            this.m_lastIndexFile = null;
        }
    }

    static {
        try {
            Properties settings = DataManagerSettingsProvider.getInstance().getSettingsForCountry("AUS");
            if (settings.getProperty("DO_NOT_PRE_INIT") == null) {
                AUS_DataManager.start();
            }
        }
        catch (IOException IOEx) {
            AUS_DataManager.start();
        }
    }
}

