/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.dp.binary;

import com.mapinfo.mapmarker.AUS.AUS_CandidateConstants;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_GeoInfoRecord;
import com.mapinfo.mapmarker.AUS.dp.binary.index.AUS_GeoInfoIndexFile;
import com.mapinfo.mapmarker.AUS.utils.AUS_StringUtilities;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.GenericSegment;
import com.mapinfo.mapmarker.common.dp.binary.GenericStreetBuilder;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoDataItem;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.index.GeoInfoIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexSingleValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.FileNotFoundException;
import java.io.IOException;

public class AUS_GenericStreetBuilder
extends GenericStreetBuilder {
    private GeoInfoIndexFile m_geoIndex;

    public void setGeoInfoPath(String geoInfoPath) throws DataCreationException {
        try {
            this.m_geoIndex = new AUS_GeoInfoIndexFile();
            this.m_geoIndex.open(StringUtilities.appendToPath((String)geoInfoPath, (String)"geoinfo.jdx"));
        }
        catch (FileNotFoundException ex) {
            throw new DataCreationException("setGeoInfoPath: geoinfo.jdx not found for open at: " + geoInfoPath);
        }
        catch (IOException IOEx) {
            throw new DataCreationException(2001, "setGeoInfoPath:unable to open geoinfo index at: " + geoInfoPath, (Throwable)IOEx);
        }
    }

    protected GeoInfoIndexFile getGeoInfoIndex() {
        return this.m_geoIndex;
    }

    protected void populateLocalGeoInfo(GeoInfoRecord record, IDataFileDataItem geoInfoItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        AUS_GeoInfoRecord ausRecord = (AUS_GeoInfoRecord)record;
        GeoInfoDataItem geoInfo = (GeoInfoDataItem)geoInfoItem;
        try {
            int stateNumber;
            if (!AUS_StringUtilities.isEmpty(ausRecord.getPostcode())) {
                geoInfo.putString(8, ausRecord.getPostcode());
            }
            if (!AUS_StringUtilities.isEmpty(ausRecord.getAreaName1()) && (stateNumber = AUS_CandidateConstants.getStateNumber(ausRecord.getAreaName1())) > 0) {
                geoInfo.removeString(0);
                geoInfo.putByte(32, (byte)stateNumber);
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("ERROR: Unable to build GeoInfoDataItem.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(301, (Throwable)e);
        }
    }

    protected void populateLocalSegmentInfo(MMJSegmentRecord segmentRecord, IDataFileDataItem segmentItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        block25: {
            GenericSegment segment = (GenericSegment)segmentItem;
            try {
                short rightPost;
                String appendedAreaNameString;
                if (this.m_geoIndex != null && !(appendedAreaNameString = (segmentRecord.getLeftAreaName1() != null ? segmentRecord.getLeftAreaName1() : "") + (segmentRecord.getLeftAreaName2() != null ? segmentRecord.getLeftAreaName2() : "") + (segmentRecord.getLeftAreaName3() != null ? segmentRecord.getLeftAreaName3() : "") + (segmentRecord.getLeftAreaName4() != null ? segmentRecord.getLeftAreaName4() : "")).trim().equals("")) {
                    MapMarkerIndexSingleValue val;
                    MiStringIndexKey key = new MiStringIndexKey(appendedAreaNameString);
                    try {
                        val = (MapMarkerIndexSingleValue)this.m_geoIndex.search((MapMarkerIndexKey)key);
                    }
                    catch (Exception e1) {
                        DataCreationLogger.getLogger().logInternalError("Problem building generic segment.  Unable to lookup areaName in geoinfo.");
                        throw new DataCreationException(301, (Throwable)e1);
                    }
                    if (val != null && val.getOffset() > 0L) {
                        long geoOffset = val.getOffset();
                        segment.putLong(0, geoOffset);
                        segment.removeString(16);
                        segment.removeString(14);
                        if (segment.hasString(15)) {
                            segment.removeString(15);
                        }
                    } else {
                        DataCreationLogger.getLogger().logInternalError("Unable to get geoinfo record for: " + appendedAreaNameString);
                    }
                }
                if (segmentRecord.getLeftPostalCode1() != null) {
                    short leftPost;
                    try {
                        leftPost = Short.parseShort(segmentRecord.getLeftPostalCode1());
                    }
                    catch (NumberFormatException NFEx) {
                        leftPost = -1;
                    }
                    if (segmentRecord.getRightPostalCode1() != null) {
                        short rightPost2;
                        try {
                            rightPost2 = Short.parseShort(segmentRecord.getRightPostalCode1());
                        }
                        catch (NumberFormatException NFEx) {
                            rightPost2 = -1;
                        }
                        if (leftPost != -1 && leftPost == rightPost2) {
                            segment.removeString(12);
                            segment.putShort(32, leftPost);
                        } else if (leftPost != -1 && rightPost2 != -1) {
                            segment.removeString(0);
                            segment.putShort(33, leftPost);
                            segment.removeString(1);
                            segment.putShort(34, rightPost2);
                        } else if (leftPost != -1) {
                            segment.removeString(0);
                            segment.putShort(33, leftPost);
                        } else if (rightPost2 != -1) {
                            segment.removeString(1);
                            segment.putShort(34, rightPost2);
                        }
                        break block25;
                    }
                    if (leftPost != -1) {
                        segment.removeString(0);
                        segment.putShort(33, leftPost);
                    }
                    break block25;
                }
                if (segmentRecord.getRightPostalCode1() == null) break block25;
                try {
                    rightPost = Short.parseShort(segmentRecord.getRightPostalCode1());
                }
                catch (NumberFormatException NFEx) {
                    rightPost = -1;
                }
                if (rightPost != -1) {
                    segment.removeString(1);
                    segment.putShort(34, rightPost);
                }
            }
            catch (MMJETypeArraySizeExceededException MMJETASEEx) {
                DataCreationLogger.getLogger().logInternalError("Unable to populate segment data.");
                DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
                DataCreationLogger.getLogger().logStackTrace((Throwable)MMJETASEEx);
                throw new DataCreationException(106, (Throwable)MMJETASEEx);
            }
        }
    }
}

