/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.dp.binary;

import com.mapinfo.mapmarker.AUS.AUSLanguageSoundex;
import com.mapinfo.mapmarker.AUS.AUS_InternalGeographicCandidate;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_GeoInfoRecord;
import com.mapinfo.mapmarker.AUS.dp.binary.index.AUS_GeoInfoSoundexIndexFile;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.InternalGeographicCandidate;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItem;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItemAccessor;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoDataItem;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoFetcherImpl;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.IDataAccessHelper;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MiSoundexIndexKey;
import com.mapinfo.midev.geometry.DirectPosition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class AUS_GeoInfoFetcherImpl
extends GeoInfoFetcherImpl {
    private static final Soundex m_soundex = new AUSLanguageSoundex();

    public AUS_GeoInfoFetcherImpl(String dataPath, Properties localSettings, Properties localMessages) throws DataDictionaryIntializationException {
        super(dataPath, localSettings, localMessages);
    }

    protected IDataAccessHelper getDataAccessHelperType() {
        return new AUS_GeoInfoPreLoadedDataHelper();
    }

    protected IMapMarkerIndex getGeoInfoIndexType() {
        return new AUS_GeoInfoSoundexIndexFile();
    }

    protected String getGeoInfoIndexFileName() {
        return "geoinfo.sdx";
    }

    protected InternalGeographicCandidate makeInternalGeographicCandidate() {
        return new AUS_InternalGeographicCandidate();
    }

    protected ICandidate makeGeoInfoCandidate(GeoInfoRecord record) {
        ICandidate candidate = super.makeGeoInfoCandidate(record);
        ((AUS_InternalGeographicCandidate)candidate).setCode(((AUS_GeoInfoRecord)record).getPostcode());
        return candidate;
    }

    protected MapMarkerIndexKey[] makeGeoInfoIndexKeys(Address addr, IConstraints constraints) {
        ISoundexKey area3Key;
        String areaName3 = addr.getAreaName3();
        if (areaName3 != null && (area3Key = m_soundex.getSoundex(areaName3)) != null) {
            return new MapMarkerIndexKey[]{new MiSoundexIndexKey((MiSoundexKey)area3Key)};
        }
        return new MapMarkerIndexKey[0];
    }

    public List getGeoInfoCandidates(Address addr, IConstraints constraints) throws IOException, LocalizationException, MMJEDataCorruptedException {
        List candidates = super.getGeoInfoCandidates(addr, constraints);
        ArrayList<AUS_InternalGeographicCandidate> outList = null;
        if (candidates != null && candidates.size() > 0) {
            outList = new ArrayList<AUS_InternalGeographicCandidate>(candidates.size());
            for (AUS_InternalGeographicCandidate candidate : candidates) {
                outList.add(candidate);
            }
        }
        return outList;
    }

    private class AUS_GeoInfoPreLoadedDataHelper
    implements IDataAccessHelper {
        private AUS_GeoInfoPreLoadedDataHelper() {
        }

        public IDataFileDataItem getDataItemType() {
            return new GeoInfoDataItem();
        }

        public MMJDataFileMetadata getMetadataType() {
            return new MMJComplexDataFileMetadata();
        }

        public Object makeDataRecord(IDataFileDataItem item, MMJDataFileMetadata metadata) throws LocalizationException {
            AUS_GeoInfoRecord record = new AUS_GeoInfoRecord();
            GenericDataItem genericItem = (GenericDataItem)item;
            if (genericItem.hasByte(32)) {
                record.setStateNumber(GenericDataItemAccessor.getDataByte((int)32, (GenericDataItem)genericItem));
            }
            if (genericItem.hasString(8)) {
                record.setPostcode(GenericDataItemAccessor.getDataString((int)8, (GenericDataItem)genericItem));
            }
            if (genericItem.hasString(0)) {
                record.setAreaName1(GenericDataItemAccessor.getDataString((int)0, (GenericDataItem)genericItem));
            }
            if (genericItem.hasString(1)) {
                record.setAreaName2(GenericDataItemAccessor.getDataString((int)1, (GenericDataItem)genericItem));
            }
            if (genericItem.hasString(2)) {
                record.setAreaName3(GenericDataItemAccessor.getDataString((int)2, (GenericDataItem)genericItem));
            }
            if (genericItem.hasString(6)) {
                String alternates = GenericDataItemAccessor.getDataString((int)6, (GenericDataItem)genericItem);
                String[] alternatesArray = alternates.split(";");
                for (int i = 0; i < alternatesArray.length; ++i) {
                    alternatesArray[i] = alternatesArray[i].trim();
                }
                record.setAreaName3Alternates(alternatesArray);
            }
            if (genericItem.hasLong(0)) {
                long xCoord = GenericDataItemAccessor.getDataLong((int)0, (GenericDataItem)genericItem);
                if (genericItem.hasLong(1)) {
                    long yCoord = GenericDataItemAccessor.getDataLong((int)1, (GenericDataItem)genericItem);
                    DirectPosition pnt = new DirectPosition((double)xCoord / Math.pow(10.0, metadata.getXPow10()), (double)yCoord / Math.pow(10.0, metadata.getYPow10()));
                    record.setPoint(pnt);
                    if (genericItem.hasByte(0)) {
                        record.setPrecision(GenericDataItemAccessor.getDataByte((int)0, (GenericDataItem)genericItem));
                    }
                }
            }
            return record;
        }
    }
}

