/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.dp.binary;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecordComparator;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecordComparator;
import java.util.Collections;

public class AUS_MMJStreetRecordComparator
extends MMJStreetRecordComparator {
    protected MMJRangeRecordComparator m_rangeComparator;

    public AUS_MMJStreetRecordComparator(MMJRangeRecordComparator rangeComparator) {
        this.m_rangeComparator = rangeComparator;
    }

    public int compare(Object o1, Object o2) {
        MMJStreetRecord record1 = (MMJStreetRecord)o1;
        MMJStreetRecord record2 = (MMJStreetRecord)o2;
        if (record1.getSegment().getRanges() != null && !record1.getSegment().rangesSorted()) {
            Collections.sort(record1.getSegment().getRanges(), this.m_rangeComparator);
            record1.getSegment().setRangesSorted();
        }
        if (record2.getSegment().getRanges() != null && !record2.getSegment().rangesSorted()) {
            Collections.sort(record2.getSegment().getRanges(), this.m_rangeComparator);
            record2.getSegment().setRangesSorted();
        }
        if (record1.getSac() == record2.getSac()) {
            if (record1.getKey().equals(record2.getKey())) {
                return this.compareStreetInfo(record1, record2);
            }
            return record1.getKey().compareTo((Object)record2.getKey());
        }
        if (record1.getSac() < record2.getSac()) {
            return -1;
        }
        return 1;
    }

    protected int compareStreetInfo(MMJStreetRecord record1, MMJStreetRecord record2) {
        String addressString2;
        String addressString1 = this.buildStreetString(record1.getAddress());
        if (addressString1.equals(addressString2 = this.buildStreetString(record2.getAddress()))) {
            return this.comparePostalInfo(record1, record2);
        }
        return addressString1.compareTo(addressString2);
    }

    protected String buildStreetString(Address address) {
        if (address == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(address.getPreThoroughfareType() == null ? "" : address.getPreThoroughfareType());
        buffer.append(address.getPreAddress() == null ? "" : address.getPreAddress());
        buffer.append(address.getMainAddress() == null ? "" : address.getMainAddress());
        buffer.append(address.getPostThoroughfareType() == null ? "" : address.getPostThoroughfareType());
        return buffer.toString();
    }

    protected int comparePostalInfo(MMJStreetRecord record1, MMJStreetRecord record2) {
        if (record1.getSegment().getLeftPostalCode1() != null && record1.getSegment().getRightPostalCode1() != null && record1.getSegment().getLeftPostalCode1().equals(record1.getSegment().getRightPostalCode1())) {
            if (record2.getSegment().getLeftPostalCode1() != null && record2.getSegment().getRightPostalCode1() != null && record2.getSegment().getLeftPostalCode1().equals(record2.getSegment().getRightPostalCode1())) {
                if (record1.getSegment().getLeftPostalCode1().equals(record2.getSegment().getLeftPostalCode1())) {
                    return this.compareGeoInfo(record1, record2);
                }
                return record1.getSegment().getLeftPostalCode1().compareTo(record2.getSegment().getLeftPostalCode1());
            }
            return 1;
        }
        if (record2.getSegment().getLeftPostalCode1() != null && record2.getSegment().getRightPostalCode1() != null && record2.getSegment().getLeftPostalCode1().equals(record2.getSegment().getRightPostalCode1())) {
            return -1;
        }
        return this.compareGeoInfo(record1, record2);
    }

    protected int compareGeoInfo(MMJStreetRecord record1, MMJStreetRecord record2) {
        if (record1.getSegment().getLeftAreaName3() != null && record1.getSegment().getRightAreaName3() != null && record1.getSegment().getLeftAreaName3().equals(record1.getSegment().getRightAreaName3())) {
            if (record2.getSegment().getLeftAreaName3() != null && record2.getSegment().getRightAreaName3() != null && record2.getSegment().getLeftAreaName3().equals(record2.getSegment().getRightAreaName3())) {
                if (record1.getSegment().getLeftAreaName3().equals(record2.getSegment().getLeftAreaName3())) {
                    return this.compareRangeInfo(record1, record2);
                }
                return record1.getSegment().getLeftAreaName3().compareTo(record2.getSegment().getLeftAreaName3());
            }
            return 1;
        }
        if (record2.getSegment().getLeftAreaName3() != null && record2.getSegment().getRightAreaName3() != null && record2.getSegment().getLeftAreaName3().equals(record2.getSegment().getRightAreaName3())) {
            return -1;
        }
        return this.compareRangeInfo(record1, record2);
    }

    protected int compareRangeInfo(MMJStreetRecord record1, MMJStreetRecord record2) {
        if (record1.getSegment().getRanges() != null) {
            if (record2.getSegment().getRanges() != null) {
                return this.m_rangeComparator.compare(record1.getSegment().getRanges().get(0), record2.getSegment().getRanges().get(0));
            }
            return 1;
        }
        if (record2.getSegment().getRanges() != null) {
            return -1;
        }
        return 0;
    }
}

