/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.dp.binary;

import com.mapinfo.mapmarker.AUS.AUSLanguageSoundex;
import com.mapinfo.mapmarker.AUS.AUS_InternalPostOfficeCandidateAddress;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_PostOfficeDataItem;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_PostOfficeRecord;
import com.mapinfo.mapmarker.AUS.dp.binary.IAUS_PostOfficeDataFetcher;
import com.mapinfo.mapmarker.AUS.dp.binary.index.AUS_PostOfficeGeoIndex;
import com.mapinfo.mapmarker.AUS.dp.binary.index.AUS_PostOfficePostalIndex;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.IDataAccess;
import com.mapinfo.mapmarker.common.dp.binary.IDataAccessHelper;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.OnDemandDataAccess;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerReadOnlyIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexMultiValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MiSoundexIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.ShortIndexKey;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;

class AUS_PostOfficeDataFetcher
implements IAUS_PostOfficeDataFetcher {
    private static final String POSTOFFICE_DATA_FILE = "postoffice.jdr";
    private static final String POSTOFFICE_POSTAL_INDEX_FILE = "postoffice.pdx";
    private static final String POSTOFFICE_GEO_INDEX_FILE = "postoffice.gdx";
    protected static final String NO_POSTOFFICE_DATA_FILE = "exception.no.data.postoffice";
    protected static final String GEOINFO_DATA_FILE_OPEN = "exception.open.data.postoffice";
    protected static final String GEOINFO_DATA_FILE_ACCESS = "exception.access.data.postoffice";
    protected static final String NO_POSTOFFICE_POSTAL_INDEX_FILE = "exception.no.index.postal.postoffice";
    protected static final String POSTOFFICE_POSTAL_INDEX_FILE_OPEN = "exception.open.index.postal.postoffice";
    protected static final String POSTOFFICE_POSTAL_INDEX_FILE_ACCESS = "exception.access.index.postal.postoffice";
    protected static final String NO_POSTOFFICE_GEO_INDEX_FILE = "exception.no.index.geo.postoffice";
    protected static final String POSTOFFICE_GEO_INDEX_FILE_OPEN = "exception.open.index.geo.postoffice";
    protected static final String POSTOFFICE_GEO_INDEX_FILE_ACCESS = "exception.access.index.geo.postoffice";
    private Soundex m_soundex = new AUSLanguageSoundex();
    private IDataAccess m_data = new OnDemandDataAccess((IDataAccessHelper)new DataHelper());
    private IMapMarkerReadOnlyIndexFile m_postalIndex;
    private IMapMarkerReadOnlyIndexFile m_geoIndex;

    AUS_PostOfficeDataFetcher(String dataPath) throws DataDictionaryIntializationException {
        try {
            this.m_data.init(StringUtilities.appendToPath((String)dataPath, (String)POSTOFFICE_DATA_FILE));
        }
        catch (DataAccessException DAEx) {
            throw new DataDictionaryIntializationException(GEOINFO_DATA_FILE_ACCESS, (Throwable)DAEx);
        }
        catch (FileNotFoundException FNFEx) {
            throw new DataDictionaryIntializationException(NO_POSTOFFICE_DATA_FILE, (Throwable)FNFEx);
        }
        catch (IOException IOEx) {
            throw new DataDictionaryIntializationException(GEOINFO_DATA_FILE_OPEN, (Throwable)IOEx);
        }
        this.m_postalIndex = new AUS_PostOfficePostalIndex();
        try {
            this.m_postalIndex.open(StringUtilities.appendToPath((String)dataPath, (String)POSTOFFICE_POSTAL_INDEX_FILE));
        }
        catch (FileNotFoundException FNFEx) {
            throw new DataDictionaryIntializationException(NO_POSTOFFICE_POSTAL_INDEX_FILE, (Throwable)FNFEx);
        }
        catch (IOException IOEx) {
            throw new DataDictionaryIntializationException(POSTOFFICE_POSTAL_INDEX_FILE_OPEN, (Throwable)IOEx);
        }
        this.m_geoIndex = new AUS_PostOfficeGeoIndex();
        try {
            this.m_geoIndex.open(StringUtilities.appendToPath((String)dataPath, (String)POSTOFFICE_GEO_INDEX_FILE));
        }
        catch (FileNotFoundException FNFEx) {
            throw new DataDictionaryIntializationException(NO_POSTOFFICE_GEO_INDEX_FILE, (Throwable)FNFEx);
        }
        catch (IOException IOEx) {
            throw new DataDictionaryIntializationException(POSTOFFICE_GEO_INDEX_FILE_OPEN, (Throwable)IOEx);
        }
    }

    @Override
    public Collection getPostOfficeCandidates(Address addr) throws DataAccessException {
        MapMarkerIndexMultiValue uniqueValues;
        MapMarkerIndexKey postalKey = this.makePostalKey(addr);
        MapMarkerIndexKey geoKey = this.makeGeoKey(addr);
        MapMarkerIndexMultiValue postalValue = null;
        MapMarkerIndexMultiValue geoValue = null;
        if (postalKey != null) {
            try {
                postalValue = (MapMarkerIndexMultiValue)this.m_postalIndex.search(postalKey);
            }
            catch (IOException IOEx) {
                throw new DataAccessException(2102);
            }
        }
        if (geoKey != null) {
            try {
                geoValue = (MapMarkerIndexMultiValue)this.m_geoIndex.search(geoKey);
            }
            catch (IOException IOEx) {
                throw new DataAccessException(2102);
            }
        }
        if ((uniqueValues = this.removeDuplicateIndexValues(postalValue, geoValue)) == null) {
            return null;
        }
        LinkedList<AUS_InternalPostOfficeCandidateAddress> candidates = new LinkedList<AUS_InternalPostOfficeCandidateAddress>();
        for (short i = 0; i < uniqueValues.getValueCount(); i = (short)(i + 1)) {
            candidates.add(new AUS_InternalPostOfficeCandidateAddress((AUS_PostOfficeRecord)this.m_data.getRecord(uniqueValues.getOffsetAt(i))));
        }
        return candidates;
    }

    private MapMarkerIndexKey makePostalKey(Address addr) {
        String postCode = addr.getPostCode1();
        if (postCode == null) {
            return null;
        }
        try {
            return new ShortIndexKey(Short.parseShort(postCode));
        }
        catch (NumberFormatException NFEx) {
            return null;
        }
    }

    private MapMarkerIndexKey makeGeoKey(Address addr) {
        String areaName3 = addr.getAreaName3();
        if (areaName3 == null) {
            return null;
        }
        MiSoundexKey soundex = (MiSoundexKey)this.m_soundex.getSoundex(areaName3);
        if (soundex == null) {
            return null;
        }
        return new MiSoundexIndexKey(soundex);
    }

    private MapMarkerIndexMultiValue removeDuplicateIndexValues(MapMarkerIndexMultiValue postalValues, MapMarkerIndexMultiValue geoValues) {
        if (postalValues == null && geoValues == null) {
            return null;
        }
        if (postalValues == null) {
            return geoValues;
        }
        if (geoValues == null) {
            return postalValues;
        }
        TreeSet valuesSet = new TreeSet();
        this.addValues(postalValues, valuesSet);
        this.addValues(geoValues, valuesSet);
        MapMarkerIndexMultiValue outputValue = new MapMarkerIndexMultiValue();
        Iterator iterator = valuesSet.iterator();
        while (iterator.hasNext()) {
            outputValue.addOffset(((Long)iterator.next()).longValue());
        }
        return outputValue;
    }

    private void addValues(MapMarkerIndexMultiValue value, Collection values) {
        for (short i = 0; i < value.getValueCount(); i = (short)(i + 1)) {
            values.add(new Long(value.getOffsetAt(i)));
        }
    }

    private static class DataHelper
    implements IDataAccessHelper {
        private DataHelper() {
        }

        public IDataFileDataItem getDataItemType() {
            return new AUS_PostOfficeDataItem();
        }

        public MMJDataFileMetadata getMetadataType() {
            return new MMJDataFileMetadata();
        }

        public Object makeDataRecord(IDataFileDataItem item, MMJDataFileMetadata metadata) {
            return new AUS_PostOfficeRecord((AUS_PostOfficeDataItem)item);
        }
    }
}

