/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.dp.binary;

import com.mapinfo.mapmarker.AUS.dp.binary.AUS_PostOfficeRecord;
import com.mapinfo.mapmarker.common.dp.binary.CompressedSegment;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.midev.geometry.DirectPosition;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AUS_PostOfficeDataItem
extends AUS_PostOfficeRecord
implements IDataFileDataItem {
    private static final byte POSTCODE = 1;
    private static final byte AREANAME1 = 2;
    private static final byte AREANAME3 = 4;

    public AUS_PostOfficeDataItem() {
    }

    public AUS_PostOfficeDataItem(AUS_PostOfficeRecord record) {
        super(record);
    }

    public void write(DataOutput out, MMJDataFileMetadata metadata) throws IOException {
        int mask = 0;
        if (this.getPostCode() != null) {
            mask |= 1;
        }
        if (this.getAreaName1() != null) {
            mask |= 2;
        }
        if (this.getAreaName3() != null) {
            mask |= 4;
        }
        out.writeByte(mask);
        if ((mask & 1) != 0) {
            out.writeUTF(this.getPostCode());
        }
        if ((mask & 2) != 0) {
            out.writeUTF(this.getAreaName1());
        }
        if ((mask & 4) != 0) {
            out.writeUTF(this.getAreaName3());
        }
        out.writeLong(CompressedSegment.convertDoubleToLongAndRound((double)this.getLocation().getX(), (byte)metadata.getXPow10()));
        out.writeLong(CompressedSegment.convertDoubleToLongAndRound((double)this.getLocation().getY(), (byte)metadata.getYPow10()));
    }

    public void read(DataInput in, MMJDataFileMetadata metadata) throws IOException {
        byte mask = in.readByte();
        if ((mask & 1) != 0) {
            this.setPostCode(in.readUTF());
        }
        if ((mask & 2) != 0) {
            this.setAreaName1(in.readUTF());
        }
        if ((mask & 4) != 0) {
            this.setAreaName3(in.readUTF());
        }
        long longX = in.readLong();
        long longY = in.readLong();
        this.setLocation(new DirectPosition((double)longX / (double)metadata.getXFactor(), (double)longY / (double)metadata.getYFactor()));
    }
}

