/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.dp.binary.gnaf;

import com.mapinfo.mapmarker.AUS.utils.GNAFAddressClass;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeUnitRecord;
import com.mapinfo.mapmarker.utils.LongPoint;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Collections;

public class AUS_GNAFMMJRangeRecord
extends MMJRangeRecord {
    private byte m_reliability = 0;
    private byte m_confidence = (byte)-2;
    private byte m_geocodeLevel = (byte)-1;
    private String m_PID;
    private String m_lotNumber;
    private String m_lotPrefix;
    private String m_lotSuffix;
    private boolean m_bUsedLotForHouse = false;
    private boolean m_bUnitsSorted;
    private LongPoint m_originalPoint;
    private String m_primaryPID;
    private boolean m_geoContainment;
    private String m_geoFeature;
    private GNAFAddressClass m_addressClass;
    private String m_parcelID;

    public void setReliability(byte reliability) {
        this.m_reliability = reliability;
    }

    public boolean hasValidReliability() {
        return this.m_reliability != 0;
    }

    public byte getReliability() {
        return this.m_reliability;
    }

    public void setConfidence(byte confidence) {
        this.m_confidence = confidence;
    }

    public boolean hasValidConfidence() {
        return this.m_confidence != -2;
    }

    public byte getConfidence() {
        return this.m_confidence;
    }

    public void setGeocodeLevel(byte level) {
        this.m_geocodeLevel = level;
    }

    public boolean hasValidGeocodeLevel() {
        return this.m_geocodeLevel != -1;
    }

    public byte getGeocodeLevel() {
        return this.m_geocodeLevel;
    }

    public void setPID(String PID) {
        this.m_PID = PID;
    }

    public String getPID() {
        return this.m_PID;
    }

    public boolean hasPID() {
        return this.m_PID != null;
    }

    public int getUniquePIDValue() throws NumberFormatException {
        return Integer.parseInt(this.m_PID.substring(5));
    }

    public void removeRangeAttributes() {
        this.m_confidence = (byte)-2;
        this.m_geocodeLevel = (byte)-1;
        this.m_PID = null;
        this.setAlternateDataItems(null);
        this.setPlaceName(null);
        this.setAdditionalFields(Collections.emptyMap());
        this.m_primaryPID = null;
        this.m_addressClass = null;
        this.m_parcelID = null;
    }

    public void addRangeUnit(MMJRangeUnitRecord unit) {
        if (this.m_bUnitsSorted && this.getRangeUnits() != null && this.getRangeUnits().size() >= 1) {
            this.m_bUnitsSorted = false;
        }
        super.addRangeUnit(unit);
    }

    public boolean areUnitsSorted() {
        return this.m_bUnitsSorted;
    }

    public void setUnitsAreSorted(boolean bUnitsSorted) {
        this.m_bUnitsSorted = bUnitsSorted;
    }

    public void setOriginalPoint(LongPoint point) {
        this.m_originalPoint = point;
    }

    public LongPoint getOriginalPoint() {
        return this.m_originalPoint;
    }

    public boolean hasLotNumber() {
        return this.m_lotNumber != null;
    }

    public void setLotNumber(String lotNumber) {
        this.m_lotNumber = this.emptyToNull(lotNumber);
    }

    public String getLotNumber() {
        return this.m_lotNumber;
    }

    public boolean hasLotPrefix() {
        return this.m_lotPrefix != null;
    }

    public void setLotPrefix(String lotPrefix) {
        this.m_lotPrefix = this.emptyToNull(lotPrefix);
    }

    public String getLotPrefix() {
        return this.m_lotPrefix;
    }

    public boolean hasLotSuffix() {
        return this.m_lotSuffix != null;
    }

    public void setLotSuffix(String lotSuffix) {
        this.m_lotSuffix = this.emptyToNull(lotSuffix);
    }

    public String getLotSuffix() {
        return this.m_lotSuffix;
    }

    public boolean isUsedLotForHouse() {
        return this.m_bUsedLotForHouse;
    }

    public void setUsedLotForHouse(boolean b) {
        this.m_bUsedLotForHouse = b;
    }

    private String emptyToNull(String str) {
        if (str != null) {
            if (str.length() == 0) {
                return null;
            }
            if ((str = str.trim()).length() == 0) {
                return null;
            }
        }
        return str;
    }

    public void setPrimaryPID(String primaryPID) {
        this.m_primaryPID = !StringUtilities.isEmpty((String)primaryPID) ? primaryPID : null;
    }

    public boolean hasPrimaryPID() {
        return this.m_primaryPID != null;
    }

    public String getPrimaryPID() {
        return this.m_primaryPID;
    }

    public int getUniquePrimaryPIDValue() throws NumberFormatException {
        return Integer.parseInt(this.m_primaryPID.substring(5));
    }

    public void setGeoContainment(boolean flag) {
        this.m_geoContainment = flag;
    }

    public boolean getGeoContainment() {
        return this.m_geoContainment;
    }

    public void setGeoFeature(String geoFeature) {
        this.m_geoFeature = geoFeature;
    }

    public String getGeoFeature() {
        return this.m_geoFeature;
    }

    public void setAddressClass(GNAFAddressClass addressClass) {
        this.m_addressClass = addressClass;
    }

    public GNAFAddressClass getAddressClass() {
        return this.m_addressClass;
    }

    public void setParcelID(String parcelID) {
        this.m_parcelID = StringUtilities.isEmpty((String)parcelID) ? null : parcelID;
    }

    public String getParcelID() {
        return this.m_parcelID;
    }
}

