/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.dp.binary.gnaf;

import com.mapinfo.mapmarker.AUS.dp.binary.gnaf.AUS_GNAFMMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.utils.LongPoint;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class AUS_GNAFMMJSegmentRecord
extends MMJSegmentRecord {
    private String m_localityPID;
    private byte m_reliability;
    private long m_meshBlock;
    private LongPoint m_originalPoint;
    private boolean m_geoContainment;
    private String m_geoFeature;
    private long m_SA1;

    public AUS_GNAFMMJSegmentRecord() {
        this.m_reliability = 0;
        this.m_meshBlock = 0L;
        this.m_SA1 = 0L;
    }

    public AUS_GNAFMMJSegmentRecord(MMJSegmentRecord that) {
        super(that);
    }

    protected void copy(MMJSegmentRecord that) {
        super.copy(that);
        if (!(that instanceof AUS_GNAFMMJSegmentRecord)) {
            throw new IllegalArgumentException("copying from a segment that is not a AUS_GNAFMMJSegmentRecord");
        }
        AUS_GNAFMMJSegmentRecord AUSSegment = (AUS_GNAFMMJSegmentRecord)that;
        this.setMeshBlock(AUSSegment.getMeshBlock());
        this.setReliability(AUSSegment.getReliability());
        this.setGeoContainment(AUSSegment.getGeoContainment());
        this.setGeoFeature(AUSSegment.getGeoFeature());
        this.setSA1(AUSSegment.getSA1());
    }

    public void setLocalityPID(String localityPID) {
        this.m_localityPID = localityPID;
    }

    public String getLocalityPID() {
        return this.m_localityPID;
    }

    public void setMeshBlock(long meshBlock) {
        this.m_meshBlock = meshBlock;
    }

    public boolean hasValidMeshBlock() {
        return this.m_meshBlock != 0L;
    }

    public long getMeshBlock() {
        return this.m_meshBlock;
    }

    public void setReliability(byte reliability) {
        this.m_reliability = reliability;
    }

    public boolean hasValidReliability() {
        return this.m_reliability != 0;
    }

    public byte getReliability() {
        return this.m_reliability;
    }

    public void setOriginalPoint(LongPoint point) {
        this.m_originalPoint = point;
    }

    public LongPoint getOriginalPoint() {
        return this.m_originalPoint;
    }

    public void setGeoContainment(boolean flag) {
        this.m_geoContainment = flag;
    }

    public boolean getGeoContainment() {
        return this.m_geoContainment;
    }

    public void setGeoFeature(String geoFeature) {
        this.m_geoFeature = geoFeature;
    }

    public String getGeoFeature() {
        return this.m_geoFeature;
    }

    public void setIsPointHouseSegment() {
        super.setIsPointHouseSegment();
        this.m_originalPoint = null;
    }

    public List getOriginalPointsGeometry() {
        if (!this.isPointHouseSegment()) {
            return null;
        }
        List ranges = this.getRanges();
        if (ranges != null && !ranges.isEmpty() && (this.rangesSorted() || ranges.size() == 1)) {
            Iterator rangesIterator = ranges.iterator();
            LinkedList<LongPoint> geometry = new LinkedList<LongPoint>();
            while (rangesIterator.hasNext()) {
                geometry.add(((AUS_GNAFMMJRangeRecord)((Object)rangesIterator.next())).getOriginalPoint());
            }
            return geometry;
        }
        if (ranges == null) {
            DataCreationLogger.getLogger().logInternalError("\tranges are null.");
        } else if (!this.rangesSorted()) {
            DataCreationLogger.getLogger().logInternalError("\tranges not sorted.");
        }
        return null;
    }

    public String toString() {
        return super.toString() + "\n\tmeshBlock: " + this.m_meshBlock + "\n\treliability: " + this.m_reliability;
    }

    public boolean hasSA1() {
        return this.m_SA1 != 0L;
    }

    public void setSA1(long SA1) {
        this.m_SA1 = SA1;
    }

    public long getSA1() {
        return this.m_SA1;
    }
}

