/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.dp.binary.gnaf;

import com.mapinfo.mapmarker.AUS.dp.binary.gnaf.AUS_GNAFMMJRangeRecord;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecordComparator;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeUnitRecord;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class AUS_GNAFRangeRecordComparator
extends MMJRangeRecordComparator {
    private static final Comparator m_unitComparator = new UnitComparator();

    public int compare(Object o1, Object o2) {
        int superCompare = super.compare(o1, o2);
        if (superCompare != 0) {
            return superCompare;
        }
        AUS_GNAFMMJRangeRecord range1 = (AUS_GNAFMMJRangeRecord)((Object)o1);
        AUS_GNAFMMJRangeRecord range2 = (AUS_GNAFMMJRangeRecord)((Object)o2);
        List units1 = range1.getRangeUnits();
        List units2 = range2.getRangeUnits();
        if (units1 == null && units2 == null) {
            return 0;
        }
        if (units1 == null) {
            return -1;
        }
        if (units2 == null) {
            return 1;
        }
        if (!range1.areUnitsSorted()) {
            Collections.sort(units1, m_unitComparator);
            range1.setUnitsAreSorted(true);
        }
        if (!range2.areUnitsSorted()) {
            Collections.sort(units2, m_unitComparator);
            range2.setUnitsAreSorted(true);
        }
        return this.compareUnits(units1, units2);
    }

    private int compareUnits(List units1, List units2) {
        return m_unitComparator.compare(units1.get(0), units2.get(0));
    }

    private static class UnitComparator
    implements Comparator {
        private UnitComparator() {
        }

        public int compare(Object o1, Object o2) {
            ParsedNumber low2;
            MMJRangeUnitRecord unit1 = (MMJRangeUnitRecord)o1;
            MMJRangeUnitRecord unit2 = (MMJRangeUnitRecord)o2;
            ParsedNumber low1 = new ParsedNumber(unit1.getLowUnit());
            int compare = low1.compareTo((Object)(low2 = new ParsedNumber(unit2.getLowUnit())));
            if (compare != 0) {
                return compare;
            }
            ParsedNumber high1 = new ParsedNumber(unit1.getHighUnit());
            ParsedNumber high2 = new ParsedNumber(unit2.getHighUnit());
            return high1.compareTo((Object)high2);
        }
    }
}

