/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AUS_GNAFPIDIndexKey
implements MapMarkerIndexKey {
    private static final String[] STATE_PORTIONS = new String[]{"ACT", "NSW", "NT_", "OT_", "QLD", "SA_", "TAS", "VIC", "WA_"};
    private byte m_state;
    private int m_PID;

    public AUS_GNAFPIDIndexKey() {
    }

    public AUS_GNAFPIDIndexKey(String PID) {
        String GA = PID.substring(0, 2);
        if (!"GA".equals(GA)) {
            throw new IllegalArgumentException("All PID must start with \"GA\": " + PID);
        }
        this.m_state = (byte)-1;
        String state = PID.substring(2, 5);
        for (int i = 0; i < STATE_PORTIONS.length; ++i) {
            if (!STATE_PORTIONS[i].equals(state)) continue;
            this.m_state = (byte)i;
        }
        if (this.m_state == -1) {
            throw new IllegalArgumentException("No state portion in PID: " + PID);
        }
        try {
            this.m_PID = Integer.parseInt(PID.substring(5));
        }
        catch (NumberFormatException NFEx) {
            throw new IllegalArgumentException("PID does not end in interger: " + PID);
        }
    }

    public int compareTo(Object that) {
        AUS_GNAFPIDIndexKey thatKey = (AUS_GNAFPIDIndexKey)that;
        if (this.m_state == thatKey.m_state) {
            return this.m_PID - thatKey.m_PID;
        }
        if (this.m_state < thatKey.m_state) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object that) {
        AUS_GNAFPIDIndexKey thatKey = (AUS_GNAFPIDIndexKey)that;
        return this.m_state == thatKey.m_state && this.m_PID == thatKey.m_PID;
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(this.m_state);
        out.writeInt(this.m_PID);
    }

    public void read(DataInput in) throws IOException {
        this.m_state = in.readByte();
        this.m_PID = in.readInt();
    }
}

