/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.dp.binary.index.gnaf;

import com.mapinfo.mapmarker.AUS.dp.binary.index.AUS_GNAFPIDIndexKey;
import com.mapinfo.mapmarker.AUS.dp.binary.index.AUS_GNAFPIDIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.StreetDataIndexValue;
import com.mapinfo.mapmarker.utils.NIOOutputStream;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class AUS_GNAFPIDIndexFileCombiner {
    public static final String PID_COMBINED_TEMP_INDEX = "aus.tdx";
    private String m_outputPath;
    private String[] m_tempIndexes;

    private AUS_GNAFPIDIndexFileCombiner(String outputPath, String[] tempIndexes) {
        this.m_outputPath = outputPath;
        this.m_tempIndexes = tempIndexes;
    }

    private void combine() {
        NIOOutputStream output = null;
        try {
            output = this.makeOutputFile();
            for (int i = 0; i < this.m_tempIndexes.length; ++i) {
                this.process(output, this.m_tempIndexes[i]);
            }
        }
        catch (IOException IOEx) {
            System.err.println("Error processing.");
            IOEx.printStackTrace(System.err);
            System.exit(-1);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(NIOOutputStream output, String tempIndex) throws IOException {
        DataInputStream input = null;
        MiStringIndexKey key = new MiStringIndexKey();
        StreetDataIndexValue value = new StreetDataIndexValue(-1L);
        System.out.println("processing: " + tempIndex);
        File tempIndexFile = new File(tempIndex);
        String baseName = AUS_GNAFPIDIndexFileCombiner.stripExtension(tempIndexFile.getName());
        try {
            try {
                input = this.openTempIndex(tempIndex);
                while (true) {
                    key.read((DataInput)input);
                    value.read((DataInput)input);
                    AUS_GNAFPIDIndexValue outputValue = this.makeIndexValue(baseName, value);
                    AUS_GNAFPIDIndexKey outputKey = new AUS_GNAFPIDIndexKey(key.toString());
                    outputKey.write((DataOutput)output);
                    outputValue.write((DataOutput)output);
                }
            }
            catch (EOFException EOFEx) {
                System.out.println("finished processing: " + tempIndex);
                if (input != null) {
                    input.close();
                }
            }
        }
        catch (Throwable throwable) {
            if (input != null) {
                input.close();
            }
            throw throwable;
        }
    }

    private NIOOutputStream makeOutputFile() throws IOException {
        return new NIOOutputStream(new File(StringUtilities.appendToPath((String)this.m_outputPath, (String)PID_COMBINED_TEMP_INDEX)));
    }

    private static String stripExtension(String fileName) {
        int i = fileName.lastIndexOf(46);
        if (i < 0) {
            return fileName;
        }
        return fileName.substring(0, i);
    }

    private DataInputStream openTempIndex(String tempIndex) throws IOException {
        return new DataInputStream(new BufferedInputStream(new FileInputStream(new File(tempIndex))));
    }

    private AUS_GNAFPIDIndexValue makeIndexValue(String tempIndex, StreetDataIndexValue value) {
        return new AUS_GNAFPIDIndexValue(tempIndex, (int)value.getStreetOffset());
    }

    private static void usage() {
        System.out.println("AUS_GNAFPIDIndexFileCombiner <output path> <input index files>N");
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            for (int i = 0; i < args.length; ++i) {
                System.out.println("arg #" + i + ":\t" + args[i]);
            }
            AUS_GNAFPIDIndexFileCombiner.usage();
            System.exit(-1);
        }
        String[] tempIndexes = new String[args.length - 1];
        System.arraycopy(args, 1, tempIndexes, 0, tempIndexes.length);
        AUS_GNAFPIDIndexFileCombiner combiner = new AUS_GNAFPIDIndexFileCombiner(args[0], tempIndexes);
        combiner.combine();
        System.out.println("finished creating combined temporary index");
    }
}

