/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.dp.gnaf;

import com.mapinfo.mapmarker.AUS.dp.AUS_StreetDataSourceRecordConvertor;
import com.mapinfo.mapmarker.AUS.dp.binary.gnaf.AUS_GNAFMMJRangeRecord;
import com.mapinfo.mapmarker.AUS.dp.binary.gnaf.AUS_GNAFMMJRangeUnitRecord;
import com.mapinfo.mapmarker.AUS.dp.binary.gnaf.AUS_GNAFMMJSegmentRecord;
import com.mapinfo.mapmarker.AUS.dp.binary.gnaf.AUS_GNAFMMJStreetRecord;
import com.mapinfo.mapmarker.AUS.dp.gnaf.GNAFStreetHandler;
import com.mapinfo.mapmarker.AUS.dp.gnaf.IAUS_GNAFRangeDataSourceRecord;
import com.mapinfo.mapmarker.AUS.dp.gnaf.IAUS_GNAFRangeUnitDataSourceRecord;
import com.mapinfo.mapmarker.AUS.dp.gnaf.IAUS_GNAFSegmentDataSourceRecord;
import com.mapinfo.mapmarker.AUS.dp.gnaf.IGNAFOriginalStreetFieldsDataSourceRecord;
import com.mapinfo.mapmarker.AUS.utils.AUS_AddressUtils;
import com.mapinfo.mapmarker.AUS.utils.AUS_StringUtilities;
import com.mapinfo.mapmarker.AUS.utils.GNAFAddressClass;
import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IAdditionalFieldsDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IIntermediateDataRecord;
import com.mapinfo.mapmarker.common.dp.IRangeDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.ISegmentDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IStreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IUnitDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.AlternateDataItem;
import com.mapinfo.mapmarker.common.dp.binary.AlternateDataRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeUnitRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MiSoundexStreetDataIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import com.mapinfo.mapmarker.common.dp.intermediate.IIntermediateRangeDataSourceRecord;
import com.mapinfo.mapmarker.core.parser.IParser;
import com.mapinfo.mapmarker.utils.LongPoint;
import com.mapinfo.midev.geometry.DirectPosition;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class AUS_GNAFStreetDataSourceRecordConvertor
extends AUS_StreetDataSourceRecordConvertor {
    private static final Set LEVEL_TYPES_REQUIRE_NUMBER;

    public AUS_GNAFStreetDataSourceRecordConvertor(Soundex soundex, Properties dataProperties, CollationKeyGenerator generator, IParser parser, Constraints parserConstraints) throws DataCreationException {
        super(soundex, dataProperties, generator, parser, parserConstraints);
    }

    public Object convert(IDataSourceRecord inputData) throws DataCreationException {
        try {
            return super.convert(inputData);
        }
        catch (NoGNAFRangesException NoGNAFREx) {
            return null;
        }
    }

    protected MMJSegmentRecord makeSegmentRecordType() {
        return new AUS_GNAFMMJSegmentRecord();
    }

    private boolean validSegmentReliability(int reliability) {
        switch (reliability) {
            case 1: 
            case 2: 
            case 3: {
                return false;
            }
        }
        return true;
    }

    protected MMJSegmentRecord convertSegmentRecord(ISegmentDataSourceRecord input, int sac, boolean convertLeft, boolean convertRight) throws DataSourceException {
        int reliability;
        AUS_GNAFMMJSegmentRecord segment = (AUS_GNAFMMJSegmentRecord)super.convertSegmentRecord(input, sac, convertLeft, convertRight);
        if (segment == null) {
            return null;
        }
        IAUS_GNAFSegmentDataSourceRecord sourceSegment = (IAUS_GNAFSegmentDataSourceRecord)input;
        if (sourceSegment.hasMeshBlock()) {
            segment.setMeshBlock(sourceSegment.getMeshBlock());
        }
        if (sourceSegment.hasReliability() && this.validSegmentReliability(reliability = sourceSegment.getReliability())) {
            segment.setReliability((byte)reliability);
            if (sourceSegment.hasOriginalLongitude() && sourceSegment.hasOriginalLatitude()) {
                segment.setOriginalPoint(this.makeLongPoint(sourceSegment.getOriginalLongitude(), sourceSegment.getOriginalLatitude()));
            }
            if (sourceSegment.hasGeoContainment()) {
                segment.setGeoContainment(sourceSegment.getGeoContainment());
            }
            if (sourceSegment.hasGeoFeature()) {
                segment.setGeoFeature(sourceSegment.getGeoFeature());
            }
        }
        if (sourceSegment.hasLocalityPID()) {
            segment.setLocalityPID(sourceSegment.getLocalityPID());
        }
        if (sourceSegment.hasSA1()) {
            segment.setSA1(sourceSegment.getSA1());
        }
        return segment;
    }

    protected void addRangesToSegment(MMJSegmentRecord segment, ISegmentDataSourceRecord input, int sac, boolean addLeft, boolean addRight) throws DataSourceException {
        super.addRangesToSegment(segment, input, sac, addLeft, addRight);
        List ranges = segment.getRanges();
        if (ranges != null && !ranges.isEmpty()) {
            for (AUS_GNAFMMJRangeRecord range : ranges) {
                List units = range.getRangeUnits();
                if (units == null || units.isEmpty()) continue;
                range.removeRangeAttributes();
            }
        }
    }

    protected MMJRangeRecord makeRangeRecordType() {
        return new AUS_GNAFMMJRangeRecord();
    }

    private boolean validRangeReliability(int reliability) {
        return !this.validSegmentReliability(reliability);
    }

    protected MMJRangeRecord modifiedConvertRangeRecord(IAUS_GNAFRangeDataSourceRecord input, int sac) throws DataSourceException {
        DirectPosition rangePoint;
        IIntermediateDataRecord[] dataRecordArray;
        if (!this.m_bPointDataSource && input.hasFrom() != input.hasTo()) {
            throw new DataSourceException(16);
        }
        String from = input.getFrom();
        String to = input.getTo();
        boolean bUsedLotForHouse = false;
        if (!(this.m_bPointDataSource || input.hasFrom() && this.stringExists(input.getFrom()) && input.hasTo() && this.stringExists(input.getTo()))) {
            if (input.hasLotNumber() || input.hasLotPrefix() || input.hasLotSuffix()) {
                to = from = AUS_AddressUtils.combineNonNullStrings(input.getLotPrefix(), input.getLotNumber(), input.getLotSuffix());
                bUsedLotForHouse = true;
            } else {
                return null;
            }
        }
        if (!this.m_bPointDataSource && !this.isValidRange(from, to)) {
            return null;
        }
        MMJRangeRecord range = this.makeRangeRecordType();
        if (bUsedLotForHouse) {
            AUS_GNAFMMJRangeRecord gnafRange = (AUS_GNAFMMJRangeRecord)range;
            gnafRange.setUsedLotForHouse(true);
        }
        range.setFromHouse(from);
        range.setToHouse(to);
        range.setOddEven(this.getOddEven(input));
        if (input.hasPlaceName() && this.stringExists(input.getPlaceName())) {
            range.setPlaceName(input.getPlaceName());
        }
        if (input.isLeft()) {
            range.setLeft();
        } else {
            range.setRight();
        }
        if (input instanceof IIntermediateRangeDataSourceRecord && (dataRecordArray = ((IIntermediateRangeDataSourceRecord)input).getIntermediateRecordArray()) != null) {
            range.setIntermediateDataRecordArray(dataRecordArray);
        }
        if (range.getOddEven() == 5 && range.getIntermediateDataRecordArray() == null) {
            if (this.m_logWrongStructTypeErrors) {
                DataCreationLogger.getLogger().logInternalError("Input specified type as ODD_EVEN_IRREGULAR but no irregular house numbers were loaded.  Range will be treated as ODD_EVEN_BOTH. (sac=" + sac + ", isLeft=" + input.isLeft() + ", from=" + input.getFrom() + ", to=" + input.getTo() + ")");
            }
            range.setOddEven(0);
        }
        this.populateAlternateDataItems(range, input, sac);
        if (range.getFromHouse() != null && !range.getFromHouse().isEmpty() && range.getFromHouse().equals((Object)range.getToHouse()) && (rangePoint = input.getPoint()) != null) {
            range.setPoint(rangePoint);
        }
        if (input instanceof IAdditionalFieldsDataSourceRecord && ((IAdditionalFieldsDataSourceRecord)input).hasAdditionalFields()) {
            range.setAdditionalFields(((IAdditionalFieldsDataSourceRecord)input).getAdditionalFields());
        }
        return range;
    }

    protected MMJRangeRecord convertRangeRecord(IRangeDataSourceRecord input, int sac) throws DataSourceException {
        IAUS_GNAFRangeDataSourceRecord rangeSource = (IAUS_GNAFRangeDataSourceRecord)input;
        AUS_GNAFMMJRangeRecord range = (AUS_GNAFMMJRangeRecord)this.modifiedConvertRangeRecord(rangeSource, sac);
        if (range == null) {
            if (rangeSource != null && rangeSource.hasPID()) {
                DataCreationLogger.getLogger().logInternalError("No range for PID: " + rangeSource.getPID());
            }
            throw new NoGNAFRangesException();
        }
        if (rangeSource.hasReliability()) {
            int reliability = rangeSource.getReliability();
            if (this.validRangeReliability(reliability)) {
                range.setReliability((byte)reliability);
                if (rangeSource.hasOriginalLongitude() && rangeSource.hasOriginalLatitude()) {
                    range.setOriginalPoint(this.makeLongPoint(rangeSource.getOriginalLongitude(), rangeSource.getOriginalLatitude()));
                }
                if (rangeSource.hasGeoContainment()) {
                    range.setGeoContainment(rangeSource.getGeoContainment());
                }
                if (rangeSource.hasGeoFeature()) {
                    range.setGeoFeature(rangeSource.getGeoFeature());
                }
            } else {
                range.setPoint(null);
            }
        }
        if (rangeSource.hasPID()) {
            range.setPID(rangeSource.getPID());
        }
        if (rangeSource.hasPrimaryPID()) {
            range.setPrimaryPID(rangeSource.getPrimaryPID());
        }
        if (rangeSource.hasConfidence()) {
            range.setConfidence((byte)rangeSource.getConfidence());
        }
        if (rangeSource.hasGeocodeLevel()) {
            range.setGeocodeLevel((byte)rangeSource.getGeocodeLevel());
        }
        if (rangeSource.hasLotNumber()) {
            range.setLotNumber(rangeSource.getLotNumber());
        }
        if (rangeSource.hasLotPrefix()) {
            range.setLotPrefix(rangeSource.getLotPrefix());
        }
        if (rangeSource.hasLotSuffix()) {
            range.setLotSuffix(rangeSource.getLotSuffix());
        }
        if (rangeSource.hasAddressClass()) {
            range.setAddressClass(GNAFAddressClass.getGNAFAddressClass(rangeSource.getAddressClass()));
        }
        if (rangeSource.hasParcelID()) {
            range.setParcelID(rangeSource.getParcelID());
        }
        return range;
    }

    protected void populateAlternateDataItems(MMJRangeRecord range, IRangeDataSourceRecord input, int sac) throws DataSourceException {
        IAUS_GNAFRangeDataSourceRecord rangeSource;
        if (range == null) {
            return;
        }
        if (input.hasPlaceName() && !AUS_StringUtilities.isEmpty(range.getPlaceName())) {
            MapMarkerIndexKey searchKey = this.makeAlternateTypeSearchKey(range.getPlaceName(), sac);
            MapMarkerIndexKey browseKey = this.makeAlternateTypeBrowseKey(range.getPlaceName(), sac);
            if (searchKey == null) {
                DataCreationLogger.getLogger().logInternalError("Unable to create soundex key for: " + range.getPlaceName());
                return;
            }
            AlternateDataRecord alternateDataRecord = new AlternateDataRecord();
            AlternateDataItem alternateItem = new AlternateDataItem(0, alternateDataRecord, searchKey, browseKey);
            range.addAlternateDataItem(alternateItem);
        }
        if ((rangeSource = (IAUS_GNAFRangeDataSourceRecord)input).hasPID() && !AUS_StringUtilities.isEmpty(rangeSource.getPID())) {
            String PID = rangeSource.getPID();
            MiStringIndexKey key = new MiStringIndexKey(PID);
            AlternateDataRecord alternateDataRecord = new AlternateDataRecord();
            alternateDataRecord.setAlternateDataID(PID);
            AlternateDataItem alternateItem = new AlternateDataItem(1, alternateDataRecord, (MapMarkerIndexKey)key, null);
            range.addAlternateDataItem(alternateItem);
        }
    }

    protected MapMarkerIndexKey makeAlternateTypeSearchKey(String soundexString, int sac) {
        MiSoundexKey sndxKey = (MiSoundexKey)this.makeSoundexKey(soundexString);
        if (sndxKey == null) {
            return null;
        }
        return new MiSoundexStreetDataIndexKey(sac, (ISoundexKey)sndxKey);
    }

    @Override
    protected int getOddEven(IRangeDataSourceRecord input) throws DataSourceException {
        ParsedNumber from = new ParsedNumber(input.getFrom());
        ParsedNumber to = new ParsedNumber(input.getTo());
        int oddEvenBoth = 0;
        if (input.hasStatus()) {
            if (input.getStatus().toLowerCase().startsWith("e")) {
                oddEvenBoth = 2;
            } else if (input.getStatus().toLowerCase().startsWith("o")) {
                oddEvenBoth = 1;
            }
        }
        if (this.isRangeStatusValid(from, to, oddEvenBoth)) {
            return oddEvenBoth;
        }
        if (from.compareTo((Object)to) == 0) {
            return from.isRangeOddEvenBoth();
        }
        return 0;
    }

    private boolean isRangeStatusValid(ParsedNumber from, ParsedNumber to, int oddEvenBoth) {
        if (oddEvenBoth == 0) {
            return !from.equals((Object)to);
        }
        int fromOddEvenBoth = from.isRangeOddEvenBoth();
        return fromOddEvenBoth == to.isRangeOddEvenBoth() && fromOddEvenBoth == oddEvenBoth;
    }

    protected MMJRangeUnitRecord makeRangeUnitRecordType() {
        return new AUS_GNAFMMJRangeUnitRecord();
    }

    protected MMJRangeUnitRecord convertRangeUnitRecord(IUnitDataSourceRecord input, int sac) throws DataSourceException {
        IAUS_GNAFRangeUnitDataSourceRecord unitSource = (IAUS_GNAFRangeUnitDataSourceRecord)input;
        String lowUnit = null;
        String lowPrefix = null;
        String lowSuffix = null;
        String highUnit = null;
        String highPrefix = null;
        String highSuffix = null;
        String unitType = null;
        if (input.hasLowUnit() && this.stringExists(input.getLowUnit())) {
            lowUnit = input.getLowUnit();
        }
        if (unitSource.hasLowUnitSuffix() && this.stringExists(unitSource.getLowUnitSuffix())) {
            lowSuffix = unitSource.getLowUnitSuffix();
        }
        if (unitSource.hasLowUnitPrefix() && this.stringExists(unitSource.getLowUnitPrefix())) {
            lowPrefix = unitSource.getLowUnitPrefix();
        }
        if (input.hasHighUnit() && this.stringExists(input.getHighUnit())) {
            highUnit = input.getHighUnit();
        }
        if (unitSource.hasHighUnitSuffix() && this.stringExists(unitSource.getHighUnitSuffix())) {
            highSuffix = unitSource.getHighUnitSuffix();
        }
        if (unitSource.hasHighUnitPrefix() && this.stringExists(unitSource.getHighUnitPrefix())) {
            highPrefix = unitSource.getHighUnitPrefix();
        }
        if (input.hasUnitType() && this.stringExists(input.getUnitType())) {
            unitType = input.getUnitType();
        }
        lowUnit = AUS_AddressUtils.combineNonNullStrings(lowPrefix, lowUnit, lowSuffix);
        highUnit = AUS_AddressUtils.combineNonNullStrings(highPrefix, highUnit, highSuffix);
        boolean bValidUnitInfo = true;
        if (!this.isValidUnit(lowUnit, highUnit, unitType)) {
            bValidUnitInfo = false;
        }
        AUS_GNAFMMJRangeUnitRecord unit = (AUS_GNAFMMJRangeUnitRecord)this.makeRangeUnitRecordType();
        if (bValidUnitInfo) {
            unit.setLowUnit(lowUnit);
            unit.setHighUnit(highUnit);
            unit.setUnitType(unitType);
        }
        if (input.hasPlaceName() && this.stringExists(input.getPlaceName())) {
            unit.setPlaceName(input.getPlaceName());
        }
        this.populateAlternateDataItems(unit, input, sac);
        if (unitSource.hasConfidence()) {
            unit.setConfidence((byte)unitSource.getConfidence());
        }
        if (unitSource.hasGeocodeLevel()) {
            unit.setGeocodeLevel((byte)unitSource.getGeocodeLevel());
        }
        if (unitSource.hasPID()) {
            unit.setPID(unitSource.getPID());
        }
        if (unitSource.hasPrimaryPID()) {
            unit.setPrimaryPID(unitSource.getPrimaryPID());
        }
        if (unitSource.hasLevelType()) {
            unit.setLevelType(unitSource.getLevelType());
        }
        if (unitSource.hasLevelNumber()) {
            unit.setLevelNumber(unitSource.getLevelNumber());
        }
        if (unitSource.hasLevelPrefix()) {
            unit.setLevelPrefix(unitSource.getLevelPrefix());
        }
        if (unitSource.hasLevelSuffix()) {
            unit.setLevelSuffix(unitSource.getLevelSuffix());
        }
        if (LEVEL_TYPES_REQUIRE_NUMBER.contains(unit.getLevelType()) && !unit.hasLevelNumberInfo()) {
            unit.setLevelType(null);
        }
        if (!bValidUnitInfo && !unit.hasLevelInfo()) {
            return null;
        }
        if (input instanceof IAdditionalFieldsDataSourceRecord && ((IAdditionalFieldsDataSourceRecord)input).hasAdditionalFields()) {
            unit.setAdditionalFields(((IAdditionalFieldsDataSourceRecord)input).getAdditionalFields());
        }
        if (unitSource.hasAddressClass()) {
            unit.setAddressClass(GNAFAddressClass.getGNAFAddressClass(unitSource.getAddressClass()));
        }
        if (unitSource.hasParcelID()) {
            unit.setParcelID(unitSource.getParcelID());
        }
        return unit;
    }

    protected void populateAlternateDataItems(MMJRangeUnitRecord unit, IUnitDataSourceRecord input, int sac) throws DataSourceException {
        IAUS_GNAFRangeUnitDataSourceRecord unitSource;
        AlternateDataItem alternateItem;
        AlternateDataRecord alternateDataRecord;
        if (unit == null) {
            return;
        }
        if (input.hasPlaceName() && !AUS_StringUtilities.isEmpty(input.getPlaceName())) {
            String placeName = input.getPlaceName();
            MapMarkerIndexKey searchKey = this.makeAlternateTypeSearchKey(placeName, sac);
            MapMarkerIndexKey browseKey = this.makeAlternateTypeBrowseKey(placeName, sac);
            if (searchKey == null) {
                DataCreationLogger.getLogger().logInternalError("Unable to create soundex key for: " + placeName);
                return;
            }
            alternateDataRecord = new AlternateDataRecord();
            alternateItem = new AlternateDataItem(0, alternateDataRecord, searchKey, browseKey);
            unit.addAlternateDataItem(alternateItem);
        }
        if ((unitSource = (IAUS_GNAFRangeUnitDataSourceRecord)input).hasPID() && !AUS_StringUtilities.isEmpty(unitSource.getPID())) {
            String PID = unitSource.getPID();
            MiStringIndexKey key = new MiStringIndexKey(PID);
            alternateDataRecord = new AlternateDataRecord();
            alternateDataRecord.setAlternateDataID(PID);
            alternateItem = new AlternateDataItem(1, alternateDataRecord, (MapMarkerIndexKey)key, null);
            unit.addAlternateDataItem(alternateItem);
        }
    }

    private LongPoint makeLongPoint(String longitude, String latitude) {
        String fixedLongitude = this.fixCoordinate(longitude);
        String fixedLatitude = this.fixCoordinate(latitude);
        try {
            long longitudeValue = Long.parseLong(fixedLongitude);
            long latitudeValue = Long.parseLong(fixedLatitude);
            return new LongPoint(longitudeValue, latitudeValue);
        }
        catch (NumberFormatException NFEx) {
            DataCreationLogger.getLogger().logInternalError(NFEx.getMessage());
            return null;
        }
    }

    private String fixCoordinate(String coordinate) {
        StringBuffer buffer = new StringBuffer();
        char[] chars = coordinate.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == ' ' || chars[i] == '.') continue;
            buffer.append(chars[i]);
        }
        return buffer.toString();
    }

    protected MMJStreetRecord makeStreetRecordType() {
        return new AUS_GNAFMMJStreetRecord();
    }

    protected MMJStreetRecord createStreetRecord(IStreetDataSourceRecord input, int leftSac, int rightSac) throws DataSourceException, DataCreationException {
        MMJStreetRecord record = super.createStreetRecord(input, leftSac, rightSac);
        if (record == null) {
            return record;
        }
        IGNAFOriginalStreetFieldsDataSourceRecord originalStreetRecord = (IGNAFOriginalStreetFieldsDataSourceRecord)input;
        if (originalStreetRecord.hasStreet() && originalStreetRecord.hasStreetType() && originalStreetRecord.hasStreetSuffix() && originalStreetRecord.hasStreetTypeAbbrev()) {
            ((AUS_GNAFMMJStreetRecord)record).setGNAFStreetInfo(GNAFStreetHandler.getStreetInfo(originalStreetRecord.getStreet(), originalStreetRecord.getStreetType(), originalStreetRecord.getStreetTypeAbbrev(), originalStreetRecord.getStreetSuffix(), record.getAddress()));
        }
        return record;
    }

    static {
        HashSet<String> temp = new HashSet<String>();
        temp.add("FL");
        temp.add("L");
        LEVEL_TYPES_REQUIRE_NUMBER = Collections.unmodifiableSet(temp);
    }

    private static class NoGNAFRangesException
    extends RuntimeException {
        private NoGNAFRangesException() {
        }
    }
}

