/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.dp.gnaf;

import com.mapinfo.mapmarker.AUS.dp.binary.GNAFStreetInfo;
import com.mapinfo.mapmarker.AUS.parser.AUS_ThoroughfareTypes;
import com.mapinfo.mapmarker.AUS.utils.AUS_AddressUtils;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class GNAFStreetHandler {
    private GNAFStreetHandler() {
    }

    public static GNAFStreetInfo getStreetInfo(String mainAddress, String streetType, String streetTypeAbbrev, String streetSuffix, Address parsed) {
        GNAFStreetInfo info = new GNAFStreetInfo();
        if (StringUtilities.isEmpty((String)streetSuffix) && !StringUtilities.isEmpty((String)parsed.getPostDirectional())) {
            info.setPostDirectionalAttached();
        }
        if (StringUtilities.isEmpty((String)streetType) && !StringUtilities.isEmpty((String)parsed.getPostThoroughfareType())) {
            if (parsed.getPostThoroughfareType().equals(AUS_ThoroughfareTypes.lookupPreferredName(streetSuffix))) {
                info.setTypeIsSuffix();
                if (!streetSuffix.equals(parsed.getPostThoroughfareType())) {
                    info.setStreetSuffix(streetSuffix);
                }
            } else {
                info.setStreetTypeAttached();
            }
        } else if (!StringUtilities.isEmpty((String)streetType) && !StringUtilities.isEmpty((String)parsed.getPostThoroughfareType())) {
            if (streetType.equals(parsed.getPostThoroughfareType())) {
                if (!StringUtilities.equalStrings((String)AUS_ThoroughfareTypes.lookupProperName(parsed.getPostThoroughfareType()), (String)parsed.getPostThoroughfareType())) {
                    info.setStreetType(streetType);
                }
            } else {
                String expandedName = AUS_ThoroughfareTypes.lookupProperName(parsed.getPostThoroughfareType());
                if (!streetType.equals(expandedName)) {
                    info.setStreetType(streetType);
                }
            }
        } else if (!StringUtilities.isEmpty((String)streetType) && StringUtilities.isEmpty((String)parsed.getPostThoroughfareType())) {
            info.setStreetType(streetType);
        }
        if (!(StringUtilities.isEmpty((String)streetSuffix) || info.getTypeIsSuffix() || streetSuffix.equals(parsed.getPostDirectional()) || streetSuffix.equals(parsed.getGenericField2()))) {
            info.setStreetSuffix(streetSuffix);
        }
        if (!StringUtilities.isEmpty((String)parsed.getGenericField2()) && !parsed.getGenericField2().equals(streetSuffix)) {
            info.setGenericField2NotSuffix();
        }
        if (!(StringUtilities.isEmpty((String)streetTypeAbbrev) || info.getStreetTypeAttached() || info.getPostDirectionalAttached() || info.getTypeIsSuffix() || StringUtilities.equalStrings((String)streetTypeAbbrev, (String)parsed.getPostThoroughfareType()))) {
            info.setStreetTypeAbbreviation(streetTypeAbbrev);
        }
        GNAFStreetHandler.testMainAddress(mainAddress, parsed, info);
        return info;
    }

    private static void testMainAddress(String mainAddress, Address parsed, GNAFStreetInfo info) {
        Address output = AUS_AddressUtils.reconstructAddress(parsed, info);
        if (!mainAddress.equals(output.getMainAddress())) {
            info.setOriginalMainAddress(mainAddress);
        }
    }
}

