/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.filters;

import com.mapinfo.mapmarker.AUS.AUS_GNAFInfoData;
import com.mapinfo.mapmarker.AUS.AUS_InternalCandidateAddress;
import com.mapinfo.mapmarker.AUS.AUS_Range;
import com.mapinfo.mapmarker.AUS.filters.FilterUtils;
import com.mapinfo.mapmarker.AUS.utils.AUS_AddressUtils;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class ExamineGNAFInfoFilterRule
implements ICloseMatchFilterRule {
    public boolean demoteOther(Address[] inputAddresses, ICandidate bestCandidate, ICandidate otherCandidate) {
        boolean bHasSameAddressNumber;
        AUS_InternalCandidateAddress best = (AUS_InternalCandidateAddress)bestCandidate;
        AUS_InternalCandidateAddress other = (AUS_InternalCandidateAddress)otherCandidate;
        if (!best.fromGNAFDictionary() && !other.fromGNAFDictionary()) {
            return false;
        }
        if (StringUtilities.isEmpty((String)inputAddresses[0].getMainAddress()) && !StringUtilities.isEmpty((String)inputAddresses[0].getPlaceName())) {
            return false;
        }
        if (best.getCombinedAddressScore() != other.getCombinedAddressScore() || best.getCombinedAdditionalFieldScore() != other.getCombinedAdditionalFieldScore() || best.getAdditionalParserFieldsScore() != other.getAdditionalParserFieldsScore()) {
            return false;
        }
        if (!best.getFormattedLocationAddress().equals(other.getFormattedLocationAddress())) {
            return false;
        }
        String streetPortion1 = AUS_AddressUtils.getFormattedStreetPortion((Address)best, null, false);
        String streetPortion2 = AUS_AddressUtils.getFormattedStreetPortion((Address)other, null, false);
        String addressNumber1 = best.getAddressNumber();
        String addressNumber2 = other.getAddressNumber();
        boolean bInputLot = StringUtilities.equalStrings((String)"LOT", (String)inputAddresses[0].getGenericField4());
        if (!bInputLot) {
            boolean bl = bInputLot = inputAddresses[0].getUnitValue() == null && StringUtilities.equalStrings((String)"LOT", (String)inputAddresses[0].getUnitType());
        }
        if (addressNumber1 == null && addressNumber2 == null) {
            if (bInputLot) {
                if (best.hasMatchingRange() != other.hasMatchingRange()) {
                    return best.hasMatchingRange();
                }
                if (best.hasMatchingRange()) {
                    AUS_Range bestRange = (AUS_Range)best.getSegment().getRangeAt(best.getMatchedRangeNumber(), best.getSegmentSide());
                    AUS_Range otherRange = (AUS_Range)other.getSegment().getRangeAt(other.getMatchedRangeNumber(), other.getSegmentSide());
                    if (bestRange.hasMatchingRangeUnit() != otherRange.hasMatchingRangeUnit()) {
                        String inputUnitValue = inputAddresses[0].getUnitValue();
                        String inputUnitType = inputAddresses[0].getUnitType();
                        boolean noInputUnit = StringUtilities.equalStrings((String)"LOT", (String)inputUnitType);
                        if (!(noInputUnit || StringUtilities.isEmpty((String)inputUnitValue) && StringUtilities.isEmpty((String)inputUnitType))) {
                            return bestRange.hasMatchingRangeUnit();
                        }
                        String gf4 = inputAddresses[0].getGenericField4();
                        if (!StringUtilities.isEmpty((String)gf4) && !gf4.startsWith("LOT")) {
                            return bestRange.hasMatchingRangeUnit();
                        }
                        return !bestRange.hasMatchingRangeUnit();
                    }
                }
            }
            if (!best.fromGNAFDictionary()) {
                return true;
            }
            if (!other.fromGNAFDictionary()) {
                return false;
            }
            if (best.fromGNAFDictionary()) {
                AUS_GNAFInfoData bestInfoData = best.getGNAFInfoData();
                AUS_GNAFInfoData otherInfoData = other.getGNAFInfoData();
                if (otherInfoData == null) {
                    return true;
                }
                if (bestInfoData != null) {
                    if (bestInfoData.getReliability() == 127) {
                        if (otherInfoData.getReliability() != 127) {
                            return false;
                        }
                    } else if (otherInfoData.getReliability() == 127) {
                        return true;
                    }
                    if (best.getInputNumber() != null && !best.getInputNumber().isEmpty()) {
                        if (bestInfoData.getConfidence() > -1 && otherInfoData.getConfidence() < 0) {
                            return true;
                        }
                        if (bestInfoData.getConfidence() < 0 && otherInfoData.getConfidence() > -1) {
                            return false;
                        }
                    } else if (FilterUtils.demoteOtherBasedOnGNAFDataWithEmptyInputNumber(bestInfoData, otherInfoData, best.getInputNumber())) {
                        return true;
                    }
                }
            }
            return false;
        }
        boolean bl = bHasSameAddressNumber = addressNumber1 != null && addressNumber1.equals(addressNumber2);
        if (bHasSameAddressNumber && streetPortion1.equals(streetPortion2)) {
            AUS_GNAFInfoData otherInfoData;
            AUS_GNAFInfoData bestInfoData;
            String inputLevelString;
            if (best.getUnitNumberScore() > other.getUnitNumberScore()) {
                return true;
            }
            if (best.getUnitNumberScore() == other.getUnitNumberScore() && best.getUnitTypeScore() > other.getUnitTypeScore()) {
                return true;
            }
            ParsedNumber inputLevel = best.getInputLevelNumber();
            String bestLevel = best.getLevelNumber();
            String otherLevel = other.getLevelNumber();
            String string = inputLevelString = inputLevel == null ? null : inputLevel.getCombinedAddressNumber();
            if (inputLevelString != null && !StringUtilities.equalStrings((String)best.getLevelNumber(), (String)other.getLevelNumber())) {
                if (StringUtilities.equalStrings((String)best.getLevelNumber(), (String)inputLevel.getCombinedAddressNumber())) {
                    return true;
                }
                if (StringUtilities.equalStrings((String)other.getLevelNumber(), (String)inputLevel.getCombinedAddressNumber())) {
                    return false;
                }
            }
            if (!StringUtilities.equalStrings((String)best.getUnitValue(), (String)other.getUnitValue())) {
                String inUnit = inputAddresses[0].getUnitValue();
                if (StringUtilities.equalStrings((String)best.getUnitValue(), (String)inUnit)) {
                    return true;
                }
                if (StringUtilities.equalStrings((String)other.getUnitValue(), (String)inUnit)) {
                    return false;
                }
            }
            if (FilterUtils.demoteOtherBasedOnInvalidGNAFConfidenceAndReliability(bestInfoData = best.getGNAFInfoData(), otherInfoData = other.getGNAFInfoData(), best.getInputNumber())) {
                return true;
            }
            if (FilterUtils.demoteOtherBasedOnGNAFConfidenceAndReliability(best, other, best.getInputNumber())) {
                return true;
            }
            if (bestInfoData != null && otherInfoData != null && !StringUtilities.equalStrings((String)bestLevel, (String)otherLevel)) {
                if (StringUtilities.equalStrings((String)inputLevelString, (String)otherLevel)) {
                    return false;
                }
                if (StringUtilities.equalStrings((String)inputLevelString, (String)bestLevel)) {
                    return true;
                }
            }
            if (FilterUtils.demoteOtherBasedOnLevelAndUnit(inputAddresses[0], best, other, true)) {
                return true;
            }
        }
        if (!StringUtilities.isEmpty((String)inputAddresses[0].getAddressNumber())) {
            AUS_Range bestRange = null;
            AUS_Range otherRange = null;
            if (best.hasMatchingRange() && other.hasMatchingRange()) {
                bestRange = (AUS_Range)best.getSegment().getRangeAt(best.getMatchedRangeNumber(), best.getSegmentSide());
                otherRange = (AUS_Range)other.getSegment().getRangeAt(other.getMatchedRangeNumber(), other.getSegmentSide());
            } else if (best.hasClosestRange() && other.hasClosestRange()) {
                bestRange = (AUS_Range)best.getSegment().getRangeAt(best.getClosestRangeNumber(), best.getClosestSegmentSide());
                otherRange = (AUS_Range)other.getSegment().getRangeAt(other.getClosestRangeNumber(), other.getClosestSegmentSide());
            } else {
                if (best.hasMatchingRange() && !other.hasMatchingRange()) {
                    return true;
                }
                if (other.hasMatchingRange() && !best.hasMatchingRange()) {
                    return false;
                }
                if (otherRange == null && bestRange == null) {
                    return false;
                }
            }
            if (bInputLot ? bestRange.isHouseFromLotNumber() && !otherRange.isHouseFromLotNumber() : !bestRange.isHouseFromLotNumber() && otherRange.isHouseFromLotNumber()) {
                return true;
            }
        }
        return false;
    }
}

