/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.filters;

import com.mapinfo.mapmarker.AUS.AUS_GNAFInfoData;
import com.mapinfo.mapmarker.AUS.AUS_InternalCandidateAddress;
import com.mapinfo.mapmarker.AUS.AUS_ParsedAddress;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ParsedNumber;

public class FilterUtils {
    static boolean demoteOtherBasedOnGNAFConfidenceAndReliability(AUS_InternalCandidateAddress best, AUS_InternalCandidateAddress other, ParsedNumber inputNumber) {
        if (best.fromGNAFDictionary()) {
            if (other.fromGNAFDictionary()) {
                AUS_GNAFInfoData bestInfoData = best.getGNAFInfoData();
                AUS_GNAFInfoData otherInfoData = other.getGNAFInfoData();
                if (otherInfoData == null) {
                    return true;
                }
                if (bestInfoData != null) {
                    if (inputNumber != null && !inputNumber.isEmpty() && bestInfoData.getConfidence() > otherInfoData.getConfidence() && otherInfoData.getConfidence() <= -1) {
                        return true;
                    }
                    if (inputNumber != null && !inputNumber.isEmpty() ? bestInfoData.getReliability() < 4 && otherInfoData.getReliability() > 3 : FilterUtils.demoteOtherBasedOnGNAFDataWithEmptyInputNumber(bestInfoData, otherInfoData, inputNumber)) {
                        return true;
                    }
                }
            }
        } else if (other.fromGNAFDictionary()) {
            AUS_GNAFInfoData otherInfoData = other.getGNAFInfoData();
            if (otherInfoData == null) {
                return true;
            }
            if (otherInfoData.getReliability() > 4) {
                return true;
            }
        }
        return false;
    }

    static boolean demoteOtherBasedOnGNAFDataWithEmptyInputNumber(AUS_GNAFInfoData bestInfoData, AUS_GNAFInfoData otherInfoData, ParsedNumber inputNumber) {
        if (bestInfoData == null || otherInfoData == null) {
            return false;
        }
        if (inputNumber != null && !inputNumber.isEmpty()) {
            return false;
        }
        if (bestInfoData.getReliability() == 4) {
            return true;
        }
        if (otherInfoData.getReliability() == 4) {
            return false;
        }
        if (bestInfoData.getReliability() > 4) {
            if (otherInfoData.getReliability() < 4) {
                return false;
            }
            if (bestInfoData.getReliability() == 5) {
                return true;
            }
            if (otherInfoData.getReliability() == 5) {
                return false;
            }
        }
        return bestInfoData.getReliability() < 4;
    }

    static boolean demoteOtherBasedOnInvalidGNAFConfidenceAndReliability(AUS_GNAFInfoData bestInfoData, AUS_GNAFInfoData otherInfoData, ParsedNumber inputNumber) {
        if (bestInfoData == null || otherInfoData == null) {
            return false;
        }
        if (bestInfoData.getReliability() == 127) {
            return otherInfoData.getReliability() == 127;
        }
        if (otherInfoData.getReliability() == 127) {
            return true;
        }
        if (inputNumber != null && !inputNumber.isEmpty()) {
            if (bestInfoData.getConfidence() == -2) {
                return otherInfoData.getConfidence() == -2;
            }
            if (otherInfoData.getConfidence() == -2) {
                return true;
            }
        }
        return false;
    }

    static boolean demoteOtherBasedOnLevelAndUnit(Address inputAddress, AUS_InternalCandidateAddress best, AUS_InternalCandidateAddress other, boolean bAddLooseComparison) {
        boolean bLevel;
        AUS_ParsedAddress parsed = (AUS_ParsedAddress)inputAddress;
        boolean bLevelNumber = parsed.getLevelValue() != null && !parsed.getLevelValue().isEmpty();
        boolean bLevelType = parsed.getLevelType() != null;
        boolean bUnitNumber = parsed.getUnitValue() != null;
        boolean bUnitType = parsed.getUnitType() != null;
        boolean bUnit = bUnitNumber || bUnitType;
        boolean bl = bLevel = bLevelNumber || bLevelType;
        if (!bUnit && !bLevel) {
            return false;
        }
        if (bUnit && bUnitNumber && best.getUnitNumberScore() == 1.0 && best.getUnitTypeScore() == 1.0 && other.getUnitNumberScore() != 1.0 && other.getUnitTypeScore() != 1.0) {
            return true;
        }
        if (bUnit && bUnitNumber && best.getUnitNumberScore() == 1.0 && best.getUnitTypeScore() == 1.0 && other.getUnitTypeScore() == 1.0 && other.getUnitNumberScore() != 1.0) {
            return true;
        }
        if (bUnit && bUnitNumber && best.getUnitNumberScore() == 1.0) {
            if (!(other.getUnitNumberScore() == 1.0 || bUnitType && other.getUnitTypeScore() == 1.0)) {
                return true;
            }
            if (bUnitType && best.getUnitTypeScore() == 1.0 && other.getUnitNumberScore() == 1.0 && other.getUnitTypeScore() != 1.0) {
                return true;
            }
        }
        if (bLevel && bLevelNumber) {
            boolean bOtherMatches;
            String bestLevelNumber = best.getLevelNumber();
            String otherLevelNumber = other.getLevelNumber();
            boolean bBestMatches = bestLevelNumber != null && parsed.getLevelValue().equals((Object)new ParsedNumber(bestLevelNumber));
            boolean bl2 = bOtherMatches = otherLevelNumber != null && parsed.getLevelValue().equals((Object)new ParsedNumber(otherLevelNumber));
            if (bBestMatches && !bOtherMatches) {
                return true;
            }
            if (bBestMatches && bOtherMatches && bLevelType) {
                bBestMatches = parsed.getLevelType().equals(best.getLevelType());
                bOtherMatches = parsed.getLevelType().equals(other.getLevelType());
                if (bBestMatches && !bOtherMatches) {
                    return true;
                }
            }
        }
        return false;
    }

    static boolean demoteOtherBasedOnLooseUnitComparison(AUS_InternalCandidateAddress best, AUS_InternalCandidateAddress other) {
        return false;
    }

    static boolean isPerfectStreetPortion(AUS_InternalCandidateAddress cand) {
        return cand.getPreDirectionalScore() == 1.0 && cand.getPreThoroughfareTypeScore() == 1.0 && cand.getPreAddressScore() == 1.0 && cand.getMainAddressScore() == 1.0 && cand.getPostAddressScore() == 1.0 && cand.getPostThoroughfareTypeScore() == 1.0 && cand.getPostDirectionalScore() == 1.0;
    }
}

