/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.filters;

import com.mapinfo.mapmarker.AUS.AUS_InternalCandidateAddress;
import com.mapinfo.mapmarker.AUS.AUS_ParsedAddress;
import com.mapinfo.mapmarker.AUS.filters.FilterUtils;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class PickBetweenPerfectMatchFilterRule
implements ICloseMatchFilterRule {
    public boolean demoteOther(Address[] inputAddresses, ICandidate bestCandidate, ICandidate otherCandidate) {
        AUS_InternalCandidateAddress best = (AUS_InternalCandidateAddress)bestCandidate;
        AUS_InternalCandidateAddress other = (AUS_InternalCandidateAddress)otherCandidate;
        if (best.isPerfectMatch() && other.isPerfectMatch()) {
            String otherFormatted;
            String bestFormatted = best.getFormattedStreetAddress();
            if (bestFormatted.equals(otherFormatted = other.getFormattedStreetAddress()) && (bestFormatted = best.getFormattedLocationAddress()).equals(otherFormatted = other.getFormattedLocationAddress())) {
                return best.getUserDictionaryPriority() <= other.getUserDictionaryPriority();
            }
            if (FilterUtils.demoteOtherBasedOnLevelAndUnit(inputAddresses[0], best, other, false)) {
                return true;
            }
            AUS_ParsedAddress parsed = (AUS_ParsedAddress)inputAddresses[0];
            ParsedNumber inputLevel = parsed.getLevelValue();
            if (inputLevel != null && !inputLevel.isEmpty()) {
                boolean bOtherMatches;
                String bestLevelNumber = best.getLevelNumber();
                String otherLevelNumber = other.getLevelNumber();
                boolean bBestMatches = bestLevelNumber != null && parsed.getLevelValue().equals((Object)new ParsedNumber(bestLevelNumber));
                boolean bl = bOtherMatches = otherLevelNumber != null && parsed.getLevelValue().equals((Object)new ParsedNumber(otherLevelNumber));
                if (bOtherMatches && !bBestMatches) {
                    return false;
                }
            }
            if (this.demoteOtherBasedOnInputCityName(inputAddresses[0], (Address)best, (Address)other)) {
                return true;
            }
            ParsedNumber inputAddressNumber = inputAddresses[0].getParsedAddressNumber();
            if (inputAddressNumber != null && !inputAddressNumber.isEmpty() && inputAddressNumber.equals((Object)best.getParsedAddressNumber()) && !inputAddressNumber.equals((Object)other.getParsedAddressNumber())) {
                return best.fromGNAFDictionary() || !best.fromGNAFDictionary() && !other.fromGNAFDictionary();
            }
            boolean bestMissingSuffix = best.isMatchingFlagSet(8);
            boolean bestSwapDir = best.isMatchingFlagSet(4);
            boolean otherMissingSuffix = other.isMatchingFlagSet(8);
            boolean otherSwapDir = other.isMatchingFlagSet(4);
            if (bestMissingSuffix == otherMissingSuffix && bestSwapDir == otherSwapDir) {
                return FilterUtils.demoteOtherBasedOnLooseUnitComparison(best, other);
            }
            if (bestMissingSuffix && bestSwapDir) {
                return false;
            }
            if (bestMissingSuffix || bestSwapDir) {
                if (!bestMissingSuffix) {
                    return otherMissingSuffix;
                }
                return otherMissingSuffix && otherSwapDir;
            }
            return otherMissingSuffix || otherSwapDir;
        }
        return false;
    }

    protected boolean demoteOtherBasedOnInputCityName(Address input, Address best, Address other) {
        String inputCity = input.getAreaName3();
        String bestCity = best.getAreaName3();
        String otherCity = other.getAreaName3();
        if ("CITY".equals(inputCity) || "CITY".equals(bestCity) || "CITY".equals(otherCity)) {
            return false;
        }
        return !StringUtilities.isEmpty((String)inputCity) && StringUtilities.equalStrings((String)inputCity, (String)bestCity) && !StringUtilities.equalStrings((String)inputCity, (String)otherCity);
    }
}

