/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.filters;

import com.mapinfo.mapmarker.AUS.AUS_InternalCandidateAddress;
import com.mapinfo.mapmarker.AUS.utils.AUS_AddressUtils;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class PickPerfectLocationForSameStreetFilterRule
implements ICloseMatchFilterRule {
    public boolean demoteOther(Address[] inputAddresses, ICandidate bestCandidate, ICandidate otherCandidate) {
        String otherStreetPortion;
        AUS_InternalCandidateAddress best = (AUS_InternalCandidateAddress)bestCandidate;
        AUS_InternalCandidateAddress other = (AUS_InternalCandidateAddress)otherCandidate;
        if (best.getCombinedAdditionalFieldScore() != 1.0 || other.getCombinedAdditionalFieldScore() == 1.0) {
            return false;
        }
        String bestStreetPortion = AUS_AddressUtils.getFormattedStreetPortion((Address)best, null, false);
        if (bestStreetPortion.equals(otherStreetPortion = AUS_AddressUtils.getFormattedStreetPortion((Address)other, null, false))) {
            String bestAddressNumber = best.getAddressNumber();
            String otherAddressNumber = other.getAddressNumber();
            if (StringUtilities.isEmpty((String)bestAddressNumber)) {
                if (StringUtilities.isEmpty((String)otherAddressNumber)) {
                    return true;
                }
                if (StringUtilities.isEmpty((String)inputAddresses[0].getAddressNumber())) {
                    return true;
                }
            } else {
                if (bestAddressNumber.equals(otherAddressNumber)) {
                    return true;
                }
                if (best.getAddressNumberScore() == 1.0 && other.getAddressNumberScore() < 1.0) {
                    return true;
                }
            }
        }
        return false;
    }
}

