/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.parser;

import com.mapinfo.mapmarker.AUS.AUS_ParsedAddress;
import com.mapinfo.mapmarker.AUS.parser.AUS_Directionals;
import com.mapinfo.mapmarker.AUS.parser.AUS_StreetPrefix;
import com.mapinfo.mapmarker.AUS.parser.AUS_ThoroughfareTypes;
import com.mapinfo.mapmarker.AUS.parser.AUS_UnitType;
import com.mapinfo.mapmarker.AUS.parser.AUS_UnitTypes;
import com.mapinfo.mapmarker.AUS.utils.AUS_StringUtilities;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.core.parser.IParseRule;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.utils.EN_StringUtilities;
import com.mapinfo.mapmarker.utils.EnglishVerbalNumber;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;
import java.util.StringTokenizer;

public class AUS_ParseMainAddressRule
implements IParseRule {
    private static final Set DELIMITERS;
    private static final Set BUILDING_IDENTIFIERS;
    private static final Set ORDINAL_INDICATORS;

    public void parse(Address ura, Address pa, IConstraints constraints) throws ParserException {
        StringWithTokens placeToks;
        String place;
        if (ura == null) {
            throw new ParserException(2000);
        }
        if (pa == null) {
            throw new ParserException(2001);
        }
        if (!StringUtilities.isEmpty((String)ura.getMainAddress()) && !StringUtilities.isEmpty((String)ura.getGenericField1())) {
            StringBuilder sb = new StringBuilder(ura.getMainAddress().trim());
            sb.append(' ');
            sb.append(ura.getGenericField1().trim());
            ura.setMainAddress(sb.toString().trim());
            ura.setGenericField1(null);
        }
        String ptfType = "";
        if (pa.getPostThoroughfareType() != null && (ptfType = pa.getPostThoroughfareType().trim()).length() > 0) {
            pa.setPostThoroughfareType(null);
        }
        ptfType = "";
        if (pa.getPreThoroughfareType() != null && (ptfType = pa.getPreThoroughfareType().trim()).length() > 0) {
            pa.setPreThoroughfareType(null);
        }
        if (ura.getPreThoroughfareType() != null) {
            ura.setPreThoroughfareType(null);
        }
        if (!StringUtilities.isEmpty((String)(place = ura.getPlaceName())) && (placeToks = new StringWithTokens(place, " .,")).size() > 1) {
            AUS_ParsedAddress locpa = new AUS_ParsedAddress(pa);
            StringBuffer unitBuf = new StringBuffer();
            this.separateUnitInfoFromPlace(placeToks, unitBuf, locpa);
            if (unitBuf.length() > 0) {
                pa.setPlaceName(placeToks.toString());
                pa.setUnitType(locpa.getUnitType());
                pa.setUnitValue(locpa.getUnitValue());
                if (locpa.getLevelType() != null) {
                    ((AUS_ParsedAddress)pa).setLevelType(locpa.getLevelType());
                }
                if (locpa.getLevelValue() != null) {
                    ((AUS_ParsedAddress)pa).setLevelValue(locpa.getLevelValue().getCombinedAddressNumber());
                }
            }
        }
        if (ura.getMainAddress() != null && ura.getMainAddress().trim().length() > 0) {
            AUS_ThoroughfareTypes tft;
            String street;
            CharSequence temp;
            String hnr = null;
            hnr = ura.getAddressNumber();
            if (!AUS_ParseMainAddressRule.isValidHouseNumberRange(hnr) && !AUS_ParseMainAddressRule.isValidHouseNumber(hnr)) {
                hnr = null;
            }
            StringBuffer buf = new StringBuffer();
            StringBuffer altBuf = new StringBuffer();
            StringBuffer buildingBuf = new StringBuffer();
            StringBuffer subBuf = new StringBuffer();
            StringBuffer poBuf = new StringBuffer();
            StringBuffer flatBuf = new StringBuffer();
            if (StringUtilities.isEmpty((String)ura.getMainAddress())) {
                return;
            }
            StringTokenizer tokens = new StringTokenizer(this.normalizeMainAddress(ura.getMainAddress()), " .,/-()+", true);
            LinkedList listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
            String mainAddress = "";
            boolean numOfItems = false;
            int numOfTokens = (listOfTokens = this.cleanAddress(listOfTokens)).size();
            if (numOfTokens == 0) {
                return;
            }
            StringBuffer parenthesisBuffer = new StringBuffer();
            this.separateIntermediateFromMainAddress(listOfTokens, parenthesisBuffer);
            this.separatePOBox(listOfTokens, poBuf);
            ((AUS_ParsedAddress)pa).setPOBoxInfo(poBuf.toString());
            this.separateUnit(listOfTokens, flatBuf, pa);
            this.separateUnit(listOfTokens, flatBuf, pa);
            this.separateMainStreetAddress(listOfTokens, buf, false, pa);
            this.separateFullUnitFromBack(listOfTokens, flatBuf, pa);
            this.separateFullUnitFromBack(listOfTokens, flatBuf, pa);
            this.separateMainStreetAddress(listOfTokens, altBuf, true, pa);
            this.separateBuildingName(listOfTokens, buildingBuf);
            if (buildingBuf.toString().trim().length() > 0) {
                this.separateBuildingName(listOfTokens, subBuf);
            }
            if (buf.length() == 0) {
                if (altBuf.length() == 0) {
                    if (buildingBuf.length() > 0) {
                        buf.replace(0, buf.length(), buildingBuf.toString());
                        buildingBuf.delete(0, buildingBuf.length());
                        if (subBuf.length() > 0) {
                            buildingBuf.replace(0, buildingBuf.length(), subBuf.toString());
                            subBuf.delete(0, subBuf.length());
                        }
                    } else {
                        this.separateMainStreetAddress(listOfTokens, altBuf, true, pa);
                    }
                } else {
                    buf.append(altBuf.toString());
                    altBuf.delete(0, altBuf.length());
                }
            }
            if ((AUS_ParseMainAddressRule.isValidHouseNumber(buf.toString()) || AUS_ParseMainAddressRule.isValidHouseNumberRange(buf.toString())) && altBuf.length() > 0) {
                if (altBuf.charAt(0) != ' ') {
                    buf.append(" ");
                }
                buf.append(altBuf);
                altBuf.delete(0, altBuf.length());
            }
            if (listOfTokens.size() > 0) {
                StringBuffer tempBuf = new StringBuffer();
                for (int i = 0; i < listOfTokens.size(); ++i) {
                    String temp2 = (String)listOfTokens.get(i);
                    if ((i == 0 || i == listOfTokens.size() - 1) && this.isDelimiter(temp2)) continue;
                    tempBuf.append(temp2);
                }
                if (buildingBuf.length() == 0) {
                    buildingBuf.append(tempBuf.toString());
                } else if (subBuf.length() == 0) {
                    subBuf.append(tempBuf.toString());
                } else if (pa.getGenericField1() == null || pa.getGenericField1().trim().length() == 0) {
                    pa.setGenericField1(tempBuf.toString().trim());
                }
            }
            this.separateHouseNumber(buf, pa);
            if (altBuf.toString().trim().length() > 0) {
                if (pa.getAddressNumber() == null || pa.getAddressNumber().trim().length() == 0) {
                    this.separateHouseNumber(altBuf, pa);
                    if (altBuf.length() > 0 && pa.getAddressNumber() != null && pa.getAddressNumber().trim().length() > 0) {
                        temp = buf;
                        buf = altBuf;
                        altBuf = temp;
                    }
                }
                pa.setGenericField2(altBuf.toString().trim());
            }
            if (StringUtilities.hasNumeric((String)buildingBuf.toString()) && subBuf.length() > 0 && !StringUtilities.hasNumeric((String)subBuf.toString())) {
                temp = subBuf;
                subBuf = buildingBuf;
                buildingBuf = temp;
            }
            this.separateDirections(buf, pa);
            this.separateStreetTypes(buf, pa);
            buf = this.separatePreAddressField(buf, pa);
            temp = buf.toString().trim();
            if (pa.getAddressNumber() != null && pa.getAddressNumber().length() > 0 && ((String)temp).length() == 2 && ((String)temp).charAt(1) != '1' && ((String)temp).charAt(1) != '3' && (((String)temp).equals("ND") && ((String)temp).charAt(1) == '2' || ((String)temp).equals("TH"))) {
                buf.insert(0, pa.getAddressNumber());
                pa.setAddressNumber((String)null);
            }
            if (pa.getAddressNumber() == null || pa.getAddressNumber().trim().length() == 0) {
                if (AUS_ParseMainAddressRule.isValidHouseNumber(altBuf.toString()) || AUS_ParseMainAddressRule.isValidHouseNumberRange(altBuf.toString())) {
                    pa.setAddressNumber(altBuf.toString());
                    altBuf.delete(0, altBuf.length());
                } else if (AUS_ParseMainAddressRule.isValidHouseNumber(buildingBuf.toString()) || AUS_ParseMainAddressRule.isValidHouseNumberRange(buildingBuf.toString())) {
                    pa.setAddressNumber(buildingBuf.toString());
                    buildingBuf.delete(0, buildingBuf.length());
                } else if (AUS_ParseMainAddressRule.isValidHouseNumber(subBuf.toString()) || AUS_ParseMainAddressRule.isValidHouseNumberRange(subBuf.toString())) {
                    pa.setAddressNumber(subBuf.toString());
                    subBuf.delete(0, subBuf.length());
                }
            }
            if ((street = buf.toString()) != null && street.length() != 0) {
                if (AUS_StreetPrefix.isPrefix(street) && pa.getPostThoroughfareType() != null) {
                    if (pa.getPreAddress() != null && pa.getPreAddress().trim().length() > 0) {
                        pa.setPreAddress(pa.getPreAddress() + " " + street);
                    } else {
                        pa.setPreAddress(street.trim());
                    }
                    buf.delete(0, buf.length());
                    buf.append(AUS_ThoroughfareTypes.lookupProperName(pa.getPostThoroughfareType()));
                    pa.setPostThoroughfareType(null);
                }
                if (pa.getPostThoroughfareType() == null && AUS_ThoroughfareTypes.lookupType(street) != null && pa.getPreAddress() == null) {
                    temp = pa.getGenericField2();
                    if (temp != null) {
                        String numericGenFld2 = EnglishVerbalNumber.convertVerbalToNumericStreetString((String)temp);
                        if (!((String)temp).equals(numericGenFld2)) {
                            temp = numericGenFld2;
                        }
                        if (((String)temp).trim().indexOf(" ") < 0) {
                            pa.setPreAddress(street.trim());
                            buf.delete(0, buf.length());
                            buf.append((String)temp);
                            pa.setGenericField2(null);
                        }
                    } else if (EN_StringUtilities.isOrdinal((String)pa.getAddressNumber())) {
                        pa.setPostThoroughfareType(AUS_ThoroughfareTypes.lookupType(street).getPreferredTypeName());
                        buf.delete(0, buf.length());
                        buf.append(pa.getAddressNumber());
                        pa.setAddressNumber((String)null);
                    } else if ("LOT".equals(pa.getUnitType()) && !StringUtilities.isEmpty((String)pa.getUnitValue()) && !StringUtilities.isEmpty((String)pa.getAddressNumber()) && AUS_ParseMainAddressRule.isValidHouseNumber(pa.getUnitValue())) {
                        pa.setPostThoroughfareType(AUS_ThoroughfareTypes.lookupType(street).getPreferredTypeName());
                        buf.delete(0, buf.length());
                        buf.append(pa.getAddressNumber());
                        pa.setAddressNumber(pa.getUnitValue());
                        pa.setUnitValue(null);
                    }
                }
                if (pa.getGenericField2() != null && AUS_ThoroughfareTypes.lookupProperName(pa.getGenericField2()) != null && (pa.getPreAddress() == null || pa.getPreAddress().length() == 0)) {
                    pa.setPreAddress(pa.getGenericField2().trim());
                    pa.setGenericField2(null);
                }
            }
            if (hnr != null) {
                pa.setAddressNumber(hnr);
            }
            if (pa.getPostThoroughfareType() == null && ura.getPostThoroughfareType() != null) {
                pa.setPostThoroughfareType(AUS_ThoroughfareTypes.lookupProperName(ura.getPostThoroughfareType()));
            }
            if (pa.getAreaName3() == null && ura.getAreaName3() != null) {
                pa.setAreaName3(ura.getAreaName3());
            }
            this.setBlankGenericFieldsToNull(pa);
            pa.setMainAddress(this.createMainAddress(buf.toString().trim()));
            if (pa.getPostThoroughfareType() == null && pa.getPreThoroughfareType() == null && pa.getPreAddress() != null && !"THE".equals(pa.getPreAddress()) && (tft = new AUS_ThoroughfareTypes()).findStreetType(pa.getMainAddress())) {
                pa.setPostThoroughfareType(pa.getMainAddress());
                pa.setMainAddress(pa.getPreAddress());
                pa.setPreAddress(null);
            }
            if (((AUS_ParsedAddress)pa).getPOBoxNumber() != null && pa.getMainAddress() == null) {
                pa.setMainAddress("PO BOX");
                pa.getAdditionalFields().put(AddressImpl.POB_IN_MAIN_ADDRESS_FIELD, "true");
                pa.setAddressNumber(((AUS_ParsedAddress)pa).getPOBoxNumber());
            } else if (((AUS_ParsedAddress)pa).getPOBoxNumber() != null) {
                pa.getAdditionalFields().put(AddressImpl.KEY_POBOX, "PO BOX");
                pa.getAdditionalFields().put(AddressImpl.KEY_POBOX_NUMBER, ((AUS_ParsedAddress)pa).getPOBoxNumber());
            }
            if (altBuf.length() > 0 && constraints.getCustomString("ORIGINAL_SINGLE_LINE") != null) {
                pa.getAdditionalFields().put("POSSIBLE_PLACE_NAME", altBuf.toString());
            }
            this.adjustForUnparsedLevelOrUnit((AUS_ParsedAddress)pa);
            if (parenthesisBuffer.length() > 0) {
                this.pickBestFromIntermediate(pa, parenthesisBuffer);
            }
        }
    }

    protected void adjustForUnparsedLevelOrUnit(AUS_ParsedAddress pa) {
        StringBuilder builder;
        AUS_UnitType firstUnitType;
        if (pa.getUnitType() != null || pa.getUnitValue() != null || pa.getLevelType() != null || pa.getLevelValue() != null || pa.getAddressNumber() == null) {
            return;
        }
        String currentMain = pa.getMainAddress();
        if (StringUtilities.isEmpty((String)currentMain) || currentMain.indexOf(32) <= 0) {
            return;
        }
        String firstAmbiguousNumber = pa.getAddressNumber();
        StringTokenizer stringTokenizer = new StringTokenizer(currentMain);
        String secondAmbiguousNumber = stringTokenizer.nextToken();
        if (!AUS_ParseMainAddressRule.isValidHouseNumber(secondAmbiguousNumber)) {
            return;
        }
        String thirdAmbiguousNumber = null;
        String startOfRealAddress = "";
        if (stringTokenizer.hasMoreTokens()) {
            int ct = stringTokenizer.countTokens();
            thirdAmbiguousNumber = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens() || !AUS_ParseMainAddressRule.isValidHouseNumber(thirdAmbiguousNumber)) {
                startOfRealAddress = thirdAmbiguousNumber;
                thirdAmbiguousNumber = null;
                if (ct == 1 && StringUtilities.isNumeric((String)secondAmbiguousNumber) && ORDINAL_INDICATORS.contains(startOfRealAddress)) {
                    return;
                }
            } else if (ct == 2 && StringUtilities.isNumeric((String)thirdAmbiguousNumber) && ORDINAL_INDICATORS.contains(startOfRealAddress = stringTokenizer.nextToken())) {
                StringBuilder tmpBuf = new StringBuilder(thirdAmbiguousNumber);
                tmpBuf.append(' ');
                tmpBuf.append(startOfRealAddress);
                startOfRealAddress = tmpBuf.toString();
                thirdAmbiguousNumber = null;
            }
        }
        if ((firstUnitType = this.findTypeInString(builder = new StringBuilder(firstAmbiguousNumber))) != null) {
            firstAmbiguousNumber = builder.toString();
        }
        if (thirdAmbiguousNumber == null) {
            this.chooseUnit(pa, firstUnitType, firstAmbiguousNumber);
            pa.setAddressNumber(new ParsedNumber(secondAmbiguousNumber));
        } else {
            pa.setAddressNumber(new ParsedNumber(thirdAmbiguousNumber));
            builder = new StringBuilder(secondAmbiguousNumber);
            AUS_UnitType secondUnitType = this.findTypeInString(builder);
            if (secondUnitType != null) {
                secondAmbiguousNumber = builder.toString();
            }
            if (firstUnitType != null && firstUnitType.getSecondaryType() == AUS_UnitType.LEVEL && (secondUnitType == null || secondUnitType.getSecondaryType() != AUS_UnitType.LEVEL) || firstUnitType == null && secondUnitType != null && secondUnitType.getSecondaryType() != AUS_UnitType.LEVEL) {
                pa.setLevelValue(firstAmbiguousNumber);
                if (firstUnitType != null) {
                    pa.setLevelType(firstUnitType.getAbbreviation());
                }
                pa.setUnitValue(secondAmbiguousNumber);
                if (secondUnitType != null) {
                    pa.setUnitType(secondUnitType.getAbbreviation());
                }
            } else {
                pa.setUnitValue(firstAmbiguousNumber);
                if (firstUnitType != null) {
                    pa.setUnitType(firstUnitType.getAbbreviation());
                }
                pa.setLevelValue(secondAmbiguousNumber);
                if (secondUnitType != null) {
                    pa.setLevelType(secondUnitType.getAbbreviation());
                }
            }
        }
        if (StringUtilities.isEmpty((String)startOfRealAddress)) {
            startOfRealAddress = stringTokenizer.nextToken();
        }
        StringBuilder sb = new StringBuilder(startOfRealAddress);
        while (stringTokenizer.hasMoreTokens()) {
            sb.append(' ');
            sb.append(stringTokenizer.nextToken());
        }
        pa.setMainAddress(sb.toString());
    }

    protected AUS_UnitType findTypeInString(StringBuilder testString) {
        AUS_UnitType unitType = null;
        if (testString.length() > 1 && Character.isLetter(testString.charAt(0)) && Character.isDigit(testString.charAt(testString.length() - 1))) {
            int k;
            for (k = 0; Character.isLetter(testString.charAt(k)) && k < testString.length(); ++k) {
            }
            if (k < testString.length() && (unitType = AUS_UnitTypes.getUnitType(testString.substring(0, k))) != null) {
                testString.replace(0, k, "");
            }
        }
        return unitType;
    }

    private String normalizeMainAddress(String street) {
        if (StringUtilities.isEmpty((String)street)) {
            return street;
        }
        StringBuffer buf = new StringBuffer(street.length() + 20);
        StringTokenizer tokenizer = new StringTokenizer(street, " .,/-()+", true);
        boolean bChanged = false;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            String[] values = this.separateCombinedUnitTypeAndValue(token);
            if (values != null) {
                buf.append(values[0]);
                buf.append(' ');
                buf.append(values[1]);
                bChanged = true;
                continue;
            }
            buf.append(token);
        }
        return bChanged ? buf.toString() : street;
    }

    private String[] separateCombinedUnitTypeAndValue(String typeAndValue) {
        if (StringUtilities.isEmpty((String)typeAndValue)) {
            return null;
        }
        if (AUS_ParseMainAddressRule.isValidHouseNumber(typeAndValue)) {
            return null;
        }
        return AUS_UnitTypes.separateUnitTypeAndValue(typeAndValue);
    }

    private StringBuffer separatePreAddressField(StringBuffer buf, Address pa) {
        StringTokenizer st = new StringTokenizer(buf.toString(), " ");
        if (st.countTokens() != 2) {
            return buf;
        }
        String possibleStreetPrefix = st.nextToken();
        if (AUS_StreetPrefix.isPrefix(possibleStreetPrefix)) {
            pa.setPreAddress(possibleStreetPrefix);
            return new StringBuffer(st.nextToken());
        }
        return buf;
    }

    private String Ordinal2String(String s) {
        String[] r = new String[]{"FIRST", "SECOND", "THIRD", "FOURTH", "FIFTH", "SIXTH", "SEVENTH", "EIGHTH", "NINTH", "TENTH", "ELEVENTH", "TWELFTH", "THIRTEENTH", "FOURTEENTH", "FIFTEENTH", "SIXTEENTH", "SEVENTEENTH", "EIGHTEENTH", "NINETEENTH", "TWENTIETH"};
        s = s.trim();
        int n = Integer.parseInt(s = s.substring(0, s.length() - 2), 10) - 1;
        if (n > 0 && n < 21) {
            return r[n];
        }
        return s;
    }

    private void setBlankGenericFieldsToNull(Address pa) {
        if (pa.getGenericField1() == null || pa.getGenericField1().equals("")) {
            pa.setGenericField1(null);
        }
        if (pa.getGenericField2() == null || pa.getGenericField2().equals("")) {
            pa.setGenericField2(null);
        }
        if (pa.getGenericField3() == null || pa.getGenericField3().equals("")) {
            pa.setGenericField3(null);
        }
        if (pa.getGenericField4() == null || pa.getGenericField4().equals("")) {
            pa.setGenericField4(null);
        }
    }

    private LinkedList cleanAddress(LinkedList<String> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            sb.append(s);
        }
        StringTokenizer tokens = new StringTokenizer(AUS_StringUtilities.standardize(sb.toString(), false), " .,/-()+", true);
        return StringUtilities.tokensToList((StringTokenizer)tokens);
    }

    private void separateMainStreetAddress(LinkedList list, StringBuffer buf, boolean alwaysSeperate, Address pa) {
        int numOfTokens = list.size();
        int endPos = -1;
        int startPos = -1;
        int intermediatePos = -1;
        int firstIntermediatePos = -1;
        boolean hasFoundStreetName = false;
        boolean possibleStreetNameFound = false;
        boolean houseNumberFound = false;
        boolean bPossibleHouseNumberFound = false;
        int possibleHouseNumberPos = -1;
        boolean bNeedToCheckIfHouseNumberIsPrecededByUnit = false;
        boolean streetTypeFound = false;
        boolean lastTokenWasDirection = false;
        int numOfNames = 0;
        int slashUnitPos = -1;
        AUS_ThoroughfareTypes tft = new AUS_ThoroughfareTypes();
        String strToken = null;
        block0: for (int i = numOfTokens - 1; i >= 0; --i) {
            strToken = (String)list.get(i);
            if (!streetTypeFound) {
                if (strToken.equals(" ")) continue;
                if (this.isDelimiter(strToken) && !strToken.equals("-") && !strToken.equals("/")) {
                    intermediatePos = i;
                    if (firstIntermediatePos < 0) {
                        firstIntermediatePos = i;
                    }
                }
                if (tft.findStreetType(strToken) && i != 0) {
                    streetTypeFound = true;
                    if (numOfNames <= 0) continue;
                    intermediatePos = i;
                    continue;
                }
                if (AUS_Directionals.isDirection(strToken)) continue;
                ++numOfNames;
                continue;
            }
            if (strToken.equals(" ")) continue;
            if (houseNumberFound) {
                if (strToken.equals("-")) continue;
                if (strToken.length() == 1 && this.isTokenQualifiedForSingleOrDoubleCharUnitValue(strToken) && !AUS_Directionals.isDirection(strToken) && !AUS_ParseMainAddressRule.isBuildingType(strToken)) {
                    startPos = i + 1;
                    break;
                }
            }
            if (",".equals(strToken)) break;
            if (AUS_ParseMainAddressRule.isValidHouseNumber(strToken) && (i == 0 || !bNeedToCheckIfHouseNumberIsPrecededByUnit || this.getPossibleUnitTypeWithCountFromBack(list.listIterator(i - 1)) == null)) {
                if (hasFoundStreetName) {
                    startPos = i;
                    if (houseNumberFound) {
                        int possibleUnitPos;
                        int startIndex = i - 1;
                        int possibleSlashPos = -1;
                        if (startIndex > 0 && (possibleSlashPos = this.findSlashIndicatorBeforeNormalStringAppears(list, startIndex, true)) != -1 && (possibleUnitPos = this.findValidHouseNumberFromFirstNormalString(list, possibleSlashPos - 1, true)) != -1) {
                            this.chooseUnit((AUS_ParsedAddress)pa, null, (String)list.get(possibleUnitPos));
                            slashUnitPos = possibleUnitPos;
                        }
                        if (possibleSlashPos == -1) {
                            ListIterator iter = list.listIterator(i + 1);
                            while (iter.hasNext()) {
                                String tempToken = (String)iter.next();
                                if (this.isDelimiter(tempToken)) {
                                    if (!"-".equals(tempToken)) continue;
                                    if (!AUS_ParseMainAddressRule.isStrictValidHouseNumber((String)list.get(0))) break block0;
                                    startPos = 0;
                                    break block0;
                                }
                                if (AUS_ParseMainAddressRule.isStrictValidHouseNumber((String)list.get(0))) {
                                    startPos = 0;
                                    break block0;
                                }
                                startPos = i + 1;
                                break block0;
                            }
                            break;
                        }
                    }
                    houseNumberFound = true;
                    bPossibleHouseNumberFound = true;
                    possibleHouseNumberPos = startPos;
                    continue;
                }
                houseNumberFound = false;
                hasFoundStreetName = true;
                continue;
            }
            if (AUS_ParseMainAddressRule.isBuildingType(strToken)) {
                if (hasFoundStreetName) {
                    startPos = i + 1;
                    break;
                }
                hasFoundStreetName = true;
                continue;
            }
            if (AUS_Directionals.isDirection(strToken)) {
                if (hasFoundStreetName) {
                    startPos = i;
                    lastTokenWasDirection = true;
                    continue;
                }
                hasFoundStreetName = true;
                continue;
            }
            if (houseNumberFound) {
                houseNumberFound = false;
                bNeedToCheckIfHouseNumberIsPrecededByUnit = true;
            }
            hasFoundStreetName = true;
            startPos = i;
        }
        if (!streetTypeFound && alwaysSeperate && firstIntermediatePos > -1) {
            startPos = firstIntermediatePos;
            endPos = numOfTokens - 1;
        } else {
            endPos = startPos < intermediatePos ? intermediatePos : numOfTokens - 1;
        }
        if (startPos == -1) {
            startPos = 0;
        }
        if (!houseNumberFound && bPossibleHouseNumberFound) {
            startPos = possibleHouseNumberPos;
        }
        if (streetTypeFound || alwaysSeperate) {
            int i;
            StringBuffer tempBuf = new StringBuffer();
            for (i = endPos; i < numOfTokens - 1; ++i) {
                strToken = (String)list.get(i);
                if (this.isDelimiter(strToken) && (i == endPos || i == list.size() - 1)) continue;
                tempBuf.append(strToken);
            }
            if (AUS_ParseMainAddressRule.isValidHouseNumber(tempBuf.toString()) || AUS_ParseMainAddressRule.isValidHouseNumberRange(tempBuf.toString())) {
                endPos = list.size() - 1;
            }
            if (buf.length() != 0 && startPos <= endPos) {
                buf.append(" ");
            }
            for (i = startPos; i <= endPos; ++i) {
                strToken = (String)list.get(startPos);
                if (i != startPos && i != endPos || !this.isDelimiter(strToken)) {
                    buf.append(strToken);
                }
                list.remove(startPos);
            }
            if (slashUnitPos != -1 && startPos > slashUnitPos && list.size() >= startPos - slashUnitPos) {
                for (int index = slashUnitPos; index < startPos; ++index) {
                    list.remove(slashUnitPos);
                }
            }
        }
    }

    private boolean isDelimiter(String str) {
        return str != null && DELIMITERS.contains(str);
    }

    public static boolean isBuildingType(String str) {
        return str != null && BUILDING_IDENTIFIERS.contains(str);
    }

    public static boolean isValidHouseNumber(String hnr) {
        int suffixStart;
        int prefixEnd;
        if (hnr == null) {
            return false;
        }
        int hnrLen = (hnr = hnr.trim()).length();
        if (hnrLen == 0) {
            return false;
        }
        if (EN_StringUtilities.isOrdinal((String)hnr)) {
            return false;
        }
        for (prefixEnd = 0; prefixEnd < hnrLen && Character.isLetter(hnr.charAt(prefixEnd)); ++prefixEnd) {
        }
        if (prefixEnd == hnrLen || prefixEnd > 3) {
            return false;
        }
        for (suffixStart = hnrLen; suffixStart > -1 && Character.isLetter(hnr.charAt(suffixStart - 1)); --suffixStart) {
        }
        if (hnrLen - suffixStart > 2 || prefixEnd >= suffixStart) {
            return false;
        }
        for (int index = prefixEnd; index < suffixStart; ++index) {
            if (Character.isDigit(hnr.charAt(index))) continue;
            return false;
        }
        return true;
    }

    private static boolean isStrictValidHouseNumber(String hnr) {
        if (hnr == null) {
            return false;
        }
        int hnrLen = (hnr = hnr.trim()).length();
        if (hnrLen == 0) {
            return false;
        }
        if (StringUtilities.isNumeric((String)hnr)) {
            return true;
        }
        if (Character.isLetter(hnr.charAt(0))) {
            return StringUtilities.isNumeric((String)hnr, (int)1, (int)hnr.length());
        }
        if (Character.isLetter(hnr.charAt(hnrLen - 1))) {
            return StringUtilities.isNumeric((String)hnr, (int)0, (int)(hnrLen - 1));
        }
        return false;
    }

    private void separateStreetTypes(StringBuffer mainAddressBuf, Address pa) {
        AUS_ThoroughfareTypes tft = new AUS_ThoroughfareTypes();
        String mainAddress = mainAddressBuf.toString();
        if (tft.findStreetType(mainAddress)) {
            int pos = tft.getTypeNameLocation();
            if (!tft.getTypeName().equals(AUS_ThoroughfareTypes.lookupPreferredName(mainAddress))) {
                pa.setPostThoroughfareType(tft.getPreferredTypeName());
                mainAddressBuf.delete(0, mainAddressBuf.length());
                mainAddressBuf.append(mainAddress.substring(0, pos).trim());
            }
        }
    }

    private void separateDirections(StringBuffer mainAddressBuf, Address pa) {
        if (mainAddressBuf == null || mainAddressBuf.length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(mainAddressBuf.toString());
        StringBuffer buf = new StringBuffer();
        String temp = null;
        String preDir = null;
        String postDir = null;
        if (!st.hasMoreTokens()) {
            return;
        }
        temp = st.nextToken();
        if (AUS_Directionals.isDirection(temp)) {
            preDir = temp;
        } else {
            buf.append(temp);
        }
        if (st.hasMoreTokens()) {
            temp = st.nextToken();
            if (AUS_Directionals.isDirection(temp)) {
                if (preDir != null && buf.length() == 0) {
                    preDir = preDir + " " + temp;
                } else {
                    postDir = temp;
                }
            } else {
                if (buf.length() > 0) {
                    buf.append(" ");
                }
                buf.append(temp);
            }
        }
        while (st.hasMoreTokens()) {
            temp = st.nextToken();
            if (AUS_Directionals.isDirection(temp)) {
                if (postDir == null) {
                    postDir = temp;
                    continue;
                }
                postDir = postDir + " " + temp;
                continue;
            }
            if (postDir != null) {
                if (buf.length() > 0) {
                    buf.append(" ");
                }
                buf.append(postDir);
                postDir = null;
                buf.append(" ");
                buf.append(temp);
                continue;
            }
            if (buf.length() > 0) {
                buf.append(" ");
            }
            buf.append(temp);
        }
        AUS_ThoroughfareTypes tft = new AUS_ThoroughfareTypes();
        String streetTypeName = null;
        if (buf.length() != 0) {
            streetTypeName = buf.toString().trim();
        }
        if (buf.length() == 0 || tft.findStreetType(streetTypeName) && tft.getTypeName().equals(AUS_ThoroughfareTypes.lookupPreferredName(streetTypeName)) && preDir != null) {
            if (preDir != null) {
                buf.insert(0, preDir + " ");
                preDir = null;
            } else if (postDir != null) {
                buf.append(postDir);
                postDir = null;
            }
        }
        pa.setPreDirectional(preDir);
        pa.setPostDirectional(postDir);
        mainAddressBuf.delete(0, mainAddressBuf.length());
        mainAddressBuf.append(buf.toString());
    }

    private void separateHouseNumber(StringBuffer mainAddressBuf, Address pa) {
        String temp;
        if (mainAddressBuf == null || mainAddressBuf.length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(mainAddressBuf.toString().trim(), " /-", true);
        String houseNum = null;
        StringBuffer buf = new StringBuffer();
        int validTokenCount = 0;
        while (st.hasMoreTokens()) {
            StringTokenizer newST;
            String subStr;
            temp = st.nextToken();
            if (!(temp.equals(" ") || temp.equals("-") || temp.equals("/"))) {
                ++validTokenCount;
            }
            int delta = 0;
            boolean bValidHouseNumber = AUS_ParseMainAddressRule.isValidHouseNumber(temp);
            if (!bValidHouseNumber && temp.length() > 1 && (subStr = this.getHouseNumberWithLastSpecialCharRemoved(temp)) != null) {
                bValidHouseNumber = true;
                temp = subStr;
                delta = 1;
            }
            if (!bValidHouseNumber) continue;
            int currentPosition = mainAddressBuf.toString().indexOf(temp) + temp.length() + delta;
            String restOfString = mainAddressBuf.toString().substring(currentPosition);
            if (restOfString != null && restOfString.length() != 0 && (newST = new StringTokenizer(restOfString, " /-", true)).hasMoreTokens()) {
                String temp2 = newST.nextToken();
                if (temp2.equals(" ") && newST.hasMoreTokens()) {
                    temp2 = newST.nextToken();
                }
                if (AUS_ThoroughfareTypes.lookupProperName(temp2) != null && validTokenCount > 1) {
                    if (!newST.hasMoreTokens()) continue;
                    temp2 = newST.nextToken();
                    if (temp2.equals(" ") && newST.hasMoreTokens()) {
                        temp2 = newST.nextToken();
                    }
                    if (AUS_ThoroughfareTypes.lookupProperName(temp2) == null) {
                        continue;
                    }
                } else if ("/".equals(temp2)) {
                    boolean bContinue = false;
                    while (newST.hasMoreTokens()) {
                        String token = newST.nextToken();
                        if (this.isDelimiter(token)) continue;
                        if (!AUS_ParseMainAddressRule.isValidHouseNumber(token)) break;
                        this.chooseUnit((AUS_ParsedAddress)pa, null, temp);
                        bContinue = true;
                        break;
                    }
                    if (bContinue) continue;
                }
            }
            houseNum = temp;
            break;
        }
        if (!st.hasMoreTokens()) {
            return;
        }
        temp = st.nextToken();
        if (temp.equals(" ") && st.hasMoreTokens()) {
            temp = st.nextToken();
        }
        if (temp.equals("-") && st.hasMoreTokens()) {
            String subStr;
            boolean bValidHouseNumber;
            temp = st.nextToken();
            if (temp.equals(" ") && st.hasMoreTokens()) {
                temp = st.nextToken();
            }
            if (!(bValidHouseNumber = AUS_ParseMainAddressRule.isValidHouseNumber(temp)) && (subStr = this.getHouseNumberWithLastSpecialCharRemoved(temp)) != null) {
                bValidHouseNumber = true;
                temp = subStr;
            }
            StringBuffer tempRangedNumberBuf = new StringBuffer(houseNum);
            tempRangedNumberBuf.append('-');
            tempRangedNumberBuf.append(temp);
            String rangedHouseNumber = tempRangedNumberBuf.toString();
            if (bValidHouseNumber && AUS_ParseMainAddressRule.isValidHouseNumberRange(rangedHouseNumber)) {
                houseNum = rangedHouseNumber;
                temp = st.hasMoreTokens() ? st.nextToken() : null;
                if (temp != null && temp.equals(" ") && st.hasMoreTokens()) {
                    temp = st.nextToken();
                }
            }
        }
        if (temp != null) {
            buf.append(temp);
        }
        while (st.hasMoreTokens()) {
            temp = st.nextToken();
            buf.append(temp);
        }
        if (houseNum != null) {
            pa.setAddressNumber(houseNum);
        }
        mainAddressBuf.delete(0, mainAddressBuf.length());
        mainAddressBuf.append(buf.toString());
    }

    private String getHouseNumberWithLastSpecialCharRemoved(String str) {
        String subStr;
        char lastChar;
        if (str != null && str.length() > 1 && !Character.isLetterOrDigit(lastChar = str.charAt(str.length() - 1)) && AUS_ParseMainAddressRule.isValidHouseNumber(subStr = str.substring(0, str.length() - 1))) {
            return subStr;
        }
        return null;
    }

    public static boolean isValidHouseNumberRange(String hnr) {
        if (hnr == null || hnr.length() == 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(hnr, "-");
        if (!st.hasMoreTokens() || st.countTokens() != 2) {
            return false;
        }
        if (!AUS_ParseMainAddressRule.isValidHouseNumber(st.nextToken())) {
            return false;
        }
        return AUS_ParseMainAddressRule.isValidHouseNumber(st.nextToken());
    }

    private void separateBuildingName(LinkedList list, StringBuffer buf) {
        String strToken;
        int i;
        int numOfTokens = list.size();
        if (numOfTokens == 0) {
            return;
        }
        int endPos = -1;
        int startPos = 0;
        boolean buildingTypeFound = false;
        for (i = 0; i < numOfTokens; ++i) {
            strToken = (String)list.get(i);
            if (strToken.equals(" ")) continue;
            if (strToken.equals(",")) {
                startPos = i;
            }
            if (!AUS_ParseMainAddressRule.isBuildingType(strToken)) continue;
            buildingTypeFound = true;
            break;
        }
        if (buildingTypeFound) {
            for (i = startPos; i < numOfTokens; ++i) {
                strToken = (String)list.get(startPos);
                if (strToken.equals(",")) {
                    if (i != startPos) {
                        break;
                    }
                } else {
                    buf.append(strToken);
                }
                list.remove(startPos);
            }
        }
    }

    private void separateUnit(LinkedList list, StringBuffer buf, Address addr) {
        int numOfTokens = list.size();
        if (numOfTokens == 0) {
            return;
        }
        if (list.size() > 1) {
            int anotherValidHouseNumberIndex;
            int slashIndex;
            int endUnitPos = -1;
            int possibleUnitIndex = this.findValidHouseNumberFromFirstNormalString(list, 0, false);
            if (possibleUnitIndex > -1 && (slashIndex = this.findSlashIndicatorBeforeNormalStringAppears(list, possibleUnitIndex + 1, false)) != -1 && (anotherValidHouseNumberIndex = this.findValidHouseNumberFromFirstNormalString(list, slashIndex + 1, false)) != -1) {
                endUnitPos = anotherValidHouseNumberIndex - 1;
            }
            if (endUnitPos != -1) {
                this.chooseUnit((AUS_ParsedAddress)addr, null, (String)list.get(possibleUnitIndex));
                for (int index = 0; index <= endUnitPos; ++index) {
                    list.remove(0);
                }
                return;
            }
        }
        int endPos = -1;
        String possibleUnitName = null;
        int nonDelimiterCount = 0;
        AUS_UnitType firstPossibleUnitType = null;
        int firstPossibleUnitPos = -1;
        for (int i = 0; i < numOfTokens; ++i) {
            String strToken = (String)list.get(i);
            if (this.isDelimiter(strToken)) continue;
            if (i >= list.size() - 1) break;
            boolean bIsAnUnitToken = AUS_UnitTypes.isUnitTypeToken(strToken);
            if (++nonDelimiterCount > AUS_UnitTypes.MAX_TOKENS_FOR_UNIT || firstPossibleUnitType != null && !bIsAnUnitToken) {
                AUS_UnitType possibleUnitType = AUS_UnitTypes.getUnitType(possibleUnitName);
                if (possibleUnitType != null) {
                    this.chooseUnit((AUS_ParsedAddress)addr, possibleUnitType, null);
                    this.putRemovedStringIntoBuffer(list, buf, i - 1);
                    break;
                }
                if (firstPossibleUnitType == null) break;
                this.chooseUnit((AUS_ParsedAddress)addr, firstPossibleUnitType, null);
                this.putRemovedStringIntoBuffer(list, buf, firstPossibleUnitPos);
                break;
            }
            AUS_UnitType unitType = AUS_UnitTypes.getUnitType(possibleUnitName = possibleUnitName != null ? possibleUnitName + " " + strToken : strToken);
            if (unitType == null) {
                if (bIsAnUnitToken) continue;
                break;
            }
            int unitValueRelativePos = this.findUnitValueRelativeIndex(list.listIterator(i + 1));
            if (unitValueRelativePos != -1 && i + unitValueRelativePos < list.size() - 1) {
                boolean bCheckForLevelWithoutNumber = unitType != null && unitType.getSecondaryType() == AUS_UnitType.LEVEL && addr.getUnitValue() == null && !unitType.mustHaveUnitValue();
                StringBuffer tempBuf = new StringBuffer(10);
                for (int relativeIndex = 1; relativeIndex <= unitValueRelativePos; ++relativeIndex) {
                    String unitValueToken = (String)list.get(i + relativeIndex);
                    if (!this.isDelimiter(unitValueToken)) {
                        tempBuf.append(unitValueToken);
                        continue;
                    }
                    if (bCheckForLevelWithoutNumber && "/".equals(unitValueToken)) {
                        ((AUS_ParsedAddress)addr).setLevelType(unitType.getAbbreviation());
                        this.putRemovedStringIntoBuffer(list, buf, i);
                        return;
                    }
                    if (!"-".equals(unitValueToken)) continue;
                    tempBuf.append('-');
                }
                String unitValue = tempBuf.toString();
                if (unitValue.length() > 0 && unitValue.charAt(unitValue.length() - 1) == '-') {
                    unitValue = unitValue.substring(0, unitValue.length() - 1);
                }
                this.chooseUnit((AUS_ParsedAddress)addr, unitType, unitValue);
                this.putRemovedStringIntoBuffer(list, buf, i + unitValueRelativePos);
                return;
            }
            if (firstPossibleUnitType != null) continue;
            firstPossibleUnitType = unitType;
            firstPossibleUnitPos = i;
        }
    }

    private int findUnitValueRelativeIndex(ListIterator iter) {
        int index;
        if (iter == null) {
            return -1;
        }
        int numberOfIgnoredChars = this.stepOverLeadingPunctuations(iter);
        int n = index = numberOfIgnoredChars > 0 ? numberOfIgnoredChars : 0;
        if (!iter.hasNext()) {
            return -1;
        }
        ++index;
        String token = (String)iter.next();
        if (StringUtilities.hasNumeric((String)token)) {
            boolean bHasHyphen = false;
            while (iter.hasNext()) {
                ++index;
                String tempToken = (String)iter.next();
                if (this.isDelimiter(tempToken)) {
                    if (!"-".equals(tempToken)) continue;
                    bHasHyphen = true;
                    break;
                }
                iter.previous();
                --index;
                break;
            }
            if (bHasHyphen) {
                int tempRemovedDelimiters = this.stepOverLeadingPunctuations(iter);
                if (tempRemovedDelimiters > 0) {
                    index += tempRemovedDelimiters;
                }
                if (iter.hasNext()) {
                    ++index;
                    if (StringUtilities.hasNumeric((String)((String)iter.next()))) {
                        if (this.hasPotentialHouseNumber(iter)) {
                            return index;
                        }
                    } else if (this.hasPotentialHouseNumber(iter)) {
                        return --index;
                    }
                }
            } else if (this.hasPotentialHouseNumber(iter)) {
                return index;
            }
        } else if (this.isTokenQualifiedForSingleOrDoubleCharUnitValue(token)) {
            return index;
        }
        return -1;
    }

    private String returnUnitValue(StringWithTokens.TokenIterator iter) {
        if (iter == null) {
            return null;
        }
        if (!iter.hasNext()) {
            return null;
        }
        String token = iter.next();
        if (StringUtilities.hasNumeric((String)token)) {
            return token;
        }
        if (this.isTokenQualifiedForSingleOrDoubleCharUnitValue(token)) {
            return token;
        }
        return null;
    }

    private boolean isTokenQualifiedForSingleOrDoubleCharUnitValue(String token) {
        if (token.length() > 2 || token.length() == 0 || !Character.isLetter(token.charAt(0))) {
            return false;
        }
        if (token.length() == 1) {
            return true;
        }
        return Character.isLetter(token.charAt(1));
    }

    private boolean hasPotentialHouseNumber(Iterator iter) {
        if (iter == null) {
            return false;
        }
        boolean bFoundHouseNumber = false;
        while (iter.hasNext()) {
            String token = (String)iter.next();
            if (!AUS_ParseMainAddressRule.isValidHouseNumber(token)) continue;
            bFoundHouseNumber = true;
            break;
        }
        return bFoundHouseNumber && iter.hasNext();
    }

    private void putRemovedStringIntoBuffer(LinkedList list, StringBuffer buf, int endIndex) {
        if (list == null || buf == null || endIndex > list.size() - 1) {
            return;
        }
        ListIterator iter = list.listIterator();
        for (int index = 0; iter.hasNext() && index <= endIndex; ++index) {
            String token = (String)iter.next();
            iter.remove();
            if (this.isDelimiter(token)) continue;
            if (buf.length() != 0) {
                buf.append(' ');
            }
            buf.append(token);
        }
        while (iter.hasNext() && this.isDelimiter((String)iter.next())) {
            iter.remove();
        }
    }

    private void putStringToBeRemovedIntoBuffer(StringWithTokens toklist, StringBuffer buf, int index) {
        String token = toklist.getToken(index);
        if (buf.length() != 0) {
            buf.append(' ');
        }
        buf.append(token);
    }

    private int stepOverLeadingPunctuations(ListIterator iter) {
        if (iter == null) {
            return -1;
        }
        int index = 0;
        while (iter.hasNext()) {
            ++index;
            String token = (String)iter.next();
            if (this.isDelimiter(token)) continue;
            iter.previous();
            return --index;
        }
        return index;
    }

    private int findSlashIndicatorBeforeNormalStringAppears(LinkedList list, int startIndex, boolean bBackward) {
        String token;
        if (startIndex < 0 || startIndex > list.size() - 1) {
            return -1;
        }
        if (bBackward) {
            startIndex = list.size() - 1 - startIndex;
            list = new LinkedList(list);
            Collections.reverse(list);
        }
        for (int index = startIndex; index < list.size() && this.isDelimiter(token = (String)list.get(index)); ++index) {
            if (!"/".equals(token)) continue;
            if (bBackward) {
                return list.size() - 1 - index;
            }
            return index;
        }
        return -1;
    }

    private int findValidHouseNumberFromFirstNormalString(LinkedList list, int startIndex, boolean bBackward) {
        if (startIndex < 0 || startIndex > list.size() - 1) {
            return -1;
        }
        if (bBackward) {
            startIndex = list.size() - 1 - startIndex;
            list = new LinkedList(list);
            Collections.reverse(list);
        }
        for (int index = startIndex; index < list.size(); ++index) {
            String token = (String)list.get(index);
            if (this.isDelimiter(token)) continue;
            if (!AUS_ParseMainAddressRule.isValidHouseNumber(token)) break;
            if (bBackward) {
                return list.size() - 1 - index;
            }
            return index;
        }
        return -1;
    }

    private void separateFullUnitFromBack(LinkedList list, StringBuffer buf, Address addr) {
        UnitTypeWithCount unitTypeWithCount;
        if (list.size() < 2) {
            return;
        }
        if (addr.getUnitType() != null || addr.getUnitValue() != null) {
            return;
        }
        int count = 0;
        ListIterator iter = list.listIterator(list.size());
        String unitValue = null;
        while (iter.hasPrevious()) {
            ++count;
            String token = (String)iter.previous();
            if (this.isDelimiter(token)) continue;
            if (StringUtilities.hasNumeric((String)token) || this.isTokenQualifiedForSingleOrDoubleCharUnitValue(token)) {
                unitValue = token;
                break;
            }
            return;
        }
        if ((unitTypeWithCount = this.getPossibleUnitTypeWithCountFromBack(iter)) != null) {
            this.chooseUnit((AUS_ParsedAddress)addr, unitTypeWithCount.getUnitType(), unitValue);
            ListIterator listIterator = list.listIterator(list.size() - count - unitTypeWithCount.getCountOfTokens());
            while (listIterator.hasNext()) {
                String token = (String)listIterator.next();
                if (!this.isDelimiter(token)) {
                    if (buf.length() != 0) {
                        buf.append(' ');
                    }
                    buf.append(token);
                }
                listIterator.remove();
            }
        }
    }

    private UnitTypeWithCount getPossibleUnitTypeWithCountFromBack(ListIterator iter) {
        int countOfUnitTokens = 0;
        boolean bFirstNonDelimiterMet = false;
        AUS_UnitType possibleUnitType = null;
        int countForPossibleUnit = -1;
        String possibleTokensForUnit = null;
        int count = 0;
        while (iter.hasPrevious() && countOfUnitTokens < AUS_UnitTypes.MAX_TOKENS_FOR_UNIT) {
            AUS_UnitType unitType;
            ++count;
            String token = (String)iter.previous();
            if (this.isDelimiter(token)) continue;
            if (!bFirstNonDelimiterMet) {
                bFirstNonDelimiterMet = true;
                ++countOfUnitTokens;
                unitType = AUS_UnitTypes.getUnitType(token);
                boolean bIsUnitTypeToken = AUS_UnitTypes.isUnitTypeToken(token);
                if (bIsUnitTypeToken) {
                    possibleTokensForUnit = token;
                }
                if (unitType != null) {
                    possibleUnitType = unitType;
                    countForPossibleUnit = count;
                    if (bIsUnitTypeToken) continue;
                    break;
                }
                if (bIsUnitTypeToken) continue;
                break;
            }
            ++countOfUnitTokens;
            if (!AUS_UnitTypes.isUnitTypeToken(token)) break;
            possibleTokensForUnit = token + " " + possibleTokensForUnit;
            unitType = AUS_UnitTypes.getUnitType(possibleTokensForUnit);
            if (unitType == null) continue;
            possibleUnitType = unitType;
            countForPossibleUnit = count;
        }
        if (possibleUnitType != null) {
            return new UnitTypeWithCount(possibleUnitType, countForPossibleUnit);
        }
        return null;
    }

    private void chooseUnit(AUS_ParsedAddress addr, AUS_UnitType unitType, String newUnitValue) {
        String newUnitType;
        if (unitType == null && StringUtilities.isEmpty((String)newUnitValue)) {
            return;
        }
        if (unitType != null && unitType.getSecondaryType() == AUS_UnitType.LEVEL) {
            if (!unitType.mustHaveUnitValue() || newUnitValue != null) {
                addr.setLevelType(unitType.getAbbreviation());
                addr.setLevelValue(newUnitValue);
            }
            return;
        }
        if (unitType != null && unitType.mustHaveUnitValue() && StringUtilities.isEmpty((String)newUnitValue)) {
            return;
        }
        String oldUnitType = addr.getUnitType();
        String oldUnitValue = addr.getUnitValue();
        String string = newUnitType = unitType == null ? null : unitType.getAbbreviation();
        if (!StringUtilities.isEmpty((String)oldUnitType) || !StringUtilities.isEmpty((String)oldUnitValue)) {
            if (!StringUtilities.isEmpty((String)oldUnitType)) {
                if (newUnitType == null) {
                    addr.setGenericField4(this.combineUnitString(oldUnitType, oldUnitValue));
                    addr.setUnitType(null);
                    addr.setUnitValue(newUnitValue);
                } else if (AUS_UnitTypes.isBuildingType(newUnitType)) {
                    addr.setGenericField4(this.combineUnitString(newUnitType, newUnitValue));
                } else if (AUS_UnitTypes.isBuildingType(oldUnitType)) {
                    addr.setGenericField4(this.combineUnitString(oldUnitType, oldUnitValue));
                    addr.setUnitType(newUnitType);
                    addr.setUnitValue(newUnitValue);
                } else if ("LOT".equals(newUnitType) && StringUtilities.isEmpty((String)addr.getAddressNumber()) && AUS_ParseMainAddressRule.isValidHouseNumber(newUnitValue)) {
                    addr.setGenericField4("LOT");
                    addr.setAddressNumber(newUnitValue);
                } else {
                    addr.setGenericField4(this.combineUnitString(newUnitType, newUnitValue));
                }
            } else {
                addr.setGenericField4(this.combineUnitString(unitType == null ? null : unitType.getAbbreviation(), newUnitValue));
            }
        } else {
            if (unitType != null) {
                addr.setUnitType(unitType.getAbbreviation());
            }
            addr.setUnitValue(newUnitValue);
        }
    }

    private String combineUnitString(String unitTypeName, String unitValue) {
        StringBuffer buf = new StringBuffer(15);
        if (!StringUtilities.isEmpty((String)unitTypeName)) {
            buf.append(unitTypeName);
        }
        if (!StringUtilities.isEmpty((String)unitValue)) {
            if (buf.length() != 0) {
                buf.append(' ');
            }
            buf.append(unitValue);
        }
        if (buf.length() != 0) {
            return buf.toString();
        }
        return "";
    }

    private String separatePOBox(LinkedList list, StringBuffer buf) {
        int numOfTokens = list.size();
        if (numOfTokens == 0) {
            return null;
        }
        int endPos = -1;
        int startPos = 0;
        String poNumber = new String("");
        String previousToken = new String("");
        for (int i = 0; i < numOfTokens; ++i) {
            String strToken = (String)list.get(i);
            if (strToken.equals(" ") || strToken.equals(".")) continue;
            if (strToken.equalsIgnoreCase("P")) {
                previousToken = "P";
                startPos = i;
                continue;
            }
            if (strToken.equalsIgnoreCase("PO")) {
                previousToken = "O";
                startPos = i;
                continue;
            }
            if (strToken.equalsIgnoreCase("GPO")) {
                previousToken = "O";
                startPos = i;
                continue;
            }
            if (strToken.equalsIgnoreCase("O") && previousToken.equalsIgnoreCase("P")) {
                previousToken = "O";
                continue;
            }
            if (strToken.equalsIgnoreCase("BOX") && previousToken.equalsIgnoreCase("O")) {
                previousToken = "BOX";
                continue;
            }
            if (strToken.equalsIgnoreCase("NO") && previousToken.equalsIgnoreCase("BOX")) continue;
            if (StringUtilities.hasNumeric((String)strToken.trim()) && previousToken.equalsIgnoreCase("Box")) {
                int j;
                poNumber = strToken.trim();
                endPos = i;
                for (j = startPos; j <= endPos; ++j) {
                    buf.append(list.remove(startPos));
                }
                endPos = startPos;
                while (j < list.size() && ((strToken = (String)list.get(endPos)).equals(" ") || strToken.equals(","))) {
                    list.remove(endPos);
                    ++j;
                }
                for (j = startPos - 1; j > 0; --j) {
                    strToken = (String)list.get(j);
                    if (strToken.equals(" ")) continue;
                    if (strToken.equals(",")) break;
                    list.add(startPos, ",");
                    break;
                }
                return poNumber;
            }
            previousToken = "";
        }
        return null;
    }

    private static boolean isRomanNumeral(String word) {
        char[] romanChars = new char[]{'V', 'I', '1', 'X'};
        if (word == null || word.trim().length() == 0) {
            return false;
        }
        char[] chars = word.toUpperCase().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            int j;
            for (j = 0; j < romanChars.length && chars[i] != romanChars[j]; ++j) {
            }
            if (j != romanChars.length) continue;
            return false;
        }
        return true;
    }

    private String createMainAddress(String mainAddress) {
        return EnglishVerbalNumber.convertVerbalToNumericStreetString((String)mainAddress);
    }

    private void separateUnitInfoFromPlace(StringWithTokens tokens, StringBuffer buf, AUS_ParsedAddress addr) {
        StringBuffer placebuf = new StringBuffer();
        StringWithTokens.TokenIterator iterator = tokens.iterator();
        int i = 0;
        int remcnt = 0;
        boolean bDone = false;
        while (iterator.hasNext() && !bDone) {
            String curTok = iterator.next();
            AUS_UnitType unitType = AUS_UnitTypes.getUnitType(curTok);
            if (unitType == null && curTok.length() > 1 && Character.isLetter(curTok.charAt(0)) && Character.isDigit(curTok.charAt(curTok.length() - 1))) {
                int k;
                String buf2 = null;
                String unitVal = null;
                for (k = 0; Character.isLetter(curTok.charAt(k)) && k < curTok.length(); ++k) {
                }
                if (k < curTok.length()) {
                    buf2 = curTok.substring(0, k);
                    unitType = AUS_UnitTypes.getUnitType(buf2);
                    unitVal = curTok.substring(k);
                    ++remcnt;
                }
                if (unitType != null) {
                    if (unitVal != null) {
                        this.chooseUnit(addr, unitType, unitVal);
                    } else {
                        this.chooseUnit(addr, unitType, null);
                    }
                    this.putStringToBeRemovedIntoBuffer(tokens, buf, i);
                    bDone = true;
                }
            }
            if (unitType != null) {
                String unitVal = this.returnUnitValue(iterator);
                if (unitVal == null && !unitType.mustHaveUnitValue()) {
                    this.chooseUnit(addr, unitType, null);
                    this.putStringToBeRemovedIntoBuffer(tokens, buf, i);
                    ++remcnt;
                } else if (unitVal != null) {
                    this.chooseUnit(addr, unitType, unitVal);
                    this.putStringToBeRemovedIntoBuffer(tokens, buf, i);
                    this.putStringToBeRemovedIntoBuffer(tokens, buf, i + 1);
                    remcnt += 2;
                }
            } else {
                bDone = true;
            }
            ++i;
        }
        if (remcnt > 0) {
            for (int cnt = 0; cnt < remcnt; ++cnt) {
                tokens.removeFirst();
            }
        }
    }

    protected void separateIntermediateFromMainAddress(LinkedList list, StringBuffer buf) {
        String strToken;
        int i;
        if (list == null || buf == null) {
            return;
        }
        int numOfTokens = list.size();
        int openParenIdx = -1;
        int closeParenIdx = -1;
        for (i = 0; i < numOfTokens; ++i) {
            strToken = (String)list.get(i);
            if (strToken.length() > 1 || !"(".equals(strToken)) continue;
            openParenIdx = i;
            break;
        }
        if (openParenIdx == -1) {
            return;
        }
        for (i = numOfTokens - 1; i > openParenIdx; --i) {
            strToken = (String)list.get(i);
            if (strToken.length() > 1 || !")".equals(strToken)) continue;
            closeParenIdx = i;
            break;
        }
        if (closeParenIdx == -1) {
            return;
        }
        list.remove(closeParenIdx);
        for (int curIdx = closeParenIdx - 1; curIdx > openParenIdx; --curIdx) {
            buf.insert(0, list.remove(curIdx));
        }
        list.remove(openParenIdx);
    }

    protected void pickBestFromIntermediate(Address parsedAddress, StringBuffer buf) {
        if (parsedAddress == null || buf == null || buf.length() == 0) {
            return;
        }
        if (!StringUtilities.isEmpty((String)parsedAddress.getPostThoroughfareType())) {
            this.addAsMiscAddress(parsedAddress, buf.toString());
            return;
        }
        if (!StringUtilities.isEmpty((String)parsedAddress.getPreThoroughfareType())) {
            this.addAsMiscAddress(parsedAddress, buf.toString());
            return;
        }
        StringTokenizer tokens = new StringTokenizer(buf.toString(), " .,/-()+", true);
        if (tokens.countTokens() == 1) {
            this.addAsMiscAddress(parsedAddress, buf.toString());
            return;
        }
        String origString = buf.toString();
        AUS_ParsedAddress alternateParsedAddress = new AUS_ParsedAddress();
        this.separateStreetTypes(buf, (Address)alternateParsedAddress);
        this.separateHouseNumber(buf, (Address)alternateParsedAddress);
        alternateParsedAddress.setMainAddress(buf.toString());
        if (!this.mergeSelectFields(parsedAddress, (Address)alternateParsedAddress)) {
            this.addAsMiscAddress(parsedAddress, origString);
        }
    }

    protected boolean mergeSelectFields(Address primary, Address secondary) {
        String primaryAddrNum = primary.getAddressNumber();
        String secondaryAddrNum = secondary.getAddressNumber();
        if (!StringUtilities.isEmpty((String)primaryAddrNum) && !StringUtilities.isEmpty((String)secondaryAddrNum)) {
            return false;
        }
        String primaryPostType = primary.getPostThoroughfareType();
        String secondaryPostType = secondary.getPostThoroughfareType();
        if (!StringUtilities.isEmpty((String)primaryPostType) && !StringUtilities.isEmpty((String)secondaryPostType)) {
            return false;
        }
        boolean bMerged = false;
        if (StringUtilities.isEmpty((String)primaryAddrNum) && !StringUtilities.isEmpty((String)secondaryAddrNum)) {
            bMerged = true;
            primary.setAddressNumber(secondaryAddrNum);
        }
        if (StringUtilities.isEmpty((String)primaryPostType) && !StringUtilities.isEmpty((String)secondaryPostType)) {
            bMerged = true;
            primary.setPostThoroughfareType(secondaryPostType);
        }
        if (bMerged) {
            String secondaryString = secondary.getMainAddress();
            if (!StringUtilities.isEmpty((String)secondaryString)) {
                this.addAsMiscAddress(primary, primary.getMainAddress());
                primary.setMainAddress(secondaryString);
            }
        } else {
            String secondaryString = secondary.getMainAddress();
            if (!StringUtilities.isEmpty((String)secondaryString)) {
                this.addAsMiscAddress(primary, secondaryString);
            }
        }
        return true;
    }

    private void addAsMiscAddress(Address addr, String str) {
        if (StringUtilities.isEmpty((String)addr.getGenericField2())) {
            addr.setGenericField2(str);
        } else {
            addr.setGenericField3(str);
        }
    }

    static {
        HashSet<String> tempSet = new HashSet<String>(10);
        tempSet.add(",");
        tempSet.add(" ");
        tempSet.add("-");
        tempSet.add("/");
        tempSet.add(".");
        tempSet.add("(");
        tempSet.add(")");
        tempSet.add("_");
        DELIMITERS = Collections.unmodifiableSet(tempSet);
        String[] buildingIdentifiers = new String[]{"APARTMENT", "APT", "BUILDING", "BLD", "BLDG", "COTTAGE", "COURT", "HOUSE", "OFFICE", "CENTRE", "CENTER", "DEPT", "DEPARTMENT", "ROOM", "OFFICES", "FLOOR", "TERRACE", "PLACE", "UNIT", "SUITE", "ESTATE", "LEVEL"};
        tempSet = new HashSet(25);
        for (int index = 0; index < buildingIdentifiers.length; ++index) {
            tempSet.add(buildingIdentifiers[index]);
        }
        BUILDING_IDENTIFIERS = Collections.unmodifiableSet(tempSet);
        tempSet = new HashSet();
        tempSet.add("ST");
        tempSet.add("ND");
        tempSet.add("TH");
        ORDINAL_INDICATORS = Collections.unmodifiableSet(tempSet);
    }

    private class UnitTypeWithCount {
        private AUS_UnitType m_unitType;
        private int m_count;

        private UnitTypeWithCount(AUS_UnitType unitType, int count) {
            this.m_unitType = unitType;
            this.m_count = count;
        }

        public AUS_UnitType getUnitType() {
            return this.m_unitType;
        }

        public int getCountOfTokens() {
            return this.m_count;
        }
    }
}

