/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.parser;

import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class AUS_ThoroughfareTypes {
    private String m_type = "";
    private int m_location = -1;
    private static final Map LOOKUP_MAP;
    private static final Map TYPE_AND_PLURAL;

    public String getTypeName() {
        return this.m_type;
    }

    public int getTypeNameLocation() {
        return this.m_location;
    }

    public boolean findStreetType(String mainAddr) {
        if (mainAddr == null || StringUtilities.isEmpty((String)mainAddr.trim())) {
            return false;
        }
        StringWithTokens tokens = new StringWithTokens(mainAddr, " \t\n\r\f");
        String possibleStreetType = tokens.getLastToken();
        KeyInfo info = AUS_ThoroughfareTypes.lookupType(possibleStreetType);
        if (info != null) {
            if (tokens.size() > 2) {
                StringBuilder builder = new StringBuilder(tokens.getToken(tokens.size() - 2));
                builder.append(' ');
                builder.append(possibleStreetType);
                KeyInfo twoWord = AUS_ThoroughfareTypes.lookupType(builder.toString());
                if (twoWord != null) {
                    info = twoWord;
                    possibleStreetType = builder.toString();
                }
            }
            this.m_type = info.getPreferredTypeName();
            this.m_location = mainAddr.lastIndexOf(possibleStreetType);
            return true;
        }
        return false;
    }

    public String getPreferredTypeName() {
        return AUS_ThoroughfareTypes.lookupPreferredName(this.m_type);
    }

    public static String lookupProperName(String key) {
        KeyInfo info = AUS_ThoroughfareTypes.lookupType(key);
        if (info != null) {
            return info.getProperTypeName();
        }
        return null;
    }

    public static String lookupPreferredName(String key) {
        KeyInfo info = AUS_ThoroughfareTypes.lookupType(key);
        if (info != null) {
            return info.getPreferredTypeName();
        }
        return null;
    }

    public static KeyInfo lookupType(String key) {
        if (StringUtilities.isEmpty((String)key)) {
            return null;
        }
        return (KeyInfo)LOOKUP_MAP.get(key.trim());
    }

    public static boolean isRelative(KeyInfo type1, KeyInfo type2) {
        if (type1 == null || type2 == null) {
            return false;
        }
        KeyInfo keyInfo = (KeyInfo)TYPE_AND_PLURAL.get(type1.getPreferredTypeName());
        return keyInfo == type2;
    }

    static {
        try {
            Properties streetTypes = new Properties();
            streetTypes.load(AUS_ThoroughfareTypes.class.getResourceAsStream("AUS_ThoroughfareTypes.properties"));
            HashMap<String, KeyInfo> keys = new HashMap<String, KeyInfo>();
            Enumeration<?> e = streetTypes.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String val = streetTypes.getProperty(key);
                key = key.toUpperCase();
                StringTokenizer tokens = new StringTokenizer(val, ",");
                String preferredName = tokens.nextToken().trim();
                String properName = tokens.nextToken().trim();
                boolean canStart = Boolean.valueOf(tokens.nextToken().trim());
                boolean canEnd = Boolean.valueOf(tokens.nextToken().trim());
                KeyInfo keyInfo = new KeyInfo(preferredName, properName, canStart, canEnd);
                keys.put(key, keyInfo);
            }
            Properties streetTypesNames = new Properties();
            streetTypesNames.load(AUS_ThoroughfareTypes.class.getResourceAsStream("AUS_ThoroughfareTypesNames.properties"));
            HashMap tempLookupMap = new HashMap(300);
            Enumeration<?> enumeration = streetTypesNames.propertyNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String value = streetTypesNames.getProperty(key);
                String[] tokens = value.split(",");
                Object keyInfo = keys.get(key.toUpperCase());
                for (int index = 0; index < tokens.length; ++index) {
                    tempLookupMap.put(tokens[index].trim().toUpperCase(), keyInfo);
                }
            }
            LOOKUP_MAP = Collections.unmodifiableMap(tempLookupMap);
            HashMap tempPluralMap = new HashMap(32);
            tempPluralMap.put("BVD", LOOKUP_MAP.get("BVDE"));
            tempPluralMap.put("BVDE", LOOKUP_MAP.get("BVD"));
            tempPluralMap.put("CMMN", LOOKUP_MAP.get("CMMNS"));
            tempPluralMap.put("CMMNS", LOOKUP_MAP.get("CMMN"));
            tempPluralMap.put("DOWN", LOOKUP_MAP.get("DWNS"));
            tempPluralMap.put("DWNS", LOOKUP_MAP.get("DOWN"));
            tempPluralMap.put("FLAT", LOOKUP_MAP.get("FLTS"));
            tempPluralMap.put("FLTS", LOOKUP_MAP.get("FLAT"));
            tempPluralMap.put("GDN", LOOKUP_MAP.get("GDNS"));
            tempPluralMap.put("GDNS", LOOKUP_MAP.get("GDN"));
            tempPluralMap.put("GTE", LOOKUP_MAP.get("GTES"));
            tempPluralMap.put("GTES", LOOKUP_MAP.get("GTE"));
            tempPluralMap.put("HILL", LOOKUP_MAP.get("HILLS"));
            tempPluralMap.put("HILLS", LOOKUP_MAP.get("HILL"));
            tempPluralMap.put("KEY", LOOKUP_MAP.get("KEYS"));
            tempPluralMap.put("KEYS", LOOKUP_MAP.get("KEY"));
            tempPluralMap.put("MEW", LOOKUP_MAP.get("MEWS"));
            tempPluralMap.put("MEWS", LOOKUP_MAP.get("MEW"));
            tempPluralMap.put("QY", LOOKUP_MAP.get("QYS"));
            tempPluralMap.put("QYS", LOOKUP_MAP.get("QY"));
            tempPluralMap.put("RD", LOOKUP_MAP.get("RDS"));
            tempPluralMap.put("RDS", LOOKUP_MAP.get("RD"));
            tempPluralMap.put("ROW", LOOKUP_MAP.get("ROWE"));
            tempPluralMap.put("ROWE", LOOKUP_MAP.get("ROW"));
            tempPluralMap.put("STAI", LOOKUP_MAP.get("STRT"));
            tempPluralMap.put("STRT", LOOKUP_MAP.get("STAI"));
            tempPluralMap.put("VIEW", LOOKUP_MAP.get("VWS"));
            tempPluralMap.put("VWS", LOOKUP_MAP.get("VIEW"));
            tempPluralMap.put("VLLA", LOOKUP_MAP.get("VLLS"));
            tempPluralMap.put("VLLS", LOOKUP_MAP.get("VLLA"));
            tempPluralMap.put("WD", LOOKUP_MAP.get("WDS"));
            tempPluralMap.put("WDS", LOOKUP_MAP.get("WD"));
            TYPE_AND_PLURAL = Collections.unmodifiableMap(tempPluralMap);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to load required files for AUS_ThoughfareTypes.", ex);
        }
    }

    public static class KeyInfo {
        private String m_preferredType = "";
        private String m_properName = "";
        private boolean m_canStart = false;
        private boolean m_canEnd = false;

        private KeyInfo(String preferredType, String properName, boolean canStart, boolean canEnd) {
            this.m_preferredType = preferredType;
            this.m_properName = properName;
            this.m_canStart = canStart;
            this.m_canEnd = canEnd;
        }

        public String getPreferredTypeName() {
            return this.m_preferredType;
        }

        public String getProperTypeName() {
            return this.m_properName;
        }

        public boolean canStart() {
            return this.m_canStart;
        }

        public boolean canEnd() {
            return this.m_canEnd;
        }
    }
}

