/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.reverseGeocode;

import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.IReverseGeocodeCandidate;
import com.mapinfo.mapmarker.core.reverseGeocode.CoreStandardReverseGeocodeSubHandler2;
import com.mapinfo.mapmarker.core.reverseGeocode.IReverseGeocodeInternalConstraints;
import com.mapinfo.mapmarker.user.IReverseGeocodeConstraints;
import com.mapinfo.mapmarker.user.ReverseGeocodeLocation;
import com.mapinfo.midev.unit.LinearUnit;
import java.util.ArrayList;
import java.util.List;

public class AUSReverseGeocodeSubHandler
extends CoreStandardReverseGeocodeSubHandler2 {
    protected static final int DISTANCE_BUFFER_IN_METERS = 1;

    protected List<CoreStandardReverseGeocodeSubHandler2.RGCandidateHolder> filterCandidates(ReverseGeocodeLocation originalLocation, IReverseGeocodeInternalConstraints constraints, List<IReverseGeocodeCandidate> allCandidates) throws MapMarkerInternalException {
        double maxDist = originalLocation.getDistanceAsLength().getValue(LinearUnit.METER);
        List<IReverseGeocodeCandidate> filteredCandidates = new ArrayList(1);
        ArrayList<CoreStandardReverseGeocodeSubHandler2.RGCandidateHolder> returnCandidates = new ArrayList<CoreStandardReverseGeocodeSubHandler2.RGCandidateHolder>(1);
        IReverseGeocodeCandidate lastCandidate = null;
        for (IReverseGeocodeCandidate candidate : allCandidates) {
            if (candidate.getDistance() > maxDist) break;
            if (lastCandidate == null) {
                lastCandidate = candidate;
            } else if (candidate.getDistance() > lastCandidate.getDistance() + 1.0) break;
            candidate.matchAddressNumber(originalLocation, (IReverseGeocodeConstraints)constraints);
            filteredCandidates.add(candidate);
        }
        filteredCandidates = this.filterBasedOnStreetSide(filteredCandidates, originalLocation, constraints);
        for (IReverseGeocodeCandidate candidate : filteredCandidates) {
            returnCandidates.add(new CoreStandardReverseGeocodeSubHandler2.RGCandidateHolder(candidate.toCandidateAddress(originalLocation, (IReverseGeocodeConstraints)constraints), candidate.getUserDictionaryPriority()));
        }
        return returnCandidates;
    }
}

