/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.singleline;

import com.mapinfo.mapmarker.core.singleline.IAddressParsing;
import com.mapinfo.mapmarker.core.singleline.IAddressSplit;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;

public class AUS_AvoidSplitEndingInArticleRule
implements Comparator<IAddressParsing> {
    private static final Set<String> commonArticles;

    @Override
    public int compare(IAddressParsing o1, IAddressParsing o2) {
        boolean endsInArticle1 = this.endsInArticle(o1);
        boolean endsInArticle2 = this.endsInArticle(o2);
        if (endsInArticle1 && !endsInArticle2) {
            return 1;
        }
        if (!endsInArticle1 && endsInArticle2) {
            return -1;
        }
        return 0;
    }

    private boolean endsInArticle(IAddressParsing parsing) {
        IAddressSplit split = parsing.getSplit();
        String main = split.getAddress().getMainAddress();
        if (StringUtilities.isEmpty((String)main)) {
            return false;
        }
        int idx = main.lastIndexOf(32);
        if (idx < 0) {
            return commonArticles.contains(main);
        }
        return commonArticles.contains(main.substring(idx + 1));
    }

    static {
        HashSet<String> temp = new HashSet<String>();
        temp.add("THE");
        temp.add("OF");
        commonArticles = Collections.unmodifiableSet(temp);
    }
}

