/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.singleline;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.singleline.IAddressParsing;
import com.mapinfo.mapmarker.core.singleline.SingleLineUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;

public class AUS_AvoidTypeInCityRule
implements Comparator<IAddressParsing> {
    private static final List<String> commonStreetTypes;

    @Override
    public int compare(IAddressParsing o1, IAddressParsing o2) {
        boolean hasType1 = this.hasStreetTypeAnywhereInCityName(o1);
        boolean hasType2 = this.hasStreetTypeAnywhereInCityName(o2);
        if (hasType1 && !hasType2) {
            return 1;
        }
        if (!hasType1 && hasType2) {
            return -1;
        }
        return 0;
    }

    private boolean hasStreetTypeAnywhereInCityName(IAddressParsing parsing) {
        Address parse1 = SingleLineUtils.getFirstParsedAddress((IAddressParsing)parsing);
        String city = parse1.getAreaName3();
        if (StringUtilities.isEmpty((String)city)) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(city);
        while (st.hasMoreTokens()) {
            if (!commonStreetTypes.contains(st.nextToken())) continue;
            return true;
        }
        return false;
    }

    static {
        ArrayList<String> temp = new ArrayList<String>();
        temp.add("STREET");
        temp.add("ROAD");
        temp.add("AVENUE");
        temp.add("RD");
        temp.add("AVE");
        temp.add("LANE");
        temp.add("ESPLANADE");
        temp.add("DRIVE");
        temp.add("CIRCUIT");
        temp.add("PLACE");
        temp.add("WALK");
        temp.add("COURT");
        temp.add("VIEW");
        temp.add("BOULEVARD");
        temp.add("BLVD");
        temp.add("HWY");
        commonStreetTypes = Collections.unmodifiableList(temp);
    }
}

