/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.singleline;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.singleline.IAddressParsing;
import com.mapinfo.mapmarker.core.singleline.SingleLineUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Comparator;

public class AUS_PreferCityInLastlineRule
implements Comparator<IAddressParsing> {
    @Override
    public int compare(IAddressParsing o1, IAddressParsing o2) {
        if (this.countNonCityFields(o1) == this.countNonCityFields(o2)) {
            boolean hasCity1 = this.hasCity(o1);
            boolean hasCity2 = this.hasCity(o2);
            if (hasCity1 && !hasCity2) {
                return -1;
            }
            if (!hasCity1 && hasCity2) {
                return 1;
            }
        }
        return 0;
    }

    private boolean hasCity(IAddressParsing parsing) {
        Address parse1 = SingleLineUtils.getFirstParsedAddress((IAddressParsing)parsing);
        return !StringUtilities.isEmpty((String)parse1.getAreaName3());
    }

    private int countNonCityFields(IAddressParsing parsing) {
        int result = 0;
        Address parse = parsing.getParse()[0];
        if (!StringUtilities.isEmpty((String)parse.getPlaceName())) {
            ++result;
        }
        if (!StringUtilities.isEmpty((String)parse.getMainAddress())) {
            ++result;
        }
        if (!StringUtilities.isEmpty((String)parse.getPreThoroughfareType())) {
            ++result;
        }
        if (!StringUtilities.isEmpty((String)parse.getPostThoroughfareType())) {
            ++result;
        }
        if (!StringUtilities.isEmpty((String)parse.getPreDirectional())) {
            ++result;
        }
        if (!StringUtilities.isEmpty((String)parse.getPostDirectional())) {
            ++result;
        }
        if (!StringUtilities.isEmpty((String)parse.getAddressNumber())) {
            ++result;
        }
        if (!StringUtilities.isEmpty((String)parse.getAreaName1())) {
            ++result;
        }
        if (!StringUtilities.isEmpty((String)parse.getAreaName2())) {
            ++result;
        }
        if (!StringUtilities.isEmpty((String)parse.getAreaName4())) {
            ++result;
        }
        if (!StringUtilities.isEmpty((String)parse.getPostCode1())) {
            ++result;
        }
        if (!StringUtilities.isEmpty((String)parse.getPostCode2())) {
            ++result;
        }
        if (!StringUtilities.isEmpty((String)parse.getUnitType())) {
            ++result;
        }
        if (!StringUtilities.isEmpty((String)parse.getUnitValue())) {
            ++result;
        }
        return result;
    }
}

