/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.singleline;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.singleline.IAddressParsing;
import com.mapinfo.mapmarker.core.singleline.SingleLineUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;

public class AUS_PreferMainAndCityWithoutGenFld2
implements Comparator<IAddressParsing> {
    private static final Set<String> LEGAL_STREET_SUFFIXES;

    @Override
    public int compare(IAddressParsing ia1, IAddressParsing ia2) {
        boolean bCheckSuffix;
        if (ia1.getSplit().isFromReverseSplit() && ia2.getSplit().isFromReverseSplit()) {
            return 0;
        }
        boolean bGenFld2_1 = this.hasGenericField2(ia1);
        boolean bGenFld2_2 = this.hasGenericField2(ia2);
        boolean bCity1 = this.hasCity(ia1);
        boolean bCity2 = this.hasCity(ia2);
        boolean bMain1 = this.hasMain(ia1);
        boolean bMain2 = this.hasMain(ia2);
        boolean blike1 = bMain1 && bCity1 && !bGenFld2_1;
        boolean blike2 = bMain2 && bCity2 && !bGenFld2_2;
        boolean bl = bCheckSuffix = bMain1 && bMain2 && bCity1 && bCity2;
        if (bCheckSuffix) {
            boolean bLikeSuffix1 = this.hasSuffixInGenericField2(ia1);
            boolean bLikeSuffix2 = this.hasSuffixInGenericField2(ia2);
            if (bLikeSuffix1 && !bLikeSuffix2) {
                return -1;
            }
            if (!bLikeSuffix1 && bLikeSuffix2) {
                return 1;
            }
        }
        if (bGenFld2_1 != bGenFld2_2) {
            if (blike1 && !blike2) {
                return -1;
            }
            if (blike2 && !blike1) {
                return 1;
            }
        }
        return 0;
    }

    private boolean hasGenericField2(IAddressParsing parsing) {
        Address parse1 = SingleLineUtils.getFirstParsedAddress((IAddressParsing)parsing);
        return !StringUtilities.isEmpty((String)parse1.getGenericField2());
    }

    private boolean hasCity(IAddressParsing parsing) {
        Address parse1 = SingleLineUtils.getFirstParsedAddress((IAddressParsing)parsing);
        return !StringUtilities.isEmpty((String)parse1.getAreaName3());
    }

    private boolean hasMain(IAddressParsing parsing) {
        Address parse1 = SingleLineUtils.getFirstParsedAddress((IAddressParsing)parsing);
        return !StringUtilities.isEmpty((String)parse1.getMainAddress());
    }

    private boolean hasSuffixInGenericField2(IAddressParsing parsing) {
        Address parse1 = SingleLineUtils.getFirstParsedAddress((IAddressParsing)parsing);
        return !StringUtilities.isEmpty((String)parse1.getGenericField2()) && LEGAL_STREET_SUFFIXES.contains(parse1.getGenericField2());
    }

    static {
        HashSet<String> tmp = new HashSet<String>(11);
        tmp.add("CN");
        tmp.add("DE");
        tmp.add("EX");
        tmp.add("LR");
        tmp.add("ML");
        tmp.add("UP");
        tmp.add("IN");
        tmp.add("OF");
        tmp.add("ON");
        tmp.add("OP");
        tmp.add("OT");
        LEGAL_STREET_SUFFIXES = Collections.unmodifiableSet(tmp);
    }
}

