/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN;

import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.InternalIntersectionCandidateAddress;
import com.mapinfo.mapmarker.core.ICoreParseHandler;
import com.mapinfo.mapmarker.core.address.CoreAddressGeocoder;
import com.mapinfo.mapmarker.core.address.IAddressGeocoder;
import com.mapinfo.mapmarker.core.address.ICoreAddressGeocoder;
import com.mapinfo.mapmarker.core.parser.ICoreParser;
import com.mapinfo.mapmarker.core.parser.IIntersectionParser;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ResourceBundle;

public class CAN_AddressGeocoder
implements IAddressGeocoder {
    private static final String[] SAFE_INTERSECTION_TYPES = new String[]{"&&", "@"};
    private final IAddressGeocoder m_coreGeocoder;

    public CAN_AddressGeocoder() {
        this((IAddressGeocoder)new CoreAddressGeocoder());
    }

    protected CAN_AddressGeocoder(IAddressGeocoder baseGeocoder) {
        this.m_coreGeocoder = baseGeocoder;
    }

    public GeocodeResult geocode(IConstraints preferences, ResourceBundle bundle) throws MMInternalFatalException, MapMarkerInternalException {
        GeocodeResult gr = this.m_coreGeocoder.geocode(preferences, bundle);
        if (this.shouldAttemptAsNonIntersection(gr, preferences)) {
            this.reparse(preferences);
            ((ICoreAddressGeocoder)preferences.getHandler()).setPostalFallbackOccured(false);
            ((ICoreAddressGeocoder)preferences.getHandler()).setGeoFallbackOccured(false);
            gr = this.m_coreGeocoder.geocode(preferences, bundle);
        }
        return gr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reparse(IConstraints preferences) throws ParserException {
        IHandler handler = preferences.getHandler();
        IIntersectionParser originalIntersectionParser = ((ICoreParser)handler).getIntersectionParser();
        ((ICoreParser)handler).setIntersectionParser((IIntersectionParser)new NoOpParser());
        try {
            Address[] parse = ((ICoreParseHandler)handler).getParser().parse(handler.getInputAddress(), preferences);
            handler.setParsedAddressArray(parse);
        }
        finally {
            ((ICoreParser)handler).setIntersectionParser(originalIntersectionParser);
        }
    }

    private boolean shouldAttemptAsNonIntersection(GeocodeResult gr, IConstraints preferences) {
        ICandidate cand;
        boolean wasIntersection = preferences.getHandler().isParsedIntersection();
        if (!wasIntersection) {
            return false;
        }
        String inputMain = preferences.getHandler().getInputAddress().getMainAddress();
        if (!StringUtilities.isEmpty((String)inputMain)) {
            for (String safeIntersectionType : SAFE_INTERSECTION_TYPES) {
                if (!inputMain.contains(safeIntersectionType)) continue;
                return false;
            }
        }
        return gr.getNumberCandidates() <= 0 || !((cand = (ICandidate)preferences.getHandler().getMatchResults().get(0)) instanceof InternalIntersectionCandidateAddress);
    }

    private static class NoOpParser
    implements IIntersectionParser {
        private NoOpParser() {
        }

        public Address[] getIntersectionAddresses(Address addrIn) {
            return new Address[]{addrIn};
        }
    }
}

