/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN;

import com.mapinfo.mapmarker.CAN.CAN_Segment;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.FieldScores;
import com.mapinfo.mapmarker.common.InternalBrowseAddress;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.core.browse.CoreBrowseFilter;
import com.mapinfo.mapmarker.core.browse.IBrowseFilter;
import com.mapinfo.mapmarker.core.browse.ICoreBrowseFilter;
import com.mapinfo.mapmarker.core.matcher.IMatchPreferences;
import com.mapinfo.mapmarker.core.matcher.MatcherException;
import java.util.ArrayList;
import java.util.List;

public class CAN_BrowseFilter
implements IBrowseFilter {
    CoreBrowseFilter m_coreFilter = new CoreBrowseFilter();

    public List filterAddresses(IConstraints constraints, Address inputAddress, List browseAddresses) throws MatcherException {
        if (browseAddresses == null || browseAddresses.isEmpty()) {
            return browseAddresses;
        }
        FieldScores thresholds = constraints.getHandler().getMatcherConstants().getFieldScores();
        ArrayList<InternalBrowseAddress> filteredList = new ArrayList<InternalBrowseAddress>();
        InternalBrowseAddress filteredAddress = null;
        String ldu = inputAddress.getPostCode2();
        for (InternalBrowseAddress address : browseAddresses) {
            filteredAddress = this.filterAddress(address, inputAddress, thresholds, constraints, ldu);
            if (filteredAddress == null) continue;
            filteredList.add(filteredAddress);
        }
        return filteredList;
    }

    protected InternalBrowseAddress filterAddress(InternalBrowseAddress address, Address inputAddress, FieldScores thresholds, IConstraints constraints, String ldu) {
        InternalBrowseAddress filteredAddress = constraints.getHandler().getBrowseHelper().makeBrowseAddress((Address)address);
        int segmentCount = address.getSegmentCount();
        for (int i = 0; i < segmentCount; ++i) {
            Segment segment = address.getSegmentAt(i);
            Segment filteredSegment = this.filterSegment(segment, inputAddress, thresholds, constraints, ldu);
            if (filteredSegment == null) continue;
            filteredAddress.addSegment(filteredSegment);
        }
        if (filteredAddress.getSegmentCount() > 0) {
            return filteredAddress;
        }
        return null;
    }

    protected Segment filterSegment(Segment segment, Address inputAddress, FieldScores thresholds, IConstraints constraints, String ldu) {
        IMatchPreferences constants = constraints.getHandler().getMatchConstraintsConverter().repackageGeocodingConstraints(constraints, inputAddress);
        GeoInfoRecord geoinfo = segment.getGeoInfoRecord();
        IHandler handler = constraints.getHandler();
        if (geoinfo != null) {
            if (!this.passesFilter(inputAddress.getAreaName1(), geoinfo.getAreaName1(), thresholds.getAreaName1(), constraints.isMustMatchArea1(), handler) && !this.passesFilter(inputAddress.getAreaName1(), geoinfo.getAltAreaName1(), thresholds.getAreaName1(), constraints.isMustMatchArea1(), handler)) {
                return null;
            }
            if (!this.passesFilter(inputAddress.getAreaName2(), geoinfo.getAreaName2(), thresholds.getAreaName2(), constraints.isMustMatchArea2(), handler) && !this.passesFilter(inputAddress.getAreaName2(), geoinfo.getAltAreaName2(), thresholds.getAreaName2(), constraints.isMustMatchArea2(), handler)) {
                return null;
            }
            if (!this.passesFilter(inputAddress.getAreaName3(), geoinfo.getAreaName3(), thresholds.getAreaName3(), constants.getExactMatchAreaName3(), handler) && !this.passesFilter(inputAddress.getAreaName3(), geoinfo.getAltAreaName3(), thresholds.getAreaName3(), constants.getExactMatchAreaName3(), handler)) {
                return null;
            }
            if (!this.passesFilter(inputAddress.getAreaName4(), geoinfo.getAreaName4(), thresholds.getAreaName4(), constants.getExactMatchAreaName4(), handler) && !this.passesFilter(inputAddress.getAreaName4(), geoinfo.getAltAreaName4(), thresholds.getAreaName4(), constants.getExactMatchAreaName1(), handler)) {
                return null;
            }
        } else {
            if (!this.passesFilter(inputAddress.getAreaName1(), segment.getLeftAreaName1(), thresholds.getAreaName1(), constants.getExactMatchAreaName1(), handler) && !this.passesFilter(inputAddress.getAreaName1(), segment.getRightAreaName1(), thresholds.getAreaName1(), constants.getExactMatchAreaName1(), handler)) {
                return null;
            }
            if (!this.passesFilter(inputAddress.getAreaName2(), segment.getLeftAreaName2(), thresholds.getAreaName2(), constants.getExactMatchAreaName2(), handler) && !this.passesFilter(inputAddress.getAreaName2(), segment.getRightAreaName2(), thresholds.getAreaName2(), constants.getExactMatchAreaName2(), handler)) {
                return null;
            }
            if (!this.passesFilter(inputAddress.getAreaName3(), segment.getLeftAreaName3(), thresholds.getAreaName3(), constants.getExactMatchAreaName3(), handler) && !this.passesFilter(inputAddress.getAreaName3(), segment.getRightAreaName3(), thresholds.getAreaName3(), constants.getExactMatchAreaName3(), handler)) {
                return null;
            }
            if (!this.passesFilter(inputAddress.getAreaName4(), segment.getLeftAreaName4(), thresholds.getAreaName4(), constants.getExactMatchAreaName4(), handler) && !this.passesFilter(inputAddress.getAreaName4(), segment.getRightAreaName4(), thresholds.getAreaName4(), constants.getExactMatchAreaName4(), handler)) {
                return null;
            }
        }
        if (!this.passesFilter(inputAddress.getPostCode1(), segment.getLeftPostCode1(), thresholds.getPostalCode1(), constants.getExactMatchPostalCode1(), handler) && !this.passesFilter(inputAddress.getPostCode1(), segment.getRightPostCode1(), thresholds.getPostalCode1(), constants.getExactMatchPostalCode1(), handler)) {
            return null;
        }
        if (ldu != null && !((CAN_Segment)segment).containsLDU(ldu)) {
            return null;
        }
        return segment;
    }

    protected boolean passesFilter(String field1, String field2, double threshold, boolean mustMatch, IHandler handler) {
        if (field1 == null) {
            return true;
        }
        double fieldScore = ((ICoreBrowseFilter)handler).getScoringHelper().makeStringScorer().scoreString(field1, field2);
        if (mustMatch && fieldScore != 1.0) {
            return false;
        }
        return !(fieldScore < threshold);
    }
}

