/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class CAN_CensusInfo {
    private static final int CD_LENGTH = 4;
    private static final int DA_LENGTH = 4;
    private static final int CSD_LENGTH = 3;
    private static final int CMA_LENGTH = 3;
    private static final int CT_LENGTH = 6;
    private short m_CD = (short)-1;
    private short m_DA = (short)-1;
    private short m_CSD = (short)-1;
    private short m_CMA = (short)-1;
    private int m_CT = -1;

    public void setCD(short CD) {
        this.m_CD = CD;
    }

    public boolean hasCD() {
        return this.m_CD != -1;
    }

    public short getCD() {
        return this.m_CD;
    }

    public String getCDString() {
        if (this.hasCD()) {
            return StringUtilities.intToLeadingZeroString((int)4, (int)this.m_CD);
        }
        return null;
    }

    public void setDA(short DA) {
        this.m_DA = DA;
    }

    public boolean hasDA() {
        return this.m_DA != -1;
    }

    public short getDA() {
        return this.m_DA;
    }

    public String getDAString() {
        if (this.hasDA()) {
            return StringUtilities.intToLeadingZeroString((int)4, (int)this.m_DA);
        }
        return null;
    }

    public void setCSD(short CSD) {
        this.m_CSD = CSD;
    }

    public boolean hasCSD() {
        return this.m_CSD != -1;
    }

    public short getCSD() {
        return this.m_CSD;
    }

    public String getCSDString() {
        if (this.hasCSD()) {
            return StringUtilities.intToLeadingZeroString((int)3, (int)this.m_CSD);
        }
        return null;
    }

    public void setCMA(short CMA) {
        this.m_CMA = CMA;
    }

    public boolean hasCMA() {
        return this.m_CMA != -1;
    }

    public short getCMA() {
        return this.m_CMA;
    }

    public String getCMAString() {
        if (this.hasCMA()) {
            return StringUtilities.intToLeadingZeroString((int)3, (int)this.m_CMA);
        }
        return null;
    }

    public void setCT(int CT) {
        this.m_CT = CT;
    }

    public boolean hasCT() {
        return this.m_CT != -1;
    }

    public int getCT() {
        return this.m_CT;
    }

    public String getCTString() {
        if (this.hasCT()) {
            return StringUtilities.intToLeadingZeroString((int)6, (int)this.m_CT);
        }
        return null;
    }

    public boolean equals(Object that) {
        CAN_CensusInfo thatInfo = (CAN_CensusInfo)that;
        return this.m_CD == thatInfo.m_CD && this.m_DA == thatInfo.m_DA && this.m_CSD == thatInfo.m_CSD && this.m_CMA == thatInfo.m_CMA && this.m_CT == thatInfo.m_CT;
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        buffer.append("CD: ");
        buffer.append(this.m_CD);
        buffer.append(lineSeparator);
        buffer.append('\t');
        buffer.append(this.getCDString());
        buffer.append(lineSeparator);
        buffer.append("DA: ");
        buffer.append(this.m_DA);
        buffer.append(lineSeparator);
        buffer.append('\t');
        buffer.append(this.getDAString());
        buffer.append(lineSeparator);
        buffer.append("CSD: ");
        buffer.append(this.m_CSD);
        buffer.append(lineSeparator);
        buffer.append('\t');
        buffer.append(this.getCSDString());
        buffer.append(lineSeparator);
        buffer.append("CMA: ");
        buffer.append(this.m_CMA);
        buffer.append(lineSeparator);
        buffer.append('\t');
        buffer.append(this.getCMAString());
        buffer.append(lineSeparator);
        buffer.append("CT: ");
        buffer.append(this.m_CT);
        buffer.append(lineSeparator);
        buffer.append('\t');
        buffer.append(this.getCTString());
        buffer.append(lineSeparator);
        buffer.append(lineSeparator);
        return buffer.toString();
    }

    public void output(Address candidate) {
        if (this.hasCD()) {
            this.populateAdditionalField("CENSUS_CD", this.getCDString(), candidate);
        }
        if (this.hasDA()) {
            this.populateAdditionalField("CENSUS_DA", this.getDAString(), candidate);
        }
        if (this.hasCSD()) {
            this.populateAdditionalField("CENSUS_CSD", this.getCSDString(), candidate);
        }
        if (this.hasCMA()) {
            this.populateAdditionalField("CENSUS_CMA", this.getCMAString(), candidate);
        }
        if (this.hasCT()) {
            this.populateAdditionalField("CENSUS_CT", this.getCTString(), candidate);
        }
    }

    private void populateAdditionalField(String field, String value, Address addr) {
        addr.getAdditionalFields().put(field, value);
    }

    public static CAN_CensusInfo makeShared(CAN_CensusInfo info1, CAN_CensusInfo info2) {
        if (info1 == null) {
            return info2;
        }
        if (info2 == null) {
            return info1;
        }
        if (info1 == info2 || info1.equals(info2)) {
            return info1;
        }
        CAN_CensusInfo info = null;
        if (info1.hasCD() && info2.hasCD() && info1.m_CD == info2.m_CD) {
            info = new CAN_CensusInfo();
            info.setCD(info1.m_CD);
            if (info1.hasDA() && info2.hasDA() && info1.m_DA == info2.m_DA) {
                info.setDA(info1.m_DA);
            }
            if (info1.hasCSD() && info2.hasCSD() && info1.m_CSD == info2.m_CSD) {
                info.setCSD(info1.m_CSD);
            }
        }
        if (info1.hasCMA() && info2.hasCMA() && info1.m_CMA == info2.m_CMA) {
            if (info == null) {
                info = new CAN_CensusInfo();
            }
            info.setCMA(info1.m_CMA);
            if (info1.hasCT() && info2.hasCT() && info1.m_CT == info2.m_CT) {
                info.setCT(info1.m_CT);
            }
        }
        return info;
    }
}

