/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN;

import com.mapinfo.mapmarker.CAN.CAN_DictionaryGeographyInfo;
import com.mapinfo.mapmarker.CAN.CAN_InternalDBAvailabilityCandidate;
import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.MMGeneralGeocoderException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.ICountryGeographyInfo;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessException;
import com.mapinfo.mapmarker.common.dp.IDataManager;
import com.mapinfo.mapmarker.core.IRetrievedCandidates;
import com.mapinfo.mapmarker.core.custom.ICustomGeocoder;
import java.util.ArrayList;
import java.util.List;

public class CAN_CustomGeocoder
implements ICustomGeocoder {
    public static final int GEOCODE_TYPE_DB_AVAILABILITY = 205;
    public static final int GEOCODE_TYPE_PB_KEY = 200;

    public GeocodeResult geocodeCustom(int geocodeType, IConstraints constraints) throws MapMarkerInternalException {
        IHandler handler = constraints.getHandler();
        GeocodeResult gr = new GeocodeResult();
        switch (geocodeType) {
            case 205: {
                List dictInfos;
                ArrayList<CAN_InternalDBAvailabilityCandidate> list = new ArrayList<CAN_InternalDBAvailabilityCandidate>();
                CAN_InternalDBAvailabilityCandidate cand = new CAN_InternalDBAvailabilityCandidate();
                ICountryGeographyInfo infos = handler.getDataManager().getCountryGeographyInfo();
                if (infos.hasUserDictionaries()) {
                    cand.setDBFlags(4);
                }
                if ((dictInfos = infos.getDictionaryInfos()) != null) {
                    for (CAN_DictionaryGeographyInfo CANDictInfo : dictInfos) {
                        if (CANDictInfo.hasStreets()) {
                            cand.setDBFlags(cand.getDBFlags() | 1);
                        }
                        if (!CANDictInfo.hasCentroids()) continue;
                        cand.setDBFlags(cand.getDBFlags() | 2);
                    }
                }
                list.add(cand);
                gr.setNumberCandidates(1);
                handler.setGeocodeResult(gr);
                handler.setMatchResults(list);
                break;
            }
            case 200: {
                return this.geocodePBKey(constraints);
            }
            default: {
                throw new MMGeneralGeocoderException(2307);
            }
        }
        return gr;
    }

    private GeocodeResult geocodePBKey(IConstraints constraints) throws MapMarkerInternalException {
        IRetrievedCandidates retrieved;
        IHandler handler = constraints.getHandler();
        GeocodeResult result = new GeocodeResult();
        IDataManager dataManager = handler.getDataManager();
        try {
            retrieved = dataManager.getPBKeyCandidates(handler.getInputAddress(), constraints);
        }
        catch (FatalDataAccessException FDAEx) {
            throw new MMGeneralGeocoderException(2102, (Throwable)FDAEx);
        }
        result.setDataLicensed(retrieved.getDataLicensed());
        List candidates = retrieved.getCandidates();
        int candidateCount = candidates.size();
        result.setNumberCandidates(candidateCount);
        result.setNumberCloseCandidates(candidateCount);
        handler.setMatchResults(candidates);
        handler.setGeocodeResult(result);
        return result;
    }
}

