/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN;

import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CAN_EnglishSoundex
extends Soundex {
    private static final int MAX_SOUNDEX_KEY_LENGTH = 9;
    private static final char[] letters = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c7', '\u00c0', '\u00c1', '\u00c2', '\u00c6', '\u00c9', '\u00c8', '\u00ca', '\u00cb', '\u00ce', '\u00cf', '\u00d3', '\u00d4', '\u00d9', '\u00db', '\u00dc'};
    private static final int[] sounds = new int[]{0, 1, 2, 3, 0, 1, 2, 0, 0, 2, 2, 4, 5, 5, 0, 1, 2, 6, 2, 3, 0, 1, 0, 2, 0, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final String soundStr = "000000000000000000000001111222222222334556";
    private static final String charStr = "AEHIOUWY\u00c0\u00c1\u00c2\u00c6\u00c9\u00c8\u00ca\u00cb\u00ce\u00cf\u00d3\u00d4\u00d9\u00db\u00dcBFPVCGJKQSXZ\u00c7DTLMNR";
    private static final String DIGITS = "0123456789";
    protected static final int NUMERIC_CASE_REVERSE = 1;
    protected static final int NUMERIC_CASE_ADDZERO = 2;
    protected static final int NUMERIC_CASE_INCDEC = 3;
    private static final String VALID_CODES = "123456";
    private static final int SPECIAL_CASE_INITIALDIGIT = 1;
    private static final int SPECIAL_CASE_PO_BOX = 2;
    private static final char PO_BOX_FIRST_LETTER = '#';
    private final HashMap m_soundHash = new HashMap(sounds.length);
    private static final int INCREASE_DECREASE_VALUE = 3;
    public static final int REPLACE_FIRST_LETTER_EQUIVALENT = 1024;
    private static final char[] A_EQUIVALENTS = new char[]{'A', '\u00c0', '\u00c1', '\u00c2'};
    private static final char[] E_EQUIVALENTS = new char[]{'E', '\u00c6', '\u00c9', '\u00c8', '\u00ca', '\u00cb'};
    private static final char[] I_EQUIVALENTS = new char[]{'I', '\u00ce', '\u00cf'};
    private static final char[] O_EQUIVALENTS = new char[]{'O', '\u00d3', '\u00d4'};
    private static final char[] U_EQUIVALENTS = new char[]{'U', '\u00d9', '\u00db', '\u00dc'};
    private static final char[] C_EQUIVALENTS = new char[]{'C', '\u00c7'};
    private static final Map<Character, Collection<Character>> FIRST_LETTER_EQUIVALENTS = new HashMap<Character, Collection<Character>>();
    protected static final String[] ignoredWordList;

    private static Map<Character, Collection<Character>> makeMap(char[] chars) {
        HashMap<Character, Collection<Character>> m = new HashMap<Character, Collection<Character>>();
        for (int i = 0; i < chars.length; ++i) {
            Character key = new Character(chars[i]);
            ArrayList<Character> value = new ArrayList<Character>(chars.length - 1);
            for (int j = 0; j < chars.length; ++j) {
                if (j == i) continue;
                value.add(new Character(chars[j]));
            }
            m.put(key, value);
        }
        return m;
    }

    public CAN_EnglishSoundex() {
        for (int i = 0; i < sounds.length; ++i) {
            this.m_soundHash.put(new Character(letters[i]), new Integer(sounds[i]));
        }
    }

    public ISoundexKey getSoundex(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        if ((str = this.removeUnwantedCharsAndWords(str.toUpperCase())).length() == 0) {
            return null;
        }
        int spCaseType = this.isSpecialCase(str);
        if (spCaseType != 0) {
            return this.handleSpecialCases(spCaseType, str);
        }
        char[] inputStringArray = str.toCharArray();
        if (inputStringArray.length == 0) {
            return null;
        }
        MiSoundexKey key = new MiSoundexKey();
        key.setFirstChar(inputStringArray[0]);
        int inputStringLength = inputStringArray.length;
        int returnCode = 0;
        int base = 1;
        int lastcode = 0;
        int sdx = 0;
        int i = 1;
        int soundexKeysAdded = 0;
        while (i < inputStringLength && soundexKeysAdded < 9) {
            char c = inputStringArray[i];
            boolean bIncrement = true;
            Integer intKey = (Integer)this.m_soundHash.get(new Character(c));
            sdx = intKey == null ? 0 : intKey;
            boolean bVowel = false;
            if (sdx == 0) {
                bVowel = true;
                while (i < inputStringLength) {
                    if (Character.isDigit(c = inputStringArray[i++]) || (sdx = (intKey = (Integer)this.m_soundHash.get(new Character(c))) == null ? 0 : intKey) == 0) continue;
                    bIncrement = false;
                    break;
                }
            }
            boolean tryTwoCharCases = true;
            if (bIncrement) {
                if (i + 1 >= inputStringLength) {
                    tryTwoCharCases = false;
                }
            } else if (i >= inputStringLength) {
                tryTwoCharCases = false;
            }
            if (tryTwoCharCases && soundexKeysAdded + 1 < 9) {
                switch (c) {
                    case 'X': {
                        returnCode += base * sdx;
                        base *= 10;
                        ++soundexKeysAdded;
                        sdx = 7;
                        break;
                    }
                    case 'Q': {
                        returnCode += base * sdx;
                        base *= 10;
                        ++soundexKeysAdded;
                        sdx = 8;
                        break;
                    }
                }
            }
            if (sdx != lastcode || bVowel) {
                returnCode += base * sdx;
                base *= 10;
                lastcode = sdx;
                ++soundexKeysAdded;
            }
            if (!bIncrement) continue;
            ++i;
        }
        key.setNumericValue(returnCode);
        return key;
    }

    protected int isSpecialCase(String str) {
        if (Character.isDigit(str.charAt(0))) {
            return 1;
        }
        if ("PO BOX".equals(str)) {
            return 2;
        }
        return 0;
    }

    protected ISoundexKey handleSpecialCases(int type, String str) {
        MiSoundexKey key = null;
        int code = 0;
        switch (type) {
            case 1: {
                code = this.getNumericValue(str);
                key = new MiSoundexKey();
                key.setFirstChar('0');
                key.setNumericValue(code);
                break;
            }
            case 2: {
                key = new MiSoundexKey();
                key.setFirstChar('#');
            }
        }
        return key;
    }

    protected int getNumericValue(String str) {
        int code = 0;
        try {
            code = Integer.parseInt(StringUtilities.trimToChars((String)str, (String)DIGITS));
        }
        catch (NumberFormatException e) {
            code = 0;
        }
        return code;
    }

    protected RemoveWordResult removeWord(String str, String word) {
        RemoveWordResult ret = new RemoveWordResult();
        ret.retStr = str;
        ret.found = 0;
        if (str.indexOf(" ") == -1) {
            ret.found = -1;
            return ret;
        }
        if (str.indexOf(word) == -1) {
            return ret;
        }
        int wordLength = word.length();
        while (str.startsWith(word + ' ')) {
            ret.retStr = str = str.substring(wordLength + 1);
            ret.found = 1;
        }
        while (str.endsWith(' ' + word)) {
            ret.retStr = str = str.substring(0, str.length() - wordLength - 1);
            ret.found = 1;
        }
        int pos = str.indexOf(' ' + word + ' ');
        while (pos > -1) {
            str = str.substring(0, pos) + str.substring(pos + wordLength + 1);
            pos = str.indexOf(' ' + word + ' ');
            ret.retStr = str;
            ret.found = 1;
        }
        if (str.indexOf(" ") == -1) {
            ret.found = -1;
            return ret;
        }
        return ret;
    }

    protected String removeUnwantedCharsAndWords(String str) {
        int i;
        str = str.trim();
        if ((str = str.replace('-', ' ')).indexOf(" ") != -1) {
            int len = ignoredWordList.length;
            for (i = 0; i < len; ++i) {
                RemoveWordResult ret = this.removeWord(str, ignoredWordList[i]);
                str = ret.retStr;
                if (ret.found < 0) break;
            }
        }
        char[] tempArray = str.toCharArray();
        StringBuffer returnBuffer = new StringBuffer(str.length());
        for (i = 0; i < tempArray.length; ++i) {
            char c = tempArray[i];
            if (!Character.isLetterOrDigit(c)) continue;
            returnBuffer.append(c);
        }
        return returnBuffer.toString();
    }

    public List calculateAlternateSoundexKeys(String origString, ISoundexKey origKey, int possibleErrors, List keys) {
        Character lookup;
        Collection<Character> values;
        int val;
        int j;
        StringBuffer nameBuf;
        int len;
        MiSoundexKey key;
        char c;
        int i;
        int end;
        char sound;
        int idx;
        if (possibleErrors == 0) {
            return keys;
        }
        if (origString == null || origString.length() == 0) {
            return keys;
        }
        if ((origString = this.removeUnwantedCharsAndWords(origString.toUpperCase())).length() == 0) {
            return keys;
        }
        int type = this.isSpecialCase(origString);
        if (type == 1) {
            return this.calculateAlternateNumericSoundexKeys(origString, possibleErrors, keys);
        }
        if (type == 2) {
            return keys;
        }
        String origUpper = origString.toUpperCase();
        char firstChar = ((MiSoundexKey)origKey).getFirstChar();
        int origNumericVal = ((MiSoundexKey)origKey).getNumericValue();
        if ((possibleErrors & 0x20) > 0) {
            // empty if block
        }
        if ((possibleErrors & 1) > 0 && (idx = charStr.indexOf(firstChar)) >= 0) {
            sound = soundStr.charAt(idx);
            end = soundStr.lastIndexOf(sound) + 1;
            for (i = soundStr.indexOf(sound); i < end; ++i) {
                c = charStr.charAt(i);
                if (c == firstChar) continue;
                key = new MiSoundexKey();
                key.setNumericValue(origNumericVal);
                key.setFirstChar(c);
                if (key == null || keys.contains(key)) continue;
                keys.add(key);
            }
        }
        if ((possibleErrors & 2) > 0) {
            len = origUpper.length();
            nameBuf = new StringBuffer(origUpper);
            for (i = 1; i < len; ++i) {
                c = nameBuf.charAt(i);
                idx = charStr.indexOf(c);
                if (idx < 0 || (sound = soundStr.charAt(charStr.indexOf(c))) == '0') continue;
                nameBuf.setCharAt(i, 'A');
                key = (MiSoundexKey)this.getSoundex(nameBuf.toString());
                if (key != null && !keys.contains(key)) {
                    keys.add(key);
                }
                nameBuf.setCharAt(i, c);
            }
        }
        if ((possibleErrors & 0x40) > 0) {
            len = origUpper.length();
            nameBuf = new StringBuffer(origUpper);
            for (i = 1; i < len; ++i) {
                c = nameBuf.charAt(i);
                idx = charStr.indexOf(c);
                if (idx < 0 || (sound = soundStr.charAt(charStr.indexOf(c))) == '0') continue;
                nameBuf.setCharAt(i, 'A');
                key = (MiSoundexKey)this.getSoundex(nameBuf.toString());
                if (key != null && !keys.contains(key)) {
                    char d;
                    keys.add(key);
                    if (i < len - 1 && nameBuf.charAt(i - 1) == nameBuf.charAt(i + 1) && (idx = charStr.indexOf(d = nameBuf.charAt(i - 1))) >= 0 && (sound = soundStr.charAt(idx)) != '0') {
                        nameBuf.setCharAt(i - 1, 'A');
                        key = (MiSoundexKey)this.getSoundex(nameBuf.toString());
                        if (key != null && !keys.contains(key)) {
                            keys.add(key);
                        }
                        nameBuf.setCharAt(i - 1, d);
                    }
                }
                nameBuf.setCharAt(i, c);
            }
        }
        if ((possibleErrors & 4) > 0) {
            String code = String.valueOf(origNumericVal);
            int len2 = code.length();
            end = VALID_CODES.length();
            StringBuffer sb = new StringBuffer(len2);
            for (i = 0; i < len2; ++i) {
                for (j = 0; j < end; ++j) {
                    if (code.charAt(i) == VALID_CODES.charAt(j)) continue;
                    sb.delete(0, len2);
                    sb.append(code);
                    sb.replace(i, i + 1, String.valueOf(VALID_CODES.charAt(j)));
                    key = new MiSoundexKey();
                    key.setFirstChar(firstChar);
                    val = Integer.parseInt(sb.toString());
                    key.setNumericValue(val);
                    if (keys.contains(key)) continue;
                    keys.add(key);
                }
            }
        }
        if ((possibleErrors & 8) > 0) {
            String code = String.valueOf(origNumericVal);
            int len3 = code.length();
            if (len3 == 9) {
                code = code.substring(1);
                --len3;
            }
            end = VALID_CODES.length();
            StringBuffer sb = new StringBuffer(len3 + 1);
            for (i = 0; i < len3 + 1; ++i) {
                for (j = 0; j < end; ++j) {
                    sb.delete(0, len3 + 1);
                    sb.append(code);
                    if (i + 1 < len3 && code.charAt(i) == '3' && VALID_CODES.charAt(j) == '7') {
                        sb.replace(i, i + 1, "7");
                        key = new MiSoundexKey();
                        val = Integer.parseInt(sb.toString());
                        key.setNumericValue(val);
                        key.setFirstChar(firstChar);
                        if (!keys.contains(key)) {
                            keys.add(key);
                        }
                        sb.replace(i, i + 1, "3");
                        sb.insert(i, '7');
                        key = new MiSoundexKey();
                        val = Integer.parseInt(sb.toString());
                        key.setNumericValue(val);
                        key.setFirstChar(firstChar);
                        if (keys.contains(key)) continue;
                        keys.add(key);
                        continue;
                    }
                    if (i + 1 < len3 && code.charAt(i) == '1' && VALID_CODES.charAt(j) == '8') {
                        sb.replace(i, i + 1, "8");
                        key = new MiSoundexKey();
                        val = Integer.parseInt(sb.toString());
                        key.setNumericValue(val);
                        key.setFirstChar(firstChar);
                        if (!keys.contains(key)) {
                            keys.add(key);
                        }
                        sb.replace(i, i + 1, "1");
                        sb.insert(i, '8');
                        key = new MiSoundexKey();
                        val = Integer.parseInt(sb.toString());
                        key.setNumericValue(val);
                        key.setFirstChar(firstChar);
                        if (keys.contains(key)) continue;
                        keys.add(key);
                        continue;
                    }
                    sb.insert(i, VALID_CODES.charAt(j));
                    key = new MiSoundexKey();
                    val = Integer.parseInt(sb.toString());
                    key.setNumericValue(val);
                    key.setFirstChar(firstChar);
                    if (keys.contains(key)) continue;
                    keys.add(key);
                }
            }
        }
        if ((possibleErrors & 0x10) > 0) {
            String code = String.valueOf(origNumericVal);
            int len4 = code.length() - 1;
            StringBuffer sb = new StringBuffer(len4 + 1);
            sb.append(code);
            for (i = 0; i < len4; ++i) {
                char c1 = sb.charAt(i);
                char c2 = sb.charAt(i + 1);
                sb.setCharAt(i, c2);
                sb.setCharAt(i + 1, c1);
                key = new MiSoundexKey();
                val = Integer.parseInt(sb.toString());
                key.setNumericValue(val);
                key.setFirstChar(firstChar);
                if (!keys.contains(key)) {
                    keys.add(key);
                }
                sb.setCharAt(i, c1);
                sb.setCharAt(i + 1, c2);
            }
        }
        if ((possibleErrors & 0x400) > 0 && (values = FIRST_LETTER_EQUIVALENTS.get(lookup = new Character(((MiSoundexKey)origKey).getFirstChar()))) != null) {
            for (Character replace : values) {
                MiSoundexKey altKey = new MiSoundexKey();
                altKey.setFirstChar(replace.charValue());
                altKey.setNumericValue(((MiSoundexKey)origKey).getNumericValue());
                if (keys.contains(altKey)) continue;
                keys.add(altKey);
            }
        }
        return keys;
    }

    public static void main(String[] args) {
        int j;
        int len;
        List list;
        String value;
        ISoundexKey key;
        String test;
        int i;
        CAN_EnglishSoundex soundex = new CAN_EnglishSoundex();
        String[] tests = new String[]{"BERLIN", "TANNENSTR", "BAUMENSTRASSE", "NEIDERSPAARER STRA\ufffdE", "IM STILLEN WINKEL", "IM DEN GR\ufffdNDEN", "INGEBORD-BACHMANN-STRA\ufffdE", "AM RO\ufffdBURG", "Pfaffendobel", "Flugplatzweg", "Am Querstra\ufffdE", "PO BOX 100", "Po Box 111", "po box 4705"};
        for (i = 0; i < tests.length; ++i) {
            test = tests[i];
            key = soundex.getSoundex(test);
            value = key.toString();
            System.out.println("\nTest: " + test + "\tValue: " + value + " input first char: " + test.charAt(0));
            list = new ArrayList();
            list = soundex.calculateAlternateSoundexKeys(test, key, 1, list);
            len = list.size();
            for (j = 0; j < len; ++j) {
                System.out.println("\nOutput: " + test + "\t alternate " + list.get(j));
            }
        }
        for (i = 0; i < args.length; ++i) {
            test = args[i];
            key = soundex.getSoundex(test);
            value = key.toString();
            System.out.println("\nInput: " + test + "\tValue: " + value + " input first char: " + test.charAt(0));
            list = new ArrayList();
            list = soundex.calculateAlternateSoundexKeys(test, key, 1, list);
            len = list.size();
            for (j = 0; j < len; ++j) {
                System.out.println("\nOutput: " + test + "\t alternate " + list.get(j));
            }
        }
    }

    private List calculateAlternateNumericSoundexKeys(String numVal, int caseType, List keys) {
        int intVal;
        if ((numVal = StringUtilities.trimToChars((String)numVal, (String)DIGITS)) == null) {
            return keys;
        }
        try {
            intVal = Integer.parseInt(numVal);
        }
        catch (NumberFormatException nfe) {
            return keys;
        }
        switch (caseType) {
            case 1: {
                keys.clear();
                this.reverseNumericValue(intVal, keys);
                break;
            }
            case 2: {
                keys.clear();
                this.addZeroToNumericValue(intVal, keys);
                break;
            }
            case 3: {
                keys.clear();
                this.increaseDecreaseNumericValue(intVal, keys);
            }
        }
        return keys;
    }

    private void reverseNumericValue(int intVal, List keys) {
        String val = String.valueOf(intVal);
        if (val == null) {
            return;
        }
        StringBuffer revVal = new StringBuffer();
        int cnt = val.length();
        if (cnt == 1) {
            return;
        }
        boolean zeroFound = true;
        for (int i = cnt - 1; i >= 0; --i) {
            if (val.charAt(i) == '0' & zeroFound) continue;
            revVal.append(val.charAt(i));
            zeroFound = false;
        }
        String revValStr = revVal.toString();
        if (!revValStr.equals(val)) {
            MiSoundexKey key = new MiSoundexKey();
            key.setFirstChar('0');
            try {
                key.setNumericValue(Integer.parseInt(revValStr));
            }
            catch (NumberFormatException e) {
                return;
            }
            keys.add(key);
        }
    }

    private void addZeroToNumericValue(int intVal, List keys) {
        String val = String.valueOf(intVal);
        StringBuffer newVal = new StringBuffer();
        newVal.append(val);
        newVal.append('0');
        MiSoundexKey key = null;
        try {
            key = new MiSoundexKey();
            key.setFirstChar('0');
            key.setNumericValue(Integer.parseInt(newVal.toString()));
            keys.add(key);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        newVal = null;
        newVal = new StringBuffer();
        newVal.append(val);
        newVal.insert(1, '0');
        if (keys.indexOf(newVal.toString()) == -1) {
            try {
                key = new MiSoundexKey();
                key.setFirstChar('0');
                key.setNumericValue(Integer.parseInt(newVal.toString()));
                keys.add(key);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void increaseDecreaseNumericValue(int intVal, List keys) {
        int i;
        int tmp = 0;
        MiSoundexKey key = null;
        if (intVal <= 0) {
            return;
        }
        for (i = 1; i <= 3; ++i) {
            tmp = intVal - i;
            if (tmp <= 0) continue;
            key = new MiSoundexKey();
            key.setFirstChar('0');
            key.setNumericValue(tmp);
            keys.add(key);
        }
        for (i = 1; i <= 3; ++i) {
            tmp = intVal + i;
            key = new MiSoundexKey();
            key.setFirstChar('0');
            key.setNumericValue(tmp);
            keys.add(key);
        }
    }

    static {
        FIRST_LETTER_EQUIVALENTS.putAll(CAN_EnglishSoundex.makeMap(A_EQUIVALENTS));
        FIRST_LETTER_EQUIVALENTS.putAll(CAN_EnglishSoundex.makeMap(E_EQUIVALENTS));
        FIRST_LETTER_EQUIVALENTS.putAll(CAN_EnglishSoundex.makeMap(I_EQUIVALENTS));
        FIRST_LETTER_EQUIVALENTS.putAll(CAN_EnglishSoundex.makeMap(O_EQUIVALENTS));
        FIRST_LETTER_EQUIVALENTS.putAll(CAN_EnglishSoundex.makeMap(U_EQUIVALENTS));
        FIRST_LETTER_EQUIVALENTS.putAll(CAN_EnglishSoundex.makeMap(C_EQUIVALENTS));
        ignoredWordList = new String[]{"DE", "DES", "DU", "LA", "LE", "LES", "THE"};
    }

    protected class RemoveWordResult {
        String retStr;
        int found;

        protected RemoveWordResult() {
        }
    }
}

