/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN;

import com.mapinfo.mapmarker.DictionaryUsagePreference;
import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.user.GeocodeConstraints;

public class CAN_GeocodeConstraints
extends GeocodeConstraints {
    public static final String KEY_MUST_MATCH_HOUSE_NUMBER = "KEY_MUST_MATCH_ADDRNUM";
    public static final String KEY_MUST_MATCH_STREET = "KEY_MUST_MATCH_STREET";
    public static final String KEY_MUST_MATCH_CITY = "KEY_MUST_MATCH_CITY";
    public static final String KEY_MUST_MATCH_PROVINCE = "KEY_MUST_MATCH_PROVINCE";
    public static final String KEY_MUST_MATCH_FSA = "KEY_MUST_MATCH_FSA";
    public static final String KEY_MUST_HAVE_LDU = "KEY_MUST_HAVE_LDU";
    private boolean m_mustHaveLDU;

    public CAN_GeocodeConstraints() {
        this(null);
    }

    public CAN_GeocodeConstraints(GeocodeConstraints constraints) {
        super((IGeocodeConstraints)constraints);
        if (constraints == null) {
            this.setDefaultValues();
        }
    }

    public void setDefaultValues() {
        this.init();
    }

    protected void init() {
        this.setGeocodeType(0);
        this.setClientCoordinateSystem("epsg:4326");
        this.setClientLocale("en_CA");
        this.setReturnCloseCandidatesOnly(false);
        this.setCornerOffset(7.0);
        this.setCornerOffsetUnits("m");
        this.setFallbackToGeographic(false);
        this.setFallbackToPostal(false);
        this.setMaxCandidates(1);
        this.setMaxRanges(0);
        this.setMaxRangeUnits(0);
        this.setMustMatchAddressNumber(false);
        this.setMustMatchArea1(false);
        this.setMustMatchArea3(false);
        this.setMustMatchInput(false);
        this.setMustMatchCountry(true);
        this.setStreetOffset(7.0);
        this.setStreetOffsetUnits("m");
        this.setMustMatchMainAddress(false);
        this.setMustMatchPostalCode(false);
        this.setDictionaryUsage(DictionaryUsagePreference.AD_AND_UD);
        this.setDictionarySearchOrder(null);
    }

    public boolean isMustMatchStreet() {
        return this.isMustMatchMainAddress();
    }

    public void setMustMatchStreet(boolean bMatch) {
        this.setMustMatchMainAddress(bMatch);
    }

    public boolean isMustMatchHouseNumber() {
        return this.isMustMatchAddressNumber();
    }

    public void setMustMatchHouseNumber(boolean bMatch) {
        this.setMustMatchAddressNumber(bMatch);
    }

    public boolean isMustMatchCity() {
        return this.isMustMatchArea3();
    }

    public void setMustMatchCity(boolean bMatch) {
        this.setMustMatchArea3(bMatch);
    }

    public boolean isMustMatchProvince() {
        return this.isMustMatchArea1();
    }

    public void setMustMatchProvince(boolean bMatch) {
        this.setMustMatchArea1(bMatch);
    }

    public boolean isMustMatchFSA() {
        return this.isMustMatchPostalCode();
    }

    public void setMustMatchFSA(boolean bMatch) {
        this.setMustMatchPostalCode(bMatch);
    }

    public void setMustHaveLDU(boolean flag) {
        this.m_mustHaveLDU = flag;
        super.setCustomString(KEY_MUST_HAVE_LDU, this.m_mustHaveLDU ? "true" : "false");
    }

    public boolean isMustHaveLDU() {
        return this.m_mustHaveLDU;
    }
}

