/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN;

import com.mapinfo.mapmarker.CAN.CAN_Range;
import com.mapinfo.mapmarker.CAN.CAN_StreetCandidateAddress;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_DataDictionary;
import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.CandidateRange;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalBrowseAddress;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;

public class CAN_InternalBrowseAddress
extends InternalBrowseAddress {
    public CAN_InternalBrowseAddress() {
        this(new CAN_StreetCandidateAddress());
    }

    public CAN_InternalBrowseAddress(CAN_StreetCandidateAddress address) {
        super((Address)address);
        this.setVendorCode(address.getVendorCode());
    }

    public boolean isAPCandidate() {
        return ((CAN_StreetCandidateAddress)this.getStreetCandidateAddress()).isAPCandidate();
    }

    public CAN_DataDictionary.DICTIONARY_TYPE getDictionaryType() {
        return ((CAN_StreetCandidateAddress)this.getStreetCandidateAddress()).getDictionaryType();
    }

    public void setStreetCandidateAddress(StreetCandidateAddress street) {
        if (street instanceof CAN_StreetCandidateAddress) {
            super.setStreetCandidateAddress(street);
        } else {
            super.setStreetCandidateAddress((StreetCandidateAddress)new CAN_StreetCandidateAddress((Address)street));
        }
    }

    public CandidateAddress toCandidateAddress(Address parsed, IConstraints constraints) {
        CandidateAddress cand = new CandidateAddress((Address)this);
        cand.setFormattedStreetAddress(this.getFormattedStreetAddress());
        cand.setNumberOfReturnableRanges(-1);
        if (this.fromUserDictionary()) {
            cand.setFromUserDictionary();
        }
        int segmentCount = this.getSegmentCount();
        for (int i = 0; i < segmentCount; ++i) {
            Segment segment = this.getSegmentAt(i);
            int leftRangeCount = segment.getRangeCount(0);
            if (leftRangeCount != 0) {
                for (int j = 0; j < leftRangeCount; ++j) {
                    CAN_Range leftRange = (CAN_Range)segment.getRangeAt(j, 0);
                    CandidateRange range = leftRange.toCandidateRange(null, 0);
                    this.copySegmentInfoToRange(range, segment, 0);
                    String LDU = leftRange.getLDU();
                    range.setPostalCode2(LDU);
                    cand.addCandidateRange(range);
                }
            } else {
                CandidateRange range = new CandidateRange();
                range.setLowAddress("");
                range.setHighAddress("");
                this.copySegmentInfoToRange(range, segment, 0);
                range.setLeftRightIndicator(0);
                cand.addCandidateRange(range);
            }
            int rightRangeCount = segment.getRangeCount(1);
            if (rightRangeCount != 0) {
                for (int j = 0; j < rightRangeCount; ++j) {
                    CAN_Range rightRange = (CAN_Range)segment.getRangeAt(j, 1);
                    CandidateRange range = rightRange.toCandidateRange(null, 1);
                    this.copySegmentInfoToRange(range, segment, 1);
                    String LDU = rightRange.getLDU();
                    range.setPostalCode2(LDU);
                    cand.addCandidateRange(range);
                }
                continue;
            }
            CandidateRange range = new CandidateRange();
            range.setLowAddress("");
            range.setHighAddress("");
            this.copySegmentInfoToRange(range, segment, 1);
            range.setLeftRightIndicator(1);
            cand.addCandidateRange(range);
        }
        cand.addKeyValueToAdditionalFields("StreetDataType", this.getVendorCode());
        return cand;
    }
}

