/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN;

import com.mapinfo.mapmarker.CAN.AlternateItem;
import com.mapinfo.mapmarker.CAN.CAN_CensusInfo;
import com.mapinfo.mapmarker.CAN.CAN_GeoInfoRecord;
import com.mapinfo.mapmarker.CAN.CAN_ParsedAddress;
import com.mapinfo.mapmarker.CAN.CAN_Range;
import com.mapinfo.mapmarker.CAN.CAN_RangeUnit;
import com.mapinfo.mapmarker.CAN.CAN_ScoringAddress;
import com.mapinfo.mapmarker.CAN.CAN_Segment;
import com.mapinfo.mapmarker.CAN.CAN_SegmentAttributeScorer;
import com.mapinfo.mapmarker.CAN.CAN_StreetCandidateAddress;
import com.mapinfo.mapmarker.CAN.MunicipalityRecord;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_DataDictionary;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_DataManager;
import com.mapinfo.mapmarker.CAN.parser.CAN_Directionals;
import com.mapinfo.mapmarker.CAN.parser.CAN_NewThoroughfareTypes;
import com.mapinfo.mapmarker.CAN.parser.CAN_UnitType;
import com.mapinfo.mapmarker.CAN.parser.CAN_UnitTypes;
import com.mapinfo.mapmarker.CAN.parser.SaintReplacer;
import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.CandidateRange;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.RangeUnit;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.core.IPOBoxHandler;
import com.mapinfo.mapmarker.user.IReverseGeocodeConstraints;
import com.mapinfo.mapmarker.user.ReverseGeocodeCandidateAddress;
import com.mapinfo.mapmarker.user.ReverseGeocodeLocation;
import com.mapinfo.mapmarker.utils.CoordConvertor;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.mapmarker.utils.MidevConversionUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.geometry.DirectPosition;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

public class CAN_InternalCandidateAddress
extends InternalCandidateAddress {
    private static final int SEGMENT_SIDE_UNKNOWN = -1;
    private boolean m_bSegmentSideDetermined;
    private boolean m_bPostalCodesScored;
    private boolean m_bAreaNamesScored;
    private boolean m_bAreaName3ScoreBasedOnAlternate;
    private boolean m_bInputHasUnit = true;
    private String m_qcPreTypeName = null;
    private String m_qcPostTypeName = null;
    private String m_unitType = null;
    private String m_unitValue = null;
    private String m_FSA = null;
    private String m_LDU = null;
    public static final double AREANAME3_THRESHOLD = 0.75;
    public static final double POSTALCODE1_THRESHOLD = 0.75;
    public static final double POSTALCODE2_THRESHOLD = 0.9;
    private boolean m_isInputEnglishPOBox;
    private boolean m_isInputFrenchPOBox;
    private String m_outputStationInfo;
    private boolean m_isFrenchGD;
    private String m_additionalRRNumber;
    private RangeMatch m_bestRangeMatch;
    private String m_outputAreaName3;
    private boolean m_isPlaceNameMatch;
    private boolean m_ignoreInputUnitType;
    private static final double PERFECT_SCORE = 1.0;
    private boolean m_bOverrodeReverseGeocodeSegmentSide = false;
    private boolean m_adjustS4;
    private double m_postDirectionalScore = 0.0;
    private boolean m_bAreaName3ScoreMuniAlternate = false;
    private boolean m_ignoreStation;
    public static final String FRENCH_PO_BOX = "FRENCH_PO_BOX";
    public static final String ENGLISH_PO_BOX = "ENGLISH_PO_BOX";

    public CAN_InternalCandidateAddress() {
        this(new CAN_StreetCandidateAddress());
    }

    public CAN_InternalCandidateAddress(CAN_StreetCandidateAddress addr) {
        super((Address)addr);
        this.setSegmentSide(-1);
        this.setClosestSegmentSide(-1);
        this.setPostDirectionalScore(addr.getPostDirectionalScore());
    }

    public boolean isAPCandidate() {
        return ((CAN_StreetCandidateAddress)this.getStreetCandidateAddress()).isAPCandidate();
    }

    public CAN_DataDictionary.DICTIONARY_TYPE getDictionaryType() {
        return ((CAN_StreetCandidateAddress)this.getStreetCandidateAddress()).getDictionaryType();
    }

    public CandidateAddress toCandidateAddress(Address input, IConstraints constraints) throws MapMarkerInternalException {
        boolean bPostTypeMatched;
        ParsedNumber num;
        boolean englishBox;
        String checkBox;
        boolean frenchDualAddress;
        int debugLevel = DebugLevel.getDebugLevel((int)1);
        CandidateAddress candidate = new CandidateAddress((Address)this);
        CAN_ParsedAddress canInput = (CAN_ParsedAddress)input;
        this.m_isInputEnglishPOBox = canInput.isEnglishPOBox();
        this.m_isInputFrenchPOBox = canInput.isFrenchPOBox();
        this.m_isFrenchGD = canInput.isFrenchGD();
        this.m_additionalRRNumber = canInput.getAdditionalRouteServiceNumber();
        boolean is_DualAddrCase = constraints.getHandler() instanceof IPOBoxHandler && ((IPOBoxHandler)constraints.getHandler()).isDualAddress();
        boolean POB_MatchInProgress = Boolean.valueOf(constraints.getCustomString("POBOX_MATCH_IN_PROGRESS", "false"));
        if (is_DualAddrCase && !POB_MatchInProgress) {
            this.m_ignoreStation = true;
        }
        boolean bl = frenchDualAddress = (checkBox = canInput.getAdditionalFieldForKey(FRENCH_PO_BOX)) != null && Boolean.valueOf(checkBox) != false && is_DualAddrCase && POB_MatchInProgress;
        if (this.isInputFrenchPOBox() || frenchDualAddress) {
            this.setMainAddress("CP");
            candidate.setMainAddress("CP");
        }
        boolean bl2 = englishBox = canInput.getAdditionalFieldForKey(ENGLISH_PO_BOX) != null && "true".equals(canInput.getAdditionalFieldForKey(ENGLISH_PO_BOX));
        if (POB_MatchInProgress && (is_DualAddrCase || frenchDualAddress || this.isInputEnglishPOBox() || this.isInputFrenchPOBox() || englishBox)) {
            if (this.getMatchedRangeNumber() >= 0) {
                candidate.addKeyValueToAdditionalFields("PO_BOX_VALIDATED", "");
            } else {
                candidate.addKeyValueToAdditionalFields("PO_BOX_GENERAL", "");
            }
        }
        if (this.isFrenchGD()) {
            this.setMainAddress("PR");
            candidate.setMainAddress("PR");
        }
        if (candidate.getAreaName3() != null) {
            candidate.setAreaName3(candidate.getAreaName3().toUpperCase());
        }
        if (candidate.getAddressNumber() != null) {
            if (!this.m_ignoreInputUnitType && this.m_bInputHasUnit && input.getUnitType() != null && input.getUnitType().length() != 0) {
                candidate.setUnitType(input.getUnitType());
                this.setUnitType(input.getUnitType());
            }
            if (this.m_bInputHasUnit && input.getUnitValue() != null && input.getUnitValue().length() != 0) {
                candidate.setUnitValue(input.getUnitValue());
                this.setUnitValue(input.getUnitValue());
            }
        } else {
            candidate.setGenericField4(null);
        }
        if (this.getAreaName1() != null && this.getAreaName1().equalsIgnoreCase("QC") && this.getOriginalName() != null && CAN_Directionals.isDirectional(candidate.getMainAddress())) {
            StringWithTokens toks = new StringWithTokens(this.getOriginalName());
            String last = toks.getLastToken();
            if (toks.size() > 1 && CAN_Directionals.isDirectional(last)) {
                candidate.setMainAddress(last);
            }
        }
        candidate.setFormattedStreetAddress(this.getFormattedStreetAddress(candidate.getGenericField4()));
        candidate.setFormattedLocationAddress(this.getFormattedLocationAddress());
        candidate.setSourceStreetID(this.getStreetOffset());
        if (this.fromUserDictionary()) {
            candidate.setFromUserDictionary();
        }
        candidate.setConfiguredDictionaryNumber(this.getDictionaryPriority() + 1);
        if (this.isCloseMatch()) {
            candidate.setCloseMatch();
        }
        if (this.getCountryScore() == 1.0) {
            candidate.setCountryMatched();
        }
        if (!(num = new ParsedNumber(input.getAddressNumber())).isEmpty()) {
            if (this.getAddressNumberScore() == 1.0) {
                candidate.setAddressNumberMatched();
            }
        } else {
            candidate.setAddressNumberMatched();
        }
        candidate.setStreetPrefixAndSuffixMatched();
        if (!this.fieldExists(input.getMainAddress()) || this.getMainAddressScore() == 1.0) {
            candidate.setStreetNameMatched();
        }
        if (!this.fieldExists(input.getPreDirectional())) {
            candidate.setPreDirectionalMatched();
        }
        if (!this.fieldExists(input.getPostDirectional())) {
            candidate.setPostDirectionalMatched();
        }
        if (this.getPreDirectionalScore() == 1.0) {
            candidate.setPreDirectionalMatched();
        }
        if (this.getPostDirectionalScore() == 1.0) {
            candidate.setPostDirectionalMatched();
        }
        boolean bPreTypeMatched = !this.fieldExists(input.getPreThoroughfareType()) || this.getPreThoroughfareTypeScore() == 1.0;
        boolean bl3 = bPostTypeMatched = !this.fieldExists(input.getPostThoroughfareType()) || this.getPostThoroughfareTypeScore() == 1.0;
        if (bPreTypeMatched && bPostTypeMatched) {
            candidate.setThoroughfareTypeMatched();
        }
        if (!this.fieldExists(input.getPostCode1()) || !canInput.fixedPostCode1() && this.getPostCode1Score() == 1.0) {
            candidate.setPostalCode1Matched();
        }
        if (!this.fieldExists(input.getPostCode2()) || !canInput.fixedPostCode2() && this.getPostCode2Score() == 1.0) {
            candidate.setPostalCode2Matched();
        }
        if (!this.fieldExists(input.getAreaName1()) || this.getAreaName1Score() == 1.0) {
            candidate.setAreaName1Matched();
        }
        if (!this.fieldExists(input.getAreaName2()) || this.getAreaName2Score() == 1.0) {
            candidate.setAreaName2Matched();
        }
        if (!this.fieldExists(input.getAreaName3()) || this.getAreaName3Score() == 1.0) {
            candidate.setAreaName3Matched();
        }
        if (!this.fieldExists(input.getAreaName4()) || this.getAreaName4Score() == 1.0) {
            candidate.setAreaName4Matched();
        }
        if (!this.fieldExists(input.getPlaceName()) || this.getPlaceNameScore() == 1.0) {
            candidate.setPlaceNameMatched();
        }
        if (this.fieldExists(input.getPlaceName()) && !this.fieldExists(candidate.getPlaceName())) {
            candidate.setPlaceName(input.getPlaceName());
        }
        this.setGeocodedPoint(candidate, debugLevel, constraints, this.loadResourceBundleForLocale(constraints.getClientLocale()));
        int maxRanges = constraints.getMaxRanges();
        candidate.setNumberOfReturnableRanges(maxRanges);
        Segment segment = this.getSegment();
        if (maxRanges != 0) {
            CandidateRange candRange;
            Range range;
            int i;
            int numLeftRanges = segment.getRangeCount(0);
            int numRightRanges = segment.getRangeCount(1);
            for (i = 0; i < numLeftRanges; ++i) {
                range = segment.getRangeAt(i, 0);
                candRange = ((CAN_Range)range).toCandidateRange(num, 1, constraints, segment);
                candidate.addCandidateRange(candRange);
            }
            for (i = 0; i < numRightRanges; ++i) {
                range = segment.getRangeAt(i, 1);
                candRange = ((CAN_Range)range).toCandidateRange(num, 2, constraints, segment);
                candidate.addCandidateRange(candRange);
            }
        }
        this.m_FSA = input.getPostCode1();
        this.m_LDU = input.getPostCode2();
        String geores = this.buildPrecisionCode(candidate);
        if (!geores.startsWith("B") && this.isAreaName3ScoreBasedOnAlternate() && !this.m_bAreaName3ScoreMuniAlternate && this.getAreaName3Score() == 1.0) {
            StringBuffer sb = new StringBuffer(geores);
            sb.setCharAt(7, '-');
            geores = sb.toString();
        }
        candidate.addKeyValueToAdditionalFields("RESULT_CODE", geores);
        this.assignOutputCensusFields((Address)candidate);
        this.fixOutputTypes((Address)candidate);
        this.populateSegmentId((Address)candidate);
        if (candidate.getPrecisionCode().startsWith("S4") && StringUtilities.isEmpty((String)candidate.getAddressNumber()) && this.getInputNumber() != null && !StringUtilities.isEmpty((String)this.getInputNumber().getCombinedAddressNumber())) {
            this.m_adjustS4 = true;
            candidate.setFormattedStreetAddress(this.getFormattedStreetAddress());
            candidate.setAddressNumber(this.getInputNumber().getCombinedAddressNumber());
        }
        candidate.addKeyValueToAdditionalFields("StreetDataType", this.getVendorCode());
        candidate.addKeyValueToAdditionalFields("INPUT_MATCH_SCORE", String.valueOf(this.inputMatchScore));
        if (this.getDictionaryType() == CAN_DataDictionary.DICTIONARY_TYPE.MLD_POINTS) {
            this.assignPbkey((Address)candidate);
        }
        return candidate;
    }

    static String removeOverlap(String initialString, String overlapString) {
        if (StringUtilities.isEmpty((String)overlapString) || StringUtilities.isEmpty((String)initialString)) {
            return initialString;
        }
        for (int i = 0; i < initialString.length(); ++i) {
            int regionLength = initialString.length() - i;
            if (!overlapString.regionMatches(true, 0, initialString, i, regionLength) || i != 0 && Character.isLetter(initialString.charAt(i - 1)) || overlapString.length() != regionLength && Character.isLetter(overlapString.charAt(regionLength))) continue;
            return initialString.substring(0, i).trim();
        }
        return initialString;
    }

    public boolean isPerfectMatchExcludingCity() {
        if (this.getCombinedAddressScore() == 1.0 && this.getCombinedAdditionalFieldScore() == 1.0) {
            return true;
        }
        return this.getCombinedAddressScore() == 1.0 && this.getPostCode1Score() == 1.0 && this.getAreaName1Score() == 1.0 && this.getAreaName2Score() == 1.0 && this.getAreaName3Score() > 0.75 && this.getAreaName4Score() == 1.0;
    }

    public String getOriginalName() {
        return ((CAN_StreetCandidateAddress)this.getStreetCandidateAddress()).getOriginalName();
    }

    public String getFormattedStreetAddress() {
        return this.getFormattedStreetAddress(true, null);
    }

    protected String getFormattedStreetAddress(String genericField4) {
        return this.getFormattedStreetAddress(true, genericField4);
    }

    public String getFormattedStreetIgnoreOriginalName() {
        return this.getFormattedStreetAddress(false, null);
    }

    private String getFormattedStreetAddress(boolean bUseOriginalName, String genericField4) {
        CAN_Range bestRange;
        String originalName = bUseOriginalName ? this.getOriginalName() : null;
        StringBuffer str = new StringBuffer();
        boolean isQC = false;
        if (this.getAreaName1() != null && this.getAreaName1().equalsIgnoreCase("QC")) {
            isQC = true;
        }
        boolean bUseDashUnitFormat = false;
        if (this.getUnitType() != null && this.getUnitValue() != null && this.getUnitType().equals("#") && genericField4 == null) {
            bUseDashUnitFormat = true;
        }
        String temp = this.getAddressNumber();
        if (this.m_adjustS4) {
            temp = this.getInputNumber().getCombinedAddressNumber();
        }
        if (temp != null && !this.isPOBox()) {
            if (bUseDashUnitFormat) {
                str.append(this.getUnitValue());
                str.append('-');
            }
            str.append(temp);
            str.append(' ');
        }
        if (originalName != null) {
            str.append(originalName);
            str.append(' ');
        } else {
            String tmp;
            boolean done;
            CAN_NewThoroughfareTypes.KeyInfo info;
            String ttype;
            String tempStreet = this.getMainAddress();
            String tempreDirectional = this.getPreDirectional();
            if (tempreDirectional != null) {
                String expanded = CAN_Directionals.getFullName(tempreDirectional);
                if (expanded != null) {
                    str.append(expanded);
                } else {
                    str.append(tempreDirectional);
                }
                str.append(' ');
            }
            if ((ttype = this.getPreThoroughfareType()) != null && ttype.length() != 0 && (info = CAN_NewThoroughfareTypes.lookupByPreferredName(ttype)) != null) {
                done = false;
                if (isQC) {
                    tmp = info.getProperTypeName();
                    this.m_qcPreTypeName = CAN_NewThoroughfareTypes.getSpecialQCTypeProperName(tmp);
                    if (this.m_qcPreTypeName != null) {
                        str.append(this.m_qcPreTypeName);
                        str.append(' ');
                        done = true;
                    }
                }
                if (!done) {
                    str.append(info.getProperTypeName());
                    str.append(' ');
                }
            }
            if (tempStreet != null) {
                str.append(SaintReplacer.replace(tempStreet));
                str.append(' ');
                if (this.isPOBox()) {
                    temp = this.getAddressNumber();
                    if (this.m_adjustS4) {
                        temp = this.getInputNumber().getCombinedAddressNumber();
                    }
                    if (temp != null) {
                        str.append(temp);
                        str.append(' ');
                    }
                }
            }
            if ((ttype = this.getPostThoroughfareType()) != null && ttype.length() != 0 && (info = CAN_NewThoroughfareTypes.lookupByPreferredName(ttype)) != null) {
                done = false;
                if (isQC) {
                    tmp = info.getProperTypeName();
                    this.m_qcPostTypeName = CAN_NewThoroughfareTypes.getSpecialQCTypeProperName(tmp);
                    if (this.m_qcPostTypeName != null) {
                        str.append(this.m_qcPostTypeName);
                        str.append(' ');
                        done = true;
                    }
                }
                if (!done) {
                    str.append(info.getProperTypeName());
                    str.append(' ');
                }
            }
            if ((temp = this.getPostDirectional()) != null) {
                str.append(temp);
                str.append(' ');
            }
        }
        if (!bUseDashUnitFormat) {
            String unitType = this.getUnitType();
            String unitVal = this.getUnitValue();
            if (!StringUtilities.isEmpty((String)unitType) && "FL".equals(unitType) && ("MAIN".equals(unitVal.trim()) || "GROUND".equals(unitVal.trim()))) {
                str.append(unitVal);
                str.append(' ');
                str.append(unitType);
                str.append(' ');
            } else {
                if (unitType != null) {
                    str.append(unitType);
                    str.append(' ');
                }
                if (unitVal != null) {
                    str.append(unitVal);
                    str.append(' ');
                }
            }
            if (genericField4 != null) {
                str.append(genericField4);
                str.append(' ');
            }
        }
        if (!StringUtilities.isEmpty((String)this.getOutputStationInfo()) && !this.m_ignoreStation) {
            str.append(this.getOutputStationInfo());
            str.append(' ');
        }
        if (this.getAdditionalRRNumber() != null && this.getAdditionalRRNumber().length() > 0 && (bestRange = (CAN_Range)this.getRange()) != null) {
            String type = ((CAN_Range)this.getRange()).getRouteServiceType();
            String num = ((CAN_Range)this.getRange()).getRouteServiceNumber();
            if (num != null && num.length() > 0 && num.equals(this.getAdditionalRRNumber())) {
                str.append(type);
                str.append(' ');
                str.append(num);
                str.append(' ');
            }
        }
        return str.toString().trim();
    }

    public String getFormattedLocationAddress() {
        int len;
        StringBuffer str = new StringBuffer();
        String tmp = this.getAreaName3();
        if (tmp != null) {
            str.append(tmp);
            str.append(' ');
        }
        if ((tmp = this.getAreaName1()) != null) {
            str.append(tmp);
            str.append(' ');
        }
        if ((tmp = this.getPostCode1()) != null) {
            str.append(tmp);
            str.append(' ');
        }
        if ((tmp = this.getPostCode2()) != null) {
            str.append(tmp);
            str.append(' ');
        }
        if ((len = str.length()) != 0) {
            str.deleteCharAt(len - 1);
        }
        return str.toString();
    }

    public String getAreaName1() {
        Segment segment;
        String areaName1 = super.getAreaName1();
        if (areaName1 == null && (segment = this.getSegment()) != null) {
            String left = segment.getLeftAreaName1();
            if (left != null) {
                return left;
            }
            return segment.getRightAreaName1();
        }
        return areaName1;
    }

    public String getAreaName3() {
        if (this.m_outputAreaName3 != null) {
            return this.m_outputAreaName3;
        }
        return super.getAreaName3();
    }

    private Range getRange() {
        Range rng = this.getSegment().getRangeAt(this.getMatchedRangeNumber(), this.getSegmentSide());
        if (rng == null && this.getClosestRangeNumber() >= 0) {
            rng = this.getSegment().getRangeAt(this.getClosestRangeNumber(), this.getClosestSegmentSide());
        }
        return rng;
    }

    public String getPostCode2() {
        Range rng = this.getRange();
        if (rng != null) {
            return ((CAN_Range)rng).getLDU();
        }
        return null;
    }

    private void determineClosestSegmentSideWithoutHouse(ScoringAddress parsedAddress) {
        CAN_Segment segment = (CAN_Segment)this.getSegment();
        if (segment.getLeftGeoInfoRecord() != null && segment.getLeftGeoInfoRecord() == segment.getRightGeoInfoRecord() && segment.getLeftPostCode1() != null && segment.getLeftPostCode1().equals(segment.getRightPostCode1())) {
            this.setClosestSegmentSide(0);
            this.setSegmentSideDetermined(true);
        }
        if (segment.getLeftAreaName3() == null && segment.getRightAreaName3() != null) {
            this.setClosestSegmentSide(1);
            this.setSegmentSideDetermined(true);
        } else if (segment.getLeftAreaName3() != null && segment.getRightAreaName3() == null) {
            this.setClosestSegmentSide(0);
            this.setSegmentSideDetermined(true);
        }
        if (this.isSegmentSideDetermined()) {
            return;
        }
        this.setClosestSegmentSide(0);
        CAN_SegmentAttributeScorer leftScorer = new CAN_SegmentAttributeScorer(this.getPostCode1(), this.getPostCode2(), this.getAreaName1(), this.getAreaName3(), this.getAlternateAreaName3Collection());
        leftScorer.score(parsedAddress);
        if (leftScorer.getPostalCode1Score() == 1.0 && leftScorer.getAreaName3Score() == 1.0 && !leftScorer.isAreaName3ScoreBasedOnAlternate()) {
            this.setSegmentSideDetermined(true);
            this.assignPostalCodeScores(leftScorer);
            this.assignAreaNameScores(leftScorer);
            return;
        }
        this.setClosestSegmentSide(1);
        CAN_SegmentAttributeScorer rightScorer = new CAN_SegmentAttributeScorer(this.getPostCode1(), this.getPostCode2(), this.getAreaName1(), this.getAreaName3(), this.getAlternateAreaName3Collection());
        rightScorer.score(parsedAddress);
        if (rightScorer.getPostalCode1Score() == 1.0 && rightScorer.getAreaName3Score() == 1.0 && !rightScorer.isAreaName3ScoreBasedOnAlternate()) {
            this.setSegmentSideDetermined(true);
            this.assignPostalCodeScores(rightScorer);
            this.assignAreaNameScores(rightScorer);
            return;
        }
        boolean bUseLeft = false;
        boolean bUseRight = false;
        this.setClosestSegmentSide(-1);
        if (leftScorer.getAreaName3Score() == rightScorer.getAreaName3Score()) {
            if (!leftScorer.isAreaName3ScoreBasedOnAlternate() && rightScorer.isAreaName3ScoreBasedOnAlternate()) {
                bUseLeft = true;
            } else if (leftScorer.isAreaName3ScoreBasedOnAlternate() && !rightScorer.isAreaName3ScoreBasedOnAlternate()) {
                bUseRight = true;
            } else if (leftScorer.getPostalCode1Score() >= rightScorer.getPostalCode1Score()) {
                bUseLeft = true;
            } else {
                bUseRight = true;
            }
        } else if (leftScorer.getAreaName3Score() > rightScorer.getAreaName3Score()) {
            bUseLeft = true;
        } else {
            bUseRight = true;
        }
        this.setSegmentSideDetermined(true);
        if (bUseLeft) {
            this.setClosestSegmentSide(0);
            this.assignPostalCodeScores(leftScorer);
            this.assignAreaNameScores(leftScorer);
        }
        if (bUseRight) {
            this.setClosestSegmentSide(1);
            this.assignPostalCodeScores(rightScorer);
            this.assignAreaNameScores(rightScorer);
        }
    }

    protected void setSegmentSideDetermined(boolean flag) {
        this.m_bSegmentSideDetermined = flag;
    }

    protected boolean isSegmentSideDetermined() {
        if (!(this.m_bSegmentSideDetermined || this.getSegmentSide() == -1 && this.getClosestSegmentSide() == -1)) {
            return true;
        }
        return this.m_bSegmentSideDetermined;
    }

    protected void setPostalCodesScored(boolean flag) {
        this.m_bPostalCodesScored = flag;
    }

    protected boolean arePostalCodesScored() {
        return this.m_bPostalCodesScored;
    }

    protected void setAreaNamesScored(boolean flag) {
        this.m_bAreaNamesScored = flag;
    }

    protected boolean areAreaNamesScored() {
        return this.m_bAreaNamesScored;
    }

    public void scoreAreaNames(ScoringAddress scoringAddress) {
        if (!this.isSegmentSideDetermined()) {
            this.determineClosestSegmentSideWithoutHouse(scoringAddress);
        }
        if (!this.areAreaNamesScored()) {
            CAN_SegmentAttributeScorer scorer = new CAN_SegmentAttributeScorer(this.getPostCode1(), this.getPostCode2(), this.getAreaName1(), this.getAreaName3(), this.getAlternateAreaName3Collection());
            scorer.scoreAreaNames(scoringAddress);
            this.assignAreaNameScores(scorer);
        }
    }

    public void scorePostalInformation(ScoringAddress scoringAddress) {
        if (!this.isSegmentSideDetermined()) {
            this.determineClosestSegmentSideWithoutHouse(scoringAddress);
        }
        if (!this.arePostalCodesScored()) {
            CAN_SegmentAttributeScorer scorer = new CAN_SegmentAttributeScorer(this.getPostCode1(), this.getPostCode2(), this.getAreaName1(), this.getAreaName3(), this.getAlternateAreaName3Collection());
            scorer.scorePostalCodes(scoringAddress);
            this.assignPostalCodeScores(scorer);
        }
    }

    protected void setAreaName3ScoreBasedOnAlternate(boolean flag) {
        this.m_bAreaName3ScoreBasedOnAlternate = flag;
    }

    public boolean isAreaName3ScoreBasedOnAlternate() {
        return this.m_bAreaName3ScoreBasedOnAlternate;
    }

    protected Collection<String> getAlternateAreaName3Collection() {
        CAN_GeoInfoRecord geoInfo = null;
        if (this.getSegmentSide() == 0) {
            geoInfo = (CAN_GeoInfoRecord)((CAN_Segment)this.getSegment()).getLeftGeoInfoRecord();
        } else if (this.getSegmentSide() == 1) {
            geoInfo = (CAN_GeoInfoRecord)((CAN_Segment)this.getSegment()).getRightGeoInfoRecord();
        } else if (this.getClosestSegmentSide() == 0) {
            geoInfo = (CAN_GeoInfoRecord)((CAN_Segment)this.getSegment()).getLeftGeoInfoRecord();
        } else if (this.getClosestSegmentSide() == 1) {
            geoInfo = (CAN_GeoInfoRecord)((CAN_Segment)this.getSegment()).getRightGeoInfoRecord();
        }
        if (geoInfo != null) {
            return geoInfo.getAlternateAreaName3s();
        }
        return Collections.emptyList();
    }

    private void assignAreaNameScores(CAN_SegmentAttributeScorer scorer) {
        this.setAreaName1Score(scorer.getAreaName1Score());
        this.setAreaName3Score(scorer.getAreaName3Score());
        this.setAreaName3ScoreBasedOnAlternate(scorer.isAreaName3ScoreBasedOnAlternate());
        this.setAreaNamesScored(true);
    }

    private void assignPostalCodeScores(CAN_SegmentAttributeScorer scorer) {
        this.setPostCode1Score(scorer.getPostalCode1Score());
        this.setPostCode2Score(scorer.getPostalCode2Score());
        this.setPostalCodesScored(true);
    }

    public void setPostDirectionalScore(double score) {
        this.m_postDirectionalScore = score;
    }

    public double getPostDirectionalScore() {
        return this.m_postDirectionalScore;
    }

    public void computeScores(ScoringAddress scoringAddress, String charsToIgnore) {
        if (!(scoringAddress.getUnitType() != null && scoringAddress.getUnitType().length() != 0 || scoringAddress.getUnitValue() != null && scoringAddress.getUnitValue().length() != 0)) {
            this.m_bInputHasUnit = false;
        }
        super.computeScores(scoringAddress, charsToIgnore);
        this.m_outputStationInfo = ((CAN_ScoringAddress)scoringAddress).getStationInformation();
        if (((CAN_ScoringAddress)scoringAddress).isSingleLine() && (this.getAreaName3Score() < 1.0 || this.isAreaName3ScoreBasedOnAlternate())) {
            this.m_outputStationInfo = CAN_InternalCandidateAddress.removeOverlap(this.getOutputStationInfo(), this.getAreaName3());
            this.fixSingleLineUnitType((CAN_ScoringAddress)scoringAddress);
        }
        if (((CAN_ScoringAddress)scoringAddress).isSingleLine() && !StringUtilities.isEmpty((String)scoringAddress.getPostDirectional()) && this.getPostDirectionalScore() != 1.0 && this.getAreaName3Score() != 1.0) {
            String inputDirectional = scoringAddress.getPostDirectional();
            String expandedDirectional = CAN_Directionals.getFullName(inputDirectional);
            String candidateCity = this.getAreaName3();
            if (candidateCity != null && (candidateCity.startsWith(expandedDirectional) || candidateCity.startsWith(inputDirectional + ' '))) {
                String originalCity = scoringAddress.getAreaName3();
                scoringAddress.setAreaName3(expandedDirectional + ' ' + originalCity);
                double updatedCityScore = scoringAddress.scoreAreaName3(this.getAreaName3());
                if (updatedCityScore > this.getAreaName3Score()) {
                    this.setAreaName3ScoreBasedOnAlternate(false);
                    this.setAreaName3Score(updatedCityScore);
                    this.setPostDirectionalScore(1.0);
                }
                scoringAddress.setAreaName3(originalCity);
            }
        }
    }

    private void fixSingleLineUnitType(CAN_ScoringAddress scoringAddress) {
        int spaceIdx;
        String firstWord;
        CAN_UnitType unitTypeFromArea3;
        if (StringUtilities.isEmpty((String)this.getAreaName3())) {
            return;
        }
        String canUnitType = this.getUnitType();
        String inputUnitVal = scoringAddress.getUnitValue();
        String inputUnitType = scoringAddress.getUnitType();
        if (StringUtilities.isEmpty((String)inputUnitVal) && !StringUtilities.isEmpty((String)inputUnitType) && StringUtilities.isEmpty((String)canUnitType) && (unitTypeFromArea3 = CAN_UnitTypes.getUnitType(firstWord = (spaceIdx = this.getAreaName3().indexOf(32)) > 0 ? this.getAreaName3().substring(0, spaceIdx) : this.getAreaName3())) != null && inputUnitType.equals(unitTypeFromArea3.getAbbreviation())) {
            this.m_ignoreInputUnitType = true;
        }
    }

    public double getPreDirectionalScore() {
        return this.getStreetCandidateAddress().getPreDirectionalScore();
    }

    public void findBestRange(ScoringAddress parsedAddress) {
        ParsedNumber pn = parsedAddress.getParsedAddressNumber();
        boolean ruralMatch = this.checkForRuralBaseRange((CAN_ScoringAddress)parsedAddress);
        if (ruralMatch) {
            if (pn != null && !pn.isEmpty()) {
                this.setCntAddressNumberFieldsMatched(0);
            }
        } else {
            this.chooseBestRange((CAN_ScoringAddress)parsedAddress);
        }
        int cnt = this.getCntAddressNumberFieldsMatched();
        if (pn != null && pn.getAddressSuffix() != null && cnt > 0) {
            this.setCntAddressNumberFieldsMatched(++cnt);
        }
    }

    private void chooseBestRangeByPlaceName(CAN_ScoringAddress scoringAddress) {
        if (StringUtilities.isEmpty((String)scoringAddress.getPlaceName())) {
            return;
        }
        Segment segment = this.getSegment();
        if (segment == null) {
            return;
        }
        this.m_bestRangeMatch = null;
        this.chooseBestRangeByPlaceName(scoringAddress, 0);
        this.chooseBestRangeByPlaceName(scoringAddress, 1);
        if (this.m_bestRangeMatch != null && this.m_bestRangeMatch.getPlaceNameScore() >= 0.76) {
            this.m_bestRangeMatch.transferAsBestRange();
            this.m_isPlaceNameMatch = true;
        } else {
            this.m_bestRangeMatch = null;
        }
    }

    private void chooseBestRangeByPlaceName(CAN_ScoringAddress scoringAddress, int side) {
        Segment segment = this.getSegment();
        int rangeCount = segment.getRangeCount(side);
        for (int i = 0; i < rangeCount; ++i) {
            CAN_Range range = (CAN_Range)segment.getRangeAt(i, side);
            double bestPlaceScore = 0.0;
            if (!StringUtilities.isEmpty((String)range.getPlaceName())) {
                bestPlaceScore = scoringAddress.scorePlaceName(range.getPlaceName());
            }
            int bestUnit = -1;
            int unitCount = range.getRangeUnitCount();
            for (int j = 0; j < unitCount; ++j) {
                double unitPlaceScore;
                CAN_RangeUnit unit = (CAN_RangeUnit)range.getRangeUnitAt(j);
                if (StringUtilities.isEmpty((String)unit.getPlaceName()) || !((unitPlaceScore = scoringAddress.scorePlaceName(unit.getPlaceName())) > bestPlaceScore)) continue;
                bestPlaceScore = unitPlaceScore;
                bestUnit = j;
            }
            if (bestUnit >= 0) {
                range.setMatchingRangeUnit(bestUnit);
            }
            RangeMatch match = new RangeMatch(range, side, i, 0, scoringAddress);
            if (this.m_bestRangeMatch != null && !match.isBetterThan(this.m_bestRangeMatch)) continue;
            this.m_bestRangeMatch = match;
        }
    }

    public boolean isPlaceNameMatch() {
        return this.m_isPlaceNameMatch;
    }

    private boolean checkForRuralBaseRange(CAN_ScoringAddress parsedAddress) {
        CAN_Segment seg = (CAN_Segment)this.getSegment();
        if (seg.getRangeCount(0) == 1 && seg.getRangeCount(1) == 0) {
            CAN_Range range = (CAN_Range)seg.getRangeAt(0, 0);
            if (range.getParsedFrom().isPureNumeric() && range.getParsedTo().isPureNumeric() && range.getParsedFrom().getAddressNumber() == 0L && range.getParsedTo().getAddressNumber() == 0L) {
                RangeMatch rMatch = new RangeMatch(range, 0, 0, 1, parsedAddress);
                rMatch.transferAsBestRange();
                return true;
            }
        } else if (seg.getRangeCount(0) == 2 && seg.getRangeCount(1) == 0) {
            CAN_Range baseRange = null;
            for (int i = 0; i < 2; ++i) {
                CAN_Range range = (CAN_Range)seg.getRangeAt(i, 0);
                if (!range.getParsedFrom().isPureNumeric() || !range.getParsedTo().isPureNumeric() || range.getParsedFrom().getAddressNumber() != 0L || range.getParsedTo().getAddressNumber() != 0L || i != 0) continue;
                baseRange = range;
            }
            if (baseRange != null) {
                RangeMatch rMatch = new RangeMatch(baseRange, 0, 0, 1, parsedAddress);
                rMatch.transferAsBestRange();
                return true;
            }
        }
        return false;
    }

    private void chooseBestRange(CAN_ScoringAddress scoringAddress) {
        Segment segment = this.getSegment();
        if (segment == null) {
            return;
        }
        this.checkSegmentSide(scoringAddress, 0);
        this.checkSegmentSide(scoringAddress, 1);
        if (this.m_bestRangeMatch != null) {
            this.m_bestRangeMatch.transferAsBestRange();
        } else {
            this.chooseBestRangeByPlaceName(scoringAddress);
            if (!this.getRangeMatchedFlag()) {
                super.findClosestRange();
            }
        }
    }

    private void checkSegmentSide(CAN_ScoringAddress scoringAddress, int side) {
        if (super.isInputNumberNull()) {
            return;
        }
        Segment segment = this.getSegment();
        int rangeCount = segment.getRangeCount(side);
        for (int i = 0; i < rangeCount; ++i) {
            CAN_Range range = (CAN_Range)segment.getRangeAt(i, side);
            if (range.getOddEven() != 0 && range.getOddEven() != scoringAddress.getParsedAddressNumber().isRangeOddEvenBoth()) continue;
            int numberFieldsMatched = range.isNumberInRange(scoringAddress.getParsedAddressNumber());
            if (numberFieldsMatched > 0) {
                range.findMatchingRangeUnit(scoringAddress.getParsedUnitValue(), scoringAddress.getUnitType(), scoringAddress.getPostCode2());
                RangeMatch match = new RangeMatch(range, side, i, numberFieldsMatched, scoringAddress);
                if (this.m_bestRangeMatch != null && !match.isBetterThan(this.m_bestRangeMatch)) continue;
                this.m_bestRangeMatch = match;
                continue;
            }
            range.computeOffsetFromRange(scoringAddress.getParsedAddressNumber());
        }
    }

    public String getAddressNumber() {
        if (this.isPlaceNameMatch()) {
            return this.getRange().getParsedFrom().getCombinedAddressNumber();
        }
        return super.getAddressNumber();
    }

    public void setUnitType(String unitType) {
        this.m_unitType = unitType;
    }

    public String getUnitType() {
        return this.m_unitType;
    }

    public void setUnitValue(String unitValue) {
        this.m_unitValue = unitValue;
    }

    public String getUnitValue() {
        return this.m_unitValue;
    }

    protected double getHouseNumberPercentage(int segmentSide, int rangeNumber, ParsedNumber targetHouse) {
        int rangeCount = this.getSegment().getRangeCount(segmentSide);
        if (rangeCount == 1) {
            return super.getHouseNumberPercentage(segmentSide, rangeNumber, targetHouse);
        }
        List ranges = this.getSegment().getRanges(segmentSide);
        Range r = (Range)ranges.get(0);
        int oddEven = r.getOddEven();
        int divisionFactor = oddEven != 0 ? 2 : 1;
        ParsedNumber lowestHouseNumber = ((Range)ranges.get(0)).getParsedRange().getLowEndpoint();
        ParsedNumber highestHouseNumber = ((Range)ranges.get(0)).getParsedRange().getHighEndpoint();
        for (int i = 0; i < rangeCount; ++i) {
            ParsedNumber currentHigh;
            ParsedNumber currentLow;
            r = (Range)ranges.get(i);
            if (divisionFactor != 1 && r.getOddEven() != oddEven) {
                divisionFactor = 1;
            }
            if (lowestHouseNumber.compareTo((Object)(currentLow = r.getParsedRange().getLowEndpoint())) > 0) {
                lowestHouseNumber = currentLow;
            }
            if (highestHouseNumber.compareTo((Object)(currentHigh = r.getParsedRange().getHighEndpoint())) >= 0) continue;
            highestHouseNumber = currentHigh;
        }
        long totalAddresses = highestHouseNumber.computeDifference(lowestHouseNumber, divisionFactor);
        long targetAddressPosition = targetHouse.computeDifference(lowestHouseNumber, divisionFactor);
        return this.calculateSegmentPercentage(totalAddresses, targetAddressPosition);
    }

    public String buildPrecisionCode(CandidateAddress cand) {
        boolean poboxValidated;
        StringBuffer tempGeoResult = new StringBuffer();
        if (cand.getLocationPrecision() == 1) {
            tempGeoResult.append("S5");
        } else if (cand.getLocationPrecision() == 2) {
            tempGeoResult.append("S4");
        } else if (cand.getLocationPrecision() == 3) {
            tempGeoResult.append("S1");
        } else if (cand.getLocationPrecision() == 5) {
            tempGeoResult.append("S3");
        } else if (cand.getLocationPrecision() == 0) {
            tempGeoResult.append("S0");
        } else if (cand.getLocationPrecision() == 17) {
            tempGeoResult.append("S7");
        } else if (cand.getLocationPrecision() == 16) {
            tempGeoResult.append("S8");
        } else if (cand.getLocationPrecision() == 18) {
            tempGeoResult.append("SC");
        }
        if (cand.doesAddressNumberMatch()) {
            tempGeoResult.append("H");
        } else {
            tempGeoResult.append("-");
        }
        if (cand.doesPreDirectionalMatch()) {
            tempGeoResult.append('P');
        } else {
            tempGeoResult.append('-');
        }
        if (cand.doesStreetNameMatch()) {
            tempGeoResult.append('N');
        } else {
            tempGeoResult.append('-');
        }
        if (cand.doesThoroughfareTypeMatch()) {
            tempGeoResult.append('T');
        } else {
            tempGeoResult.append('-');
        }
        if (cand.doesPostDirectionalMatch()) {
            tempGeoResult.append('S');
        } else {
            tempGeoResult.append('-');
        }
        if (cand.doesAreaName3Match()) {
            tempGeoResult.append("C");
        } else {
            tempGeoResult.append("-");
        }
        if (this.m_FSA == null && this.m_LDU == null && cand.getPostCode1() != null && cand.getPostCode2() != null || this.m_FSA != null && this.m_LDU == null && cand.doesPostalCode1Match() && cand.getPostCode2() != null || this.m_FSA != null && this.m_LDU != null && cand.doesPostalCode1Match() && cand.doesPostalCode2Match()) {
            tempGeoResult.append("Z");
        } else {
            tempGeoResult.append("-");
        }
        if (cand.fromUserDictionary()) {
            tempGeoResult.append("U");
        } else {
            tempGeoResult.append("A");
        }
        boolean poboxGeneral = cand.getAdditionalFieldForKey("PO_BOX_GENERAL") != null;
        boolean bl = poboxValidated = cand.getAdditionalFieldForKey("PO_BOX_VALIDATED") != null;
        if (poboxGeneral || poboxValidated) {
            cand.getAdditionalFields().put("LEGACY_RESULT_CODE", tempGeoResult.toString());
            if (poboxGeneral) {
                cand.getAdditionalFields().remove("PO_BOX_GENERAL");
                return "B1";
            }
            cand.getAdditionalFields().remove("PO_BOX_VALIDATED");
            return "B2";
        }
        return tempGeoResult.toString();
    }

    public boolean isInputFrenchPOBox() {
        return this.m_isInputFrenchPOBox;
    }

    public boolean isFrenchGD() {
        return this.m_isFrenchGD;
    }

    public boolean isInputEnglishPOBox() {
        return this.m_isInputEnglishPOBox;
    }

    public boolean isPOBox() {
        if (this.m_ignoreStation) {
            return false;
        }
        return this.isInputFrenchPOBox() || this.isInputEnglishPOBox() || ((CAN_StreetCandidateAddress)this.getStreetCandidateAddress()).isPOBox();
    }

    private String getOutputStationInfo() {
        return this.m_outputStationInfo;
    }

    public String getAdditionalRRNumber() {
        return this.m_additionalRRNumber;
    }

    private void setOutputAreaName3(String outputAreaName3) {
        this.m_outputAreaName3 = outputAreaName3;
    }

    public void setGeocodedPoint(CandidateAddress addr, int debugLevel, IConstraints constraints, ResourceBundle bundle) {
        super.setGeocodedPoint(addr, debugLevel, constraints, bundle);
        if (addr.getLocationPrecision() == 0) {
            try {
                ((CAN_DataManager)constraints.getHandler().getDataManager()).addPostInfoTo(addr, constraints, this.getDictionaryPriority());
                if (addr.getLocationPrecision() != 0) {
                    addr.setLocation(CoordConvertor.transformPointFromWGS84((CoordSys)constraints.getClientCoordinateSystemObject(), (DirectPosition)addr.getLocationPoint()));
                    addr.setCoordSysString(MidevConversionUtils.getSRSname((CoordSys)constraints.getClientCoordinateSystemObject()));
                }
            }
            catch (DataAccessException dataAccessException) {
                // empty catch block
            }
        }
    }

    private void fixOutputTypes(Address output) {
        CAN_NewThoroughfareTypes.KeyInfo info;
        if (this.m_qcPreTypeName != null) {
            output.setPreThoroughfareType(this.m_qcPreTypeName);
        } else if (!StringUtilities.isEmpty((String)output.getPreThoroughfareType()) && (info = CAN_NewThoroughfareTypes.lookupByPreferredName(output.getPreThoroughfareType())) != null) {
            output.setPreThoroughfareType(CAN_NewThoroughfareTypes.getPreTypeForOutput(info.getProperTypeName()));
        }
        if (this.m_qcPostTypeName != null) {
            output.setPostThoroughfareType(this.m_qcPostTypeName);
        } else if (!StringUtilities.isEmpty((String)output.getPostThoroughfareType()) && (info = CAN_NewThoroughfareTypes.lookupByPreferredName(output.getPostThoroughfareType())) != null) {
            output.setPostThoroughfareType(info.getProperTypeName());
        }
    }

    void assignOutputCensusFields(Address output) {
        CAN_Segment cs = (CAN_Segment)this.getSegment();
        CAN_CensusInfo census = this.getSegmentSide() == 0 ? cs.getLeftCensusInfo() : (this.getSegmentSide() == 1 ? cs.getRightCensusInfo() : (this.getClosestSegmentSide() == 0 ? cs.getLeftCensusInfo() : (this.getClosestSegmentSide() == 1 ? cs.getRightCensusInfo() : CAN_CensusInfo.makeShared(cs.getLeftCensusInfo(), cs.getRightCensusInfo()))));
        if (census != null) {
            census.output(output);
        }
    }

    public ReverseGeocodeCandidateAddress toCandidateAddress(ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) throws MapMarkerInternalException {
        MunicipalityRecord muniRec;
        ReverseGeocodeCandidateAddress candidate = super.toCandidateAddress(location, constraints);
        Range range = this.getRange();
        if (range != null && range instanceof CAN_Range && (muniRec = ((CAN_Range)range).getMunicipalityRecord()) != null) {
            this.m_outputAreaName3 = muniRec.getMunicipalityWithAccents();
            if (this.m_outputAreaName3 == null) {
                this.m_outputAreaName3 = muniRec.getMunicipality();
            }
            if (this.m_outputAreaName3 != null) {
                candidate.setAreaName3(this.m_outputAreaName3);
                candidate.setFormattedLocationAddress(this.getFormattedLocationAddress());
            }
        }
        this.fixOutputTypes((Address)candidate);
        this.assignOutputCensusFields((Address)candidate);
        if (this.getDictionaryType() == CAN_DataDictionary.DICTIONARY_TYPE.MLD_POINTS) {
            this.assignPbkey((Address)candidate);
        }
        return candidate;
    }

    public void matchAddressNumber(ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) {
        super.matchAddressNumber(location, constraints);
        if (this.getAddressNumber() == null) {
            if (this.getSegmentSide() == 0) {
                if (StringUtilities.isEmpty((String)this.getSegment().getLeftAreaName3()) && ((CAN_Segment)this.getSegment()).getLeftGeoInfoRecord() == null) {
                    this.setSegmentSide(-1);
                    this.setClosestSegmentSide(1);
                    this.m_bOverrodeReverseGeocodeSegmentSide = true;
                }
            } else if (StringUtilities.isEmpty((String)this.getSegment().getRightAreaName3()) && ((CAN_Segment)this.getSegment()).getRightGeoInfoRecord() == null) {
                this.setSegmentSide(-1);
                this.setClosestSegmentSide(0);
                this.m_bOverrodeReverseGeocodeSegmentSide = true;
            }
        }
    }

    public boolean isFromCorrectStreetSide(ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) {
        if (this.m_bOverrodeReverseGeocodeSegmentSide) {
            return false;
        }
        return super.isFromCorrectStreetSide(location, constraints);
    }

    public double getRawMainAddressScore() {
        return ((CAN_StreetCandidateAddress)this.getStreetCandidateAddress()).getRawMainAddressScore();
    }

    void assignPbkey(Address address) {
        Segment segment = this.getSegment();
        int numLeftRanges = segment.getRangeCount(0);
        String pbkey = "";
        CAN_Range range = (CAN_Range)this.getRange();
        if (range == null) {
            return;
        }
        CAN_RangeUnit unit = null;
        if (this.m_bInputHasUnit && range.hasMatchingRangeUnit()) {
            unit = (CAN_RangeUnit)range.getRangeUnitAt(range.getMatchingRangeUnit());
        }
        pbkey = unit != null && unit.getPbkey() != null ? unit.getPbkey() : range.getPbkey();
        address.getAdditionalFields().put("PBKEY", pbkey);
    }

    private class RangeMatch {
        private static final double MUNI_TO_SEGMENT_DELTA = 0.1;
        private static final double AREANAME2_THRESHOLD_SCORE = 0.8;
        private static final double AREANAME2_SCORE_DELTA = 0.25;
        private static final int MAX_FIELDS_MATCHED = 7;
        private CAN_Range m_range;
        private int m_segmentSide;
        private int m_rangeNumber;
        private int m_numberFieldsMatched;
        private long m_numberOfAddresses;
        private boolean m_bFSAMatched;
        private boolean m_bAreaName1Matched;
        private boolean m_bNoInputAreaName3;
        private double m_areaName3Score;
        private boolean m_bAreaName3ScoreBasedOnMuniRecord;
        private boolean m_bAreaName3MuniScoreBasedOnAlternate;
        private boolean m_bAreaName3GeoInfoScoreBasedOnAlternate;
        private boolean m_bAreaName3ScoreBasedOnAreaName2;
        private boolean m_bRouteServiceTypeMatched;
        private boolean m_bRouteServiceNumberMatched;
        private boolean m_bLDUMatched;
        private boolean m_bNoInputPlaceName;
        private double m_placeNameScore;
        private String m_outputAreaName3;
        private int m_fieldsMatched;
        private int m_fieldsIgnored;
        private boolean m_matchedUnitFromLDU;
        private String m_rangeMatchUnitType;
        private String m_rangeMatchUnitValue;

        private RangeMatch(CAN_Range range, int segmentSide, int rangeNumber, int numberFieldsMatched, CAN_ScoringAddress scoringAddress) {
            this.m_range = range;
            this.m_segmentSide = segmentSide;
            this.m_rangeNumber = rangeNumber;
            this.m_numberFieldsMatched = numberFieldsMatched;
            this.m_numberOfAddresses = this.m_range.computeAddressesInRange();
            this.evalateSegmentFields(scoringAddress);
            this.evaluateRangeFields(scoringAddress);
            this.scoreAreaName3(scoringAddress);
            this.checkLDU(scoringAddress);
            this.scorePlaceName(scoringAddress);
            this.countMatchedFields();
            this.determineMatchedUnitFromLDU(range, scoringAddress);
        }

        private void determineMatchedUnitFromLDU(CAN_Range range, CAN_ScoringAddress scoringAddress) {
            if (StringUtilities.isEmpty((String)scoringAddress.getUnitValue()) && StringUtilities.isEmpty((String)scoringAddress.getUnitType()) && range.hasMatchingRangeUnit()) {
                this.m_matchedUnitFromLDU = true;
                this.m_rangeMatchUnitType = "#";
                this.m_rangeMatchUnitValue = range.getUnitValue(new ParsedNumber(""));
            }
        }

        private boolean isBetterThan(RangeMatch that) {
            if (this.m_fieldsMatched > that.m_fieldsMatched) {
                return true;
            }
            if (this.m_fieldsMatched == that.m_fieldsMatched && this.m_fieldsMatched == 7) {
                if (this.m_range.hasMatchingRangeUnit() && !that.m_range.hasMatchingRangeUnit()) {
                    return true;
                }
                if (this.m_bAreaName3ScoreBasedOnMuniRecord && !that.m_bAreaName3ScoreBasedOnMuniRecord) {
                    return true;
                }
                if (this.m_bAreaName3ScoreBasedOnMuniRecord && that.m_bAreaName3ScoreBasedOnMuniRecord && !this.m_bAreaName3MuniScoreBasedOnAlternate && that.m_bAreaName3MuniScoreBasedOnAlternate) {
                    return true;
                }
                if (!this.m_bAreaName3ScoreBasedOnMuniRecord && !that.m_bAreaName3ScoreBasedOnMuniRecord && !this.m_bAreaName3GeoInfoScoreBasedOnAlternate && that.m_bAreaName3GeoInfoScoreBasedOnAlternate) {
                    return true;
                }
                if (!this.m_bAreaName3ScoreBasedOnAreaName2 && that.m_bAreaName3ScoreBasedOnAreaName2) {
                    return true;
                }
                if (this.m_numberFieldsMatched > that.m_numberFieldsMatched) {
                    return true;
                }
                if (this.m_numberOfAddresses < that.m_numberOfAddresses) {
                    return true;
                }
                if (CAN_InternalCandidateAddress.this.getSegment().isHouseSegment() && !StringUtilities.isEmpty((String)this.m_range.getPlaceName()) && StringUtilities.isEmpty((String)that.m_range.getPlaceName())) {
                    return true;
                }
            } else if (this.m_fieldsMatched == that.m_fieldsMatched) {
                if (this.m_bFSAMatched && !that.m_bFSAMatched) {
                    return true;
                }
                if (!this.m_bNoInputAreaName3 && this.m_areaName3Score > that.m_areaName3Score) {
                    return true;
                }
                if (this.m_range.hasMatchingRangeUnit() && !that.m_range.hasMatchingRangeUnit()) {
                    return true;
                }
                if (!this.m_bNoInputPlaceName && this.m_placeNameScore > that.m_placeNameScore) {
                    return true;
                }
                if (this.m_numberFieldsMatched > that.m_numberFieldsMatched) {
                    return true;
                }
                if (this.m_numberOfAddresses < that.m_numberOfAddresses) {
                    return true;
                }
                if (CAN_InternalCandidateAddress.this.getSegment().isHouseSegment() && !StringUtilities.isEmpty((String)this.m_range.getPlaceName()) && StringUtilities.isEmpty((String)that.m_range.getPlaceName())) {
                    return true;
                }
            }
            return false;
        }

        private void transferAsBestRange() {
            RangeUnit unit;
            CAN_InternalCandidateAddress.this.setSegmentSide(this.m_segmentSide);
            CAN_InternalCandidateAddress.this.setMatchedRangeNumber(this.m_rangeNumber);
            CAN_InternalCandidateAddress.this.setCntAddressNumberFieldsMatched(this.m_numberFieldsMatched);
            CAN_InternalCandidateAddress.this.setAreaName3Score(this.m_areaName3Score);
            CAN_InternalCandidateAddress.this.setAreaNamesScored(true);
            CAN_InternalCandidateAddress.this.setOutputAreaName3(this.m_outputAreaName3);
            if (this.m_bAreaName1Matched) {
                CAN_InternalCandidateAddress.this.setAreaName1Score(1.0);
            }
            if (this.m_bFSAMatched) {
                CAN_InternalCandidateAddress.this.setPostCode1Score(1.0);
            }
            if (this.m_bLDUMatched) {
                CAN_InternalCandidateAddress.this.setPostCode2Score(1.0);
                CAN_InternalCandidateAddress.this.setPostalCodesScored(true);
            }
            CAN_InternalCandidateAddress.this.setPlaceNameScore(this.m_placeNameScore);
            if (this.m_bAreaName3ScoreBasedOnMuniRecord && this.m_bAreaName3MuniScoreBasedOnAlternate) {
                CAN_InternalCandidateAddress.this.setAreaName3ScoreBasedOnAlternate(true);
            } else if (this.m_bAreaName3ScoreBasedOnAreaName2) {
                CAN_InternalCandidateAddress.this.setAreaName3ScoreBasedOnAlternate(true);
            } else if (!this.m_bAreaName3ScoreBasedOnMuniRecord && this.m_bAreaName3GeoInfoScoreBasedOnAlternate) {
                CAN_InternalCandidateAddress.this.setAreaName3ScoreBasedOnAlternate(true);
            }
            CAN_InternalCandidateAddress.this.m_bAreaName3ScoreMuniAlternate = this.m_bAreaName3MuniScoreBasedOnAlternate;
            if (this.m_matchedUnitFromLDU && this.m_range.hasMatchingRangeUnit() && (unit = this.m_range.getRangeUnitAt(this.m_range.getMatchingRangeUnit())) != null && unit.getNumberOfUnits() == 1L) {
                CAN_InternalCandidateAddress.this.setUnitType(this.m_rangeMatchUnitType);
                CAN_InternalCandidateAddress.this.setUnitValue(this.m_rangeMatchUnitValue);
            }
        }

        private void evalateSegmentFields(CAN_ScoringAddress scoringAddress) {
            if (CAN_InternalCandidateAddress.this.fieldExists(scoringAddress.getPostCode1())) {
                String FSA = this.m_segmentSide == 0 ? CAN_InternalCandidateAddress.this.getSegment().getLeftPostCode1() : CAN_InternalCandidateAddress.this.getSegment().getRightPostCode1();
                this.m_bFSAMatched = scoringAddress.getPostCode1().equals(FSA);
            } else {
                ++this.m_fieldsIgnored;
            }
            if (CAN_InternalCandidateAddress.this.fieldExists(scoringAddress.getAreaName1())) {
                String areaName1 = this.m_segmentSide == 0 ? CAN_InternalCandidateAddress.this.getSegment().getLeftAreaName1() : CAN_InternalCandidateAddress.this.getSegment().getRightAreaName1();
                this.m_bAreaName1Matched = scoringAddress.getAreaName1().equals(areaName1);
            } else {
                ++this.m_fieldsIgnored;
            }
        }

        private void evaluateRangeFields(CAN_ScoringAddress scoringAddress) {
            if (CAN_InternalCandidateAddress.this.fieldExists(scoringAddress.getRouteServiceType())) {
                this.m_bRouteServiceTypeMatched = scoringAddress.getRouteServiceType().equals(this.m_range.getRouteServiceType());
            } else {
                ++this.m_fieldsIgnored;
            }
            if (CAN_InternalCandidateAddress.this.fieldExists(scoringAddress.getRouteServiceNumber())) {
                this.m_bRouteServiceNumberMatched = scoringAddress.getRouteServiceNumber().equals(this.m_range.getRouteServiceNumber());
            } else {
                ++this.m_fieldsIgnored;
            }
        }

        private void scoreAreaName3(CAN_ScoringAddress scoringAddress) {
            if (CAN_InternalCandidateAddress.this.fieldExists(scoringAddress.getAreaName3())) {
                double bestScore;
                double muniScore = this.getAreaName3ScoreForMuniRecord(scoringAddress);
                if (muniScore == 1.0) {
                    this.m_areaName3Score = muniScore;
                    this.m_bAreaName3ScoreBasedOnMuniRecord = true;
                    return;
                }
                double geoInfoScore = this.getAreaName3ScoreForGeoInfo(scoringAddress);
                if (geoInfoScore == 1.0) {
                    this.m_areaName3Score = geoInfoScore;
                    return;
                }
                double areaName3Score = scoringAddress.scoreAreaName3(this.m_segmentSide == 0 ? CAN_InternalCandidateAddress.this.getSegment().getLeftAreaName3() : CAN_InternalCandidateAddress.this.getSegment().getRightAreaName3());
                if (areaName3Score == 1.0) {
                    this.m_areaName3Score = areaName3Score;
                    return;
                }
                double areaName2Score = 0.0;
                if (this.m_bFSAMatched || scoringAddress.getPostCode1() == null) {
                    String areaName2 = this.m_segmentSide == 0 ? CAN_InternalCandidateAddress.this.getSegment().getLeftAreaName2() : CAN_InternalCandidateAddress.this.getSegment().getRightAreaName2();
                    areaName2Score = scoringAddress.scoreAreaName3(areaName2);
                    if (areaName2Score == 1.0) {
                        this.m_areaName3Score = areaName2Score;
                        this.m_bAreaName3ScoreBasedOnAreaName2 = true;
                        return;
                    }
                    if (areaName2Score < 0.8) {
                        areaName2Score = 0.0;
                    }
                }
                if ((bestScore = this.max(muniScore, this.max(geoInfoScore, this.max(areaName3Score, areaName2Score)))) == muniScore) {
                    this.m_areaName3Score = muniScore;
                    this.m_bAreaName3ScoreBasedOnMuniRecord = true;
                    return;
                }
                if (bestScore == areaName3Score && areaName3Score - muniScore > 0.1) {
                    this.m_areaName3Score = areaName3Score;
                    return;
                }
                if (bestScore == geoInfoScore && geoInfoScore - muniScore > 0.1) {
                    this.m_areaName3Score = geoInfoScore;
                    return;
                }
                if (bestScore == areaName2Score && areaName2Score - muniScore > 0.25) {
                    this.m_areaName3Score = areaName2Score;
                    this.m_bAreaName3ScoreBasedOnAreaName2 = true;
                    return;
                }
                this.m_areaName3Score = muniScore;
                this.m_bAreaName3ScoreBasedOnMuniRecord = true;
            } else {
                this.m_bNoInputAreaName3 = true;
                ++this.m_fieldsIgnored;
            }
        }

        private double getAreaName3ScoreForMuniRecord(CAN_ScoringAddress scoringAddress) {
            double bestScore = 0.0;
            MunicipalityRecord muniRecord = this.m_range.getMunicipalityRecord();
            if (muniRecord != null) {
                Collection alternates;
                this.m_outputAreaName3 = muniRecord.getMunicipalityWithAccents();
                if (this.m_outputAreaName3 == null) {
                    this.m_outputAreaName3 = muniRecord.getMunicipality();
                }
                if ((bestScore = scoringAddress.scoreAreaName3(muniRecord.getMunicipality())) < 1.0 && (alternates = muniRecord.getAlternates()) != null) {
                    Iterator altsIterator = alternates.iterator();
                    while (bestScore < 1.0 && altsIterator.hasNext()) {
                        AlternateItem alt = (AlternateItem)altsIterator.next();
                        if (alt.getFSA() != null && !alt.getFSA().equals(scoringAddress.getPostCode1())) continue;
                        double tempScore = scoringAddress.scoreAreaName3(alt.getAlternate());
                        if (tempScore > bestScore) {
                            bestScore = tempScore;
                            this.m_bAreaName3MuniScoreBasedOnAlternate = true;
                        }
                        if (bestScore != 1.0 || !alt.isAlternateValid()) continue;
                        this.m_outputAreaName3 = alt.getAlternate();
                        this.m_bAreaName3MuniScoreBasedOnAlternate = true;
                    }
                }
            }
            return bestScore;
        }

        private double getAreaName3ScoreForGeoInfo(CAN_ScoringAddress scoringAddress) {
            Collection<String> alternates;
            double bestScore = 0.0;
            CAN_GeoInfoRecord geoInfo = (CAN_GeoInfoRecord)(this.m_segmentSide == 0 ? ((CAN_Segment)CAN_InternalCandidateAddress.this.getSegment()).getLeftGeoInfoRecord() : ((CAN_Segment)CAN_InternalCandidateAddress.this.getSegment()).getRightGeoInfoRecord());
            if (geoInfo != null && (bestScore = scoringAddress.scoreAreaName3(geoInfo.getAreaName3())) < 1.0 && (alternates = geoInfo.getAlternateAreaName3s()) != null) {
                Iterator<String> altsIterator = alternates.iterator();
                while (bestScore < 1.0 && altsIterator.hasNext()) {
                    double tempScore = scoringAddress.scoreAreaName3(altsIterator.next());
                    if (!(tempScore > bestScore)) continue;
                    this.m_bAreaName3GeoInfoScoreBasedOnAlternate = true;
                    bestScore = tempScore;
                }
            }
            return bestScore;
        }

        private void checkLDU(CAN_ScoringAddress scoringAddress) {
            if (!this.m_bFSAMatched || !CAN_InternalCandidateAddress.this.fieldExists(scoringAddress.getPostCode1())) {
                ++this.m_fieldsIgnored;
                return;
            }
            if (CAN_InternalCandidateAddress.this.fieldExists(scoringAddress.getPostCode2())) {
                this.m_bLDUMatched = scoringAddress.getPostCode2().equals(this.m_range.getRangeLDU());
                if (!this.m_bLDUMatched && this.m_range.hasMatchingRangeUnit()) {
                    this.m_bLDUMatched = scoringAddress.getPostCode2().equals(this.m_range.getLDU());
                }
            } else {
                ++this.m_fieldsIgnored;
            }
        }

        private void scorePlaceName(CAN_ScoringAddress scoringAddress) {
            if (CAN_InternalCandidateAddress.this.fieldExists(scoringAddress.getPlaceName())) {
                this.m_placeNameScore = scoringAddress.scorePlaceName(this.m_range.getPlaceName());
            } else {
                ++this.m_fieldsIgnored;
                this.m_bNoInputPlaceName = true;
            }
        }

        private void countMatchedFields() {
            if (this.m_bAreaName1Matched) {
                ++this.m_fieldsMatched;
                if (this.m_areaName3Score == 1.0) {
                    ++this.m_fieldsMatched;
                }
            }
            if (this.m_bFSAMatched) {
                ++this.m_fieldsMatched;
                if (this.m_bLDUMatched) {
                    ++this.m_fieldsMatched;
                }
            }
            if (this.m_placeNameScore == 1.0) {
                ++this.m_fieldsMatched;
            }
            if (this.m_bRouteServiceTypeMatched) {
                ++this.m_fieldsMatched;
                if (this.m_bRouteServiceNumberMatched) {
                    ++this.m_fieldsMatched;
                }
            }
            this.m_fieldsMatched += this.m_fieldsIgnored;
        }

        private double max(double d1, double d2) {
            if (d1 >= d2) {
                return d1;
            }
            return d2;
        }

        public double getPlaceNameScore() {
            return this.m_placeNameScore;
        }
    }
}

