/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN;

import com.mapinfo.mapmarker.CAN.CAN_InternalCandidateAddress;
import com.mapinfo.mapmarker.CAN.CAN_InternalMatchPreferences;
import com.mapinfo.mapmarker.CAN.CAN_ScoringAddress;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.FieldScores;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.InternalMatcherConstants;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.core.matcher.CoreMatcher;
import com.mapinfo.mapmarker.core.matcher.CoreMatcherHandler;
import com.mapinfo.mapmarker.core.matcher.IMatchPreferences;
import com.mapinfo.mapmarker.core.matcher.IMatcherHandler;
import com.mapinfo.mapmarker.core.matcher.MatcherException;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CAN_MatcherHandler
implements IMatcherHandler {
    public static final double PLACE_NAME_CUTOFF = 0.76;
    public static final String NO_GEOSACS = "NO_GEOSACS";
    public static final String DOFRENCHVER = "DOFRENCHVER";
    private static final double UNMATCHED_TYPE_MAIN_ADDRESS_THRESHOLD = 0.9;
    private static final double UNMATCHED_TYPE_MAIN_ADDRESS_LOW_THRESHOLD = 0.85;
    private CoreMatcherHandler m_coreHandler = new CoreMatcherHandler();
    private static final Set m_routeServiceTypes;

    public void scoreCandidate(InternalCandidateAddress candidate, ScoringAddress scoringAddress, InternalMatcherConstants constants) {
        double score = 0.0;
        double typeDelta = 0.0;
        candidate.computeScores(scoringAddress, constants.getCharsToIgnore());
        FieldScores matchedConstants = constants.getMatched();
        FieldScores blankConstants = constants.getBlank();
        score = scoringAddress.getParsedAddressNumber() != null ? (score += candidate.getAddressNumberScore() * matchedConstants.getAddressNumber()) : (score += candidate.getAddressNumberScore() * blankConstants.getAddressNumber());
        score = this.fieldExists(scoringAddress.getMainAddress()) || this.fieldExists(candidate.getMainAddress()) ? (score += matchedConstants.getMainAddress() * candidate.getMainAddressScore()) : (score += blankConstants.getMainAddress() * candidate.getMainAddressScore());
        if (this.fieldExists(scoringAddress.getPreThoroughfareType()) || this.fieldExists(candidate.getPreThoroughfareType())) {
            score += matchedConstants.getPreThoroughfareType() * candidate.getPreThoroughfareTypeScore();
            if (!this.fieldExists(scoringAddress.getPreThoroughfareType())) {
                typeDelta += matchedConstants.getPreThoroughfareType() - blankConstants.getPreThoroughfareType();
            }
        } else {
            score += blankConstants.getPreThoroughfareType() * candidate.getPreThoroughfareTypeScore();
        }
        if (this.fieldExists(scoringAddress.getPostThoroughfareType()) || this.fieldExists(candidate.getPostThoroughfareType())) {
            score += matchedConstants.getPostThoroughfareType() * candidate.getPostThoroughfareTypeScore();
            if (!this.fieldExists(scoringAddress.getPostThoroughfareType())) {
                typeDelta += matchedConstants.getPostThoroughfareType() - blankConstants.getPostThoroughfareType();
            }
        } else {
            score += blankConstants.getPostThoroughfareType() * candidate.getPostThoroughfareTypeScore();
        }
        score = this.fieldExists(scoringAddress.getPreDirectional()) || this.fieldExists(candidate.getPreDirectional()) ? (score += matchedConstants.getPreDirectional() * candidate.getPreDirectionalScore()) : (score += blankConstants.getPreDirectional() * candidate.getPreDirectionalScore());
        score = this.fieldExists(scoringAddress.getPostDirectional()) || this.fieldExists(candidate.getPostDirectional()) ? (score += matchedConstants.getPostDirectional() * candidate.getPostDirectionalScore()) : (score += blankConstants.getPostDirectional() * candidate.getPostDirectionalScore());
        if (((CAN_InternalCandidateAddress)candidate).isPlaceNameMatch() && StringUtilities.isEmpty((String)scoringAddress.getMainAddress())) {
            candidate.setCombinedAddressScore(1.0);
        } else {
            candidate.setCombinedAddressScore(Math.min(score / (this.m_coreHandler.getMaximumAddressScore() + typeDelta), 1.0));
        }
        score = 0.0;
        score = this.fieldExists(scoringAddress.getPostCode1()) ? (score += matchedConstants.getPostalCode1() * candidate.getPostCode1Score()) : (score += blankConstants.getPostalCode1() * candidate.getPostCode1Score());
        score = this.fieldExists(scoringAddress.getAreaName1()) ? (score += matchedConstants.getAreaName1() * candidate.getAreaName1Score()) : (score += blankConstants.getAreaName1() * candidate.getAreaName1Score());
        score = this.fieldExists(scoringAddress.getAreaName3()) ? (score += matchedConstants.getAreaName3() * candidate.getAreaName3Score()) : (score += blankConstants.getAreaName3() * candidate.getAreaName3Score());
        candidate.setCombinedAdditionalFieldScore(score / this.m_coreHandler.getMaximumAdditionalFieldScore());
        candidate.buildInputMatchScore((Address)scoringAddress, matchedConstants);
    }

    public void computeMaximumAddressScore(Address parsedAddress, InternalMatcherConstants constants) {
        double maximumAddressScore = 0.0;
        FieldScores matchedConstants = constants.getMatched();
        FieldScores blankConstants = constants.getBlank();
        this.m_coreHandler.computeMaximumAddressScore(parsedAddress, constants);
        maximumAddressScore = this.fieldExists(parsedAddress.getAddressNumber()) ? (maximumAddressScore += matchedConstants.getAddressNumber()) : (maximumAddressScore += blankConstants.getAddressNumber());
        maximumAddressScore = this.fieldExists(parsedAddress.getPreThoroughfareType()) ? (maximumAddressScore += matchedConstants.getPreThoroughfareType()) : (maximumAddressScore += blankConstants.getPreThoroughfareType());
        maximumAddressScore = this.fieldExists(parsedAddress.getMainAddress()) ? (maximumAddressScore += matchedConstants.getMainAddress()) : (maximumAddressScore += blankConstants.getMainAddress());
        maximumAddressScore = this.fieldExists(parsedAddress.getPostThoroughfareType()) ? (maximumAddressScore += matchedConstants.getPostThoroughfareType()) : (maximumAddressScore += blankConstants.getPostThoroughfareType());
        maximumAddressScore = this.fieldExists(parsedAddress.getPreDirectional()) ? (maximumAddressScore += matchedConstants.getPreDirectional()) : (maximumAddressScore += blankConstants.getPreDirectional());
        maximumAddressScore = this.fieldExists(parsedAddress.getPostDirectional()) ? (maximumAddressScore += matchedConstants.getPostDirectional()) : (maximumAddressScore += blankConstants.getPostDirectional());
        this.m_coreHandler.setMaximumAddressScore(maximumAddressScore);
    }

    public void decideCloseMatch(IMatchPreferences preferences, InternalCandidateAddress candidate, InternalMatcherConstants constants, ScoringAddress scoringAddress) throws MatcherException {
        boolean bInputRouteService;
        boolean bCandidateRouteService;
        if (((CAN_InternalMatchPreferences)preferences).isMustHaveLDU() && candidate.getPostCode2() == null) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (!((CAN_InternalCandidateAddress)candidate).isPOBox() && candidate.isPointHouseCandidate(null) && StringUtilities.isEmpty((String)scoringAddress.getAddressNumber()) && !StringUtilities.isEmpty((String)candidate.getAddressNumber()) && !candidate.isHouseNumberFromPlaceMatch()) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        boolean bPreDirMatched = StringUtilities.isEmpty((String)scoringAddress.getPreDirectional()) || candidate.getPreDirectionalScore() >= 0.99;
        boolean bPreTypeMatched = StringUtilities.isEmpty((String)scoringAddress.getPreThoroughfareType()) || candidate.getPreThoroughfareTypeScore() >= 0.99;
        boolean bPostTypeMatched = StringUtilities.isEmpty((String)scoringAddress.getPostThoroughfareType()) || candidate.getPostThoroughfareTypeScore() >= 0.99;
        boolean bPostDirMatched = StringUtilities.isEmpty((String)scoringAddress.getPostDirectional()) || candidate.getPostDirectionalScore() >= 0.99;
        int totalMisMatches = 0;
        if (!bPreDirMatched) {
            ++totalMisMatches;
        }
        if (!bPreTypeMatched) {
            ++totalMisMatches;
        }
        if (!bPostTypeMatched) {
            ++totalMisMatches;
        }
        if (!bPostDirMatched) {
            ++totalMisMatches;
        }
        if (totalMisMatches >= 2) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (((CAN_InternalMatchPreferences)preferences).getRequirePreDirectionalToMatch() && candidate.getPreDirectionalScore() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchPostalCode1() && candidate.getPostCode1Score() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchStreetNameFields() && (candidate.getMainAddressScore() != 1.0 || candidate.getPreThoroughfareTypeScore() != 1.0 || candidate.getPostThoroughfareTypeScore() != 1.0)) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if ((preferences.getExactMatchAddressNumber() || ((CAN_InternalCandidateAddress)candidate).isPOBox()) && candidate.getAddressNumberScore() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchAreaName1() && candidate.getAreaName1Score() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchAreaName3() && candidate.getAreaName3Score() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        CAN_InternalCandidateAddress canCandidate = (CAN_InternalCandidateAddress)candidate;
        if (!StringUtilities.isEmpty((String)scoringAddress.getMainAddress()) && candidate.getCombinedAddressScore() < constants.getCloseMatchCutOff()) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (StringUtilities.isEmpty((String)scoringAddress.getMainAddress()) && !canCandidate.isPlaceNameMatch()) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (candidate.getPreThoroughfareTypeScore() != 1.0 && (bCandidateRouteService = m_routeServiceTypes.contains(candidate.getPreThoroughfareType())) != (bInputRouteService = m_routeServiceTypes.contains(scoringAddress.getPreThoroughfareType()))) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (((CAN_ScoringAddress)scoringAddress).isRemovedStartEndWordforRetry() && (candidate.getMainAddressScore() != 1.0 || candidate.getMainAddressScore() == 1.0 && (scoringAddress.getPostThoroughfareType() != null && candidate.getPostThoroughfareTypeScore() != 1.0 || scoringAddress.getPreThoroughfareType() != null && candidate.getPreThoroughfareTypeScore() != 1.0))) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (candidate.getMainAddressScore() != 1.0 && (scoringAddress.getPostThoroughfareType() != null && candidate.getPostThoroughfareTypeScore() < 0.99 || scoringAddress.getPreThoroughfareType() != null && candidate.getPreThoroughfareTypeScore() < 0.99)) {
            if (((CAN_InternalMatchPreferences)preferences).isStrictFirstPass()) {
                candidate.setCloseMatchFlag(false);
                return;
            }
            boolean bHasMatchingLDUAndVeryGoodLastLine = this.hasMatchingLDUAndVeryGoodLastLine(scoringAddress, candidate);
            if (!bHasMatchingLDUAndVeryGoodLastLine && candidate.getMainAddressScore() < 0.9) {
                candidate.setCloseMatchFlag(false);
                return;
            }
            if (bHasMatchingLDUAndVeryGoodLastLine && candidate.getMainAddressScore() < 0.85) {
                candidate.setCloseMatchFlag(false);
                return;
            }
        }
        if (scoringAddress.getPostCode1() != null) {
            if (candidate.getPostCode1Score() != 1.0 || candidate.getPostCode2Score() < 0.9) {
                if (scoringAddress.getAreaName1() != null && scoringAddress.getAreaName3() != null) {
                    if (candidate.getAreaName1Score() != 1.0 || candidate.getAreaName3Score() < 0.6 || (this.isRuralFSA(scoringAddress.getPostCode1()) || this.isRuralFSA(candidate.getPostCode1())) && (((CAN_InternalCandidateAddress)candidate).isAreaName3ScoreBasedOnAlternate() || candidate.getAreaName3Score() < 0.9)) {
                        candidate.setCloseMatchFlag(false);
                        return;
                    }
                } else if (candidate.getPostCode1Score() != 1.0) {
                    candidate.setCloseMatchFlag(false);
                    return;
                }
            }
        } else {
            if (!StringUtilities.isEmpty((String)scoringAddress.getAreaName1()) && candidate.getAreaName1Score() != 1.0 || candidate.getAreaName3Score() < 0.6) {
                candidate.setCloseMatchFlag(false);
                return;
            }
            if (this.isRuralFSA(candidate.getPostCode1()) && (((CAN_InternalCandidateAddress)candidate).isAreaName3ScoreBasedOnAlternate() || candidate.getAreaName3Score() < 0.9) && candidate.getAddressNumberScore() < 1.0) {
                candidate.setCloseMatchFlag(false);
                return;
            }
        }
        if (candidate.getPostDirectional() != null && candidate.getPostDirectionalScore() == 0.0 && (candidate.getPostCode1Score() != 1.0 || candidate.getPostCode2Score() != 1.0)) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (candidate.getPreDirectional() != null && candidate.getPreDirectionalScore() == 0.0 && (candidate.getPostCode1Score() != 1.0 || candidate.getPostCode2Score() != 1.0)) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (scoringAddress.getPostThoroughfareType() != null && scoringAddress.getPostThoroughfareType().equalsIgnoreCase("PK") && candidate.getPostThoroughfareTypeScore() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        Address searchParsedAddress = ((CAN_InternalMatchPreferences)preferences).getSearchParsedAddress();
        if (searchParsedAddress != null && (this.isRuralFSA(searchParsedAddress.getPostCode1()) || this.isRuralFSA(candidate.getPostCode1())) && searchParsedAddress.getAreaName1() != null && searchParsedAddress.getAreaName3() != null && candidate.getAreaName3Score() < 0.75 && (candidate.getPostCode1Score() != 1.0 || candidate.getPostCode2Score() != 1.0)) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (StringUtilities.isEmpty((String)scoringAddress.getAreaName1()) && StringUtilities.isEmpty((String)scoringAddress.getAreaName2()) && StringUtilities.isEmpty((String)scoringAddress.getAreaName4()) && StringUtilities.isEmpty((String)scoringAddress.getPostCode1()) && !StringUtilities.isEmpty((String)scoringAddress.getAreaName3()) && candidate.getAreaName3Score() <= 0.7) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (this.makePOBFalse(preferences, scoringAddress, candidate)) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        String InPostType = scoringAddress.getPostThoroughfareType();
        String candPreType = canCandidate.getPreThoroughfareType();
        if (((CAN_ScoringAddress)scoringAddress).isQC() && !StringUtilities.isEmpty((String)candPreType) && !StringUtilities.isEmpty((String)InPostType) && "SQ".equals(InPostType)) {
            scoringAddress.getAdditionalFields().put(DOFRENCHVER, "true");
            candidate.setCloseMatchFlag(false);
            return;
        }
        candidate.setCloseMatchFlag(true);
    }

    private boolean makePOBFalse(IMatchPreferences prefs, ScoringAddress scoringAddress, InternalCandidateAddress candidateAddress) {
        if (!((CAN_InternalMatchPreferences)prefs).isPoBoxMatchInProgress()) {
            return false;
        }
        if (!StringUtilities.isEmpty((String)scoringAddress.getPostCode1()) && !StringUtilities.isEmpty((String)scoringAddress.getPostCode2()) && StringUtilities.isEmpty((String)scoringAddress.getAreaName3()) && !StringUtilities.isEmpty((String)candidateAddress.getPostCode2()) && candidateAddress.getPostCode2Score() < 1.0) {
            return true;
        }
        if (!StringUtilities.isEmpty((String)scoringAddress.getPostCode1()) && StringUtilities.isEmpty((String)scoringAddress.getPostCode2()) && !StringUtilities.isEmpty((String)scoringAddress.getAreaName3()) && candidateAddress.getAreaName3Score() < 0.99 && scoringAddress.getAdditionalFields().get(NO_GEOSACS) == null) {
            return true;
        }
        if (!(StringUtilities.isEmpty((String)scoringAddress.getPostCode1()) || StringUtilities.isEmpty((String)scoringAddress.getPostCode2()) || StringUtilities.isEmpty((String)scoringAddress.getAreaName3()))) {
            boolean LDUbad = false;
            boolean Citybad = false;
            if (!StringUtilities.isEmpty((String)candidateAddress.getPostCode2()) && candidateAddress.getPostCode2Score() != 1.0) {
                LDUbad = true;
            }
            if (!StringUtilities.isEmpty((String)candidateAddress.getAreaName3()) && candidateAddress.getAreaName3Score() < 0.99 && scoringAddress.getAdditionalFields().get(NO_GEOSACS) == null) {
                Citybad = true;
            }
            if (LDUbad && Citybad) {
                return true;
            }
        }
        return false;
    }

    private boolean isRuralFSA(String FSA) {
        return FSA != null && FSA.length() > 1 && FSA.charAt(1) == '0';
    }

    private boolean fieldExists(String val) {
        return CoreMatcher.fieldExists((String)val);
    }

    public boolean removeSecondCandidate(InternalCandidateAddress best, InternalCandidateAddress other) {
        return this.m_coreHandler.removeSecondCandidate(best, other);
    }

    public double getMaximumAdditionalFieldScore() {
        return this.m_coreHandler.getMaximumAdditionalFieldScore();
    }

    public double getMaximumAddressScore() {
        return this.m_coreHandler.getMaximumAddressScore();
    }

    public void setMaximumAddressScore(double value) {
        this.m_coreHandler.setMaximumAddressScore(value);
    }

    public void setMaximumAdditionalFieldScore(double value) {
        this.m_coreHandler.setMaximumAdditionalFieldScore(value);
    }

    public void computeMaximumAdditionalFieldScore(Address parsedAddress, InternalMatcherConstants constants) {
        this.m_coreHandler.computeMaximumAdditionalFieldScore(parsedAddress, constants);
    }

    public List removeMultipleSegmentsForStreet(List candidates, IConstraints constraints) {
        return candidates;
    }

    private boolean hasMatchingLDUAndVeryGoodLastLine(ScoringAddress scoringAddress, InternalCandidateAddress candidate) {
        if (StringUtilities.isEmpty((String)scoringAddress.getPostCode1())) {
            return false;
        }
        if (StringUtilities.isEmpty((String)scoringAddress.getPostCode2())) {
            return false;
        }
        if (candidate.getPostCode1Score() != 1.0) {
            return false;
        }
        if (candidate.getPostCode2Score() != 1.0) {
            return false;
        }
        return !(candidate.getCombinedAdditionalFieldScore() < 0.95);
    }

    static {
        HashSet<String> temp = new HashSet<String>();
        temp.add("RR");
        temp.add("SS");
        temp.add("MR");
        temp.add("GDE");
        temp.add("GDF");
        m_routeServiceTypes = Collections.unmodifiableSet(temp);
    }
}

