/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN;

import com.mapinfo.mapmarker.CAN.CAN_RangeUnit;
import com.mapinfo.mapmarker.CAN.MunicipalityRecord;
import com.mapinfo.mapmarker.CandidateRange;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.RangeUnit;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class CAN_Range
extends Range {
    protected String m_LDU = null;
    private String pbkey = null;
    private String m_routeServiceType;
    private short m_routeServiceNumber;
    private MunicipalityRecord m_municipalityRecord;

    public CAN_Range() {
        this.m_routeServiceNumber = (short)-1;
    }

    public CAN_Range(String from, String to) {
        super(from, to);
        this.m_routeServiceNumber = (short)-1;
    }

    public CAN_Range(Range range) {
        super(range);
        if (range instanceof CAN_Range) {
            CAN_Range thatRange = (CAN_Range)range;
            this.setLDU(thatRange.getLDU());
            this.setPbkey(thatRange.getPbkey());
            this.m_routeServiceType = thatRange.m_routeServiceType;
            this.m_routeServiceNumber = thatRange.m_routeServiceNumber;
        } else {
            this.m_routeServiceNumber = (short)-1;
        }
    }

    public String getLDU() {
        int matchingUnitIndex;
        CAN_RangeUnit rangeUnit;
        String unitLDU;
        if (this.hasMatchingRangeUnit() && (unitLDU = (rangeUnit = (CAN_RangeUnit)this.getRangeUnitAt(matchingUnitIndex = this.getMatchingRangeUnit())).getLDU()) != null && unitLDU.length() != 0) {
            return unitLDU;
        }
        return this.m_LDU;
    }

    public void setLDU(String ldu) {
        this.m_LDU = ldu;
    }

    public String getPbkey() {
        return this.pbkey;
    }

    public void setPbkey(String pbkey) {
        this.pbkey = pbkey;
    }

    public String getRangeLDU() {
        return this.m_LDU;
    }

    public void setRouteServiceType(String routeServiceType) {
        this.m_routeServiceType = routeServiceType;
    }

    public String getRouteServiceType() {
        return this.m_routeServiceType;
    }

    public void setRouteServiceNumber(short routeServiceNumber) {
        this.m_routeServiceNumber = routeServiceNumber;
    }

    public String getRouteServiceNumber() {
        if (this.m_routeServiceNumber > 0) {
            return String.valueOf(this.m_routeServiceNumber);
        }
        return null;
    }

    public void setMunicipalityRecord(MunicipalityRecord municipalityRecord) {
        this.m_municipalityRecord = municipalityRecord;
    }

    public MunicipalityRecord getMunicipalityRecord() {
        return this.m_municipalityRecord;
    }

    public String getPlaceName() {
        int matchingUnitIndex;
        RangeUnit rangeUnit;
        String unitPlace;
        if (this.hasMatchingRangeUnit() && (unitPlace = (rangeUnit = this.getRangeUnitAt(matchingUnitIndex = this.getMatchingRangeUnit())).getPlaceName()) != null && unitPlace.length() != 0) {
            return unitPlace;
        }
        return super.getPlaceName();
    }

    public void findClosestRangeUnit(ScoringAddress parsedInput) {
    }

    public void findMatchingRangeUnit(ParsedNumber unitNumber, String unitType, String inputPost2) {
        if (unitNumber.isEmpty() && !StringUtilities.isEmpty((String)inputPost2) && !StringUtilities.equalStringsIgnoreCase((String)this.m_LDU, (String)inputPost2)) {
            int numRangeUnits = this.getRangeUnitCount();
            if (numRangeUnits <= 0) {
                return;
            }
            int matchingRangeUnit = -1;
            for (int i = 0; i < numRangeUnits; ++i) {
                CAN_RangeUnit unit = (CAN_RangeUnit)this.getRangeUnitAt(i);
                if (!StringUtilities.equalStringsIgnoreCase((String)unit.getLDU(), (String)inputPost2)) continue;
                if (!(matchingRangeUnit >= 0 || unit.getNumberOfUnits() != 1L && StringUtilities.isEmpty((String)unit.getPlaceName()))) {
                    matchingRangeUnit = i;
                    continue;
                }
                matchingRangeUnit = -1;
                break;
            }
            this.setMatchingRangeUnit(matchingRangeUnit);
        } else if (!unitNumber.isEmpty()) {
            this.findMatchingRangeUnit(unitNumber, unitType);
        }
    }

    public String getUnitValue(ParsedNumber inputUnitId) {
        if (this.hasMatchingRangeUnit() && inputUnitId.isEmpty()) {
            return this.getRangeUnitAt(this.getMatchingRangeUnit()).getLowUnit();
        }
        return super.getUnitValue(inputUnitId);
    }

    public CandidateRange toCandidateRange(ParsedNumber inputHouseNumber, int side, IConstraints constraints, Segment segment) {
        CandidateRange range = super.toCandidateRange(inputHouseNumber, side, null, constraints);
        range.setPostalCode2(this.getLDU());
        if (side == 1) {
            if (range.getAreaName1() == null) {
                range.setAreaName1(segment.getLeftAreaName1());
            }
            if (range.getAreaName3() == null) {
                range.setAreaName3(segment.getLeftAreaName3());
            }
            if (range.getAreaName4() == null) {
                range.setAreaName4(segment.getLeftAreaName4());
            }
            if (range.getPostalCode1() == null) {
                range.setPostalCode1(segment.getLeftPostCode1());
            }
            if (range.getPostalCode2() == null) {
                range.setPostalCode2(segment.getLeftPostCode2());
            }
        } else {
            if (range.getAreaName1() == null) {
                range.setAreaName1(segment.getRightAreaName1());
            }
            if (range.getAreaName3() == null) {
                range.setAreaName3(segment.getRightAreaName3());
            }
            if (range.getAreaName4() == null) {
                range.setAreaName4(segment.getRightAreaName4());
            }
            if (range.getPostalCode1() == null) {
                range.setPostalCode1(segment.getRightPostCode1());
            }
            if (range.getPostalCode2() == null) {
                range.setPostalCode2(segment.getRightPostCode2());
            }
        }
        return range;
    }
}

