/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN;

import com.mapinfo.mapmarker.CAN.AddressUtils;
import com.mapinfo.mapmarker.CAN.CAN_ParsedAddress;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.StringScorer;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class CAN_ScoringAddress
extends ScoringAddress {
    public static final double HWY_TYPES_SCORE = 0.75;
    private static final int ST_HASH = "ST".hashCode();
    private static final int STE_HASH = "STE".hashCode();
    private static final int SAINT_HASH = "SAINT".hashCode();
    private static final int SAINTE_HASH = "SAINTE".hashCode();
    private static final StringScorer m_scorer;
    private boolean m_RemovedStartEndWordforRetry;
    private boolean m_mustHaveLDU;
    private String m_routeServiceType;
    private String m_routeServiceNumber;
    private String m_stationInformation;
    private final Map m_areaName3Cache;
    private static HashSet m_articleSet;
    private boolean m_isSingleLine;
    private boolean m_isPOBox;
    private Map m_ordinals = new HashMap();
    private static final Set m_highwayTypes;

    public CAN_ScoringAddress() {
        this(new CAN_ParsedAddress());
    }

    public CAN_ScoringAddress(CAN_ParsedAddress addr) {
        super((Address)addr, true, false, false);
        this.m_areaName3Cache = this.getAreaName3() != null ? new HashMap() : null;
        this.m_routeServiceType = addr.getAdditionalRouteServiceType();
        this.m_routeServiceNumber = addr.getAdditionalRouteServiceNumber();
        this.m_stationInformation = addr.getStationInformation();
        this.m_isPOBox = addr.isEnglishPOBox() || addr.isFrenchPOBox();
    }

    public StringScorer getStringScorer() {
        return m_scorer;
    }

    public boolean getIsRuralFSA() {
        return ((CAN_ParsedAddress)this.getAddress()).getIsRuralFSA();
    }

    public boolean isQC() {
        return ((CAN_ParsedAddress)this.getAddress()).isQC();
    }

    public void setMustHaveLDU(boolean flag) {
        this.m_mustHaveLDU = flag;
    }

    public boolean isMustHaveLDU() {
        return this.m_mustHaveLDU;
    }

    public double scorePostThoroughfareType(String str) {
        String postType = this.getPostThoroughfareType();
        if (postType == null) {
            return str == null ? 1.0 : 0.0;
        }
        if (postType.equals(str)) {
            return 1.0;
        }
        if (m_highwayTypes.contains(postType) && m_highwayTypes.contains(str)) {
            return 0.75;
        }
        return 0.0;
    }

    public double scorePreThoroughfareType(String str) {
        String preType = this.getPreThoroughfareType();
        if (preType == null) {
            return str == null ? 1.0 : 0.0;
        }
        if (preType.equals(str)) {
            return 1.0;
        }
        if (CAN_ScoringAddress.isHighwayType(preType) && CAN_ScoringAddress.isHighwayType(str)) {
            return 0.75;
        }
        return 0.0;
    }

    public static boolean isHighwayType(String str) {
        return m_highwayTypes.contains(str);
    }

    public static double scoreDirectionals(String parseDir, String candDir) {
        boolean isEmptyParseDir = true;
        boolean isEmptyCandDir = true;
        if (parseDir != null && parseDir.length() != 0) {
            isEmptyParseDir = false;
        }
        if (candDir != null && candDir.length() != 0) {
            isEmptyCandDir = false;
        }
        if (isEmptyParseDir) {
            if (isEmptyCandDir) {
                return 1.0;
            }
            if (candDir.length() == 1) {
                return 0.1;
            }
            return 0.05;
        }
        if (isEmptyCandDir) {
            if (parseDir.length() == 1) {
                return 0.1;
            }
            return 0.05;
        }
        if (parseDir.length() == 1) {
            if (candDir.length() == 1) {
                if (parseDir.charAt(0) == candDir.charAt(0)) {
                    return 1.0;
                }
                return 0.0;
            }
            if (candDir.length() == 2) {
                char p0 = parseDir.charAt(0);
                if (p0 == 'N' || p0 == 'S') {
                    if (candDir.charAt(0) == p0) {
                        return 0.75;
                    }
                    return 0.0;
                }
                if (candDir.charAt(1) == p0) {
                    return 0.75;
                }
                return 0.0;
            }
        }
        if (parseDir.length() == 2) {
            char p0 = parseDir.charAt(0);
            char c0 = candDir.charAt(0);
            if (candDir.length() == 1) {
                if (c0 == p0) {
                    return 0.5;
                }
                if (c0 == parseDir.charAt(1)) {
                    return 0.5;
                }
                return 0.0;
            }
            if (candDir.length() == 2) {
                if (c0 == p0 && candDir.charAt(1) == parseDir.charAt(1)) {
                    return 1.0;
                }
                return 0.0;
            }
        }
        return 0.0;
    }

    public double scorePreDirectional(String str) {
        return CAN_ScoringAddress.scoreDirectionals(str, this.getPreDirectional());
    }

    public double scorePostDirectional(String str) {
        return CAN_ScoringAddress.scoreDirectionals(str, this.getPostDirectional());
    }

    public double scoreAreaName1(String areaName1) {
        if (this.getAreaName1() == null) {
            return 1.0;
        }
        return this.getAreaName1().equals(areaName1) ? 1.0 : 0.0;
    }

    public double scoreAreaName3(String str) {
        StringWithTokens myTokens;
        int myIdx;
        StringWithTokens swt = new StringWithTokens(str, " -");
        int otherIdx = this.findSaintIndex(swt);
        if (otherIdx >= 0 && (myIdx = this.findSaintIndex(myTokens = new StringWithTokens(this.getAreaName3(), " -"))) >= 0) {
            String otherTok = swt.getToken(otherIdx);
            String myTok = myTokens.getToken(myIdx);
            if (!myTok.equals(otherTok)) {
                int len = otherTok.length();
                if (myTok.length() > 3) {
                    if (len == 2) {
                        swt.setToken(otherIdx, "SAINT");
                    } else if (len == 3) {
                        swt.setToken(otherIdx, "SAINTE");
                    }
                } else if (len == 5) {
                    swt.setToken(otherIdx, "ST");
                } else if (len == 6) {
                    swt.setToken(otherIdx, "STE");
                }
                str = str.indexOf(45) >= 0 ? swt.toStringWithSep('-') : swt.toString();
            }
        }
        return this.doScore(AddressUtils.replaceMTWithMOUNT(str), AddressUtils.replaceMTWithMOUNT(this.getAreaName3()), this.m_areaName3Cache);
    }

    protected int findSaintIndex(StringWithTokens tokens) {
        int sz = tokens.size();
        for (int i = 0; i < sz; ++i) {
            int hashCode;
            String tok = tokens.getToken(i);
            if (tok.charAt(0) != 'S' || !(ST_HASH == (hashCode = tok.hashCode()) && "ST".equals(tok) || STE_HASH == hashCode && "STE".equals(tok) || SAINT_HASH == hashCode && "SAINT".equals(tok)) && (SAINTE_HASH != hashCode || !"SAINTE".equals(tok))) continue;
            return i;
        }
        return -1;
    }

    double scoreMainAddressAdjusted(String str, double rawScore) {
        if (rawScore == 1.0) {
            return rawScore;
        }
        String mainAddress = this.getMainAddress();
        if (mainAddress == null || str == null) {
            return rawScore;
        }
        String strippedMainAddress = null;
        if (this.mayBeOrdinal(mainAddress) && mainAddress.equals(strippedMainAddress = this.stripOrdinal(mainAddress))) {
            strippedMainAddress = null;
        }
        String strippedStr = null;
        if (this.mayBeOrdinal(str) && str.equals(strippedStr = this.stripOrdinal(str))) {
            strippedStr = null;
        }
        if (strippedMainAddress != null || strippedStr != null) {
            if (strippedMainAddress != null) {
                this.setMainAddress(strippedMainAddress);
            }
            double noOrdinalScore = super.scoreMainAddress(strippedStr != null ? strippedStr : str);
            if (strippedMainAddress != null) {
                this.setMainAddress(mainAddress);
            }
            if (noOrdinalScore > rawScore) {
                rawScore = noOrdinalScore;
            }
        }
        if (rawScore == 1.0) {
            return rawScore;
        }
        if (str.length() != 0) {
            StringWithTokens inputMainTokens = new StringWithTokens(this.getMainAddress(), "- ");
            StringWithTokens candMainTokens = new StringWithTokens(str, "- ");
            int inputTokenSize = inputMainTokens.size();
            int candTokenSize = candMainTokens.size();
            StringBuffer newInput = new StringBuffer();
            StringBuffer newCand = new StringBuffer();
            boolean bInputAdjusted = false;
            boolean bFirstToken = true;
            for (int i = 0; i < inputTokenSize; ++i) {
                String inputToken = inputMainTokens.getToken(i);
                if (!m_articleSet.contains(inputToken)) {
                    if (!bFirstToken) {
                        newInput.append(' ');
                    } else {
                        bFirstToken = false;
                    }
                    if (AddressUtils.isSaintVariation(inputToken)) {
                        newInput.append(this.getSaintForScoring());
                        bInputAdjusted = true;
                        continue;
                    }
                    if (this.mayBeOrdinal(inputToken)) {
                        String stripped = this.stripOrdinal(inputToken);
                        if (inputToken.equals(stripped)) {
                            newInput.append(inputToken);
                            continue;
                        }
                        newInput.append(stripped);
                        bInputAdjusted = true;
                        continue;
                    }
                    newInput.append(inputToken);
                    continue;
                }
                bInputAdjusted = true;
            }
            boolean bCandAdjusted = false;
            bFirstToken = true;
            for (int i = 0; i < candTokenSize; ++i) {
                String candToken = candMainTokens.getToken(i);
                if (!m_articleSet.contains(candToken)) {
                    if (!bFirstToken) {
                        newCand.append(' ');
                    } else {
                        bFirstToken = false;
                    }
                    if (AddressUtils.isSaintVariation(candToken)) {
                        newCand.append(this.getSaintForScoring());
                        bCandAdjusted = true;
                        continue;
                    }
                    if (this.mayBeOrdinal(candToken)) {
                        String stripped = this.stripOrdinal(candToken);
                        if (candToken.equals(stripped)) {
                            newCand.append(candToken);
                            continue;
                        }
                        newCand.append(stripped);
                        bCandAdjusted = true;
                        continue;
                    }
                    newCand.append(candToken);
                    continue;
                }
                bCandAdjusted = true;
            }
            if (bInputAdjusted || bCandAdjusted) {
                if (bInputAdjusted) {
                    this.setMainAddress(newInput.toString());
                }
                double adjustedScore = super.scoreMainAddress(bCandAdjusted ? newCand.toString() : str);
                if (bInputAdjusted) {
                    this.setMainAddress(mainAddress);
                }
                if (adjustedScore > rawScore) {
                    rawScore = adjustedScore;
                }
            }
        }
        return rawScore;
    }

    private boolean mayBeOrdinal(String str) {
        return str != null && str.length() > 1 && Character.isDigit(str.charAt(0)) && !Character.isDigit(str.charAt(str.length() - 1));
    }

    private String stripOrdinal(String str) {
        boolean bValid;
        int digits;
        String stripped;
        block34: {
            char[] strChars;
            block33: {
                if (str == null || str.length() <= 1 || !Character.isDigit(str.charAt(0)) || Character.isDigit(str.charAt(str.length() - 1))) {
                    return str;
                }
                stripped = (String)this.m_ordinals.get(str);
                if (stripped != null) {
                    return stripped;
                }
                strChars = str.toCharArray();
                for (digits = 1; digits < strChars.length && Character.isDigit(strChars[digits]); ++digits) {
                }
                bValid = false;
                if (digits != 1) break block33;
                switch (strChars[0]) {
                    case '1': {
                        if (strChars.length == 3 && (str.endsWith("ST") || str.endsWith("ER") || str.endsWith("RE"))) {
                            bValid = true;
                            break;
                        }
                        if (strChars.length == 5 && str.endsWith("I\u00c8RE")) {
                            bValid = true;
                            break;
                        }
                        break block34;
                    }
                    case '2': {
                        if (strChars.length == 2 && str.endsWith("E")) {
                            bValid = true;
                            break;
                        }
                        if (strChars.length == 3 && str.endsWith("ND")) {
                            bValid = true;
                            break;
                        }
                        break block34;
                    }
                    case '3': {
                        if (strChars.length == 2 && str.endsWith("E")) {
                            bValid = true;
                            break;
                        }
                        if (strChars.length == 3 && str.endsWith("RD")) {
                            bValid = true;
                            break;
                        }
                        break block34;
                    }
                    default: {
                        if (strChars.length == 2 && str.endsWith("E")) {
                            bValid = true;
                            break;
                        }
                        if (strChars.length == 3 && str.endsWith("TH")) {
                            bValid = true;
                            break;
                        }
                        break block34;
                    }
                }
                break block34;
            }
            if (digits == 2 && strChars[0] == '1') {
                if (strChars.length == 3 && strChars[2] == 'E') {
                    bValid = true;
                } else if (strChars.length == 4 && str.endsWith("TH")) {
                    bValid = true;
                }
            } else if (strChars.length - digits == 1) {
                if (strChars[strChars.length - 1] == 'E') {
                    bValid = true;
                }
            } else if (strChars.length - digits == 2) {
                if (digits >= 3 && strChars[digits - 2] == '1' && str.endsWith("TH")) {
                    bValid = true;
                } else {
                    switch (strChars[digits - 1]) {
                        case '1': {
                            if (!str.endsWith("ST")) break;
                            bValid = true;
                            break;
                        }
                        case '2': {
                            if (!str.endsWith("ND")) break;
                            bValid = true;
                            break;
                        }
                        case '3': {
                            if (!str.endsWith("RD")) break;
                            bValid = true;
                            break;
                        }
                        default: {
                            if (!str.endsWith("TH")) break;
                            bValid = true;
                        }
                    }
                }
            }
        }
        if (bValid) {
            stripped = str.substring(0, digits);
            this.m_ordinals.put(str, stripped);
            return stripped;
        }
        return str;
    }

    private String getSaintForScoring() {
        return "SAINT";
    }

    public boolean isRemovedStartEndWordforRetry() {
        return this.m_RemovedStartEndWordforRetry;
    }

    public void setRemovedStartEndWordforRetry(boolean flag) {
        this.m_RemovedStartEndWordforRetry = flag;
    }

    public double scorePostCode1(String str) {
        String FSA = this.getPostCode1();
        if (FSA == null ^ str == null) {
            return 0.0;
        }
        if (FSA != null) {
            char[] strChars;
            if (FSA.equalsIgnoreCase(str)) {
                return 1.0;
            }
            char[] FSAChars = FSA.toCharArray();
            int common = this.getCommonFSAChars(FSAChars, strChars = str.toCharArray());
            if (common == 1) {
                if (FSAChars[1] == '0' || strChars[1] == '0') {
                    return 0.15;
                }
                return 0.25;
            }
            if (common == 2) {
                if (FSAChars[1] == '0' || strChars[1] == '0') {
                    return 0.45;
                }
                return 0.5;
            }
            return 0.0;
        }
        return 1.0;
    }

    private int getCommonFSAChars(char[] FSA, char[] input) {
        if (FSA.length != 3 || input.length != 3) {
            return 0;
        }
        if (FSA[0] == input[0]) {
            if (FSA[1] == input[1]) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public String getRouteServiceNumber() {
        return this.m_routeServiceNumber;
    }

    public String getRouteServiceType() {
        return this.m_routeServiceType;
    }

    public String getStationInformation() {
        return this.m_stationInformation;
    }

    public boolean isSingleLine() {
        return this.m_isSingleLine;
    }

    public void setIsSingleLine(boolean isSingleLine) {
        this.m_isSingleLine = isSingleLine;
    }

    public boolean isPOBox() {
        return this.m_isPOBox;
    }

    static {
        StringBuffer buf = new StringBuffer();
        buf.append("& c ; \u00e7 , \u00c7 ");
        buf.append("& n ; \u00f1 , \u00d1 ");
        buf.append("& a ; \u00e0 , \u00c0 , \u00e1 , \u00c1 , \u00e4 , \u00c4 ,  \u00e2 , \u00c2 , \u00e3 , \u00c3 ");
        buf.append("& e ; \u00e9 , \u00e8 , \u00eb , \u00ea , \u00c8 , \u00c9, \u00ca , \u00cb ");
        buf.append("& i ; \u00ec , \u00ed , \u00ee , \u00ef , \u00cd , \u00cc , \u00cf , \u00ce ");
        buf.append("& o ; \u00f2 , \u00fe , \u00f4 , \u00f5 , \u00d2 , \u00d3 , \u00d4, \u00d5 , \u00f3 ");
        buf.append("& u ; \u00f9 , \u00fa , \u00fb , \u00fc , \u00da , \u00d9 , \u00db , \u00dc ");
        m_scorer = new StringScorer(true, new Locale("ca", "CA"), buf.toString());
        String[] articles = new String[]{"DU", "DE", "DES", "D", "DEL", "L", "LA", "LE", "LES", "THE"};
        m_articleSet = new HashSet(articles.length);
        m_articleSet.addAll(Arrays.asList(articles));
        TreeSet<String> highwayTypes = new TreeSet<String>();
        highwayTypes.add("HWY");
        highwayTypes.add("EXPY");
        highwayTypes.add("FRWY");
        highwayTypes.add("PKWY");
        highwayTypes.add("RTE");
        highwayTypes.add("ART");
        highwayTypes.add("CHWY");
        highwayTypes.add("CRTE");
        highwayTypes.add("RHWY");
        highwayTypes.add("TCHWY");
        highwayTypes.add("THWY");
        highwayTypes.add("TPKE");
        m_highwayTypes = Collections.unmodifiableSet(highwayTypes);
    }
}

