/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN;

import com.mapinfo.mapmarker.CAN.CAN_CensusInfo;
import com.mapinfo.mapmarker.CAN.CAN_Range;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import java.util.List;
import java.util.ListIterator;

public class CAN_Segment
extends Segment {
    private CAN_CensusInfo m_leftCensus;
    private CAN_CensusInfo m_rightCensus;
    private GeoInfoRecord m_leftGeoInfo;
    private GeoInfoRecord m_rightGeoInfo;

    public CAN_Segment() {
    }

    public CAN_Segment(Segment segment) {
        super(segment);
        if (segment != null && segment instanceof CAN_Segment) {
            CAN_Segment can = (CAN_Segment)segment;
            this.setLeftCensusInfo(can.getLeftCensusInfo());
            this.setRightCensusInfo(can.getRightCensusInfo());
            this.setLeftGeoInfoRecord(this.m_leftGeoInfo);
            this.setRightGeoInfoRecord(this.m_rightGeoInfo);
        }
    }

    public void setLeftGeoInfoRecord(GeoInfoRecord leftGeoInfo) {
        this.m_leftGeoInfo = leftGeoInfo;
    }

    GeoInfoRecord getLeftGeoInfoRecord() {
        return this.m_leftGeoInfo;
    }

    public void setRightGeoInfoRecord(GeoInfoRecord rightGeoInfo) {
        this.m_rightGeoInfo = rightGeoInfo;
    }

    GeoInfoRecord getRightGeoInfoRecord() {
        return this.m_rightGeoInfo;
    }

    public void setGeoInfoRecord(GeoInfoRecord geoInfo) {
        this.m_leftGeoInfo = geoInfo;
        this.m_rightGeoInfo = geoInfo;
    }

    public void setLeftCensusInfo(CAN_CensusInfo info) {
        this.m_leftCensus = info;
    }

    public CAN_CensusInfo getLeftCensusInfo() {
        return this.m_leftCensus;
    }

    public void setRightCensusInfo(CAN_CensusInfo info) {
        this.m_rightCensus = info;
    }

    public CAN_CensusInfo getRightCensusInfo() {
        return this.m_rightCensus;
    }

    public boolean containsLDU(String ldu) {
        List ranges = this.getRanges(0);
        if (this.checkRanges(ranges, ldu)) {
            return true;
        }
        ranges = this.getRanges(1);
        return this.checkRanges(ranges, ldu);
    }

    private boolean checkRanges(List ranges, String ldu) {
        if (ranges != null) {
            ListIterator it = ranges.listIterator();
            while (it.hasNext()) {
                CAN_Range range = (CAN_Range)((Object)it.next());
                String test = range.getLDU();
                if (test == null || !test.equals(ldu)) continue;
                return true;
            }
        }
        return false;
    }

    protected Range makeRange(Range source) {
        return new CAN_Range(source);
    }

    protected Range makeRange(String from, String to) {
        return new CAN_Range(from, to);
    }

    public String getLeftAreaName1() {
        if (this.m_leftGeoInfo != null) {
            return this.m_leftGeoInfo.getAreaName1();
        }
        return super.getLeftAreaName1();
    }

    public String getRightAreaName1() {
        if (this.m_rightGeoInfo != null) {
            return this.m_rightGeoInfo.getAreaName1();
        }
        return super.getRightAreaName1();
    }

    public String getLeftAreaName3() {
        if (this.m_leftGeoInfo != null) {
            return this.m_leftGeoInfo.getAreaName3();
        }
        return super.getLeftAreaName3();
    }

    public String getRightAreaName3() {
        if (this.m_rightGeoInfo != null) {
            return this.m_rightGeoInfo.getAreaName3();
        }
        return super.getRightAreaName3();
    }

    public String getLeftAltAreaName3s() {
        if (this.m_leftGeoInfo != null) {
            return this.m_leftGeoInfo.getAltAreaName3();
        }
        return null;
    }

    public String getRightAltAreaName3s() {
        if (this.m_rightGeoInfo != null) {
            return this.m_rightGeoInfo.getAltAreaName3();
        }
        return null;
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer(super.toString());
        buffer.append("leftCensus: ");
        if (this.m_leftCensus != null) {
            buffer.append(lineSeparator);
            buffer.append(this.m_leftCensus.toString());
        } else {
            buffer.append("null");
            buffer.append(lineSeparator);
        }
        buffer.append("rightCensus: ");
        if (this.m_rightCensus != null) {
            buffer.append(lineSeparator);
            buffer.append(this.m_rightCensus.toString());
        } else {
            buffer.append("null");
            buffer.append(lineSeparator);
        }
        buffer.append(lineSeparator);
        buffer.append(lineSeparator);
        return buffer.toString();
    }
}

