/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN;

import com.mapinfo.mapmarker.common.ScoringAddress;
import java.util.Collection;
import java.util.Iterator;

public class CAN_SegmentAttributeScorer {
    private static final double PERFECT_SCORE = 1.0;
    private String m_postalCode1;
    private String m_postalCode2;
    private double m_postalCode1Score;
    private double m_postalCode2Score;
    private String m_areaName1;
    private String m_areaName3;
    private Collection<String> m_altAreaName3Collection;
    private double m_areaName1Score;
    private double m_areaName3Score;
    private boolean m_bAreaName3ScoreBasedOnAlternate;

    CAN_SegmentAttributeScorer(String postalCode1, String postalCode2, String areaName1, String areaName3, Collection<String> altAreaName3Collection) {
        this.m_postalCode1 = postalCode1;
        this.m_postalCode2 = postalCode2;
        this.m_areaName1 = areaName1;
        this.m_areaName3 = areaName3;
        this.m_altAreaName3Collection = altAreaName3Collection;
    }

    public void score(ScoringAddress input) {
        this.scorePostalCodes(input);
        this.scoreAreaNames(input);
    }

    private String getPostalCode1() {
        return this.m_postalCode1;
    }

    private void setPostalCode1Score(double score) {
        this.m_postalCode1Score = score;
    }

    public double getPostalCode1Score() {
        return this.m_postalCode1Score;
    }

    private String getPostalCode2() {
        return this.m_postalCode2;
    }

    private void setPostalCode2Score(double score) {
        this.m_postalCode2Score = score;
    }

    public double getPostalCode2Score() {
        return this.m_postalCode2Score;
    }

    private String getAreaName1() {
        return this.m_areaName1;
    }

    private String getAreaName3() {
        return this.m_areaName3;
    }

    private Collection<String> getAlternateAreaName3Collection() {
        return this.m_altAreaName3Collection;
    }

    private void setAreaName1Score(double score) {
        this.m_areaName1Score = score;
    }

    public double getAreaName1Score() {
        return this.m_areaName1Score;
    }

    private void setAreaName3Score(double score) {
        this.m_areaName3Score = score;
    }

    public double getAreaName3Score() {
        return this.m_areaName3Score;
    }

    private void setAreaName3ScoreBasedOnAlternate(boolean flag) {
        this.m_bAreaName3ScoreBasedOnAlternate = flag;
    }

    public boolean isAreaName3ScoreBasedOnAlternate() {
        return this.m_bAreaName3ScoreBasedOnAlternate;
    }

    public void scoreAreaNames(ScoringAddress input) {
        this.setAreaName1Score(input.scoreAreaName1(this.getAreaName1()));
        this.setAreaName3Score(input.scoreAreaName3(this.getAreaName3()));
        double score = this.getAreaName3Score();
        if (score != 1.0) {
            String alt;
            double altScore = 0.0;
            Iterator<String> iterator = this.getAlternateAreaName3Collection().iterator();
            while (iterator.hasNext() && (altScore = input.scoreAreaName3(alt = iterator.next())) != 1.0) {
            }
            if (altScore > score) {
                this.setAreaName3Score(altScore);
                this.setAreaName3ScoreBasedOnAlternate(true);
            }
        }
    }

    public void scorePostalCodes(ScoringAddress scoringAddress) {
        this.scorePostalCode1(scoringAddress);
        this.scorePostalCode2(scoringAddress);
    }

    private void scorePostalCode1(ScoringAddress scoringAddress) {
        this.setPostalCode1Score(scoringAddress.scorePostCode1(this.getPostalCode1()));
    }

    private void scorePostalCode2(ScoringAddress scoringAddress) {
        if (this.getPostalCode1Score() == 1.0) {
            String inputPostCode2 = scoringAddress.getPostCode2();
            if (inputPostCode2 == null || inputPostCode2.length() == 0) {
                this.setPostalCode2Score(1.0);
            } else if (inputPostCode2.equals(this.getPostalCode2())) {
                this.setPostalCode2Score(1.0);
            }
        }
    }
}

