/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN;

import com.mapinfo.mapmarker.CAN.CAN_ScoringAddress;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_DataDictionary;
import com.mapinfo.mapmarker.CAN.parser.CAN_NewThoroughfareTypes;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;
import com.mapinfo.mapmarker.common.StringScorer;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class CAN_StreetCandidateAddress
extends StreetCandidateAddress {
    private String m_originalName;
    private String m_deliveryInstallationInfo;
    private static final StringScorer m_scorer;
    private static final String PO_BOX = "PO BOX";
    private boolean m_isPOBox;
    private final CAN_DataDictionary.DICTIONARY_TYPE m_dictionaryType;
    private double m_rawMainAddressScore;
    private static final Set interchangeableThoroughfareTypeSet;

    public CAN_StreetCandidateAddress() {
        this(CAN_DataDictionary.DICTIONARY_TYPE.STANDARD);
    }

    public CAN_StreetCandidateAddress(CAN_DataDictionary.DICTIONARY_TYPE dictionaryType) {
        this.m_dictionaryType = dictionaryType;
    }

    public CAN_StreetCandidateAddress(Address addr) {
        super(addr);
        this.m_dictionaryType = addr instanceof CAN_StreetCandidateAddress ? ((CAN_StreetCandidateAddress)addr).m_dictionaryType : CAN_DataDictionary.DICTIONARY_TYPE.STANDARD;
    }

    public boolean isAPCandidate() {
        return this.m_dictionaryType == CAN_DataDictionary.DICTIONARY_TYPE.PARCEL;
    }

    public CAN_DataDictionary.DICTIONARY_TYPE getDictionaryType() {
        return this.m_dictionaryType;
    }

    public void setOriginalName(String originalName) {
        this.m_originalName = originalName;
    }

    public String getOriginalName() {
        return this.m_originalName;
    }

    public void setDeliveryInstallationInfo(String deliveryInstallationInfo) {
        this.m_deliveryInstallationInfo = deliveryInstallationInfo;
    }

    public String getDeliveryInstallationInfo() {
        return this.m_deliveryInstallationInfo;
    }

    public void setMainAddress(String mainAddr) {
        if (PO_BOX.equals(mainAddr)) {
            this.m_isPOBox = true;
        }
        super.setMainAddress(mainAddr);
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer(super.toString());
        buffer.append(lineSeparator);
        buffer.append("CAN_StreetCandidateAddress:");
        buffer.append(lineSeparator);
        buffer.append("originalName: ");
        buffer.append(this.getOriginalName());
        buffer.append(lineSeparator);
        buffer.append("delivery installation info: ");
        buffer.append(this.getDeliveryInstallationInfo());
        buffer.append(lineSeparator);
        buffer.append("rawMainAddressScore: ");
        buffer.append(this.getRawMainAddressScore());
        buffer.append(lineSeparator);
        buffer.append(lineSeparator);
        return buffer.toString();
    }

    public StringScorer getStringScorer() {
        return m_scorer;
    }

    public void score(ScoringAddress input) {
        this.setGenericField1Score(1.0);
        this.setGenericField2Score(1.0);
        this.setGenericField3Score(1.0);
        this.setGenericField4Score(1.0);
        this.setPreAddressScore(1.0);
        this.setPostAddressScore(1.0);
        this.setCountryScore(1.0);
        this.m_rawMainAddressScore = input.scoreMainAddress(this.getMainAddress());
        this.setMainAddressScore(((CAN_ScoringAddress)input).scoreMainAddressAdjusted(this.getMainAddress(), this.m_rawMainAddressScore));
        this.scoreThoroughfareTypes(input);
        this.scoreDirectionals(input);
        this.setGenericField4(input.getGenericField4());
        this.setIsScored(true);
    }

    private void scoreDirectionals(ScoringAddress input) {
        String inPreDir = input.getPreDirectional();
        String inPostDir = input.getPostDirectional();
        String candPreDir = this.getPreDirectional();
        String candPostDir = this.getPostDirectional();
        double score = 0.0;
        if (inPreDir == null && inPostDir == null && candPreDir == null && candPostDir == null) {
            this.setPreDirectionalScore(1.0);
            this.setPostDirectionalScore(1.0);
            return;
        }
        if (inPreDir != null && candPreDir != null || inPostDir != null && candPostDir != null) {
            this.setPreDirectionalScore(this.calculateScoreDirectionals(inPreDir, candPreDir));
            this.setPostDirectionalScore(this.calculateScoreDirectionals(inPostDir, candPostDir));
        } else {
            if (inPreDir != null && candPostDir != null) {
                score = 1.0 + this.calculateScoreDirectionals(inPreDir, candPostDir);
            } else if (inPostDir != null && candPreDir != null) {
                score = 1.0 + this.calculateScoreDirectionals(inPostDir, candPreDir);
            }
            if (score == 2.0) {
                this.setPreDirectionalScore(1.0);
                this.setPostDirectionalScore(1.0);
            } else {
                this.setPreDirectionalScore(this.calculateScoreDirectionals(inPreDir, candPreDir));
                this.setPostDirectionalScore(this.calculateScoreDirectionals(inPostDir, candPostDir));
            }
        }
    }

    public double calculateScoreDirectionals(String parseDir, String candDir) {
        boolean isEmptyParseDir = true;
        boolean isEmptyCandDir = true;
        if (parseDir != null && parseDir.length() != 0) {
            isEmptyParseDir = false;
        }
        if (candDir != null && candDir.length() != 0) {
            isEmptyCandDir = false;
        }
        if (isEmptyParseDir) {
            if (isEmptyCandDir) {
                return 1.0;
            }
            if (candDir.length() == 1) {
                return 0.1;
            }
            return 0.05;
        }
        if (isEmptyCandDir) {
            if (parseDir.length() == 1) {
                return 0.1;
            }
            return 0.05;
        }
        if (parseDir.length() == 1) {
            if (candDir.length() == 1) {
                if (parseDir.charAt(0) == candDir.charAt(0)) {
                    return 1.0;
                }
                char par = parseDir.charAt(0);
                char can = candDir.charAt(0);
                if (par == 'W' && can == 'O' || par == 'O' && can == 'W') {
                    return 1.0;
                }
                return 0.0;
            }
            if (candDir.length() == 2) {
                char p0 = parseDir.charAt(0);
                if (p0 == 'N' || p0 == 'S') {
                    if (candDir.charAt(0) == p0) {
                        return 0.75;
                    }
                    return 0.0;
                }
                if (candDir.charAt(1) == p0) {
                    return 0.75;
                }
                char can = candDir.charAt(1);
                if (p0 == 'W' && can == 'O' || p0 == 'O' && can == 'W') {
                    return 0.75;
                }
                return 0.0;
            }
        }
        if (parseDir.length() == 2) {
            char p0 = parseDir.charAt(0);
            char c0 = candDir.charAt(0);
            if (candDir.length() == 1) {
                if (c0 == p0) {
                    return 0.5;
                }
                if (c0 == 'W' && p0 == 'O' || c0 == 'O' && p0 == 'W') {
                    return 0.5;
                }
                if (c0 == parseDir.charAt(1)) {
                    return 0.5;
                }
                char par = parseDir.charAt(1);
                if (par == 'W' && c0 == 'O' || par == 'O' && c0 == 'W') {
                    return 0.5;
                }
                return 0.0;
            }
            if (candDir.length() == 2) {
                if (c0 == p0) {
                    if (candDir.charAt(1) == parseDir.charAt(1)) {
                        return 1.0;
                    }
                    char par = parseDir.charAt(1);
                    char can = candDir.charAt(1);
                    if (par == 'W' && can == 'O' || par == 'O' && can == 'W') {
                        return 1.0;
                    }
                }
                return 0.0;
            }
        }
        return 0.0;
    }

    private void scoreThoroughfareTypes(ScoringAddress input) {
        String inPreType = input.getPreThoroughfareType();
        String inPostType = input.getPostThoroughfareType();
        String candPreType = this.getPreThoroughfareType();
        String candPostType = this.getPostThoroughfareType();
        if (inPreType != null && candPreType != null && inPostType == null && candPostType == null) {
            this.setPostThoroughfareTypeScore(1.0);
            this.setPreThoroughfareTypeScore(this.scoreTypes(inPreType, candPreType));
        } else if (inPostType != null && candPostType != null && inPreType == null && candPreType == null) {
            this.setPreThoroughfareTypeScore(1.0);
            this.setPostThoroughfareTypeScore(this.scoreTypes(inPostType, candPostType));
        } else if (inPreType != null && inPostType == null && candPreType == null && candPostType != null) {
            double typeScore = this.scoreTypes(inPreType, candPostType);
            if (typeScore == 1.0 && interchangeableThoroughfareTypeSet.contains(inPreType)) {
                this.setPreThoroughfareTypeScore(1.0);
                this.setPostThoroughfareTypeScore(1.0);
            } else if (typeScore != 1.0 && StringUtilities.equalStrings((String)"RUE", (String)inPreType) && StringUtilities.equalStrings((String)"ST", (String)candPostType)) {
                this.setPreThoroughfareTypeScore(1.0);
                this.setPostThoroughfareTypeScore(1.0);
            } else {
                this.setPreThoroughfareTypeScore(0.99 * typeScore);
                this.setPostThoroughfareTypeScore(0.99);
            }
        } else if (inPreType == null && inPostType != null && candPreType != null && candPostType == null) {
            double typeScore = this.scoreTypes(inPostType, candPreType);
            if (typeScore == 1.0 && interchangeableThoroughfareTypeSet.contains(inPostType)) {
                this.setPreThoroughfareTypeScore(1.0);
                this.setPostThoroughfareTypeScore(1.0);
            } else if (typeScore != 1.0 && StringUtilities.equalStrings((String)"RUE", (String)candPreType) && StringUtilities.equalStrings((String)"ST", (String)inPostType)) {
                this.setPreThoroughfareTypeScore(1.0);
                this.setPostThoroughfareTypeScore(1.0);
            } else {
                this.setPreThoroughfareTypeScore(0.99);
                this.setPostThoroughfareTypeScore(0.99 * typeScore);
            }
        } else if (inPreType == null && inPostType == null && candPreType == null && candPostType == null) {
            this.setPostThoroughfareTypeScore(1.0);
            this.setPreThoroughfareTypeScore(1.0);
        }
    }

    private double scoreTypes(String input, String candType) {
        if (input.equalsIgnoreCase(candType)) {
            return 1.0;
        }
        CAN_NewThoroughfareTypes.KeyInfo key = CAN_NewThoroughfareTypes.lookupByTypeName(input.toUpperCase());
        if (key != null && key.getPreferredTypeName().equalsIgnoreCase(candType)) {
            return 1.0;
        }
        if (CAN_ScoringAddress.isHighwayType(input.toUpperCase()) && CAN_ScoringAddress.isHighwayType(candType)) {
            return 0.75;
        }
        return 0.0;
    }

    public boolean isPOBox() {
        return this.m_isPOBox;
    }

    public double getRawMainAddressScore() {
        return this.m_rawMainAddressScore;
    }

    static {
        StringBuffer buf = new StringBuffer();
        buf.append("& c ; \u00e7 , \u00c7 ");
        buf.append("& n ; \u00f1 , \u00d1 ");
        buf.append("& a ; \u00e0 , \u00c0 , \u00e1 , \u00c1 , \u00e4 , \u00c4 ,  \u00e2 , \u00c2 , \u00e3 , \u00c3 ");
        buf.append("& e ; \u00e9 , \u00e8 , \u00eb , \u00ea , \u00c8 , \u00c9, \u00ca , \u00cb ");
        buf.append("& i ; \u00ec , \u00ed , \u00ee , \u00ef , \u00cd , \u00cc , \u00cf , \u00ce");
        buf.append("& o ; \u00f2 , \u00fe , \u00f4 , \u00f5 , \u00d2 , \u00d3 , \u00d4, \u00d5 , \u00f3 ");
        buf.append("& u ; \u00f9 , \u00fa , \u00fb , \u00fc , \u00da , \u00d9 , \u00db , \u00dc ");
        m_scorer = new StringScorer(true, new Locale("ca", "CA"), buf.toString());
        HashSet<String> set = new HashSet<String>(2);
        set.add("AVE");
        set.add("BD");
        interchangeableThoroughfareTypeSet = Collections.unmodifiableSet(set);
    }
}

