/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN;

import com.mapinfo.mapmarker.CAN.AlternateItem;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class MunicipalityRecord {
    private String m_province;
    private String m_municipality;
    private String m_withAccents;
    private Collection m_alternates;

    public MunicipalityRecord(String province, String municipality, String withAccents) {
        this();
        this.m_province = province;
        this.m_municipality = municipality;
        this.m_withAccents = withAccents;
    }

    protected MunicipalityRecord() {
    }

    protected void setProvince(String province) {
        this.m_province = province;
    }

    public String getProvince() {
        return this.m_province;
    }

    public void setMunicipality(String municipality) {
        this.m_municipality = municipality;
    }

    public String getMunicipality() {
        return this.m_municipality;
    }

    public void setMunicipalityWithAccents(String withAccents) {
        this.m_withAccents = withAccents;
    }

    public String getMunicipalityWithAccents() {
        return this.m_withAccents;
    }

    public void addAlternate(AlternateItem item) {
        if (this.m_alternates == null) {
            this.m_alternates = new LinkedList();
        }
        this.m_alternates.add(item);
    }

    public Collection getAlternates() {
        return this.m_alternates;
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        buffer.append("province: ");
        buffer.append(this.getProvince());
        buffer.append(lineSeparator);
        buffer.append("municipality: ");
        buffer.append(this.getMunicipality());
        buffer.append(lineSeparator);
        buffer.append("accented municipality: ");
        buffer.append(this.getMunicipalityWithAccents());
        buffer.append(lineSeparator);
        Collection alternates = this.getAlternates();
        if (alternates != null && !alternates.isEmpty()) {
            buffer.append("alternates:");
            buffer.append(lineSeparator);
            Iterator iterator = alternates.iterator();
            while (iterator.hasNext()) {
                buffer.append(iterator.next().toString());
            }
        } else {
            buffer.append("no alternates");
            buffer.append(lineSeparator);
        }
        return buffer.toString();
    }
}

