/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.CANPost;

import com.mapinfo.mapmarker.CAN.dp.CANPost.ICANPostSource;
import com.mapinfo.mapmarker.CAN.dp.CANPost.ICombinedRecord;
import com.mapinfo.mapmarker.CAN.dp.CANPost.IUnMatchedOutputer;
import com.mapinfo.mapmarker.CAN.dp.CANPost.IUnMatchedStreetRecordBuilder;
import com.mapinfo.mapmarker.CAN.dp.merge.IMergeRecorder;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IStreetDataSourceRecord;
import java.util.Collection;

public class AbstractUnMatchedProcessor {
    private ICANPostSource m_source;
    private IMergeRecorder m_recorder;
    private IUnMatchedStreetRecordBuilder m_streetBuilder;
    private IUnMatchedOutputer m_outputer;
    private String m_province;
    private int m_recordsRead;
    private int m_recordsWithLeftOvers;
    private int m_recordsConverted;

    protected AbstractUnMatchedProcessor(ICANPostSource source, IMergeRecorder recorder, IUnMatchedStreetRecordBuilder streetBuilder, IUnMatchedOutputer outputer, String province) {
        this.m_source = source;
        this.m_recorder = recorder;
        this.m_streetBuilder = streetBuilder;
        this.m_outputer = outputer;
        this.m_province = province;
    }

    protected void process() throws DataSourceException {
        ICombinedRecord record;
        while ((record = this.m_source.getNextRecord()) != null) {
            ++this.m_recordsRead;
            Collection<ICombinedRecord> leftOvers = this.m_recorder.getAvailable(record);
            if (leftOvers == null) continue;
            ++this.m_recordsWithLeftOvers;
            IStreetDataSourceRecord street = this.m_streetBuilder.buildStreet(record, leftOvers);
            if (street == null) continue;
            ++this.m_recordsConverted;
            this.m_outputer.output(street);
        }
    }

    protected int getRecordsRead() {
        return this.m_recordsRead;
    }

    protected int getRecordsWithLeftOvers() {
        return this.m_recordsWithLeftOvers;
    }

    protected int getRecordsConverted() {
        return this.m_recordsConverted;
    }
}

