/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.CANPost;

import com.mapinfo.mapmarker.CAN.CAN_ParsedAddress;
import com.mapinfo.mapmarker.CAN.dp.CANPost.AccentsLookup;
import com.mapinfo.mapmarker.CAN.dp.CANPost.CANPostStreet;
import com.mapinfo.mapmarker.CAN.dp.CANPost.ICombinedRecord;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.INonStreetElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IRouteServiceElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IStreetElements;
import com.mapinfo.mapmarker.CAN.dp.merge.MergeUtilities;
import com.mapinfo.mapmarker.CAN.parser.CAN_Directionals;
import com.mapinfo.mapmarker.CAN.parser.CAN_NewThoroughfareTypes;
import com.mapinfo.mapmarker.CAN.parser.SaintReplacer;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.HashSet;
import java.util.Set;

public class StreetNameBuilder {
    private static final Set m_frenchTypes = new HashSet();
    private static final Set m_preTypesForNumberedRoads;
    private AccentsLookup m_accents;

    public StreetNameBuilder(AccentsLookup accents) {
        this.m_accents = accents;
    }

    public CANPostStreet makeStreet(ICombinedRecord record) {
        return this.makeStreet(record, true, true, false, false, false, false, false);
    }

    private CANPostStreet makeStreet(ICombinedRecord record, boolean bUseAccent, boolean bFollowOutputRules, boolean bCleanMainAddress, boolean bRemoveArticles, boolean bMainAddressOnly, boolean bDropDirs, boolean bDropTypes) {
        String streetString = null;
        String originalName = null;
        String deliveryInstallationInfo = null;
        switch (record.getStandardElements().getRecordTypeCode()) {
            case '1': 
            case '2': 
            case 'A': 
            case 'B': 
            case 'C': {
                CAN_ParsedAddress parsed;
                boolean bIsQC = "QC".equals(record.getStandardElements().getProvinceCode());
                String preParsedStreet = this.getPreParsedStreet(record.getStreetElements(), bIsQC, bUseAccent, false);
                if (preParsedStreet == null || (parsed = this.parse(preParsedStreet)) == null || preParsedStreet.equals(streetString = this.makeStreetString(parsed, bIsQC, bFollowOutputRules, bCleanMainAddress, bRemoveArticles, bMainAddressOnly, bDropDirs, bDropTypes))) break;
                if (parsed.hasFrenchOrdinal()) {
                    String ordinalStreet = this.getPreParsedStreet(record.getStreetElements(), bIsQC, bUseAccent, true);
                    preParsedStreet = streetString.equals(ordinalStreet) ? null : ordinalStreet;
                }
                originalName = preParsedStreet;
                break;
            }
            case '3': 
            case 'D': 
            case 'E': {
                streetString = "PO BOX";
                deliveryInstallationInfo = this.makeDeliveryInstallationString(record.getNonStreetElements());
                break;
            }
            case '5': {
                streetString = "GENERAL DELIVERY";
                deliveryInstallationInfo = this.makeDeliveryInstallationString(record.getNonStreetElements());
                break;
            }
            case 'F': {
                streetString = "GENERAL DELIVERY";
                deliveryInstallationInfo = this.makeDeliveryInstallationString(record.getNonStreetElements());
                break;
            }
            case '4': {
                streetString = this.makeRouteServiceString(record.getRouteServiceElements());
                deliveryInstallationInfo = this.makeDeliveryInstallationString(record.getNonStreetElements());
            }
        }
        if (streetString != null) {
            CANPostStreet street = new CANPostStreet(streetString);
            street.setOriginalName(originalName);
            street.setDeliveryInstallationInfo(deliveryInstallationInfo);
            return street;
        }
        return null;
    }

    public String makeStreetString(String name, String type, String dir, boolean bIsQC) {
        String preParsedStreet = this.getPreParsedStreet(name, type, dir, bIsQC, false);
        CAN_ParsedAddress parsed = this.parse(preParsedStreet);
        return this.makeStreetString(parsed, bIsQC, false, false, false, false, false, false);
    }

    private String getPreParsedStreet(String name, String type, String dir, boolean bIsQC, boolean bFrenchOrdinalMain) {
        boolean bTypeAsPre;
        boolean bFrenchType = m_frenchTypes.contains(type);
        boolean bPreType = false;
        if (!bFrenchType) {
            if (bIsQC && "RTE".equals(type)) {
                bPreType = true;
            } else if (StringUtilities.hasNumeric((String)name)) {
                bPreType = m_preTypesForNumberedRoads.contains(type);
            }
        }
        boolean bl = bTypeAsPre = bFrenchType || bPreType;
        if (bFrenchOrdinalMain) {
            bTypeAsPre = false;
        }
        if (bIsQC) {
            type = this.updateQCTypes(type);
        }
        return this.getStreetString(null, bTypeAsPre ? type : null, name, bTypeAsPre ? null : type, dir);
    }

    private String updateQCTypes(String type) {
        CAN_NewThoroughfareTypes.KeyInfo info = CAN_NewThoroughfareTypes.lookupByTypeName(type);
        if (info != null) {
            String outType = info.getProperTypeName();
            String qcType = CAN_NewThoroughfareTypes.getSpecialQCTypeProperName(outType);
            if (qcType != null) {
                return qcType;
            }
            return info.getProperTypeName();
        }
        return type;
    }

    private String getPreParsedStreet(IStreetElements elements, boolean bIsQC, boolean bUseAccent, boolean bFrenchOrdinalMain) {
        if (elements == null) {
            return null;
        }
        if (bUseAccent && elements.getStreetNameAccentIndicator()) {
            return this.getPreParsedStreet(this.m_accents.get(elements.getStreetName()), elements.getStreetTypeCode(), elements.getStreetDirectionCode(), bIsQC, bFrenchOrdinalMain);
        }
        return this.getPreParsedStreet(elements.getStreetName(), elements.getStreetTypeCode(), elements.getStreetDirectionCode(), bIsQC, bFrenchOrdinalMain);
    }

    private CAN_ParsedAddress parse(String streetString) {
        CAN_ParsedAddress parsed = MergeUtilities.parse(streetString);
        if (parsed == null) {
            DataCreationLogger.getLogger().logInternalError("Unable to parse CANPost: " + streetString);
            return null;
        }
        return parsed;
    }

    private String makeStreetString(CAN_ParsedAddress parsed, boolean bIsQC, boolean bFollowOutputRules, boolean bCleanMainAddress, boolean bRemoveArticles, boolean bMainAddressOnly, boolean bDropDirs, boolean bDropTypes) {
        if (!bFollowOutputRules) {
            if (bMainAddressOnly) {
                bDropTypes = true;
                bDropDirs = true;
            }
            if (bDropTypes) {
                parsed.setPreThoroughfareType(null);
                parsed.setPostThoroughfareType(null);
            }
            if (bDropDirs) {
                parsed.setPreDirectional(null);
                parsed.setPostDirectional(null);
            }
            return MergeUtilities.makePostParseString((Address)parsed, bCleanMainAddress, bRemoveArticles);
        }
        StringBuffer street = new StringBuffer();
        this.handlePreDir(street, parsed.getPreDirectional());
        this.handleType(street, parsed.getPreThoroughfareType(), bIsQC);
        this.handleMainAddress(street, parsed.getMainAddress());
        this.handleType(street, parsed.getPostThoroughfareType(), bIsQC);
        this.addElement(street, parsed.getPostDirectional());
        return street.toString();
    }

    private void handlePreDir(StringBuffer street, String preDir) {
        if (preDir == null) {
            return;
        }
        String expanded = CAN_Directionals.getFullName(preDir);
        if (expanded != null) {
            this.addElement(street, expanded);
        } else {
            this.addElement(street, preDir);
        }
    }

    private void handleType(StringBuffer street, String type, boolean bIsQC) {
        if (type == null) {
            return;
        }
        CAN_NewThoroughfareTypes.KeyInfo info = CAN_NewThoroughfareTypes.lookupByPreferredName(type);
        if (info != null) {
            String qcType;
            String outType = info.getProperTypeName();
            if (bIsQC && (qcType = CAN_NewThoroughfareTypes.getSpecialQCTypeProperName(outType)) != null) {
                outType = qcType;
            }
            this.addElement(street, outType);
        } else {
            this.addElement(street, type);
        }
    }

    private void handleMainAddress(StringBuffer street, String mainAddress) {
        if (mainAddress != null) {
            this.addElement(street, SaintReplacer.replace(mainAddress));
        }
    }

    private void addElement(StringBuffer buffer, String element) {
        if (element == null) {
            return;
        }
        if (buffer.length() > 0) {
            buffer.append(' ');
        }
        buffer.append(element);
    }

    private String makeRouteServiceString(IRouteServiceElements elements) {
        if (elements != null) {
            String type = elements.getRouteServiceTypeDescription();
            String number = elements.getRouteServiceNumber();
            if (number != null) {
                return type + ' ' + Integer.parseInt(number);
            }
            return type;
        }
        return null;
    }

    private String makeDeliveryInstallationString(INonStreetElements elements) {
        if (elements == null) {
            return null;
        }
        String desc = elements.getDeliveryInstallationTypeDescription();
        String qualifier = elements.getDeliveryInstallationQualifierName();
        if (qualifier != null) {
            return desc + ' ' + qualifier;
        }
        return desc;
    }

    public String makeStreetString(IStreetElements elements, boolean bUseAccent) {
        return this.makeStreetString(elements, bUseAccent, false);
    }

    public String makeStreetString(IStreetElements elements, boolean bUseAccent, boolean bCleanMainAddress) {
        return this.makeStreetString(elements, bUseAccent, bCleanMainAddress, false, false, false);
    }

    public String makeStreetString(IStreetElements elements, boolean bUseAccent, boolean bCleanMainAddress, boolean bRemoveArticles, boolean bMainAddressOnly, boolean bIsQC) {
        return this.makeStreetString(elements, bUseAccent, bCleanMainAddress, bRemoveArticles, bMainAddressOnly, bIsQC, false, false);
    }

    public String makeStreetString(IStreetElements elements, boolean bUseAccent, boolean bCleanMainAddress, boolean bRemoveArticles, boolean bMainAddressOnly, boolean bIsQC, boolean bDropDirs, boolean bDropTypes) {
        String mainAddress;
        boolean bTypeAsPre;
        String streetString;
        CAN_ParsedAddress parsed;
        boolean bFrenchType = m_frenchTypes.contains(elements.getStreetTypeCode());
        boolean bPreType = false;
        if (!bFrenchType) {
            if (bIsQC && "RTE".equals(elements.getStreetTypeCode())) {
                bPreType = true;
            } else if (StringUtilities.hasNumeric((String)elements.getStreetName())) {
                bPreType = m_preTypesForNumberedRoads.contains(elements.getStreetTypeCode());
            }
        }
        if ((parsed = MergeUtilities.parse(streetString = this.getStreetString(null, (bTypeAsPre = bFrenchType || bPreType) ? elements.getStreetTypeCode() : null, mainAddress = bUseAccent && elements.getStreetNameAccentIndicator() ? this.m_accents.get(elements.getStreetName()) : elements.getStreetName(), bTypeAsPre ? null : elements.getStreetTypeCode(), elements.getStreetDirectionCode()))) == null) {
            DataCreationLogger.getLogger().logInternalError("Unable to parse CANPost: " + streetString);
            return null;
        }
        if (bFrenchType && parsed.hasFrenchOrdinal()) {
            this.fixFrenchOrdinals(parsed);
        }
        if (bMainAddressOnly) {
            parsed.setPreDirectional(null);
            parsed.setPreThoroughfareType(null);
            parsed.setPostThoroughfareType(null);
            parsed.setPostDirectional(null);
        }
        if (bDropDirs) {
            parsed.setPreDirectional(null);
            parsed.setPostDirectional(null);
        }
        if (bDropTypes) {
            parsed.setPreThoroughfareType(null);
            parsed.setPostThoroughfareType(null);
        }
        return MergeUtilities.makePostParseString((Address)parsed, bCleanMainAddress, bRemoveArticles);
    }

    private String getStreetString(String preDir, String preType, String mainAddress, String postType, String postDir) {
        StringBuffer buffer = new StringBuffer();
        if (preDir != null) {
            buffer.append(preDir);
            buffer.append(' ');
        }
        if (preType != null) {
            buffer.append(preType);
            buffer.append(' ');
        }
        buffer.append(mainAddress);
        if (postType != null) {
            buffer.append(' ');
            buffer.append(postType);
        }
        if (postDir != null) {
            buffer.append(' ');
            buffer.append(postDir);
        }
        return buffer.toString();
    }

    private void fixFrenchOrdinals(CAN_ParsedAddress address) {
        if (address.getPreThoroughfareType() != null) {
            if (address.getPostThoroughfareType() != null) {
                DataCreationLogger.getLogger().logInternalError("Address has pre and post types: " + (Object)((Object)address));
            } else {
                address.setPostThoroughfareType(address.getPreThoroughfareType());
                address.setPreThoroughfareType(null);
            }
        }
    }

    static {
        m_frenchTypes.add("RUE");
        m_frenchTypes.add("CH");
        m_frenchTypes.add("RANG");
        m_frenchTypes.add("ALLEE");
        m_frenchTypes.add("AV");
        m_frenchTypes.add("BOUL");
        m_frenchTypes.add("CAR");
        m_frenchTypes.add("C");
        m_frenchTypes.add("COTE");
        m_frenchTypes.add("COUR");
        m_frenchTypes.add("COURS");
        m_frenchTypes.add("CROIS");
        m_frenchTypes.add("ECH");
        m_frenchTypes.add("ILE");
        m_frenchTypes.add("IMP");
        m_frenchTypes.add("MONTEE");
        m_frenchTypes.add("PARC");
        m_frenchTypes.add("PLACE");
        m_frenchTypes.add("PLAT");
        m_frenchTypes.add("POINTE");
        m_frenchTypes.add("RDPT");
        m_frenchTypes.add("RLE");
        m_frenchTypes.add("SENT");
        m_frenchTypes.add("TSSE");
        m_frenchTypes.add("PROM");
        m_frenchTypes.add("AUT");
        m_frenchTypes.add("VOIE");
        m_frenchTypes.add("CERLE");
        m_frenchTypes.add("ESPL");
        m_frenchTypes.add("QUAI");
        m_frenchTypes.add("ENTREE");
        m_preTypesForNumberedRoads = new HashSet();
        m_preTypesForNumberedRoads.add("RTE");
        m_preTypesForNumberedRoads.add("HWY");
        m_preTypesForNumberedRoads.add("AUT");
        m_preTypesForNumberedRoads.add("FWY");
    }
}

