/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.CANPost.index;

import com.mapinfo.mapmarker.CAN.dp.CANPost.StreetNameBuilder;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IStandardElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IStreetElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.index.CollatorMergeIndexConvertor;
import com.mapinfo.mapmarker.CAN.dp.CANPost.index.CollatorMergeKey;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.TextAccentsLoader;
import com.mapinfo.mapmarker.CAN.dp.text.CombinedRecord;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexFileConvertor;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.utils.NIOOutputStream;
import com.mapinfo.mapmarker.utils.SeekableDataInputStream;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;

public class MergeIndexer {
    private static StreetNameBuilder m_streetNameBuilder;

    public static void main(String[] args) {
        String path = args[0];
        String baseLogFile = StringUtilities.appendToPath((String)path, (String)(MergeIndexer.makeLogBase(args) + "_mi"));
        DataCreationLogger.getLogger().setErrorLog(baseLogFile + ".err", false);
        DataCreationLogger.getLogger().setStatusLog((String)null, false);
        DataCreationLogger.getLogger().setInternalErrorLog(baseLogFile + ".irr", false);
        try {
            m_streetNameBuilder = new StreetNameBuilder(TextAccentsLoader.loadLookup(args[1]));
        }
        catch (DataSourceException DSEx) {
            System.err.println(DSEx.getMessage());
            DSEx.printStackTrace(System.err);
            System.exit(1);
        }
        String[] provinces = new String[args.length - 2];
        System.arraycopy(args, 2, provinces, 0, provinces.length);
        for (int i = 0; i < provinces.length; ++i) {
            MergeIndexer.indexProvince(path, provinces[i]);
        }
    }

    private static String makeLogBase(String[] args) {
        if (args.length <= 2) {
            return null;
        }
        String base = "";
        for (int i = 2; i < args.length; ++i) {
            if (base.length() > 1) {
                base = base + "_";
            }
            base = base + args[i];
        }
        return base;
    }

    private static void indexProvince(String path, String province) {
        SeekableDataInputStream dataStream;
        NIOOutputStream indexStream;
        System.out.println("indexing " + province + "...");
        try {
            indexStream = new NIOOutputStream(new File(MergeIndexer.makeTempIndexPath(path, province)));
        }
        catch (IOException IOEx) {
            System.err.println("Unable to create temp index file for: " + province);
            IOEx.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        try {
            dataStream = new SeekableDataInputStream(new File(MergeIndexer.makeDataPath(path, province)));
        }
        catch (IOException IOEx) {
            System.err.println("Unable to open data file for: " + province);
            IOEx.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        boolean bCont = true;
        while (bCont) {
            long offset;
            CombinedRecord record = new CombinedRecord();
            try {
                offset = dataStream.getFilePointer();
                record.read((DataInput)dataStream);
            }
            catch (EOFException EOFEx) {
                bCont = false;
                continue;
            }
            catch (IOException IOEx) {
                System.err.println("Unable to read data record from: " + province);
                IOEx.printStackTrace(System.err);
                System.exit(1);
                return;
            }
            MapMarkerIndexKey[] keys = MergeIndexer.makeKeys(record.getStandardElements(), record.getStreetElements());
            if (keys == null) continue;
            try {
                for (int i = 0; i < keys.length; ++i) {
                    if (keys[i] == null) continue;
                    keys[i].write((DataOutput)indexStream);
                    indexStream.writeLong(offset);
                }
            }
            catch (IOException IOEx) {
                System.err.println("Unable to write to temp index file for: " + province);
                IOEx.printStackTrace(System.err);
                System.exit(1);
                return;
            }
        }
        try {
            dataStream.close();
        }
        catch (IOException IOEx) {
            System.err.println("Unable to close data file for: " + province);
            IOEx.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        try {
            indexStream.close();
        }
        catch (IOException IOEx) {
            System.err.println("Unable to close the temp index file for: " + province);
            IOEx.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        IndexFileConvertor convertor = MergeIndexer.getConvertor(path, province);
        try {
            convertor.convert();
        }
        catch (DataCreationException DCEx) {
            System.err.println("Error converting the index.");
            DCEx.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        System.out.println("Finished indexing " + province);
    }

    private static IndexFileConvertor getConvertor(String path, String province) {
        return new CollatorMergeIndexConvertor(MergeIndexer.makeTempIndexPath(path, province), MergeIndexer.makeIndexPath(path, province));
    }

    private static String makeTempIndexPath(String path, String province) {
        return StringUtilities.appendToPath((String)path, (String)province, (String)".tdx");
    }

    private static String makeIndexPath(String path, String province) {
        return StringUtilities.appendToPath((String)path, (String)province, (String)".mdx");
    }

    private static String makeDataPath(String path, String province) {
        return StringUtilities.appendToPath((String)path, (String)province, (String)".tdr");
    }

    private static MapMarkerIndexKey[] makeKeys(IStandardElements standardElements, IStreetElements streetElements) {
        if (streetElements == null) {
            return null;
        }
        String streetString = MergeIndexer.makeStreetString(streetElements, true, "QC".equals(standardElements.getProvinceCode()));
        if (streetString != null) {
            MapMarkerIndexKey[] keys = new MapMarkerIndexKey[]{new CollatorMergeKey(standardElements.getProvinceCode(), standardElements.getPostalCode().substring(0, 3), streetString)};
            return keys;
        }
        DataCreationLogger.getLogger().logInternalError("Unable to parse street: " + standardElements.getPostalCode() + " -- " + streetElements.getStreetName() + " -- " + streetElements.getStreetTypeCode() + " -- " + streetElements.getStreetDirectionCode());
        return null;
    }

    private static String makeStreetString(IStreetElements elements, boolean bAccent, boolean bIsQC) {
        return m_streetNameBuilder.makeStreetString(elements, bAccent, true, false, false, bIsQC);
    }
}

