/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.CANPost.index;

import com.mapinfo.mapmarker.CAN.CAN_EnglishSoundex;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.binary.index.ByteSubIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerCharSubIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIntIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerMultiLevelIndexKey;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MergeSoundexKey
implements MapMarkerMultiLevelIndexKey {
    private static final String[] PROVINES = new String[]{"AB", "BC", "MB", "NB", "NL", "NS", "NT", "NU", "ON", "PE", "QC", "SK", "YT"};
    private static final int LEVELS = 4;
    private static final Soundex m_soundex = new CAN_EnglishSoundex();
    private MapMarkerIndexKey[] m_keys = new MapMarkerIndexKey[4];

    public MergeSoundexKey(String province, String FSA, String streetName) {
        this.m_keys[0] = new ByteSubIndexKey(MergeSoundexKey.encodeProvince(province));
        this.m_keys[1] = new FSAKey(MergeSoundexKey.encodeFSA(FSA));
        MiSoundexKey soundex = (MiSoundexKey)m_soundex.getSoundex(streetName);
        this.m_keys[2] = new MapMarkerCharSubIndexKey(soundex.getFirstChar());
        this.m_keys[3] = new MapMarkerIntIndexKey(soundex.getNumericValue());
    }

    public MergeSoundexKey() {
        this.m_keys[0] = new ByteSubIndexKey();
        this.m_keys[1] = new FSAKey();
        this.m_keys[2] = new MapMarkerCharSubIndexKey();
        this.m_keys[3] = new MapMarkerIntIndexKey();
    }

    public int getLevels() {
        return 4;
    }

    public MapMarkerIndexKey getKeyAt(int level) {
        return this.m_keys[level];
    }

    private static byte encodeProvince(String province) {
        for (int i = 0; i < PROVINES.length; ++i) {
            if (!province.equals(PROVINES[i])) continue;
            return (byte)i;
        }
        return -1;
    }

    private static short encodeFSA(String FSA) {
        char[] chars = FSA.toCharArray();
        byte firstChar = (byte)(chars[0] - 65);
        byte number = (byte)Character.getNumericValue(chars[1]);
        byte lastChar = (byte)(chars[2] - 65);
        int code = MergeSoundexKey.addSubCode(0, firstChar, 26);
        code = MergeSoundexKey.addSubCode(code, number, 10);
        code = MergeSoundexKey.addSubCode(code, lastChar, 26);
        return (short)code;
    }

    private static int addSubCode(int code, int subCode, int subCodeCount) {
        return code * subCodeCount + subCode;
    }

    public boolean equals(Object that) {
        MergeSoundexKey thatKey = (MergeSoundexKey)that;
        for (int i = 0; i < 4; ++i) {
            if (this.getKeyAt(i).equals(thatKey.getKeyAt(i))) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object that) {
        MergeSoundexKey thatKey = (MergeSoundexKey)that;
        for (int i = 0; i < 4; ++i) {
            int compare = this.m_keys[i].compareTo((Object)thatKey.m_keys[i]);
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    public void write(DataOutput out) throws IOException {
        for (int i = 0; i < 4; ++i) {
            this.m_keys[i].write(out);
        }
    }

    public void read(DataInput in) throws IOException {
        for (int i = 0; i < 4; ++i) {
            this.m_keys[i].read(in);
        }
    }

    public static class FSAKey
    implements MapMarkerIndexKey {
        private short m_key;

        public FSAKey() {
        }

        public FSAKey(short key) {
            this.m_key = key;
        }

        public int compareTo(Object that) {
            FSAKey thatKey = (FSAKey)that;
            if (this.m_key < thatKey.m_key) {
                return -1;
            }
            if (this.m_key > thatKey.m_key) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object that) {
            return this.m_key == ((FSAKey)that).m_key;
        }

        public void write(DataOutput out) throws IOException {
            out.writeShort(this.m_key);
        }

        public void read(DataInput in) throws IOException {
            this.m_key = in.readShort();
        }
    }
}

