/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp;

import com.mapinfo.mapmarker.CAN.CAN_EnglishSoundex;
import com.mapinfo.mapmarker.CAN.CAN_GeoSoundexKey;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_Geo2SacRecord;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_GeoBase;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.Geo2SacDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.common.dp.IGeo2SacDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacRecord;
import java.util.Properties;

public class CAN_Geo2SacDataSourceRecordConvertorImpl
extends Geo2SacDataSourceRecordConvertorImpl {
    private static final Soundex soundex = new CAN_EnglishSoundex();
    private static int n = 0;

    public CAN_Geo2SacDataSourceRecordConvertorImpl(Properties dataProperties, Soundex soundex) {
        super(dataProperties, soundex);
    }

    protected MMJGeo2SacRecord makeGeo2SacRecord(int sac, IGeoBase base) {
        return new CAN_Geo2SacRecord(sac, (CAN_GeoBase)base);
    }

    protected IGeoBase[] makeGeoBases(IGeo2SacDataSourceRecord input) throws DataSourceException {
        if (input.hasAreaName1() && this.stringExists(input.getAreaName1()) && input.hasAreaName3() && this.stringExists(input.getAreaName3())) {
            IGeoBase[] bases;
            String areaName1 = input.getAreaName1();
            String areaName3 = input.getAreaName3();
            ISoundexKey areaName3SndxKey = soundex.getSoundex(areaName3);
            if (areaName3SndxKey == null) {
                DataCreationLogger.getLogger().logInternalError("Unable to make soundex for: " + areaName3);
                return null;
            }
            CAN_GeoSoundexKey sndxKey = new CAN_GeoSoundexKey(areaName1, (MiSoundexKey)areaName3SndxKey);
            CAN_GeoSoundexKey sndxKeyNoAN1 = new CAN_GeoSoundexKey(null, (MiSoundexKey)areaName3SndxKey);
            CAN_GeoSoundexKey altSndxKey = null;
            CAN_GeoSoundexKey altSndxKeyNoAN1 = null;
            ISoundexKey altAreaName3SndxKey = null;
            if (input.hasAlternateAreaName3() && this.stringExists(input.getAlternateAreaName3())) {
                String altAreaName3 = input.getAlternateAreaName3();
                altAreaName3SndxKey = soundex.getSoundex(altAreaName3);
                if (altAreaName3SndxKey != null) {
                    altSndxKey = new CAN_GeoSoundexKey(areaName1, (MiSoundexKey)altAreaName3SndxKey);
                    if (areaName3.equalsIgnoreCase(altAreaName3)) {
                        altSndxKey = null;
                    }
                    if (altSndxKey != null) {
                        altSndxKeyNoAN1 = new CAN_GeoSoundexKey(null, (MiSoundexKey)altAreaName3SndxKey);
                    }
                }
            } else {
                altSndxKey = null;
            }
            if (altSndxKey == null) {
                bases = new IGeoBase[]{new CAN_GeoBase(sndxKey), new CAN_GeoBase(sndxKeyNoAN1)};
                return bases;
            }
            bases = new IGeoBase[]{new CAN_GeoBase(sndxKey), new CAN_GeoBase(sndxKeyNoAN1), new CAN_GeoBase(altSndxKey), new CAN_GeoBase(altSndxKeyNoAN1)};
            return bases;
        }
        return null;
    }
}

