/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp;

import com.mapinfo.mapmarker.CAN.dp.CAN_IntermediateStreetDataFileFormatHandler;
import com.mapinfo.mapmarker.CAN.dp.CAN_MMJRangeUnitRecord;
import com.mapinfo.mapmarker.CAN.dp.CAN_MergedRangeRecord;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_MergedMMJStreetRecord;
import com.mapinfo.mapmarker.CAN.dp.intermediate.CAN_IntermediateStreetDataItem;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeUnitRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateRangeDataItem;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateStreetDataItem;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateUnitDataItem;

public class CAN_MergedIntermediateStreetDataFileFormatHandler
extends CAN_IntermediateStreetDataFileFormatHandler {
    private static int STREET_STRING_ORIGINAL_NAME = 62;
    private static int STREET_STRING_DELIVERY_INSTALLATION_INFO = 61;
    private static int STRING_RANGE_PROVINCE = 61;
    private static int STRING_RANGE_MUNICIPALITY = 60;
    private static int RANGE_STRING_ROUTE_SERVICE_TYPE = 59;
    private static int RANGE_SHORT_ROUTE_SERVICE_NUMBER = 62;
    private static final int STRING_UNIT_LDU = 62;
    private static final int STRING_UNIT_PBKEY = 58;
    private static final int STRING_RANGE_PBKEY = 58;

    public CAN_MergedIntermediateStreetDataFileFormatHandler(String fileName) {
        super(fileName);
    }

    protected IntermediateStreetDataItem getIntermediateStreetDataItemType() {
        return new CAN_IntermediateStreetDataItem();
    }

    @Override
    protected MMJStreetRecord getStreetRecordType() {
        return new CAN_MergedMMJStreetRecord();
    }

    protected void convertStreetRecord2DataItem(MMJStreetRecord record, IntermediateStreetDataItem item) throws DataSourceException {
        super.convertStreetRecord2DataItem(record, item);
        CAN_MergedMMJStreetRecord CANStreet = (CAN_MergedMMJStreetRecord)record;
        try {
            if (CANStreet.getOriginalName() != null) {
                item.putString(STREET_STRING_ORIGINAL_NAME, CANStreet.getOriginalName());
            }
            if (CANStreet.getDeliveryInstallationInfo() != null) {
                item.putString(STREET_STRING_DELIVERY_INSTALLATION_INFO, CANStreet.getDeliveryInstallationInfo());
            }
        }
        catch (MMJETypeArraySizeExceededException MMJETASEEx) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate street record.");
            DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)MMJETASEEx);
            throw new DataSourceException(14, (Throwable)MMJETASEEx);
        }
    }

    protected void convertStreetDataItem2Record(MMJStreetRecord record, IntermediateStreetDataItem item) throws DataSourceException {
        super.convertStreetDataItem2Record(record, item);
        CAN_MergedMMJStreetRecord CANStreet = (CAN_MergedMMJStreetRecord)record;
        try {
            if (item.hasString(STREET_STRING_ORIGINAL_NAME)) {
                CANStreet.setOriginalName(item.getString(STREET_STRING_ORIGINAL_NAME));
            }
            if (item.hasString(STREET_STRING_DELIVERY_INSTALLATION_INFO)) {
                CANStreet.setDeliveryInstallationInfo(item.getString(STREET_STRING_DELIVERY_INSTALLATION_INFO));
            }
        }
        catch (MMJETypeArraySizeExceededException MMJETASEEx) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate street item.");
            DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)MMJETASEEx);
            throw new DataSourceException(14, (Throwable)MMJETASEEx);
        }
    }

    @Override
    protected MMJRangeRecord getRangeRecordType() {
        return new CAN_MergedRangeRecord();
    }

    @Override
    protected void convertRangeRecord2DataItem(MMJRangeRecord record, IntermediateRangeDataItem item) throws DataSourceException {
        super.convertRangeRecord2DataItem(record, item);
        try {
            CAN_MergedRangeRecord can = (CAN_MergedRangeRecord)record;
            String temp = this.prepareStringForDataItem(can.getProvince());
            if (temp != null) {
                item.putString(STRING_RANGE_PROVINCE, temp);
            }
            if ((temp = this.prepareStringForDataItem(can.getMunicipality())) != null) {
                item.putString(STRING_RANGE_MUNICIPALITY, temp);
            }
            if ((temp = this.prepareStringForDataItem(can.getRouteServiceType())) != null) {
                item.putString(RANGE_STRING_ROUTE_SERVICE_TYPE, temp);
            }
            if (can.hasRouteServiceNumber()) {
                item.putShort(RANGE_SHORT_ROUTE_SERVICE_NUMBER, can.getRouteServiceNumber());
            }
            if (can.hasPbkey()) {
                item.putString(58, can.getPbkey());
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate range data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataSourceException(14, (Throwable)e);
        }
    }

    @Override
    protected void convertRangeDataItem2Record(MMJRangeRecord record, IntermediateRangeDataItem item) throws DataSourceException {
        super.convertRangeDataItem2Record(record, item);
        try {
            CAN_MergedRangeRecord can = (CAN_MergedRangeRecord)record;
            if (item.hasString(STRING_RANGE_PROVINCE)) {
                can.setProvince(item.getString(STRING_RANGE_PROVINCE));
            }
            if (item.hasString(STRING_RANGE_MUNICIPALITY)) {
                can.setMunicipality(item.getString(STRING_RANGE_MUNICIPALITY));
            }
            if (item.hasString(RANGE_STRING_ROUTE_SERVICE_TYPE)) {
                can.setRouteServiceType(item.getString(RANGE_STRING_ROUTE_SERVICE_TYPE));
            }
            if (item.hasShort(RANGE_SHORT_ROUTE_SERVICE_NUMBER)) {
                can.setRouteServiceNumber(item.getShort(RANGE_SHORT_ROUTE_SERVICE_NUMBER));
            }
            if (item.hasString(58)) {
                can.setPbkey(item.getString(58));
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate range data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataSourceException(14, (Throwable)e);
        }
    }

    protected MMJRangeUnitRecord getUnitRecordType() {
        return new CAN_MMJRangeUnitRecord();
    }

    protected void convertUnitRecord2DataItem(MMJRangeUnitRecord record, IntermediateUnitDataItem item) throws DataSourceException {
        super.convertUnitRecord2DataItem(record, item);
        CAN_MMJRangeUnitRecord canRecord = (CAN_MMJRangeUnitRecord)record;
        try {
            if (canRecord.getLDU() != null) {
                item.putString(62, canRecord.getLDU());
            }
            if (canRecord.getPbkey() != null) {
                item.putString(58, canRecord.getPbkey());
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate unit item.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataSourceException(14, (Throwable)e);
        }
    }

    protected void convertUnitDataItem2Record(MMJRangeUnitRecord record, IntermediateUnitDataItem item) throws DataSourceException {
        super.convertUnitDataItem2Record(record, item);
        try {
            if (item.hasString(62)) {
                ((CAN_MMJRangeUnitRecord)record).setLDU(item.getString(62));
            }
            if (item.hasString(58)) {
                ((CAN_MMJRangeUnitRecord)record).setPbkey(item.getString(58));
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate unit record.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataSourceException(14, (Throwable)e);
        }
    }
}

