/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp;

import com.mapinfo.mapmarker.CAN.AddressUtils;
import com.mapinfo.mapmarker.CAN.dp.CAN_MMJRangeUnitRecord;
import com.mapinfo.mapmarker.CAN.dp.CAN_MergedRangeRecord;
import com.mapinfo.mapmarker.CAN.dp.ICAN_SegmentDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_MMJSegmentRecord;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_MergedMMJStreetRecord;
import com.mapinfo.mapmarker.CAN.dp.binary.DataEncoder;
import com.mapinfo.mapmarker.CAN.dp.binary.index.AlternatePostalIndexKey;
import com.mapinfo.mapmarker.CAN.dp.merge.ICAN_MergedStreetDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.ICAN_RangeDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.ICAN_UnitDataSourceRecord;
import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IRangeDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.ISegmentDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IStreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IUnitDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.StreetDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.common.dp.binary.AlternateDataItem;
import com.mapinfo.mapmarker.common.dp.binary.AlternateDataRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeUnitRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerStreetMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import com.mapinfo.mapmarker.core.parser.IParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class CAN_MergedStreetDataSourceRecordConvertor
extends StreetDataSourceRecordConvertorImpl {
    private static final String PARCEL_DATA_KEY = "street_parcelData";
    private boolean m_bCreateReversePostalAlternates = false;
    private final boolean m_bIsParcelData;

    public CAN_MergedStreetDataSourceRecordConvertor(Soundex soundex, Properties dataProperties, CollationKeyGenerator generator, IParser parser, Constraints parserConstraints) throws DataCreationException {
        super(soundex, dataProperties, generator, parser, parserConstraints);
        this.m_bCreateReversePostalAlternates = "YES".equals(dataProperties.getProperty("REVERSE_POSTAL_INDEX"));
        this.m_bIsParcelData = "YES".equals(dataProperties.getProperty(PARCEL_DATA_KEY));
    }

    protected Address makePreParsedAddress(IStreetDataSourceRecord input) throws DataSourceException {
        Address address = super.makePreParsedAddress(input);
        if (address != null) {
            address.setAreaName1("QC");
        }
        return address;
    }

    protected Address getParsedStreet(IStreetDataSourceRecord input, Address inputStreetAddress) throws DataSourceException {
        Address parsedAddress = this.parseStreet(inputStreetAddress);
        if (parsedAddress == null) {
            DataCreationLogger.getLogger().logInternalError("CAN_MergedStreetDataSourceRecordConvertor:: getParsedAddress(): Unable to parse street address: \n" + inputStreetAddress.getMainAddress());
            return null;
        }
        if (parsedAddress.getMainAddress() == null || !"100".equals(parsedAddress.getAddressNumber()) || parsedAddress.getUnitValue() != null || parsedAddress.getUnitType() != null) {
            inputStreetAddress.setMainAddress(inputStreetAddress.getMainAddress() + " APT 1");
            parsedAddress = this.parseStreet(inputStreetAddress);
            if (parsedAddress == null) {
                DataCreationLogger.getLogger().logInternalError("CAN_MergedStreetDataSourceRecordConvertor:: getParsedAddress(): Unable to parse street address: \n" + inputStreetAddress.getMainAddress());
                return null;
            }
            if (!(parsedAddress.getMainAddress() != null && "100".equals(parsedAddress.getAddressNumber()) && "1".equals(parsedAddress.getUnitValue()) && "APT".equals(parsedAddress.getUnitType()))) {
                if (parsedAddress.getMainAddress() != null && "APT".equals(parsedAddress.getUnitType()) && "1".equals(parsedAddress.getUnitValue()) && 100L == parsedAddress.getParsedAddressNumber().getAddressNumber() && parsedAddress.getParsedAddressNumber().isFractionalTrailer()) {
                    DataCreationLogger.getLogger().logInternalError("Hand parsing " + inputStreetAddress);
                    parsedAddress.setMainAddress(parsedAddress.getParsedAddressNumber().getAddressTrailer() + ' ' + parsedAddress.getMainAddress());
                    parsedAddress.setAddressNumber("100");
                    DataCreationLogger.getLogger().logInternalError("Hand parsing result: " + parsedAddress.toString());
                } else {
                    DataCreationLogger.getLogger().logInternalError("CAN_MergedStreetDataSourceRecordConvertor:: getParsedAddress(): Unable to parse street address: \n" + inputStreetAddress.getMainAddress());
                    return null;
                }
            }
        }
        return parsedAddress;
    }

    protected List getAllPossibleMainAddresses(IStreetDataSourceRecord input) throws DataSourceException {
        List addresses = super.getAllPossibleMainAddresses(input);
        if (addresses != null && !addresses.isEmpty()) {
            ArrayList<Address> allAddresses = new ArrayList<Address>();
            for (Address address : addresses) {
                allAddresses.add(address);
                Address cleansedAddr = AddressUtils.cleanseAddress(address);
                if (cleansedAddr == null) continue;
                allAddresses.add(cleansedAddr);
            }
            return allAddresses;
        }
        return addresses;
    }

    protected MMJStreetRecord createAlternateStreetRecord(MMJStreetRecord standardRecord, IStreetDataSourceRecord input, Address parsed) throws DataCreationException, DataSourceException {
        HashMap fields;
        Object obj;
        MMJStreetRecord record = super.createAlternateStreetRecord(standardRecord, input, parsed);
        Address addr = record.getAddress();
        if (addr.hasAdditionalFields() && (obj = (fields = addr.getAdditionalFields()).get("CAN_REAL_MAIN_ADDRESS")) != null) {
            addr.setMainAddress((String)obj);
            fields.remove("CAN_REAL_MAIN_ADDRESS");
            record.setBrowseKeys(null);
        }
        return record;
    }

    protected MMJStreetRecord makeStreetRecordType() {
        return new CAN_MergedMMJStreetRecord();
    }

    protected MMJSegmentRecord makeSegmentRecordType() {
        return new CAN_MMJSegmentRecord();
    }

    protected MMJRangeRecord makeRangeRecordType() {
        return new CAN_MergedRangeRecord();
    }

    protected MMJRangeUnitRecord makeRangeUnitRecordType() {
        return new CAN_MMJRangeUnitRecord();
    }

    protected MMJStreetRecord createStreetRecord(IStreetDataSourceRecord input, int leftSAC, int rightSAC) throws DataCreationException, DataSourceException {
        CAN_MergedMMJStreetRecord street = (CAN_MergedMMJStreetRecord)super.createStreetRecord(input, leftSAC, rightSAC);
        if (input instanceof ICAN_MergedStreetDataSourceRecord) {
            ICAN_MergedStreetDataSourceRecord CANInput = (ICAN_MergedStreetDataSourceRecord)input;
            if (CANInput.hasOriginalName()) {
                street.setOriginalName(CANInput.getOriginalName());
            }
            if (CANInput.hasDeliveryInstallationInfo()) {
                street.setDeliveryInstallationInfo(CANInput.getDeliveryInstallationInfo());
            }
        }
        return street;
    }

    protected MMJSegmentRecord convertSegmentRecord(ISegmentDataSourceRecord input, int sac, boolean convertLeft, boolean convertRight) throws DataSourceException {
        CAN_MMJSegmentRecord segment = (CAN_MMJSegmentRecord)super.convertSegmentRecord(input, sac, convertLeft, convertRight);
        if (segment == null) {
            return null;
        }
        ICAN_SegmentDataSourceRecord CANInput = (ICAN_SegmentDataSourceRecord)input;
        if (convertLeft) {
            if (CANInput.hasLeftDA()) {
                segment.setLeftDA(CANInput.getLeftDA());
            }
            if (CANInput.hasLeftCMA()) {
                segment.setLeftCMA(CANInput.getLeftCMA());
            }
            if (CANInput.hasLeftCSD()) {
                segment.setLeftCSD(CANInput.getLeftCSD());
            }
            if (CANInput.hasLeftCT()) {
                segment.setLeftCT(CANInput.getLeftCT());
            }
            if (CANInput.hasLeftCD()) {
                segment.setLeftCD(CANInput.getLeftCD());
            }
        }
        if (convertRight) {
            if (CANInput.hasRightDA()) {
                segment.setRightDA(CANInput.getRightDA());
            }
            if (CANInput.hasRightCMA()) {
                segment.setRightCMA(CANInput.getRightCMA());
            }
            if (CANInput.hasRightCSD()) {
                segment.setRightCSD(CANInput.getRightCSD());
            }
            if (CANInput.hasRightCT()) {
                segment.setRightCT(CANInput.getRightCT());
            }
            if (CANInput.hasRightCD()) {
                segment.setRightCD(CANInput.getRightCD());
            }
        }
        return segment;
    }

    protected void addRangesToSegment(MMJSegmentRecord segment, ISegmentDataSourceRecord input, int sac, boolean addLeft, boolean addRight) throws DataSourceException {
        super.addRangesToSegment(segment, input, sac, addLeft, addRight);
        if (this.m_bIsParcelData) {
            segment.setIsPointHouseSegment();
        }
    }

    protected int getOddEven(IRangeDataSourceRecord input) throws DataSourceException {
        if ("0".equals(input.getStatus())) {
            return 2;
        }
        if ("1".equals(input.getStatus())) {
            return 1;
        }
        return 0;
    }

    protected boolean isValidRange(String from, String to) {
        return this.stringExists(from) && this.stringExists(to);
    }

    protected MMJRangeRecord convertRangeRecord(IRangeDataSourceRecord input, int sac) throws DataSourceException {
        AlternatePostalIndexKey key;
        CAN_MergedRangeRecord range = (CAN_MergedRangeRecord)super.convertRangeRecord(input, sac);
        if (range == null) {
            return null;
        }
        this.fixLeadingZeros(range);
        ICAN_RangeDataSourceRecord CANInput = (ICAN_RangeDataSourceRecord)input;
        if (CANInput.hasLDU()) {
            range.setLDU(CANInput.getLDU());
            if (this.m_bCreateReversePostalAlternates) {
                AlternateDataRecord altRecord = new AlternateDataRecord();
                altRecord.setAlternateDataID(range.getLDU());
                key = new AlternatePostalIndexKey(sac, DataEncoder.encodeLDU(range.getLDU()));
                range.addAlternateDataItem(new AlternateDataItem(1, altRecord, (MapMarkerIndexKey)key, null));
            }
        }
        if (CANInput.hasProvince()) {
            range.setProvince(CANInput.getProvince());
        }
        if (CANInput.hasMunicipality()) {
            range.setMunicipality(CANInput.getMunicipality());
        }
        if (CANInput.hasRouteServiceType()) {
            range.setRouteServiceType(CANInput.getRouteServiceType());
        }
        if (CANInput.hasRouteServiceNumber()) {
            range.setRouteServiceNumber(CANInput.getRouteServiceNumber());
        }
        if (this.m_bIsParcelData) {
            range.setPoint(input.getPoint());
        }
        if (CANInput.hasPbkey()) {
            range.setPbkey(CANInput.getPbkey());
            String pbKey = CANInput.getPbkey();
            if (pbKey != null) {
                key = new MiStringIndexKey(pbKey);
                AlternateDataRecord alternateDataRecord = new AlternateDataRecord();
                alternateDataRecord.setAlternateDataID(pbKey);
                AlternateDataItem alt = new AlternateDataItem(2, alternateDataRecord, (MapMarkerIndexKey)key, null);
                range.addAlternateDataItem(alt);
            }
        }
        return range;
    }

    private void fixLeadingZeros(MMJRangeRecord range) {
        if (range.getFromHouse() != null && range.getFromHouse().addressNumberLeadingZeros() > 0) {
            range.setFromHouse(this.fixLeadingZeros(range.getFromHouse().getCombinedAddressNumber()));
        }
        if (range.getToHouse() != null && range.getToHouse().addressNumberLeadingZeros() > 0) {
            range.setToHouse(this.fixLeadingZeros(range.getToHouse().getCombinedAddressNumber()));
        }
    }

    public String fixLeadingZeros(String input) {
        int i;
        char[] chars = input.toCharArray();
        for (i = 0; chars[i] == '0' && i < input.length() - 1; ++i) {
        }
        return String.valueOf(chars, i, input.length() - i);
    }

    protected void populateAlternateDataItems(MMJRangeRecord range, IRangeDataSourceRecord input, int sac) throws DataSourceException {
        if (range.getPlaceName() != null) {
            String place = range.getPlaceName();
            AlternateDataRecord placeRecord = new AlternateDataRecord();
            placeRecord.setAlternateDataID(place);
            ISoundexKey placeSoundex = super.makeSoundexKey(place);
            if (placeSoundex == null) {
                DataCreationLogger.getLogger().logInternalError("Unable to create range soundex for: " + place);
                return;
            }
            MapMarkerStreetMultiLevelIndexKey soundexKey = new MapMarkerStreetMultiLevelIndexKey(sac, (MiSoundexKey)placeSoundex);
            MapMarkerIndexKey browseKey = this.makeAlternateTypeBrowseKey(place, sac);
            range.addAlternateDataItem(new AlternateDataItem(0, placeRecord, (MapMarkerIndexKey)soundexKey, browseKey));
        }
    }

    protected boolean isValidUnit(String lowUnit, String highUnit, String unitType) {
        return lowUnit != null && highUnit != null;
    }

    protected MMJRangeUnitRecord convertRangeUnitRecord(IUnitDataSourceRecord input, int sac) throws DataSourceException {
        Object key;
        ICAN_UnitDataSourceRecord canInput;
        ParsedNumber high;
        CAN_MMJRangeUnitRecord record = (CAN_MMJRangeUnitRecord)super.convertRangeUnitRecord(input, sac);
        if (record == null) {
            return null;
        }
        ParsedNumber low = new ParsedNumber(record.getLowUnit());
        if (!this.areCompatibleNumbers(low, high = new ParsedNumber(record.getHighUnit()))) {
            if (low.getNumFields() == high.getNumFields()) {
                DataCreationLogger.getLogger().logInternalError("Unit values have same number of fields, but they are not the same fields, SKIPPING...  Low: " + record.getLowUnit() + "\thigh: " + record.getHighUnit());
                return null;
            }
            if (Math.abs(low.getNumFields() - high.getNumFields()) > 1) {
                DataCreationLogger.getLogger().logInternalError("Unit values to dissimilar, SKIPPING...  Low: " + record.getLowUnit() + "\thigh: " + record.getHighUnit());
                return null;
            }
            this.fixUnit(record, low, high);
            low = new ParsedNumber(record.getLowUnit());
            high = new ParsedNumber(record.getHighUnit());
            if (!this.areCompatibleNumbers(low, high)) {
                DataCreationLogger.getLogger().logInternalError("Attempted to fix but failed\tlow: " + record.getLowUnit() + "\thigh: " + record.getHighUnit() + "\tSKIPPING...");
                return null;
            }
        }
        if (low.compareTo((Object)high) > 0) {
            record.setLowUnit(high.getCombinedAddressNumber());
            record.setHighUnit(low.getCombinedAddressNumber());
        }
        if ((canInput = (ICAN_UnitDataSourceRecord)input).hasLDU()) {
            record.setLDU(canInput.getLDU());
            if (this.m_bCreateReversePostalAlternates) {
                AlternateDataRecord altRecord = new AlternateDataRecord();
                altRecord.setAlternateDataID(record.getLDU());
                key = new AlternatePostalIndexKey(sac, DataEncoder.encodeLDU(record.getLDU()));
                record.addAlternateDataItem(new AlternateDataItem(1, altRecord, (MapMarkerIndexKey)key, null));
            }
        }
        if (canInput.hasPbkey()) {
            record.setPbkey(canInput.getPbkey());
            String pbKey = canInput.getPbkey();
            if (pbKey != null) {
                key = new MiStringIndexKey(pbKey);
                AlternateDataRecord alternateDataRecord = new AlternateDataRecord();
                alternateDataRecord.setAlternateDataID(pbKey);
                AlternateDataItem alt = new AlternateDataItem(2, alternateDataRecord, (MapMarkerIndexKey)key, null);
                record.addAlternateDataItem(alt);
            }
        }
        return record;
    }

    protected void populateAlternateDataItems(MMJRangeUnitRecord unit, IUnitDataSourceRecord input, int sac) throws DataSourceException {
        if (unit.getPlaceName() != null) {
            String place = unit.getPlaceName();
            AlternateDataRecord placeRecord = new AlternateDataRecord();
            placeRecord.setAlternateDataID(place);
            ISoundexKey placeSoundex = super.makeSoundexKey(place);
            if (placeSoundex == null) {
                DataCreationLogger.getLogger().logInternalError("Unable to create unit soundex for: " + place);
                return;
            }
            MapMarkerStreetMultiLevelIndexKey soundexKey = new MapMarkerStreetMultiLevelIndexKey(sac, (MiSoundexKey)placeSoundex);
            MapMarkerIndexKey browseKey = this.makeAlternateTypeBrowseKey(place, sac);
            unit.addAlternateDataItem(new AlternateDataItem(0, placeRecord, (MapMarkerIndexKey)soundexKey, browseKey));
        }
    }

    private boolean areCompatibleNumbers(ParsedNumber number1, ParsedNumber number2) {
        if (number1.isPureNumeric() && number2.isPureNumeric()) {
            return true;
        }
        if (number1.getNumFields() != number2.getNumFields()) {
            return false;
        }
        if (number1.hasAddressPrefix() != number2.hasAddressPrefix()) {
            return false;
        }
        if (number1.hasAddressSuffix() != number2.hasAddressSuffix()) {
            return false;
        }
        if (number1.hasAddressTrailer() != number2.hasAddressTrailer()) {
            return false;
        }
        if (number1.hasNumberSeparator() != number2.hasNumberSeparator()) {
            return false;
        }
        if (number1.hasPrefixSeparator() != number2.hasPrefixSeparator()) {
            return false;
        }
        if (number1.hasSeparator() != number2.hasSeparator()) {
            return false;
        }
        if (number1.hasSuffixSeparator() != number2.hasSuffixSeparator()) {
            return false;
        }
        if (number1.hasTrailerSeparator() != number2.hasTrailerSeparator()) {
            return false;
        }
        if (number1.getAddressNumberExists() != number2.getAddressNumberExists()) {
            return false;
        }
        if (number1.getSuffixNumberExists() != number2.getSuffixNumberExists()) {
            return false;
        }
        if (number1.isHyphenatedNumber() != number2.isHyphenatedNumber()) {
            return false;
        }
        int diffs = 0;
        if (number1.getAddressNumber() != number2.getAddressNumber()) {
            ++diffs;
        }
        if (!number1.getAddressPrefix().equals(number2.getAddressPrefix())) {
            ++diffs;
        }
        if (!number1.getAddressSuffix().equals(number2.getAddressSuffix())) {
            ++diffs;
        }
        if (!number1.getAddressTrailer().equals(number2.getAddressTrailer())) {
            ++diffs;
        }
        if (number1.getSuffixNumber() != number2.getSuffixNumber()) {
            ++diffs;
        }
        if (!number1.getNumberSeparator().equals(number2.getNumberSeparator())) {
            ++diffs;
        }
        if (!number1.getPrefixSeparator().equals(number2.getPrefixSeparator())) {
            ++diffs;
        }
        if (!number1.getSuffixSeparator().equals(number2.getSuffixSeparator())) {
            ++diffs;
        }
        if (!number1.getTrailerSeparator().equals(number2.getTrailerSeparator())) {
            ++diffs;
        }
        return diffs < 2;
    }

    private void fixUnit(MMJRangeUnitRecord unit, ParsedNumber low, ParsedNumber high) {
        if (low.getNumFields() < high.getNumFields()) {
            if (high.hasAddressPrefix() && !low.hasAddressPrefix()) {
                unit.setLowUnit(high.getAddressPrefix() + unit.getLowUnit());
                return;
            }
            if (high.hasAddressSuffix() && !low.hasAddressSuffix()) {
                unit.setLowUnit(unit.getLowUnit() + high.getAddressSuffix());
            }
        } else {
            if (low.hasAddressPrefix() && !high.hasAddressPrefix()) {
                unit.setHighUnit(low.getAddressPrefix() + unit.getHighUnit());
                return;
            }
            if (low.hasAddressSuffix() && !high.hasAddressSuffix()) {
                unit.setHighUnit(unit.getHighUnit() + low.getAddressSuffix());
            }
        }
    }
}

