/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp;

import com.mapinfo.mapmarker.CAN.dp.CAN_AbstractPostalRangeDataHandler;
import com.mapinfo.mapmarker.CAN.dp.ICAN_PostInfoCensusDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_PostInfoRecord;
import com.mapinfo.mapmarker.CAN.dp.binary.index.EncodedPostInfoIndexKey;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IPostInfoDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.PostInfoDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.PostInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import java.util.HashMap;
import java.util.Properties;
import java.util.TreeMap;

public class CAN_PostInfoDataSourceRecordConvertorImpl
extends PostInfoDataSourceRecordConvertorImpl {
    protected HashMap m_provToPostalIdxMap;
    protected CAN_AbstractPostalRangeDataHandler m_handler;

    public CAN_PostInfoDataSourceRecordConvertorImpl(Properties dataProperties, CAN_AbstractPostalRangeDataHandler handler) {
        super(dataProperties);
        this.m_handler = handler;
        this.m_provToPostalIdxMap = new HashMap();
    }

    protected PostInfoRecord makePostInfoRecordType() {
        return new CAN_PostInfoRecord();
    }

    protected PostInfoRecord makePostInfoRecord(IPostInfoDataSourceRecord input) throws DataSourceException {
        CAN_PostInfoRecord record = (CAN_PostInfoRecord)super.makePostInfoRecord(input);
        String tmp = ((ICAN_PostInfoCensusDataSourceRecord)input).getCensusDA();
        record.setCensusDA(tmp);
        tmp = ((ICAN_PostInfoCensusDataSourceRecord)input).getCensusCMA();
        record.setCensusCMA(tmp);
        tmp = ((ICAN_PostInfoCensusDataSourceRecord)input).getCensusCSD();
        record.setCensusCSD(tmp);
        tmp = ((ICAN_PostInfoCensusDataSourceRecord)input).getCensusCT();
        record.setCensusCT(tmp);
        String prov = record.getAreaName1();
        TreeMap tree = (TreeMap)this.m_provToPostalIdxMap.get(prov);
        if (tree == null) {
            StringBuffer buf = new StringBuffer();
            if ("NU".equals(prov)) {
                prov = "NT";
            }
            tmp = this.m_dataProperties.getProperty("postinfo_range_index_file_base_name");
            buf.append(tmp);
            buf.append(prov);
            buf.append(".tdx");
            String outputPath = this.m_dataProperties.getProperty("postInfo_outputFilePath");
            try {
                tree = this.m_handler.readIndexFile(buf.toString(), outputPath);
                this.m_provToPostalIdxMap.put(prov, tree);
            }
            catch (DataCreationException dataCreationException) {
                // empty catch block
            }
        }
        if (tree != null) {
            Integer ptr;
            TreeMap lduTree;
            String fsa = record.getPostalCode1();
            String ldu = record.getPostalCode2();
            if (ldu != null && (lduTree = (TreeMap)tree.get(fsa)) != null && (ptr = (Integer)lduTree.get(ldu)) != null) {
                record.setRangeFilePtr(ptr);
            }
        }
        return record;
    }

    protected MapMarkerIndexKey makePostInfoIndexKey(PostInfoRecord record) {
        return new EncodedPostInfoIndexKey(record.getPostalCode1(), record.getPostalCode2());
    }
}

